/*
 * Decompiled with CFR 0.152.
 */
package de.pontonconsulting.xmlpipe.messenger.emailnotification;

import de.pontonconsulting.xmlpipe.config.MessengerConfig;
import de.pontonconsulting.xmlpipe.config.SystemEvent;
import de.pontonconsulting.xmlpipe.config.SystemEventReceiver;
import de.pontonconsulting.xmlpipe.events.ReloadConfiguration;
import de.pontonconsulting.xmlpipe.messenger.emailnotification.SystemEmailNotification;
import jakarta.annotation.PostConstruct;
import jakarta.xml.bind.JAXBException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.context.ApplicationListener;

public class SystemEventNotifier
implements ApplicationListener<ReloadConfiguration> {
    private static Log LOG = LogFactory.getFactory().getInstance("Messenger.SystemEventNotifier");
    private final Map<SystemEvent, List<SystemEventReceiver>> eventSubscribers;
    private final Lock lock;
    private final SystemEmailNotification systemEmailNotification;
    private final MessengerConfig messengerConfig;

    public SystemEventNotifier(MessengerConfig messengerConfig, SystemEmailNotification systemEmailNotification) {
        Objects.requireNonNull(messengerConfig, "SystemEventNotifier: MessengerConfig is required.");
        Objects.requireNonNull(systemEmailNotification, "SystemEventNotifier: SystemEmailNotification is required.");
        this.messengerConfig = messengerConfig;
        this.systemEmailNotification = systemEmailNotification;
        this.lock = new ReentrantLock();
        this.eventSubscribers = new ConcurrentHashMap<SystemEvent, List<SystemEventReceiver>>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendNotification(SystemEvent systemEvent, String description) {
        this.lock.lock();
        try {
            List<SystemEventReceiver> subscribers = this.eventSubscribers.get((Object)systemEvent);
            if (subscribers != null) {
                for (SystemEventReceiver subscriber : subscribers) {
                    this.systemEmailNotification.sendNotification(subscriber.getEmail(), subscriber.getSubject(), description);
                }
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PostConstruct
    public void reinit() {
        this.lock.lock();
        try {
            this.eventSubscribers.clear();
            List<SystemEventReceiver> systemEventReceivers = this.messengerConfig.getSystemEventReceivers();
            for (SystemEventReceiver systemEventReceiver : systemEventReceivers) {
                for (SystemEvent systemEvent : systemEventReceiver.getEvents()) {
                    List<SystemEventReceiver> subscribers = this.eventSubscribers.get((Object)systemEvent);
                    if (subscribers == null) {
                        subscribers = new ArrayList<SystemEventReceiver>();
                        this.eventSubscribers.put(systemEvent, subscribers);
                    }
                    if (subscribers.contains(systemEventReceiver)) continue;
                    subscribers.add(systemEventReceiver);
                }
            }
        }
        catch (JAXBException e) {
            LOG.error((Object)"Could not read messenger config.", (Throwable)e);
        }
        finally {
            this.lock.unlock();
        }
    }

    public void onApplicationEvent(ReloadConfiguration reloadConfiguration) {
        this.reinit();
    }
}

