/*
 * Decompiled with CFR 0.152.
 */
package de.pontonconsulting.xmlpipe.messenger.database.tables;

import de.pontonconsulting.xmlpipe.config.MessengerConfig;
import de.pontonconsulting.xmlpipe.message.XpMessage;
import de.pontonconsulting.xmlpipe.messenger.ReferenceDateTask;
import de.pontonconsulting.xmlpipe.messenger.database.DbException;
import de.pontonconsulting.xmlpipe.messenger.database.HibernateSessionFactory;
import de.pontonconsulting.xmlpipe.messenger.database.hibernate.Message;
import de.pontonconsulting.xmlpipe.messenger.database.hibernate.OutboundQueueMessage;
import de.pontonconsulting.xmlpipe.messenger.database.tables.BaseDAO;
import de.pontonconsulting.xmlpipe.messenger.database.tables.MessageDAO;
import jakarta.persistence.EntityManager;
import jakarta.persistence.NoResultException;
import java.time.Instant;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;

public class OutboundQueueMessageDAO
extends BaseDAO {
    public static final int STATUS_DB_CHECK = -1;
    public static final int STATUS_ENQUEUED = 0;
    public static final int STATUS_IN_TRANSFER = 1;
    public static final int STATUS_DELAYED = 2;
    public static final int STATUS_FINISHED = 99;
    private static final String QUERY_SELECT_MESSAGE_COUNT = "SELECT COUNT(*)\nFROM OutboundQueueMessage\nWHERE status != 99\n";
    private static final String QUERY_SELECT_MESSENGER_MESSAGES_IN_TRANSFER = "FROM OutboundQueueMessage\nWHERE status = 1 AND messengerId = :messengerId\n";
    private static final String QUERY_SELECT_MESSAGE_WITH_STATUS = "FROM OutboundQueueMessage\nWHERE messageId = :messageId AND status = :status AND messengerId = :messengerId\n";
    private static final String QUERY_SELECT_MESSAGE_COUNT_FOR_IDS = "SELECT COUNT(*)\nFROM OutboundQueueMessage\nWHERE messageId in :messageIds\n";
    private static final String QUERY_FINISH_MESSAGE = "UPDATE OutboundQueueMessage\nSET status = 99\nWHERE messageId = :messageId\n";
    private static final String QUERY_FINISH_MESSAGE_BY_IDS = "UPDATE OutboundQueueMessage\nSET status = 99\nWHERE messageId IN :messageIds\n";
    private static final String QUERY_DELETE_FINISHED_MESSAGE = "DELETE OutboundQueueMessage\nWHERE status = 99 AND messengerId = :messengerId\n";
    private static final String QUERY_DELETE_MESSAGE_BY_ID = "DELETE OutboundQueueMessage\nWHERE messageId = :messageId\n";
    private static final String QUERY_RESCHEDULE_MESSAGE = "UPDATE OutboundQueueMessage\nSET status = 0, timeToLive = null\nWHERE messageId = :messageId AND status != 99\n";
    private static final String SQL_UPDATE_RESET_TRANSMISSION = "UPDATE OutboundQueueMessage\nSET status = 0, timeToLive = null, lastTransmission = null, messengerId = null\nWHERE messageId = :messageId AND status = 1\n";
    private static final String QUERY_GET_NEXT_MESSAGE_IDS = "SELECT messageId\nFROM OutboundQueueMessage\nWHERE status = 0 AND receiverId = :receiverId\nORDER BY priority DESC, messageId ASC\n";
    private static final String QUERY_UPDATE_NEXT_MESSAGE = "UPDATE OutboundQueueMessage\nSET status = 1, lastTransmission = :now, messengerId = :messengerId\nWHERE messageId = :messageId AND status = 0\n";
    private static final String QUERY_SELECT_EXPIRED_MESSAGES = "FROM OutboundQueueMessage\nWHERE status = 1 AND (timeToLive <= :now OR timeToLive IS NULL)\n";
    private static final String PARAM_MESSENGER_ID = "messengerId";
    private static final String PARAM_MESSAGE_ID = "messageId";
    private static final String PARAM_MESSAGE_IDS = "messageIds";
    private final MessengerConfig _messengerConfig;
    private final ReferenceDateTask referenceDateTask;
    private final MessageDAO messageDAO;
    private Runnable messageEnqueuedNotifier;
    private Function<Long, OutboundQueueMessage> messageFinishedNotifier;

    public OutboundQueueMessageDAO(HibernateSessionFactory hibernateSessionFactory, MessengerConfig messengerConfig, ReferenceDateTask referenceDateTask, MessageDAO messageDAO) {
        super(hibernateSessionFactory);
        this._messengerConfig = messengerConfig;
        this.referenceDateTask = referenceDateTask;
        this.messageDAO = messageDAO;
    }

    public void enqueue(XpMessage xpMessage) throws DbException {
        this.enqueue(xpMessage, null, 0);
    }

    public void enqueue(XpMessage xpMessage, Long timeToLive, int priority) throws DbException {
        OutboundQueueMessage outboundQueue = new OutboundQueueMessage();
        outboundQueue.setStatus(0);
        outboundQueue.setMessageId(xpMessage.getDatabaseId());
        outboundQueue.setReceiverId(xpMessage.getReceiverLocalId());
        outboundQueue.setPriority(priority);
        outboundQueue.setTimeToLive(OutboundQueueMessageDAO.toOffsetDateTime(timeToLive));
        outboundQueue.setEnqueueTime(this.getNow());
        outboundQueue.setMessengerId(xpMessage.getMessengerId());
        this.enqueue(outboundQueue);
    }

    void enqueue(OutboundQueueMessage outboundQueue) throws DbException {
        if (Objects.isNull(outboundQueue.getMessageId()) || outboundQueue.getMessageId() < 0L) {
            throw new DbException(13013, "Can't enqueue OutboundMessage for receiver '" + outboundQueue.getReceiverId() + "' without messageId (" + outboundQueue.getMessageId() + ")");
        }
        try (EntityManager entityManager = this.createNewEntityManager();){
            entityManager.getTransaction().begin();
            entityManager.merge((Object)outboundQueue);
            this.messageDAO.updateMessageStatusInSameTransaction(outboundQueue.getMessageId(), 2, entityManager);
            entityManager.getTransaction().commit();
            if (Objects.nonNull(this.messageEnqueuedNotifier)) {
                this.messageEnqueuedNotifier.run();
            }
        }
        catch (RuntimeException e) {
            throw new DbException(13013, "Can't enqueue OutboundMessage (" + outboundQueue.getMessageId() + "): " + e.getMessage(), e);
        }
    }

    public void setTimeToLive(long messageDatabaseId, long timeToLive) throws DbException {
        block9: {
            try (EntityManager entityManager = this.createNewEntityManager();){
                entityManager.getTransaction().begin();
                int result = entityManager.createQuery(" UPDATE OutboundQueueMessage SET timeToLive = :timeToLive WHERE messageId = :messageId").setParameter("timeToLive", (Object)OutboundQueueMessageDAO.toOffsetDateTime(timeToLive)).setParameter(PARAM_MESSAGE_ID, (Object)messageDatabaseId).executeUpdate();
                if (result == 1) {
                    entityManager.getTransaction().commit();
                    break block9;
                }
                entityManager.getTransaction().rollback();
                throw new IllegalStateException("Message with id " + messageDatabaseId + " does not exist in the outbound queue.");
            }
            catch (RuntimeException e) {
                throw new DbException(-1, "Could not set timeToLive for OutboundMessage (" + messageDatabaseId + "): " + e.getMessage());
            }
        }
    }

    public List<String> getReceiverWithQueuedMessages() throws DbException {
        List list;
        block8: {
            EntityManager entityManager = this.createNewEntityManager();
            try {
                List results;
                list = results = entityManager.createQuery("SELECT DISTINCT receiverId\nFROM OutboundQueueMessage\nWHERE (status = 0 AND receiverId NOT IN (SELECT partnerId FROM RemoteMaintenanceInterval WHERE startTime <= :timestamp AND :timestamp <= endTime)\n       OR (status = 1 AND messengerId = :messengerId))\n", String.class).setParameter(PARAM_MESSENGER_ID, (Object)this._messengerConfig.getMessengerId()).setParameter("timestamp", (Object)this.referenceDateTask.getReferenceDate().getTime()).getResultList();
                if (entityManager == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (entityManager != null) {
                        try {
                            entityManager.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (RuntimeException e) {
                    throw new DbException(13008, "Can't select receivers with pending messages: " + e.getMessage(), e);
                }
            }
            entityManager.close();
        }
        return list;
    }

    public List<String> getReceiverWithInTransitMessages() throws DbException {
        List list;
        block8: {
            EntityManager entityManager = this.createNewEntityManager();
            try {
                List results;
                list = results = entityManager.createQuery("SELECT DISTINCT receiverId\nFROM OutboundQueueMessage\nWHERE status = 1 AND messengerId = :messengerId\n", String.class).setParameter("timestamp", (Object)this.referenceDateTask.getReferenceDate().getTime()).setParameter(PARAM_MESSENGER_ID, (Object)this._messengerConfig.getMessengerId()).getResultList();
                if (entityManager == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (entityManager != null) {
                        try {
                            entityManager.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (RuntimeException e) {
                    throw new DbException(13008, "Can't select receivers with pending messages: " + e.getMessage(), e);
                }
            }
            entityManager.close();
        }
        return list;
    }

    public List<OutboundQueueMessage> getOwnMessagesInTransfer() throws DbException {
        List list;
        block8: {
            EntityManager entityManager = this.createNewEntityManager();
            try {
                List messages;
                list = messages = entityManager.createQuery(QUERY_SELECT_MESSENGER_MESSAGES_IN_TRANSFER, OutboundQueueMessage.class).setParameter(PARAM_MESSENGER_ID, (Object)this._messengerConfig.getMessengerId()).getResultList();
                if (entityManager == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (entityManager != null) {
                        try {
                            entityManager.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (RuntimeException e) {
                    throw new DbException(13008, "Can't select messages with status 'IN TRANSFER' of messenger " + this._messengerConfig.getMessengerId() + ": " + e.getMessage(), e);
                }
            }
            entityManager.close();
        }
        return list;
    }

    public OutboundQueueMessage getMessage(long messageId) throws DbException {
        OutboundQueueMessage outboundQueueMessage;
        block8: {
            EntityManager entityManager = this.createNewEntityManager();
            try {
                OutboundQueueMessage nextMessage;
                outboundQueueMessage = nextMessage = (OutboundQueueMessage)entityManager.find(OutboundQueueMessage.class, (Object)messageId);
                if (entityManager == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (entityManager != null) {
                        try {
                            entityManager.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (RuntimeException e) {
                    throw new DbException(13008, "Can't select OutboundMessage " + messageId + ": " + e.getMessage(), e);
                }
            }
            entityManager.close();
        }
        return outboundQueueMessage;
    }

    public OutboundQueueMessage getMessageInTransfer(long messageId) throws DbException {
        OutboundQueueMessage outboundQueueMessage;
        block9: {
            EntityManager entityManager = this.createNewEntityManager();
            try {
                OutboundQueueMessage msg;
                outboundQueueMessage = msg = (OutboundQueueMessage)entityManager.createQuery(QUERY_SELECT_MESSAGE_WITH_STATUS, OutboundQueueMessage.class).setParameter(PARAM_MESSAGE_ID, (Object)messageId).setParameter("status", (Object)1).setParameter(PARAM_MESSENGER_ID, (Object)this._messengerConfig.getMessengerId()).getSingleResult();
                if (entityManager == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (entityManager != null) {
                        try {
                            entityManager.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (NoResultException ignore) {
                    return null;
                }
                catch (RuntimeException e) {
                    throw new DbException(13008, "Can't select OutboundMessage " + messageId + " with status IN TRANSFER: " + e.getMessage(), e);
                }
            }
            entityManager.close();
        }
        return outboundQueueMessage;
    }

    public List<Long> selectNextMessageIds(String receiverId, int messageCount) throws DbException {
        List list;
        block8: {
            EntityManager entityManager = this.createNewEntityManager();
            try {
                List resultList;
                list = resultList = entityManager.createQuery(QUERY_GET_NEXT_MESSAGE_IDS, Long.class).setParameter("receiverId", (Object)receiverId).setMaxResults(messageCount).getResultList();
                if (entityManager == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (entityManager != null) {
                        try {
                            entityManager.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (RuntimeException e) {
                    throw new DbException(13008, "Can't select next messageIds of receiver " + receiverId + ": " + e.getMessage(), e);
                }
            }
            entityManager.close();
        }
        return list;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean startTransfer(long messageId) throws DbException {
        try (EntityManager entityManager = this.createNewEntityManager();){
            entityManager.getTransaction().begin();
            OffsetDateTime now = this.getNow();
            int updateCount = entityManager.createQuery(QUERY_UPDATE_NEXT_MESSAGE).setParameter(PARAM_MESSAGE_ID, (Object)messageId).setParameter(PARAM_MESSENGER_ID, (Object)this._messengerConfig.getMessengerId()).setParameter("now", (Object)now).executeUpdate();
            if (updateCount == 1) {
                entityManager.getTransaction().commit();
                boolean bl2 = true;
                return bl2;
            }
            entityManager.getTransaction().rollback();
            boolean bl = false;
            return bl;
        }
        catch (RuntimeException e) {
            throw new DbException(13003, "Can't select receivers with pending messages: " + e.getMessage(), e);
        }
    }

    private OffsetDateTime getNow() {
        return this.referenceDateTask.getReferenceOffsetDateTime();
    }

    static OffsetDateTime toOffsetDateTime(Long millis) {
        return Objects.isNull(millis) ? null : OffsetDateTime.ofInstant(Instant.ofEpochMilli(millis), ZoneOffset.UTC);
    }

    public boolean finishMessage(long messageId) throws DbException {
        return this.finishMessage(messageId, true);
    }

    public boolean finishMessageWithoutNotify(long messageId) throws DbException {
        return this.finishMessage(messageId, false);
    }

    private boolean finishMessage(long messageId, boolean withNotify) throws DbException {
        boolean bl;
        block8: {
            EntityManager entityManager = this.createNewEntityManager();
            try {
                entityManager.getTransaction().begin();
                boolean finished = this.finishMessage(messageId, entityManager, withNotify);
                entityManager.getTransaction().commit();
                bl = finished;
                if (entityManager == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (entityManager != null) {
                        try {
                            entityManager.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (RuntimeException e) {
                    throw new DbException(13011, "Can't finish OutboundMessage (" + messageId + "): " + e.getMessage(), e);
                }
            }
            entityManager.close();
        }
        return bl;
    }

    public OutboundQueueMessage finishMessageWithResult(long messageId) throws DbException {
        OutboundQueueMessage msg = Objects.nonNull(this.messageFinishedNotifier) ? this.messageFinishedNotifier.apply(messageId) : null;
        this.finishMessage(messageId);
        if (Objects.isNull(msg)) {
            msg = this.getMessage(messageId);
        }
        return msg;
    }

    public boolean finishMessage(long messageId, EntityManager entityManager) throws DbException {
        return this.finishMessage(messageId, entityManager, true);
    }

    private boolean finishMessage(long messageId, EntityManager entityManager, boolean withNotify) throws DbException {
        boolean finished;
        boolean bl = finished = 1 == entityManager.createQuery(QUERY_FINISH_MESSAGE).setParameter(PARAM_MESSAGE_ID, (Object)messageId).executeUpdate();
        if (finished && withNotify && Objects.nonNull(this.messageFinishedNotifier)) {
            this.messageFinishedNotifier.apply(messageId);
        }
        return finished;
    }

    public int finishMessages(Collection<Long> messageIds, EntityManager entityManager) {
        int finished = entityManager.createQuery(QUERY_FINISH_MESSAGE_BY_IDS).setParameter(PARAM_MESSAGE_IDS, messageIds).executeUpdate();
        if (Objects.nonNull(this.messageFinishedNotifier)) {
            messageIds.forEach(messageId -> this.messageFinishedNotifier.apply((Long)messageId));
        }
        return finished;
    }

    public int deleteFinishMessages() throws DbException {
        int n;
        block8: {
            EntityManager entityManager = this.createNewEntityManager();
            try {
                entityManager.getTransaction().begin();
                int deleteCount = entityManager.createQuery(QUERY_DELETE_FINISHED_MESSAGE).setParameter(PARAM_MESSENGER_ID, (Object)this._messengerConfig.getMessengerId()).executeUpdate();
                entityManager.getTransaction().commit();
                n = deleteCount;
                if (entityManager == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (entityManager != null) {
                        try {
                            entityManager.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (RuntimeException e) {
                    throw new DbException(13011, "Can't delete FINISHED OutboundMessage: " + e.getMessage(), e);
                }
            }
            entityManager.close();
        }
        return n;
    }

    public boolean deleteMessage(long messageId) throws DbException {
        boolean bl;
        block9: {
            EntityManager entityManager = this.createNewEntityManager();
            try {
                entityManager.getTransaction().begin();
                int deleteCount = entityManager.createQuery(QUERY_DELETE_MESSAGE_BY_ID).setParameter(PARAM_MESSAGE_ID, (Object)messageId).executeUpdate();
                entityManager.getTransaction().commit();
                if (Objects.nonNull(this.messageFinishedNotifier)) {
                    this.messageFinishedNotifier.apply(messageId);
                }
                boolean bl2 = bl = deleteCount == 1;
                if (entityManager == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (entityManager != null) {
                        try {
                            entityManager.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (RuntimeException e) {
                    throw new DbException(13011, "Can't delete OutboundMessage (" + messageId + "): " + e.getMessage(), e);
                }
            }
            entityManager.close();
        }
        return bl;
    }

    public boolean rescheduleMessage(long messageId) throws DbException {
        boolean bl;
        block9: {
            EntityManager entityManager = this.createNewEntityManager();
            try {
                entityManager.getTransaction().begin();
                int rescheduleCount = entityManager.createQuery(QUERY_RESCHEDULE_MESSAGE).setParameter(PARAM_MESSAGE_ID, (Object)messageId).executeUpdate();
                entityManager.getTransaction().commit();
                if (rescheduleCount == 1 && Objects.nonNull(this.messageEnqueuedNotifier)) {
                    this.messageEnqueuedNotifier.run();
                }
                boolean bl2 = bl = rescheduleCount == 1;
                if (entityManager == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (entityManager != null) {
                        try {
                            entityManager.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (RuntimeException e) {
                    throw new DbException(13017, "Can't reschedule OutboundMessage (" + messageId + "): " + e.getMessage(), e);
                }
            }
            entityManager.close();
        }
        return bl;
    }

    public int getQueueSize() {
        try (EntityManager entityManager = this.createNewEntityManager();){
            int n = ((Long)entityManager.createQuery(QUERY_SELECT_MESSAGE_COUNT, Long.class).getSingleResult()).intValue();
            return n;
        }
    }

    public void dbConsistencyCheck(Message testMessage) throws DbException {
        try (EntityManager entityManager = this.createNewEntityManager();){
            entityManager.getTransaction().begin();
            OutboundQueueMessage outboundQueue = new OutboundQueueMessage();
            outboundQueue.setStatus(-1);
            outboundQueue.setMessageId(testMessage.getId());
            outboundQueue.setReceiverId(testMessage.getReceiverId());
            outboundQueue.setPriority(-1);
            outboundQueue.setEnqueueTime(this.getNow());
            entityManager.persist((Object)outboundQueue);
            entityManager.getTransaction().commit();
        }
        catch (RuntimeException e) {
            throw new DbException(13042, "DB Consistency check for table 'OUTBOUND_QUEUE' failed. Reason: " + e.getMessage(), e);
        }
    }

    public void setMessageEnqueuedNotifier(Runnable messageEnqueuedNotifier) {
        this.messageEnqueuedNotifier = messageEnqueuedNotifier;
    }

    public void setMessageFinishedNotifier(Function<Long, OutboundQueueMessage> messageFinishedNotifier) {
        this.messageFinishedNotifier = messageFinishedNotifier;
    }

    public boolean containsMessages(Collection<Long> messageDataIds, EntityManager entityManager) {
        return ((Long)entityManager.createQuery(QUERY_SELECT_MESSAGE_COUNT_FOR_IDS, Long.class).setParameter(PARAM_MESSAGE_IDS, messageDataIds).getSingleResult()).intValue() > 0;
    }

    public List<OutboundQueueMessage> getExpiredMessages() throws DbException {
        List list;
        block8: {
            EntityManager entityManager = this.createNewEntityManager();
            try {
                List messages;
                list = messages = entityManager.createQuery(QUERY_SELECT_EXPIRED_MESSAGES, OutboundQueueMessage.class).setParameter("now", (Object)this.referenceDateTask.getReferenceOffsetDateTime()).getResultList();
                if (entityManager == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (entityManager != null) {
                        try {
                            entityManager.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (RuntimeException e) {
                    throw new DbException(13008, "Can't select expired messages: " + e.getMessage(), e);
                }
            }
            entityManager.close();
        }
        return list;
    }

    public boolean resetTransmissionState(long messageId) {
        try (EntityManager entityManager = this.createNewEntityManager();){
            entityManager.getTransaction().begin();
            int updateCount = entityManager.createQuery(SQL_UPDATE_RESET_TRANSMISSION).setParameter(PARAM_MESSAGE_ID, (Object)messageId).executeUpdate();
            if (updateCount == 0) {
                _log.warn("No OutboundQueue message found to reset (messageId={} / status=1)", (Object)messageId);
            } else {
                _log.trace("TransmissionState of InboundQueue message (messageId={}) reset", (Object)messageId);
            }
            entityManager.getTransaction().commit();
            boolean bl = updateCount == 1;
            return bl;
        }
    }
}

