/*
 * Decompiled with CFR 0.152.
 */
package de.pontonconsulting.xmlpipe.messenger.database.tables;

import de.pontonconsulting.xmlpipe.messenger.ReferenceDateTask;
import de.pontonconsulting.xmlpipe.messenger.database.HibernateSessionFactory;
import de.pontonconsulting.xmlpipe.messenger.database.hibernate.MessengerUser;
import de.pontonconsulting.xmlpipe.messenger.database.tables.BaseDAO;
import jakarta.persistence.EntityManager;
import jakarta.persistence.Query;
import jakarta.persistence.TypedQuery;
import java.util.List;
import org.springframework.security.crypto.password.PasswordEncoder;

public class MessengerUserDAO
extends BaseDAO {
    private final PasswordEncoder passwordEncoder;
    private final ReferenceDateTask referenceDateTask;

    public MessengerUserDAO(HibernateSessionFactory hibernateSessionFactory, PasswordEncoder passwordEncoder, ReferenceDateTask referenceDateTask) {
        super(hibernateSessionFactory);
        this.passwordEncoder = passwordEncoder;
        this.referenceDateTask = referenceDateTask;
    }

    public boolean isEmpty() {
        try (EntityManager entityManager = this.createNewEntityManager();){
            boolean bl = (Long)entityManager.createQuery("SELECT count(*) FROM MessengerUser", Long.class).getSingleResult() == 0L;
            return bl;
        }
    }

    public List<MessengerUser> getAll() {
        try (EntityManager entityManager = this.createNewEntityManager();){
            List fromMessengerUser = entityManager.createQuery("FROM MessengerUser", MessengerUser.class).getResultList();
            fromMessengerUser.forEach(entity -> entity.setCurrentTimeSupplier(this.referenceDateTask::getReferenceOffsetDateTime));
            List list = fromMessengerUser;
            return list;
        }
    }

    public MessengerUser getUser(String username) {
        try (EntityManager entityManager = this.createNewEntityManager();){
            MessengerUser messengerUser = (MessengerUser)entityManager.find(MessengerUser.class, (Object)username);
            if (messengerUser != null) {
                messengerUser.setCurrentTimeSupplier(this.referenceDateTask::getReferenceOffsetDateTime);
            }
            MessengerUser messengerUser2 = messengerUser;
            return messengerUser2;
        }
    }

    public void addOldPassword(String username, String password) {
        try (EntityManager entityManager = this.createNewEntityManager();){
            entityManager.getTransaction().begin();
            Query query = entityManager.createNativeQuery("INSERT into OLD_PASSWORD (USERNAME, PASSWORD) VALUES (:username, :password)");
            query.setParameter("username", (Object)username);
            query.setParameter("password", (Object)password);
            query.executeUpdate();
            entityManager.getTransaction().commit();
        }
    }

    public boolean isPasswordAlreadyUsed(String username, String password) {
        try (EntityManager entityManager = this.createNewEntityManager();){
            TypedQuery query = entityManager.createQuery("SELECT op.password FROM OldPassword op WHERE op.id.username = :username", String.class);
            query.setParameter("username", (Object)username);
            for (String p : query.getResultList()) {
                try {
                    if (!this.passwordEncoder.matches((CharSequence)password, p)) continue;
                    boolean bl = true;
                    return bl;
                }
                catch (Exception exception) {}
            }
            boolean bl = false;
            return bl;
        }
    }

    public boolean deleteUser(String username) {
        boolean result = false;
        try (EntityManager entityManager = this.createNewEntityManager();){
            entityManager.getTransaction().begin();
            MessengerUser user = (MessengerUser)entityManager.find(MessengerUser.class, (Object)username);
            if (user != null) {
                entityManager.remove((Object)user);
                result = true;
            }
            entityManager.getTransaction().commit();
        }
        return result;
    }

    public boolean save(MessengerUser user) {
        boolean created = false;
        try (EntityManager entityManager = this.createNewEntityManager();){
            entityManager.getTransaction().begin();
            MessengerUser existing = (MessengerUser)entityManager.find(MessengerUser.class, (Object)user.getUsername());
            entityManager.merge((Object)user);
            entityManager.getTransaction().commit();
            created = existing == null;
        }
        return created;
    }
}

