/*
 * Decompiled with CFR 0.152.
 */
package de.pontonconsulting.xmlpipe.messenger.database.tables;

import de.pontonconsulting.xmlpipe.config.IFolders;
import de.pontonconsulting.xmlpipe.messenger.database.ConnectionPool;
import de.pontonconsulting.xmlpipe.messenger.database.DbException;
import de.pontonconsulting.xmlpipe.messenger.database.HibernateSessionFactory;
import de.pontonconsulting.xmlpipe.messenger.database.hibernate.Conversation;
import de.pontonconsulting.xmlpipe.messenger.database.tables.BaseDAO;
import jakarta.persistence.EntityManager;
import jakarta.persistence.NoResultException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;

public class ConversationDAO
extends BaseDAO {
    private static final String SQL_UPDATE_SEQUENCE_OFFSET = "UPDATE CONVERSATION SET SEQUENCE_OFFSET=? WHERE ID=?";
    public static final String TEST_VALUE_CONVERSATION_ID = "CID-1234567890123456789@ponton-consulting.de";
    private static final String SQL_GET_CONVERSATION_DATA_ID2 = "SELECT c FROM de.pontonconsulting.xmlpipe.messenger.database.hibernate.Conversation c WHERE c.conversationId = :conversation_id";
    private static final String QUERY_DELETE_ORPHAN_CONVERSATIONS_NATIVE = "DELETE from CONVERSATION\nWHERE NOT EXISTS (SELECT 1 FROM MESSAGE WHERE MESSAGE.conversation = CONVERSATION.id )\n";
    private static final String QUERY_DELETE_SINGLE_ORPHAN_CONVERSATION = "DELETE de.pontonconsulting.xmlpipe.messenger.database.hibernate.Conversation c WHERE c.id = :id AND (SELECT count(m) FROM de.pontonconsulting.xmlpipe.messenger.database.hibernate.Message m WHERE m.conversation.id = :id) = 0";

    public ConversationDAO(HibernateSessionFactory hibernateSessionFactory, IFolders folders) {
        super(hibernateSessionFactory);
    }

    public void deleteConversation(Conversation conversation) {
        if (conversation != null) {
            try (EntityManager entityManager = this.createNewEntityManager();){
                entityManager.getTransaction().begin();
                this.deleteConversation(conversation.getId(), entityManager);
                entityManager.getTransaction().commit();
            }
            catch (Exception e) {
                _log.error("Conversation could not be deleted from database: " + e.getMessage(), (Throwable)e);
            }
        }
    }

    public void deleteConversation(Long convDatabaseId, EntityManager entityManager) throws DbException {
        if (convDatabaseId != null) {
            try {
                int result = entityManager.createQuery(QUERY_DELETE_SINGLE_ORPHAN_CONVERSATION).setParameter("id", (Object)convDatabaseId).executeUpdate();
                if (result <= 0) {
                    _log.debug("Conversation {} has still referencing messages and is NOT deleted", (Object)convDatabaseId);
                } else {
                    _log.debug("Orphan Conversation {} deleted", (Object)convDatabaseId);
                }
            }
            catch (RuntimeException e) {
                throw new DbException(-1, "Conversation could not be deleted from database: ", e);
            }
        }
    }

    public Conversation getConversationData(String conversationId, EntityManager entityManager) {
        try {
            return (Conversation)entityManager.createQuery(SQL_GET_CONVERSATION_DATA_ID2, Conversation.class).setParameter("conversation_id", (Object)conversationId).getSingleResult();
        }
        catch (NoResultException e) {
            return null;
        }
    }

    public void dbConsistencyCheck() throws DbException {
        try (EntityManager entityManager = this.createNewEntityManager();){
            entityManager.getTransaction().begin();
            Conversation conversation = new Conversation();
            conversation.setConversationId(TEST_VALUE_CONVERSATION_ID);
            entityManager.persist((Object)conversation);
            entityManager.getTransaction().commit();
        }
        catch (RuntimeException e) {
            throw new DbException(13030, "DB Consistency check for table 'CONVERSATION' failed. Reason: " + e.getMessage(), e);
        }
    }

    public void dbCleanup() {
        try (EntityManager entityManager = this.createNewEntityManager();){
            Conversation conversation = this.getConversationData(TEST_VALUE_CONVERSATION_ID, entityManager);
            this.deleteConversation(conversation);
        }
    }

    public void updateSequenceOffset(long conversationDatabaseId, long offset) throws DbException {
        Connection conn = null;
        PreparedStatement stmt = null;
        try {
            conn = ConnectionPool.getDataSource().getConnection();
            stmt = conn.prepareStatement(SQL_UPDATE_SEQUENCE_OFFSET);
            stmt.setLong(1, offset);
            stmt.setLong(2, conversationDatabaseId);
            stmt.executeUpdate();
            if (!conn.getAutoCommit()) {
                conn.commit();
            }
        }
        catch (SQLException e) {
            try {
                this.rollbackConnection(conn);
                _log.error("Could not update sequence inbound offset in DB");
                throw new DbException(13056, "Could not update sequence inbound offset.", e);
            }
            catch (Throwable throwable) {
                this.closeStatement(stmt);
                this.closeConnection(conn);
                throw throwable;
            }
        }
        this.closeStatement(stmt);
        this.closeConnection(conn);
    }

    public int deleteOrphaned(EntityManager entityManager) {
        return entityManager.createNativeQuery(QUERY_DELETE_ORPHAN_CONVERSATIONS_NATIVE, Long.class).executeUpdate();
    }
}

