/*
 * Decompiled with CFR 0.152.
 */
package de.pontonconsulting.xmlpipe.messenger.database.tables;

import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.atomic.AtomicLong;

public class BlockInputStream
extends InputStream {
    private final InputStream mainInputStream;
    private final long maxBlockSize;
    private final AtomicLong currentBlockSize;
    private int lastReadByte = -1;

    public BlockInputStream(InputStream mainInputStream, long maxBlockSize) {
        this.mainInputStream = mainInputStream;
        this.maxBlockSize = maxBlockSize;
        this.currentBlockSize = new AtomicLong(maxBlockSize);
    }

    @Override
    public int read() throws IOException {
        int readByte;
        if (this.currentBlockSize.get() == this.maxBlockSize) {
            return -1;
        }
        if (this.lastReadByte != -1) {
            readByte = this.lastReadByte;
            this.lastReadByte = -1;
        } else {
            readByte = this.mainInputStream.read();
        }
        if (readByte != -1) {
            this.currentBlockSize.incrementAndGet();
        }
        return readByte;
    }

    public boolean hasNext() throws IOException {
        if (this.currentBlockSize.get() < this.maxBlockSize) {
            return false;
        }
        this.lastReadByte = this.mainInputStream.read();
        if (this.lastReadByte == -1) {
            return false;
        }
        this.currentBlockSize.set(0L);
        return true;
    }
}

