/*
 * Decompiled with CFR 0.152.
 */
package de.pontonconsulting.xmlpipe.messenger.database.tables;

import de.pontonconsulting.xmlpipe.config.IFolders;
import de.pontonconsulting.xmlpipe.config.MessengerConfig;
import de.pontonconsulting.xmlpipe.messenger.ReferenceDateTask;
import de.pontonconsulting.xmlpipe.messenger.database.DbException;
import de.pontonconsulting.xmlpipe.messenger.database.HibernateSessionFactory;
import de.pontonconsulting.xmlpipe.messenger.database.hibernate.ArchiveQueue;
import de.pontonconsulting.xmlpipe.messenger.database.tables.BaseDAO;
import jakarta.persistence.EntityManager;
import jakarta.persistence.NoResultException;
import java.util.Objects;
import java.util.Optional;

public class ArchiveQueueDAO
extends BaseDAO {
    public static final int STATUS_ENQUEUED = 0;
    public static final int STATUS_ON_ARCHIVING = 1;
    private static final String PARAM_MESSENGER_ID = "messengerId";
    private static final String PARAM_STATUS_NEW = "statusNew";
    private static final String PARAM_STATUS_OLD = "statusOld";
    private static final String PARAM_MESSAGE_ID = "messageId";
    private final MessengerConfig messengerConfig;
    private final ReferenceDateTask referenceDateTask;

    public ArchiveQueueDAO(HibernateSessionFactory hibernateSessionFactory, IFolders folders, MessengerConfig messengerConfig, ReferenceDateTask referenceDateTask) {
        super(hibernateSessionFactory);
        this.messengerConfig = messengerConfig;
        this.referenceDateTask = referenceDateTask;
    }

    public boolean enqueue(long messageId, boolean isFailedMessage) throws DbException {
        boolean bl;
        block15: {
            EntityManager entityManager = this.createNewEntityManager();
            try {
                entityManager.getTransaction().begin();
                ArchiveQueue archiveQueue = new ArchiveQueue();
                archiveQueue.setMessageId(messageId);
                archiveQueue.setFailedMessage(isFailedMessage);
                archiveQueue.setStatus(0);
                archiveQueue.setEnqueueTime(this.referenceDateTask.getReferenceOffsetDateTime());
                entityManager.persist((Object)archiveQueue);
                entityManager.getTransaction().commit();
                bl = true;
                if (entityManager == null) break block15;
            }
            catch (Throwable throwable) {
                try {
                    if (entityManager != null) {
                        try {
                            entityManager.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    DbException dbException = new DbException(13013, "Can't enqueue ArchiveMessage (" + messageId + "): " + e.getMessage(), e);
                    entityManager = this.createNewEntityManager();
                    try {
                        if (Objects.nonNull(entityManager.find(ArchiveQueue.class, (Object)messageId))) {
                            boolean bl2 = false;
                            return bl2;
                        }
                    }
                    finally {
                        if (entityManager != null) {
                            entityManager.close();
                        }
                    }
                    throw dbException;
                }
            }
            entityManager.close();
        }
        return bl;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Optional<ArchiveQueue> getNextMessageToArchive() {
        try (EntityManager entityManager = this.createNewEntityManager();){
            Long messageId = (Long)entityManager.createQuery("SELECT messageId\nFROM ArchiveQueue\nWHERE status = 0\nORDER BY enqueueTime", Long.class).setMaxResults(1).getSingleResult();
            _log.trace("Found next message ({}) to archive", (Object)messageId);
            entityManager.getTransaction().begin();
            int updateCount = entityManager.createQuery("UPDATE ArchiveQueue\nSET status = :statusNew, messengerId = :messengerId, lastArchiveRun = :now\nWHERE status = :statusOld AND messageId = :messageId").setParameter(PARAM_STATUS_NEW, (Object)1).setParameter(PARAM_STATUS_OLD, (Object)0).setParameter(PARAM_MESSENGER_ID, (Object)this.messengerConfig.getMessengerId()).setParameter("now", (Object)this.referenceDateTask.getReferenceOffsetDateTime()).setParameter(PARAM_MESSAGE_ID, (Object)messageId).executeUpdate();
            if (updateCount == 1) {
                _log.trace("Started ArchiveProcess of message ({})", (Object)messageId);
                entityManager.getTransaction().commit();
                Optional<ArchiveQueue> optional2 = Optional.of((ArchiveQueue)entityManager.find(ArchiveQueue.class, (Object)messageId));
                return optional2;
            }
            _log.trace("ArchiveProcess of message ({}) is already started", (Object)messageId);
            entityManager.getTransaction().rollback();
            Optional<ArchiveQueue> optional = Optional.empty();
            return optional;
        }
        catch (NoResultException e) {
            _log.debug("No pending message to archive found");
            return Optional.empty();
        }
        catch (Exception e) {
            _log.fatal("Can't select next pending message to archive", (Throwable)e);
        }
        return Optional.empty();
    }

    public Long getArchiveQueueSize() {
        try (EntityManager entityManager = this.createNewEntityManager();){
            Long l = (Long)entityManager.createQuery("SELECT count(*) FROM ArchiveQueue", Long.class).getSingleResult();
            return l;
        }
    }

    public Long getCountOfPendingMessages() {
        try (EntityManager entityManager = this.createNewEntityManager();){
            Long l = (Long)entityManager.createQuery("SELECT count(*) FROM ArchiveQueue WHERE status=0", Long.class).getSingleResult();
            return l;
        }
    }

    public int resetTimedOutArchiveQueueMessages() {
        try (EntityManager entityManager = this.createNewEntityManager();){
            entityManager.getTransaction().begin();
            int resetCount = entityManager.createQuery("UPDATE ArchiveQueue\nSET status = :statusNew, lastArchiveRun = NULL\nWHERE status = :statusOld AND lastArchiveRun < :timeOut AND messengerId != :messengerId").setParameter(PARAM_STATUS_NEW, (Object)0).setParameter(PARAM_STATUS_OLD, (Object)1).setParameter(PARAM_MESSENGER_ID, (Object)this.messengerConfig.getMessengerId()).setParameter("timeOut", (Object)this.referenceDateTask.getReferenceOffsetDateTime().minusMinutes(10L)).executeUpdate();
            entityManager.getTransaction().commit();
            int n = resetCount;
            return n;
        }
    }

    public int resetOwnArchiveQueueMessages() {
        try (EntityManager entityManager = this.createNewEntityManager();){
            entityManager.getTransaction().begin();
            int resetCount = entityManager.createQuery("UPDATE ArchiveQueue\nSET status = :statusNew, lastArchiveRun = NULL\nWHERE status = :statusOld AND messengerId = :messengerId").setParameter(PARAM_STATUS_NEW, (Object)0).setParameter(PARAM_STATUS_OLD, (Object)1).setParameter(PARAM_MESSENGER_ID, (Object)this.messengerConfig.getMessengerId()).executeUpdate();
            entityManager.getTransaction().commit();
            int n = resetCount;
            return n;
        }
    }

    public boolean resetArchiveQueueMessage(long messageId) {
        try (EntityManager entityManager = this.createNewEntityManager();){
            entityManager.getTransaction().begin();
            int resetCount = entityManager.createQuery("UPDATE ArchiveQueue\nSET status = :statusNew, lastArchiveRun = NULL\nWHERE status = :statusOld AND messageId = :messageId").setParameter(PARAM_STATUS_NEW, (Object)0).setParameter(PARAM_STATUS_OLD, (Object)1).setParameter(PARAM_MESSAGE_ID, (Object)messageId).executeUpdate();
            entityManager.getTransaction().commit();
            boolean bl = resetCount == 1;
            return bl;
        }
    }

    public boolean deleteArchiveQueue(long messageId) {
        try (EntityManager entityManager = this.createNewEntityManager();){
            entityManager.getTransaction().begin();
            int deleteCount = entityManager.createQuery("DELETE FROM ArchiveQueue WHERE messageId = :messageId").setParameter(PARAM_MESSAGE_ID, (Object)messageId).executeUpdate();
            entityManager.getTransaction().commit();
            boolean bl = deleteCount == 1;
            return bl;
        }
    }
}

