/*
 * Decompiled with CFR 0.152.
 */
package de.pontonconsulting.xmlpipe.messenger.database.tables;

import de.ponton.api.WebSocketAdapterInfo;
import de.pontonconsulting.xmlpipe.adapter.AdapterInfo;
import de.pontonconsulting.xmlpipe.adapter.AdapterRegistry;
import de.pontonconsulting.xmlpipe.config.IFolders;
import de.pontonconsulting.xmlpipe.config.MessengerConfig;
import de.pontonconsulting.xmlpipe.messenger.database.DbException;
import de.pontonconsulting.xmlpipe.messenger.database.HibernateSessionFactory;
import de.pontonconsulting.xmlpipe.messenger.database.hibernate.AdapterInfoId;
import de.pontonconsulting.xmlpipe.messenger.database.tables.BaseDAO;
import jakarta.persistence.EntityManager;
import jakarta.persistence.Query;
import jakarta.persistence.TypedQuery;
import jakarta.persistence.criteria.CriteriaBuilder;
import jakarta.persistence.criteria.CriteriaDelete;
import jakarta.persistence.criteria.CriteriaQuery;
import jakarta.persistence.criteria.Expression;
import jakarta.persistence.criteria.Predicate;
import jakarta.persistence.criteria.Root;
import jakarta.persistence.criteria.Selection;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;

public final class AdapterInfoDAO
extends BaseDAO {
    private static final String ERROR_GET_ADAPTER_INFO = "Error while getting Adapter Info from Database for ";
    private static final String ERROR_ADD_ADAPTER_INFO = "Error while adding Adapter Info to Database: ";
    private static final String ERROR_REMOVE_ADAPTER_INFO = "Error while removing Adapter Info from Database: ";
    private static final String ERROR_UPDATE_ADAPTER_INFO = "Error while updating Adapter Info in Database: ";
    private static final String REFERENCE_NOT_FOUND = "Reference not found";
    private static final String SQL_DELETE_ADAPTER_INFO_BY_ID = "DELETE de.pontonconsulting.xmlpipe.messenger.database.hibernate.AdapterInfo WHERE id.adapterId=:adapterId AND id.messengerId=:messengerId";
    protected static final String TEST_VALUE_ADAPTER_ID = "DBTestAdapter";
    protected static final String TEST_VALUE_ADDRESS = "";
    protected static final int TEST_VALUE_MAXIMUM_THREADS = 5;
    private static final String FEATURES_SEPARATOR = ";";
    private static final String FEATURES_SUPPORTS_ACKS = "SUPP_ACKS";
    private static final String FEATURES_SUPPORTS_ERRNOT = "SUPP_ERRNOT";
    private static final String FEATURES_SUPPORTS_RESPONSES = "SUPP_RESS";
    private static final String FEATURES_SUPPORTS_ATTACHMENTS = "SUPP_ATTS";
    private static final String FEATURES_SUPPORTS_INBOUND_MESSAGE = "SUPP_INMSG";
    private static final String FEATURES_SUPPORTS_ARCHIVE = "SUPP_ARCH";
    private static final String FEATURES_ACCEPT_PARTNER_CHANGE_EVENTS = "ACC_PCES";
    private static final String FEATURES_ACCEPT_AGREEMENT_CHANGE_EVENTS = "ACC_ACES";
    private static final String FEATURES_SERVICEIDS_PREFIX = "SERVICES=";
    private static final String FEATURES_SERVICE_SEPARATOR = ",";
    private final AdapterRegistry _registry;
    private final MessengerConfig _messengerConfig;

    public AdapterInfoDAO(HibernateSessionFactory hibernateSessionFactory, IFolders folders, AdapterRegistry registry, MessengerConfig messengerConfig) {
        super(hibernateSessionFactory);
        this._registry = registry;
        this._messengerConfig = messengerConfig;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addAdapter(AdapterInfo adapter) throws DbException {
        if (adapter.getId() == null || adapter.getId().isEmpty()) {
            throw new DbException(13025, "No adaptername supplied.");
        }
        if (adapter.getAddress() == null || adapter.getAddress().isEmpty()) {
            throw new DbException(13025, "No adapter url supplied.");
        }
        AdapterInfoDAO adapterInfoDAO = this;
        synchronized (adapterInfoDAO) {
            block23: {
                AdapterInfo oldInfo = this.getAdapter(adapter.getId());
                if (oldInfo != null && !oldInfo.isUsingDirectCommunication()) {
                    oldInfo.setIsDown(false);
                    try (EntityManager entityManager = this.createNewEntityManager();){
                        entityManager.getTransaction().begin();
                        AdapterInfoId adapterInfoId = new AdapterInfoId();
                        adapterInfoId.setAdapterId(adapter.getId());
                        adapterInfoId.setMessengerId(this._messengerConfig.getMessengerId());
                        de.pontonconsulting.xmlpipe.messenger.database.hibernate.AdapterInfo hibernateAdapterInfo = (de.pontonconsulting.xmlpipe.messenger.database.hibernate.AdapterInfo)entityManager.find(de.pontonconsulting.xmlpipe.messenger.database.hibernate.AdapterInfo.class, (Object)adapterInfoId);
                        if (hibernateAdapterInfo == null) {
                            throw new DbException(13023, "Error while updating Adapter Info in Database: Reference not found");
                        }
                        hibernateAdapterInfo.setAddress(StringUtils.left((String)adapter.getAddress(), (int)128));
                        hibernateAdapterInfo.setMaximumThreads(adapter.getMaximumThreads());
                        hibernateAdapterInfo.setProcessingTimeout(adapter.getProcessingTimeout());
                        hibernateAdapterInfo.setFeatures(this.buildFeatures(adapter));
                        entityManager.persist((Object)hibernateAdapterInfo);
                        entityManager.getTransaction().commit();
                        break block23;
                    }
                    catch (RuntimeException e) {
                        throw new DbException(13024, ERROR_UPDATE_ADAPTER_INFO + e.toString());
                    }
                }
                try (EntityManager entityManager = this.createNewEntityManager();){
                    entityManager.getTransaction().begin();
                    AdapterInfoId adapterInfoId = new AdapterInfoId();
                    adapterInfoId.setAdapterId(adapter.getId());
                    adapterInfoId.setMessengerId(this._messengerConfig.getMessengerId());
                    de.pontonconsulting.xmlpipe.messenger.database.hibernate.AdapterInfo hibAI = new de.pontonconsulting.xmlpipe.messenger.database.hibernate.AdapterInfo();
                    hibAI.setId(adapterInfoId);
                    hibAI.setAddress(StringUtils.left((String)adapter.getAddress(), (int)128));
                    hibAI.setMaximumThreads(adapter.getMaximumThreads());
                    hibAI.setFeatures(this.buildFeatures(adapter));
                    hibAI.setProcessingTimeout(adapter.getProcessingTimeout());
                    entityManager.merge((Object)hibAI);
                    entityManager.getTransaction().commit();
                }
                catch (RuntimeException e) {
                    throw new DbException(13026, ERROR_ADD_ADAPTER_INFO + e.toString());
                }
            }
            this._registry.addAdapter(adapter);
        }
    }

    private String buildFeatures(AdapterInfo adapter) {
        WebSocketAdapterInfo webSocketAdapterInfo;
        Object features = null;
        if (adapter.supportsAcknowledgements()) {
            features = FEATURES_SUPPORTS_ACKS;
        }
        if (adapter.supportsAttachments()) {
            features = features != null ? (String)features + ";SUPP_ATTS" : FEATURES_SUPPORTS_ATTACHMENTS;
        }
        if (adapter.supportsStatusResponses()) {
            features = features != null ? (String)features + ";SUPP_RESS" : FEATURES_SUPPORTS_RESPONSES;
        }
        if (adapter.acceptsPartnerChangeEvents()) {
            features = features != null ? (String)features + ";ACC_PCES" : FEATURES_ACCEPT_PARTNER_CHANGE_EVENTS;
        }
        if (adapter.acceptsAgreementChangeEvents()) {
            features = features != null ? (String)features + ";ACC_ACES" : FEATURES_ACCEPT_AGREEMENT_CHANGE_EVENTS;
        }
        if (adapter.supportsErrorNotifications()) {
            features = features != null ? (String)features + ";SUPP_ERRNOT" : FEATURES_SUPPORTS_ERRNOT;
        }
        if (adapter.supportsArchive()) {
            features = features != null ? (String)features + ";SUPP_ARCH" : FEATURES_SUPPORTS_ARCHIVE;
        }
        if (adapter instanceof WebSocketAdapterInfo && (webSocketAdapterInfo = (WebSocketAdapterInfo)adapter).supportsInboundMessage()) {
            features = features != null ? (String)features + ";SUPP_INMSG" : FEATURES_SUPPORTS_INBOUND_MESSAGE;
        }
        Set<String> services = adapter.getServices();
        boolean servicesPrefixAdded = false;
        for (String serviceId : services) {
            if (!servicesPrefixAdded) {
                servicesPrefixAdded = true;
                if (features != null) {
                    features = (String)features + ";SERVICES=" + serviceId;
                    continue;
                }
                features = FEATURES_SERVICEIDS_PREFIX + serviceId;
                continue;
            }
            features = (String)features + FEATURES_SERVICE_SEPARATOR + serviceId;
        }
        return features;
    }

    public void restoreAdapters() throws DbException {
        AdapterInfo[] adapters;
        for (AdapterInfo adapterInfo : adapters = this._registry.getAllAdapters()) {
            this.removeAdapter(adapterInfo.getId());
            if ("INTERNAL".equals(adapterInfo.getAddress())) {
                this._registry.addAdapter(adapterInfo);
                continue;
            }
            this.addAdapter(adapterInfo);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAdapter(String adapterId) throws DbException {
        AdapterInfoDAO adapterInfoDAO = this;
        synchronized (adapterInfoDAO) {
            this.deleteFormDB(adapterId);
            AdapterInfo adapterInfo = this.getAdapter(adapterId);
            if (adapterInfo != null) {
                adapterInfo.setIsDown(true);
            }
            this._registry.removeAdapter(adapterId);
        }
    }

    private void deleteFormDB(String adapterId) throws DbException {
        try (EntityManager entityManager = this.createNewEntityManager();){
            entityManager.getTransaction().begin();
            Query qry = entityManager.createQuery(SQL_DELETE_ADAPTER_INFO_BY_ID);
            qry.setParameter("adapterId", (Object)adapterId);
            qry.setParameter("messengerId", (Object)this._messengerConfig.getMessengerId());
            qry.executeUpdate();
            entityManager.getTransaction().commit();
        }
        catch (RuntimeException e) {
            throw new DbException(13027, ERROR_REMOVE_ADAPTER_INFO + e.getMessage(), e);
        }
    }

    public AdapterInfo getAdapter(String adapterId) {
        return this._registry.getAdapter(adapterId);
    }

    public void init() throws DbException {
        this.reloadPersistentAdapterList();
    }

    private void reloadPersistentAdapterList() throws DbException {
        try (EntityManager entityManager = this.createNewEntityManager();){
            CriteriaBuilder criteriaBuilder = entityManager.getCriteriaBuilder();
            CriteriaQuery criteriaQuery = criteriaBuilder.createQuery(de.pontonconsulting.xmlpipe.messenger.database.hibernate.AdapterInfo.class);
            Root root = criteriaQuery.from(de.pontonconsulting.xmlpipe.messenger.database.hibernate.AdapterInfo.class);
            Predicate predicate = criteriaBuilder.conjunction();
            predicate.getExpressions().add(criteriaBuilder.equal((Expression)root.get("id").get("messengerId"), (Object)this._messengerConfig.getMessengerId()));
            criteriaQuery.select((Selection)root);
            criteriaQuery.where((Expression)predicate);
            TypedQuery query = entityManager.createQuery(criteriaQuery);
            query.getResultStream().forEach(hibAI -> {
                String[] adapterFeatures;
                AdapterInfo info = this.getAdapterInfo((de.pontonconsulting.xmlpipe.messenger.database.hibernate.AdapterInfo)hibAI);
                info.setMaximumThreads(hibAI.getMaximumThreads());
                info.setProcessingTimeout(hibAI.getProcessingTimeout());
                info.setSupportsAcknowledgements(false);
                info.setSupportsStatusResponses(false);
                info.setSupportsAttachments(false);
                info.setAcceptsAgreementChangeEvents(false);
                info.setAcceptsPartnerChangeEvents(false);
                info.setSupportsArchive(false);
                String features = hibAI.getFeatures();
                if (features != null && (adapterFeatures = features.split(FEATURES_SEPARATOR)) != null && adapterFeatures.length > 0) {
                    for (String adapterFeature : adapterFeatures) {
                        String[] services;
                        String serviceIds;
                        if (FEATURES_SUPPORTS_ACKS.equals(adapterFeature)) {
                            info.setSupportsAcknowledgements(true);
                            continue;
                        }
                        if (FEATURES_SUPPORTS_RESPONSES.equals(adapterFeature)) {
                            info.setSupportsStatusResponses(true);
                            continue;
                        }
                        if (FEATURES_SUPPORTS_ATTACHMENTS.equals(adapterFeature)) {
                            info.setSupportsAttachments(true);
                            continue;
                        }
                        if (FEATURES_ACCEPT_PARTNER_CHANGE_EVENTS.equals(adapterFeature)) {
                            info.setAcceptsAgreementChangeEvents(true);
                            continue;
                        }
                        if (FEATURES_ACCEPT_AGREEMENT_CHANGE_EVENTS.equals(adapterFeature)) {
                            info.setAcceptsPartnerChangeEvents(true);
                            continue;
                        }
                        if (FEATURES_SUPPORTS_ERRNOT.equals(adapterFeature)) {
                            info.setSupportsErrorNotification(true);
                            continue;
                        }
                        if (FEATURES_SUPPORTS_ARCHIVE.equals(adapterFeature)) {
                            info.setSupportsArchive(true);
                            continue;
                        }
                        if (!adapterFeature.startsWith(FEATURES_SERVICEIDS_PREFIX) || (serviceIds = adapterFeature.substring(FEATURES_SERVICEIDS_PREFIX.length())) == null || serviceIds.length() <= 0) continue;
                        for (String serviceId : services = serviceIds.split(FEATURES_SERVICE_SEPARATOR)) {
                            info.addService(serviceId);
                        }
                    }
                }
                this._registry.addAdapter(info);
            });
        }
        catch (RuntimeException e) {
            throw new DbException(13028, "Error while getting Adapter Info from Database for id.messengerId :" + e.getMessage(), e);
        }
    }

    private AdapterInfo getAdapterInfo(de.pontonconsulting.xmlpipe.messenger.database.hibernate.AdapterInfo hibAI) {
        if (hibAI.getAddress().startsWith("wss")) {
            return WebSocketAdapterInfo.createBuilder().setAdapterId(hibAI.getId().getAdapterId()).setAdapterInstanceId(hibAI.getAddress()).build();
        }
        return new AdapterInfo(hibAI.getId().getAdapterId(), hibAI.getAddress(), hibAI.getProcessingTimeout());
    }

    public void dbConsistencyCheck() throws DbException {
        try (EntityManager entityManager = this.createNewEntityManager();){
            entityManager.getTransaction().begin();
            de.pontonconsulting.xmlpipe.messenger.database.hibernate.AdapterInfo hbAI = new de.pontonconsulting.xmlpipe.messenger.database.hibernate.AdapterInfo();
            AdapterInfoId aiId = new AdapterInfoId();
            aiId.setAdapterId(TEST_VALUE_ADAPTER_ID);
            aiId.setMessengerId(this._messengerConfig.getMessengerId());
            hbAI.setId(aiId);
            hbAI.setAddress(TEST_VALUE_ADDRESS);
            hbAI.setMaximumThreads(5);
            hbAI.setProcessingTimeout(5);
            hbAI.setFeatures("SUPP_ACKS;SUPP_ATTS");
            entityManager.persist((Object)hbAI);
            entityManager.getTransaction().commit();
        }
        catch (RuntimeException e) {
            throw new DbException(13026, ERROR_ADD_ADAPTER_INFO + e.getMessage(), e);
        }
    }

    public void dbCleanup() throws DbException {
        try (EntityManager entityManager = this.createNewEntityManager();){
            entityManager.getTransaction().begin();
            CriteriaBuilder criteriaBuilder = entityManager.getCriteriaBuilder();
            CriteriaDelete deleteQuery = criteriaBuilder.createCriteriaDelete(de.pontonconsulting.xmlpipe.messenger.database.hibernate.AdapterInfo.class);
            Root root = deleteQuery.from(de.pontonconsulting.xmlpipe.messenger.database.hibernate.AdapterInfo.class);
            Predicate predicate = criteriaBuilder.conjunction();
            predicate.getExpressions().add(criteriaBuilder.equal((Expression)root.get("id").get("adapterId"), (Object)TEST_VALUE_ADAPTER_ID));
            deleteQuery.where((Expression)predicate);
            entityManager.createQuery(deleteQuery).executeUpdate();
            entityManager.getTransaction().commit();
        }
        catch (RuntimeException e) {
            throw new DbException(13027, ERROR_REMOVE_ADAPTER_INFO + e.getMessage(), e);
        }
    }
}

