/*
 * Decompiled with CFR 0.152.
 */
package de.pontonconsulting.xmlpipe.messenger.database.hibernate;

import de.pontonconsulting.xmlpipe.config.FoldersProvider;
import de.pontonconsulting.xmlpipe.message.XpMessage;
import de.pontonconsulting.xmlpipe.messenger.database.FileType;
import de.pontonconsulting.xmlpipe.messenger.database.hibernate.MessageProcessingDirective;
import de.pontonconsulting.xmlpipe.messenger.database.hibernate.XpMessageAttachment;
import jakarta.persistence.CascadeType;
import jakarta.persistence.Column;
import jakarta.persistence.DiscriminatorColumn;
import jakarta.persistence.DiscriminatorType;
import jakarta.persistence.Entity;
import jakarta.persistence.FetchType;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.Inheritance;
import jakarta.persistence.InheritanceType;
import jakarta.persistence.MapKey;
import jakarta.persistence.OneToMany;
import jakarta.persistence.Table;
import java.io.File;
import java.io.Serializable;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.hibernate.annotations.GenericGenerator;
import org.hibernate.annotations.Parameter;
import org.hibernate.annotations.SQLRestriction;

@Entity
@Table(name="MESSAGE")
@Inheritance(strategy=InheritanceType.JOINED)
@DiscriminatorColumn(name="INBOUND", discriminatorType=DiscriminatorType.INTEGER)
public abstract class XpBaseMessage
implements Serializable {
    private static final long serialVersionUID = 2582532871147978905L;
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="messageIdSeq")
    @GenericGenerator(name="messageIdSeq", strategy="native", parameters={@Parameter(name="sequence", value="ID_SEQUENCE_MESSAGE")})
    @Column(name="ID")
    private Long id;
    @Column(name="MESSAGE_ID")
    private String messageId;
    @Column(name="TRANSFER_ID")
    private String transferId;
    @Column(name="TESTFLAG")
    private Integer testFlag;
    @Column(name="MESSAGE_TYPE")
    private String messageType;
    @Column(name="SCHEMA_VERSION")
    private String schemaVersion;
    @Column(name="SCHEMA_SET")
    private String schemaSet;
    @Column(name="FOLDER")
    private String folder;
    @Column(name="CONTENT_REFERENCE_FILE")
    private String contentReferenceFile;
    @Column(name="CONTENT_TYPE")
    private String contentType;
    @Column(name="SEQUENCE_NUMBER")
    private Long sequenceNumber;
    @Column(name="CREATION_TIME")
    private Long creationTime;
    @Column(name="MESSAGE_TIME")
    private Long messageTime;
    @Column(name="ACK_REQUESTED")
    private Boolean ackRequested;
    @Column(name="SENDER_ID")
    private String senderLocalId;
    private transient String senderInternalId;
    @Column(name="RECEIVER_ID")
    private String receiverLocalId;
    @Column(name="ADAPTER_ID")
    private String adapterId;
    @Column(name="PROTOCOL")
    private String protocol;
    private transient String receiverInternalId;
    @OneToMany(mappedBy="message", cascade={CascadeType.ALL}, orphanRemoval=false, fetch=FetchType.EAGER)
    @SQLRestriction(value="FILE_TYPE = 6 OR FILE_TYPE = 5")
    private List<XpMessageAttachment> attachments;
    @OneToMany(mappedBy="message", cascade={CascadeType.ALL}, orphanRemoval=true, fetch=FetchType.EAGER)
    @MapKey(name="id.type")
    private Map<String, MessageProcessingDirective> processingDirectives;
    @Column(name="CONVERSATION")
    private Long conversationDatabaseId;
    private transient String conversationId;
    private transient File contentRefFile;

    protected XpBaseMessage() {
        this.contentRefFile = null;
    }

    protected XpBaseMessage(XpMessage xpMessage) {
        this.contentRefFile = xpMessage.getCurrentContentReference();
        this.setMessageProperties(xpMessage);
        this.attachments = this.getAttachments(xpMessage);
        this.processingDirectives = this.getProcessingDirectives(xpMessage);
    }

    protected void setMessageProperties(XpMessage xpMessage) {
        this.id = xpMessage.getDatabaseId() == -1L ? null : Long.valueOf(xpMessage.getDatabaseId());
        this.messageId = xpMessage.getMessageId();
        this.transferId = xpMessage.getTransferId();
        this.folder = FoldersProvider.convertFolderToString(xpMessage.getCurrentContentReferenceFolder());
        this.contentReferenceFile = Objects.isNull(xpMessage.getCurrentContentReference()) ? null : xpMessage.getCurrentContentReference().getName();
        this.contentType = xpMessage.getCurrentContentType();
        this.messageType = xpMessage.getMessageType();
        this.schemaVersion = xpMessage.getMessageVersion();
        this.schemaSet = xpMessage.getSchemaSet();
        this.testFlag = xpMessage.isTestMessage() ? 1 : 0;
        this.senderLocalId = xpMessage.getSenderLocalId();
        this.senderInternalId = xpMessage.getSenderInternalId();
        this.receiverLocalId = xpMessage.getReceiverLocalId();
        this.receiverInternalId = xpMessage.getReceiverInternalId();
        this.conversationDatabaseId = xpMessage.getConversationDatabaseId() == -1L ? null : Long.valueOf(xpMessage.getConversationDatabaseId());
        this.conversationId = xpMessage.getConversationId();
        this.creationTime = Objects.isNull(xpMessage.getMessageTimestamp()) ? null : Long.valueOf(xpMessage.getMessageTimestamp().getTime());
        this.sequenceNumber = xpMessage.getInternalSequenceNumber();
        this.messageTime = Objects.isNull(xpMessage.getRegistrationTimestamp()) ? null : Long.valueOf(xpMessage.getRegistrationTimestamp().getTime());
        this.ackRequested = xpMessage.isAckRequested();
        this.adapterId = xpMessage.getAdapterId();
        this.protocol = xpMessage.getProtocol();
    }

    private List<XpMessageAttachment> getAttachments(XpMessage xpMessage) {
        return Objects.isNull(xpMessage.getAttachments()) ? Collections.emptyList() : xpMessage.getAttachments().stream().map(at -> new XpMessageAttachment().setMessage(this).setFileName(at.getAttachment().getName()).setFileType("xp-signature".equals(at.getRole()) ? FileType.SIGNATURE.getDbValue() : FileType.ATTACHMENT.getDbValue()).setMimeType(at.getType()).setLanguage(at.getLanguage()).setRole(at.getRole()).setDescription(at.getDescription())).toList();
    }

    private Map<String, MessageProcessingDirective> getProcessingDirectives(XpMessage xpMessage) {
        return xpMessage.getProcessingDirectives().entrySet().stream().filter(entry -> Objects.nonNull(entry.getValue())).map(e -> new MessageProcessingDirective().setMessage(this).setId(xpMessage.getDatabaseId() == -1L ? null : Long.valueOf(xpMessage.getDatabaseId()), (String)e.getKey()).setValue((String)e.getValue())).collect(Collectors.toMap(MessageProcessingDirective::getType, v -> v));
    }

    public long getDatabaseId() {
        return this.id;
    }

    public String getMessageId() {
        return this.messageId;
    }

    public String getTransferId() {
        return this.transferId;
    }

    public String getSenderLocalId() {
        return this.senderLocalId;
    }

    public String getSenderInternalId() {
        return this.senderInternalId;
    }

    public void setSenderInternalId(String senderInternalId) {
        this.senderInternalId = senderInternalId;
    }

    public String getReceiverLocalId() {
        return this.receiverLocalId;
    }

    public String getReceiverInternalId() {
        return this.receiverInternalId;
    }

    public void setReceiverInternalId(String receiverInternalId) {
        this.receiverInternalId = receiverInternalId;
    }

    public String getAdapterId() {
        return this.adapterId;
    }

    public void setAdapterId(String adapterId) {
        this.adapterId = adapterId;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public boolean isTestMessage() {
        return 1 == this.testFlag;
    }

    public String getMessageType() {
        return this.messageType;
    }

    public String getMessageVersion() {
        return this.schemaVersion;
    }

    public String getSchemaSet() {
        return this.schemaSet;
    }

    public boolean isAckRequested() {
        return Objects.nonNull(this.ackRequested) && this.ackRequested != false;
    }

    public List<XpMessageAttachment> getAttachments() {
        return Collections.unmodifiableList(this.attachments);
    }

    public void removeAllAttachments() {
        if (!this.attachments.isEmpty()) {
            this.attachments = Collections.emptyList();
        }
    }

    public String getProcessingDirective(String type) {
        MessageProcessingDirective processingDirective = Objects.isNull(this.processingDirectives) ? null : this.processingDirectives.get(type);
        return Objects.isNull(processingDirective) ? null : processingDirective.getValue();
    }

    public Map<String, String> getProcessingDirectives() {
        if (Objects.isNull(this.processingDirectives)) {
            return Collections.emptyMap();
        }
        return this.processingDirectives.values().stream().filter(mpd -> Objects.nonNull(mpd.getValue())).collect(Collectors.toMap(MessageProcessingDirective::getType, MessageProcessingDirective::getValue));
    }

    public File getCurrentContentReference() {
        if (Objects.nonNull(this.contentRefFile)) {
            return this.contentRefFile;
        }
        return new File(this.getCurrentContentReferenceFolder(), this.contentReferenceFile);
    }

    public File getCurrentContentReferenceFolder() {
        if (Objects.nonNull(this.contentRefFile)) {
            return this.contentRefFile.getParentFile();
        }
        return FoldersProvider.convertStringToFolder(this.folder);
    }

    public String getCurrentContentType() {
        return this.contentType;
    }

    public String getConversationId() {
        return this.conversationId;
    }

    public void setConversationId(String conversationId) {
        this.conversationId = conversationId;
    }

    public long getConversationDatabaseId() {
        return Objects.isNull(this.conversationDatabaseId) ? -1L : this.conversationDatabaseId;
    }

    public int getSequenceNumber() {
        return Objects.isNull(this.sequenceNumber) ? -1 : this.sequenceNumber.intValue();
    }

    public Date getMessageTimestamp() {
        return Objects.isNull(this.creationTime) || this.creationTime == 0L ? null : new Date(this.creationTime);
    }

    public Date getRegistrationTimestamp() {
        return Objects.isNull(this.messageTime) || this.messageTime == 0L ? null : new Date(this.messageTime);
    }

    public boolean isAck() {
        return "ponton".equals(this.schemaSet) && "ACK".equals(this.messageType);
    }

    public boolean isErrorNotification() {
        return "ErrorNotification".equals(this.messageType);
    }

    public boolean isPong() {
        return "ponton".equals(this.schemaSet) && "PONG".equals(this.messageType);
    }

    public boolean isPing() {
        return "ponton".equals(this.schemaSet) && ("PING".equals(this.messageType) || "StatusRequest".equals(this.messageType) || "CertUpdateRequest".equals(this.messageType));
    }

    public boolean isSignal() {
        return "ponton".equals(this.schemaSet);
    }

    public boolean wasStoredWithMessengerVersionBelow5_0() {
        return Objects.isNull(this.contentType);
    }
}

