/*
 * Decompiled with CFR 0.152.
 */
package de.pontonconsulting.xmlpipe.messenger.database.hibernate;

import de.pontonconsulting.xmlpipe.messenger.database.hibernate.ListenerCertificateId;
import jakarta.persistence.Column;
import jakarta.persistence.EmbeddedId;
import jakarta.persistence.Entity;
import jakarta.persistence.EnumType;
import jakarta.persistence.Enumerated;
import jakarta.persistence.Table;
import java.beans.Transient;
import java.io.Serializable;
import java.security.cert.CRLReason;
import java.time.OffsetDateTime;
import java.util.Objects;

@Entity
@Table(name="LISTENER_CERTIFICATE")
public class ListenerCertificate
implements Serializable {
    private static final long serialVersionUID = 3331333784265283677L;
    @EmbeddedId
    private ListenerCertificateId aliasAndType;
    @Column(name="STATUS")
    @Enumerated(value=EnumType.ORDINAL)
    private Status status;
    @Column(name="CERTIFICATE")
    private byte[] certificate;
    @Column(name="CRL_REASON")
    @Enumerated(value=EnumType.STRING)
    private CRLReason crlReason;
    @Column(name="LAST_SUCCESSFUL_CHECK")
    private OffsetDateTime lastSuccessfulCheck;
    @Column(name="LAST_CHECK")
    private OffsetDateTime lastCheck;

    public void setId(ListenerCertificateId idAndType) {
        this.aliasAndType = idAndType;
    }

    public void setAliasAndType(String alias, Type type) {
        this.setId(new ListenerCertificateId(alias, type));
    }

    public ListenerCertificateId getId() {
        return this.aliasAndType;
    }

    public Status getStatus() {
        return this.status;
    }

    public void setStatus(Status status) {
        this.status = status;
    }

    public OffsetDateTime getLastSuccessfulCheck() {
        return this.lastSuccessfulCheck;
    }

    public void setLastSuccessfulCheck(OffsetDateTime lastSuccessfulCheck) {
        this.lastSuccessfulCheck = lastSuccessfulCheck;
    }

    public CRLReason getCrlReason() {
        return this.crlReason;
    }

    public void setCrlReason(CRLReason crlReason) {
        this.crlReason = crlReason;
    }

    public OffsetDateTime getLastCheck() {
        return this.lastCheck;
    }

    public void setLastCheck(OffsetDateTime lastCheck) {
        this.lastCheck = lastCheck;
    }

    public byte[] getCertificate() {
        return this.certificate;
    }

    public void setCertificate(byte[] certificate) {
        this.certificate = certificate;
    }

    @Transient
    public String getAlias() {
        return Objects.isNull(this.aliasAndType) ? null : this.aliasAndType.alias();
    }

    @Transient
    public Type getType() {
        return Objects.isNull(this.aliasAndType) ? null : this.aliasAndType.type();
    }

    public static enum Type {
        CLIENT,
        CLIENT_CA,
        SERVER,
        SERVER_CA;

    }

    public static enum Status {
        TRUSTED,
        TEMPORARILY_DISABLED,
        REVOKED;

    }
}

