/*
 * Decompiled with CFR 0.152.
 */
package de.pontonconsulting.xmlpipe.messenger.database.hibernate;

import java.io.Serializable;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.util.Objects;

public abstract class AbstractOutboundQueueMessage
implements Serializable {
    private static final long serialVersionUID = 589077846158795510L;
    private Long messageId;
    private int status;
    private String receiverId;
    private int priority;
    private OffsetDateTime enqueueTime;
    private OffsetDateTime timeToLive;
    private OffsetDateTime lastTransmission;
    private Integer messengerId;

    public AbstractOutboundQueueMessage() {
    }

    public AbstractOutboundQueueMessage(Long messageId, Integer messengerId) {
        this.messageId = messageId;
        this.messengerId = messengerId;
        this.status = 0;
        this.enqueueTime = OffsetDateTime.now(ZoneOffset.UTC);
    }

    public AbstractOutboundQueueMessage(Long messageId, int status, String receiverId, int priority, OffsetDateTime enqueueTime, OffsetDateTime timeToLive, OffsetDateTime lastTransmission, Integer messengerId) {
        this.messageId = messageId;
        this.status = status;
        this.receiverId = receiverId;
        this.priority = priority;
        this.enqueueTime = enqueueTime;
        this.timeToLive = timeToLive;
        this.lastTransmission = lastTransmission;
        this.messengerId = messengerId;
    }

    public Long getMessageId() {
        return this.messageId;
    }

    public void setMessageId(Long messageId) {
        this.messageId = messageId;
    }

    public int getStatus() {
        return this.status;
    }

    public void setStatus(int status) {
        this.status = status;
    }

    public String getReceiverId() {
        return this.receiverId;
    }

    public void setReceiverId(String receiverId) {
        this.receiverId = receiverId;
    }

    public int getPriority() {
        return this.priority;
    }

    public void setPriority(int priority) {
        this.priority = priority;
    }

    public OffsetDateTime getEnqueueTime() {
        return this.enqueueTime;
    }

    public void setEnqueueTime(OffsetDateTime enqueueTime) {
        this.enqueueTime = enqueueTime;
    }

    public OffsetDateTime getTimeToLive() {
        return this.timeToLive;
    }

    public Long getTimeToLiveMillis() {
        return Objects.isNull(this.timeToLive) ? null : Long.valueOf(this.timeToLive.toInstant().toEpochMilli());
    }

    public void setTimeToLive(OffsetDateTime timeToLive) {
        this.timeToLive = timeToLive;
    }

    public OffsetDateTime getLastTransmission() {
        return this.lastTransmission;
    }

    public void setLastTransmission(OffsetDateTime lastTransmission) {
        this.lastTransmission = lastTransmission;
    }

    public Integer getMessengerId() {
        return this.messengerId;
    }

    public void setMessengerId(Integer messengerId) {
        this.messengerId = messengerId;
    }

    public String toString() {
        return "OutboundQueueMessage {messageId=" + this.messageId + ", status=" + this.status + ", receiverId='" + this.receiverId + "', priority=" + this.priority + ", enqueueTime=" + String.valueOf(this.enqueueTime) + ", timeToLive=" + String.valueOf(this.timeToLive) + ", lastTransmission=" + String.valueOf(this.lastTransmission) + ", messengerId=" + this.messengerId + "}";
    }
}

