/*
 * Decompiled with CFR 0.152.
 */
package de.pontonconsulting.xmlpipe.messenger.database;

import de.pontonconsulting.xmlpipe.config.SubjectElement;
import de.pontonconsulting.xmlpipe.messenger.database.GenericLogChannel;
import de.pontonconsulting.xmlpipe.messenger.database.LogChannel;
import de.pontonconsulting.xmlpipe.messenger.database.LogException;
import de.pontonconsulting.xmlpipe.messenger.database.MessageInfo;
import de.pontonconsulting.xmlpipe.messenger.emailnotification.EMailNotification;
import java.util.List;

public class LogChannelMail
extends GenericLogChannel
implements LogChannel {
    private final String _to;
    private final boolean _withAttachment;
    private final List<SubjectElement> _subjectElements;
    private EMailNotification _eMailNotification;

    public LogChannelMail(String to, boolean withAttachment, List<SubjectElement> subjectElements) {
        this._to = to;
        this._withAttachment = withAttachment;
        this._subjectElements = subjectElements;
    }

    @Override
    public void log(int messageCode, MessageInfo info, String description) throws LogException {
        String logMsg = this.getLogMessageText(messageCode);
        this._eMailNotification.sendNotification(info, this._to, this._withAttachment, this._subjectElements, messageCode, logMsg, description);
    }

    public String getTo() {
        return this._to;
    }

    public boolean equals(Object obj) {
        LogChannelMail lcm;
        return obj instanceof LogChannelMail && this._to.equals((lcm = (LogChannelMail)obj).getTo());
    }

    public void setEMailNotification(EMailNotification emailNotification) {
        this._eMailNotification = emailNotification;
    }
}

