/*
 * Decompiled with CFR 0.152.
 */
package de.pontonconsulting.xmlpipe.messenger.database;

import de.ponton.xmlpipe.queue.InboundQueue;
import de.ponton.xmlpipe.queue.OutboundQueue;
import de.pontonconsulting.xmlpipe.config.MessengerConfig;
import de.pontonconsulting.xmlpipe.messenger.CleanupTask;
import de.pontonconsulting.xmlpipe.messenger.ReferenceDateTask;
import de.pontonconsulting.xmlpipe.messenger.database.DbException;
import de.pontonconsulting.xmlpipe.messenger.database.HibernateSessionFactory;
import de.pontonconsulting.xmlpipe.messenger.database.hibernate.Message;
import de.pontonconsulting.xmlpipe.messenger.database.tables.ConversationDAO;
import de.pontonconsulting.xmlpipe.messenger.database.tables.EventLog;
import de.pontonconsulting.xmlpipe.messenger.database.tables.FileRefDAO;
import de.pontonconsulting.xmlpipe.messenger.database.tables.InboundQueueingDAO;
import de.pontonconsulting.xmlpipe.messenger.database.tables.MDNDataDAO;
import de.pontonconsulting.xmlpipe.messenger.database.tables.MessageDAO;
import de.pontonconsulting.xmlpipe.messenger.database.tables.MessageLogDAO;
import de.pontonconsulting.xmlpipe.messenger.database.tables.OutboundQueueMessageDAO;
import jakarta.persistence.EntityManager;
import jakarta.persistence.TypedQuery;
import jakarta.persistence.criteria.CriteriaBuilder;
import jakarta.persistence.criteria.CriteriaQuery;
import jakarta.persistence.criteria.Expression;
import jakarta.persistence.criteria.Order;
import jakarta.persistence.criteria.Predicate;
import jakarta.persistence.criteria.Root;
import jakarta.persistence.criteria.Selection;
import jakarta.xml.bind.JAXBException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DBCleanupTask
extends CleanupTask {
    private static final Logger LOG = LogManager.getLogger((String)"Messenger.DBCleanupThread");
    private static final int MAX_RESULTS = 1000;
    private static final int DELETE_TRANSACTION_SIZE = 200;
    private static final int DELAY_AFTER_DELETE_MILLIS = 100;
    private static final int ACCEPTED_ERRORS = 100;
    private final FileRefDAO _fileRefDAO;
    private final MDNDataDAO _mdnDataDAO;
    private final MessageLogDAO _messageLogDAO;
    private final InboundQueueingDAO inboundQueueingDAO;
    private final OutboundQueueMessageDAO outboundQueueingDAO;
    private final InboundQueue inboundMessageQueue;
    private final OutboundQueue outboundMessageQueue;
    private final MessageDAO _messageDAO;
    private final EventLog _EventLog;
    private final ConversationDAO _conversationDAO;
    private final HibernateSessionFactory _hibernateSessionFactory;

    public DBCleanupTask(HibernateSessionFactory hibernateSessionFactory, MessengerConfig messengerConfig, ReferenceDateTask referenceDateTask, FileRefDAO fileRefDAO, MDNDataDAO mdnDataDAO, MessageLogDAO messageLogDAO, MessageDAO messageDAO, EventLog EventLog2, ConversationDAO conversationDAO, InboundQueue inboundMessageQueue, OutboundQueue outboundMessageQueue, InboundQueueingDAO inboundQueueingDAO, OutboundQueueMessageDAO outboundQueueingDAO) {
        super(messengerConfig, referenceDateTask);
        this._fileRefDAO = fileRefDAO;
        this._mdnDataDAO = mdnDataDAO;
        this._messageLogDAO = messageLogDAO;
        this._messageDAO = messageDAO;
        this._EventLog = EventLog2;
        this._hibernateSessionFactory = hibernateSessionFactory;
        this._conversationDAO = conversationDAO;
        this.inboundMessageQueue = inboundMessageQueue;
        this.outboundMessageQueue = outboundMessageQueue;
        this.inboundQueueingDAO = inboundQueueingDAO;
        this.outboundQueueingDAO = outboundQueueingDAO;
    }

    @Override
    protected Logger getLogger() {
        return LOG;
    }

    @Override
    protected void doCleanup() {
        try {
            long now = this.getReferenceDateTask().getReferenceCurrentTimeMillis();
            this.deleteOldMessageEntries(now);
            this.deleteOldPingentries(now);
            this.deleteOldOKEvents(now);
            this.deleteOrphanConversation();
        }
        catch (Exception ex) {
            LOG.error("{} occurred while processing DB cleanup: {}", (Object)ex.getClass().getSimpleName(), (Object)ex.getMessage(), (Object)ex);
        }
    }

    private void deleteOrphanConversation() {
        if (!this.isRuntimeLeft()) {
            LOG.debug("Skip deletion of orphan conversations, because maximum configured runtime reached, already");
            return;
        }
        try (EntityManager entityManager = this._hibernateSessionFactory.createNewEntityManager();){
            entityManager.getTransaction().begin();
            long startTime = System.currentTimeMillis();
            LOG.debug("Start deletion of orphan conversations");
            int deletedConversation = this._conversationDAO.deleteOrphaned(entityManager);
            LOG.info("Deleted {} orphan conversations in {} seconds", (Object)deletedConversation, (Object)((System.currentTimeMillis() - startTime) / 1000L));
            entityManager.getTransaction().commit();
        }
        catch (Exception ex) {
            LOG.error(String.format("%s occurred while deleting orphan conversation records: %s", ex.getClass().getSimpleName(), ex.getMessage()), (Throwable)ex);
        }
    }

    private void deleteOldPingentries(long now) throws DbException {
        this.deleteMessagesLooped(now - 172800000L, now - 86400000L, true);
    }

    private void deleteOldMessageEntries(long now) throws DbException {
        this.deleteMessagesLooped(null, this.getMaxDatabaseAge(now), false);
    }

    private void deleteMessagesLooped(Long messageMinAge, long messageMaxAge, boolean pings) throws DbException {
        boolean messagesDeleted;
        String type;
        String string = type = pings ? "ping" : "message";
        if (!this.isRuntimeLeft()) {
            LOG.debug("Skip deletion of {} entries, because maximum configured runtime reached, already", (Object)type);
            return;
        }
        if (LOG.isDebugEnabled()) {
            if (messageMinAge != null) {
                LOG.debug("will delete all {} entries with MessageTime between {} and {}", (Object)type, (Object)new Date(messageMinAge), (Object)new Date(messageMaxAge));
            } else {
                LOG.debug("will delete all {} entries older than {}", (Object)type, (Object)new Date(messageMaxAge));
            }
        }
        AtomicInteger deleteCount = new AtomicInteger();
        HashSet<Long> defectiveMessageIds = new HashSet<Long>();
        long deleteStart = System.currentTimeMillis();
        do {
            if (!(messagesDeleted = this.deleteMessageRange(messageMinAge, messageMaxAge, pings, deleteCount, defectiveMessageIds))) continue;
            LOG.debug("... {} {} entries deleted.", (Object)deleteCount.get(), (Object)type);
        } while (messagesDeleted && this.isRuntimeLeft());
        if (!this.isRuntimeLeft()) {
            LOG.info("Cleanup stopped, because maximum configured runtime reached");
        }
        long deleteDuration = (System.currentTimeMillis() - deleteStart) / 1000L;
        LOG.info("{} {} entries deleted overall in {} seconds. {} error(s) occurred", (Object)deleteCount.get(), (Object)type, (Object)deleteDuration, (Object)defectiveMessageIds.size());
        if (!defectiveMessageIds.isEmpty()) {
            LOG.warn("The following MessageDBIds couldn't be deleted, due to DB-Errors: {}", (Object)defectiveMessageIds.stream().map(Object::toString).collect(Collectors.joining(",")));
        }
    }

    private void deleteOldOKEvents(long now) {
        if (!this.isRuntimeLeft()) {
            LOG.debug("Skip deletion of OK EVENTS, because maximum configured runtime reached, already");
            return;
        }
        long eventsMaxAge = this.getMaxOKEventsAge(now);
        LOG.debug("Start deletion of OK EVENTS with MaxAge of {}", (Object)new Date(eventsMaxAge));
        try {
            int deleteCount = this._EventLog.deleteOldOKEvents(eventsMaxAge);
            LOG.info("Deleted {} OK EVENTS", (Object)deleteCount);
        }
        catch (Exception ex) {
            LOG.error("{} occurred while deleting OK EVENTS: {}", (Object)ex.getClass().getSimpleName(), (Object)ex.getMessage(), (Object)ex);
        }
    }

    private long getMaxOKEventsAge(long now) {
        long days = 2L;
        try {
            days = this.getMessengerConfig().getOkEventAge();
        }
        catch (Exception e1) {
            LOG.error("Could not read messenger config");
        }
        long maxDays = 86400000L * days;
        return now - maxDays;
    }

    private long getMaxDatabaseAge(long now) {
        long days = 365L;
        try {
            days = this.getMessengerConfig().getDatabaseMaxAge();
        }
        catch (Exception e1) {
            LOG.error("Could not read messenger config");
        }
        long maxDays = 86400000L * days;
        return now - maxDays;
    }

    @Override
    protected boolean isCleanupEnabled() {
        try {
            return this.getMessengerConfig().isDeleteDatabase();
        }
        catch (JAXBException jAXBException) {
            return false;
        }
    }

    private boolean deleteMessageRange(Long minAge, long maxAge, boolean pings, AtomicInteger deleteCount, Set<Long> defectiveMessageIds) throws DbException {
        boolean messagedDeleted = false;
        try (EntityManager entityManager = this._hibernateSessionFactory.createNewEntityManager();){
            CriteriaBuilder criteriaBuilder = entityManager.getCriteriaBuilder();
            CriteriaQuery criteriaQuery = criteriaBuilder.createQuery(Long.class);
            Root root = criteriaQuery.from(Message.class);
            ArrayList<Predicate> predicates = new ArrayList<Predicate>();
            if (pings) {
                predicates.add(criteriaBuilder.equal((Expression)root.get("schemaSet"), (Object)"ponton"));
                predicates.add(criteriaBuilder.equal((Expression)root.get("messageType"), (Object)"PING"));
            }
            predicates.add(criteriaBuilder.lt((Expression)root.get("messageTime"), (Number)maxAge));
            if (minAge != null) {
                predicates.add(criteriaBuilder.gt((Expression)root.get("messageTime"), (Number)minAge));
            }
            if (!defectiveMessageIds.isEmpty()) {
                predicates.add(root.get("id").in(defectiveMessageIds).not());
            }
            predicates.add(criteriaBuilder.isNull((Expression)root.get("parent")));
            predicates.add(root.get("archiveStatus").in(new Object[]{3, 99}));
            criteriaQuery.where(predicates.toArray(new Predicate[0]));
            criteriaQuery.select((Selection)root.get("id"));
            criteriaQuery.orderBy(new Order[]{criteriaBuilder.asc((Expression)root.get("messageTime"))});
            TypedQuery query = entityManager.createQuery(criteriaQuery);
            query.setMaxResults(1000);
            List messageIdsToDelete = query.getResultList();
            if (!messageIdsToDelete.isEmpty()) {
                messagedDeleted = true;
                if (this.isRuntimeLeft()) {
                    this.deleteMessagesByIds(messageIdsToDelete, entityManager, deleteCount, defectiveMessageIds);
                    LOG.debug("Deleted {} ParentMessages. Overall {}", (Object)messageIdsToDelete.size(), (Object)deleteCount.get());
                }
            }
        }
        return messagedDeleted;
    }

    private void deleteMessagesByIds(List<Long> messageDataIds, EntityManager entityManager, AtomicInteger deleteCount, Set<Long> defectiveMessageIds) throws DbException {
        if (messageDataIds.size() <= 200) {
            this.deletePageOfMessagesById(messageDataIds, entityManager, deleteCount, defectiveMessageIds);
        } else {
            AtomicInteger counter = new AtomicInteger();
            Collection<List<Long>> result = messageDataIds.stream().collect(Collectors.groupingBy(it -> counter.getAndIncrement() / 200)).values();
            for (Collection collection : result) {
                this.deletePageOfMessagesById(collection, entityManager, deleteCount, defectiveMessageIds);
            }
        }
        try {
            LOG.debug("Delay CleanupThread for {}ms, to give DB chance to recover...", (Object)100);
            Thread.sleep(100L);
            LOG.debug("Wakeup from Cleanup-Delay");
        }
        catch (InterruptedException ie) {
            Thread.currentThread().interrupt();
        }
    }

    private void deletePageOfMessagesById(Collection<Long> messageDataIds, EntityManager entityManager, AtomicInteger deleteCount, Set<Long> defectiveMessageIds) throws DbException {
        try {
            LOG.debug("Start deletion of page of {} messages", (Object)messageDataIds.size());
            entityManager.getTransaction().begin();
            if (this.inboundQueueingDAO.containsMessages(messageDataIds, entityManager)) {
                throw new DbException(-1, "Messages in InboundQueue");
            }
            if (this.outboundQueueingDAO.containsMessages(messageDataIds, entityManager)) {
                throw new DbException(-1, "Messages in OutboundQueue");
            }
            LOG.trace("start messageDAO.deleteByIds");
            this._messageDAO.deleteByIds(messageDataIds, entityManager);
            entityManager.getTransaction().commit();
            deleteCount.addAndGet(messageDataIds.size());
            LOG.debug("Deleted page of {} messages. Overall {}", (Object)messageDataIds.size(), (Object)deleteCount.get());
        }
        catch (DbException e) {
            entityManager.getTransaction().rollback();
            LOG.error("PageDelete of {} messages failed due to {} ('{}') => start deletion one-by-one", (Object)messageDataIds.size(), (Object)e.getClass().getName(), (Object)e.getMessage());
            for (long messageId : messageDataIds) {
                try {
                    entityManager.getTransaction().begin();
                    this._messageDAO.deleteFromMessage(messageId, entityManager);
                    entityManager.getTransaction().commit();
                    deleteCount.incrementAndGet();
                    LOG.debug("Deleted messageId {}. Overall {}", (Object)messageId, (Object)deleteCount.get());
                }
                catch (DbException e1) {
                    defectiveMessageIds.add(messageId);
                    entityManager.getTransaction().rollback();
                    LOG.error("Deletion of message (id={}) failed due to {} ('{}')", (Object)messageId, (Object)e1.getClass().getSimpleName(), (Object)e1.getMessage());
                    if (defectiveMessageIds.size() < 100) continue;
                    LOG.error("ErrorCount exceeds maximum of {} => cancel Cleanup", (Object)100);
                    throw e1;
                }
            }
        }
    }
}

