/*
 * Decompiled with CFR 0.152.
 */
package de.pontonconsulting.xmlpipe.messenger.archive;

import de.pontonconsulting.xmlpipe.config.MessengerConfig;
import de.pontonconsulting.xmlpipe.config.model.messenger.archive.XpArchiverType;
import de.pontonconsulting.xmlpipe.messenger.archive.ArchiverException;
import de.pontonconsulting.xmlpipe.messenger.archive.DatabaseArchiver;
import de.pontonconsulting.xmlpipe.messenger.archive.FileSystemArchiver;
import de.pontonconsulting.xmlpipe.messenger.archive.IArchiver;
import de.pontonconsulting.xmlpipe.messenger.archive.NoneArchiver;
import de.pontonconsulting.xmlpipe.messenger.archive.WebsocketArchiver;
import de.pontonconsulting.xmlpipe.messenger.database.FileType;
import de.pontonconsulting.xmlpipe.messenger.database.MessageInfo;
import jakarta.xml.bind.JAXBException;
import java.io.File;
import java.io.OutputStream;
import java.util.List;
import java.util.Objects;

public class ArchiverDispatcher
implements IArchiver {
    private final MessengerConfig messengerConfig;
    private final WebsocketArchiver websocketArchiver;
    private IArchiver archiverInstance = null;
    private final FileSystemArchiver fileSystemArchiver;
    private final DatabaseArchiver databaseArchiver;

    public ArchiverDispatcher(MessengerConfig messengerConfig, WebsocketArchiver websocketArchiver, FileSystemArchiver fileSystemArchiver, DatabaseArchiver databaseArchiver) {
        this.messengerConfig = messengerConfig;
        this.websocketArchiver = websocketArchiver;
        this.fileSystemArchiver = fileSystemArchiver;
        this.databaseArchiver = databaseArchiver;
    }

    @Override
    public List<IArchiver.ArchiveResponse> sendFilesToArchive(MessageInfo messageInfo, boolean isFailedMessage, List<IArchiver.File2Archive> files2archive) throws ArchiverException {
        return this.getArchiverInstance().sendFilesToArchive(messageInfo, isFailedMessage, files2archive);
    }

    @Override
    public void readFileFromArchive(String archiveReference, OutputStream outputStream) throws ArchiverException {
        this.getArchiverInstance(archiveReference).readFileFromArchive(archiveReference, outputStream);
    }

    @Override
    public void deleteFileFromArchive(List<String> archiveReferences2delete) throws ArchiverException {
        this.getArchiverInstance(archiveReferences2delete).deleteFileFromArchive(archiveReferences2delete);
    }

    public String getArchiverName() {
        return this.getArchiverInstance().getClass().getSimpleName();
    }

    public List<IArchiver.ArchiveResponse> createLegacyArchiveResponse(MessageInfo messageInfo) {
        return this.fileSystemArchiver.createLegacyArchiveResponse(messageInfo);
    }

    public FileType getFileType(MessageInfo info, File file) {
        return FileSystemArchiver.getFileType(info, file);
    }

    private IArchiver getArchiverInstance(List<String> archiveReferences) {
        if (Objects.nonNull(archiveReferences) && !archiveReferences.isEmpty()) {
            return this.getArchiverInstance(archiveReferences.getFirst());
        }
        return this.getArchiverInstance();
    }

    private IArchiver getArchiverInstance(String archiveReference) {
        IArchiver currentArchiver = this.getArchiverInstance();
        if (Objects.nonNull(archiveReference) && (archiveReference.startsWith("$WORK") || archiveReference.startsWith("$ARCHIVE"))) {
            return this.fileSystemArchiver;
        }
        return currentArchiver;
    }

    private IArchiver getArchiverInstance() {
        if (Objects.isNull(this.archiverInstance)) {
            this.archiverInstance = switch (this.getArchiverType()) {
                case XpArchiverType.FILE_SYSTEM -> this.fileSystemArchiver;
                case XpArchiverType.WEB_SOCKET -> this.websocketArchiver;
                case XpArchiverType.DATABASE -> this.databaseArchiver;
                default -> new NoneArchiver();
            };
        }
        return this.archiverInstance;
    }

    private XpArchiverType getArchiverType() {
        XpArchiverType type;
        try {
            type = this.messengerConfig.getArchiverType();
            if (Objects.isNull((Object)type)) {
                return XpArchiverType.NONE;
            }
        }
        catch (JAXBException e) {
            return XpArchiverType.NONE;
        }
        return type;
    }
}

