/*
 * Decompiled with CFR 0.152.
 */
package de.pontonconsulting.xmlpipe.messenger.adapter;

import de.pontonconsulting.xmlpipe.adapter.AdapterInfo;
import de.pontonconsulting.xmlpipe.adapter.IAgreementEventListener;
import de.pontonconsulting.xmlpipe.adapter.IErrorNotificationHandler;
import de.pontonconsulting.xmlpipe.adapter.IMessageStatusHandler;
import de.pontonconsulting.xmlpipe.adapter.IPartnerCertificateEventListener;
import de.pontonconsulting.xmlpipe.adapter.IPartnerEventListener;
import de.pontonconsulting.xmlpipe.adapter.ISpecificAdapter;
import de.pontonconsulting.xmlpipe.adapter.MessageResult;
import de.pontonconsulting.xmlpipe.adapter.encoding.Base64Encoder;
import de.pontonconsulting.xmlpipe.message.BackEndMessage;
import de.pontonconsulting.xmlpipe.message.BackEndMessageConverter;
import de.pontonconsulting.xmlpipe.message.BackEndMessageException;
import de.pontonconsulting.xmlpipe.message.DimeMessage;
import de.pontonconsulting.xmlpipe.messenger.adapter.AdapterAccessException;
import de.pontonconsulting.xmlpipe.messenger.adapter.AdapterCustomException;
import de.pontonconsulting.xmlpipe.messenger.adapter.AdapterRejectedMessageException;
import de.pontonconsulting.xmlpipe.messenger.adapter.AdapterServlet;
import de.pontonconsulting.xmlpipe.messenger.adapter.HttpResponseListener;
import de.pontonconsulting.xmlpipe.messenger.adapter.IAdapterAccess;
import de.pontonconsulting.xmlpipe.messenger.database.hibernate.XpInboundMessage;
import de.pontonconsulting.xmlpipe.messenger.transport.HttpConnectionPoolFactory;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.net.ConnectException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.jetty.client.ConnectionPool;
import org.eclipse.jetty.client.ContentResponse;
import org.eclipse.jetty.client.HttpClient;
import org.eclipse.jetty.client.OutputStreamRequestContent;
import org.eclipse.jetty.client.Request;
import org.eclipse.jetty.client.Response;
import org.eclipse.jetty.http.HttpHeader;
import org.xml.sax.SAXParseException;

class AdapterAccess
implements IAdapterAccess {
    private static final Log _log = LogFactory.getLog((String)"Messenger.AdapterAccess");
    private static final int CONNECTION_TIMEOUT = 30000;
    private static final String COMMUNICATION_PROBLEM = "Communication problem with Adapter: ";
    private static final String TEMP_FOLDER_NAME = "temp_attachments";
    private final AdapterInfo _adapter;
    private final BackEndMessageConverter _converter;
    private static final HttpClient _httpClient = new HttpClient();
    private static final HttpConnectionPoolFactory _connectionPoolFactory;

    protected static void shutdown() {
        try {
            _httpClient.stop();
        }
        catch (Exception e) {
            _log.warn((Object)"Failed to stop the HTTP client", (Throwable)e);
        }
    }

    AdapterAccess(AdapterInfo info, BackEndMessageConverter converter) {
        this._converter = converter;
        this._adapter = info;
    }

    @Override
    public boolean isSelfCheckOk() throws AdapterAccessException {
        _log.debug((Object)("requesting selfcheck of Adapter: " + this._adapter.getId()));
        if (this._adapter.isUsingDirectCommunication()) {
            ISpecificAdapter specificAdapter = this._adapter.getAdapterInstance();
            return AdapterAccess.doIn(specificAdapter.getClass().getClassLoader(), () -> ((ISpecificAdapter)specificAdapter).doSelfCheck());
        }
        return this.isSelfCheckOkHttp();
    }

    private boolean isSelfCheckOkHttp() throws AdapterAccessException {
        if (this._adapter.getAddress().equals("ReceptionDisabled")) {
            return true;
        }
        Request request = _httpClient.POST(this._adapter.getAddress()).scheme("http").headers(headers -> headers.put("X-COMMAND", "DoSelfCheck"));
        ContentResponse response = this.post(request);
        return response.getStatus() == 200;
    }

    @Override
    public String getStatusMessage() throws AdapterAccessException {
        _log.debug((Object)("getting status of Adapter: " + this._adapter.getId()));
        if (this._adapter.isUsingDirectCommunication()) {
            ISpecificAdapter specificAdapter = this._adapter.getAdapterInstance();
            return AdapterAccess.doIn(specificAdapter.getClass().getClassLoader(), () -> ((ISpecificAdapter)specificAdapter).getStatus());
        }
        return this.getStatusMessageHttp();
    }

    private String getStatusMessageHttp() throws AdapterAccessException {
        if (this._adapter.getAddress().equals("ReceptionDisabled")) {
            return "No Status available";
        }
        Request request = _httpClient.POST(this._adapter.getAddress()).scheme("http").headers(headers -> headers.put("X-COMMAND", "Status"));
        ContentResponse response = this.post(request);
        return response.getContentAsString();
    }

    @Override
    public void partnerAdded(String internalId, String displayName, boolean isLocal) throws AdapterAccessException {
        if (this._adapter.acceptsPartnerChangeEvents()) {
            if (_log.isTraceEnabled()) {
                _log.trace((Object)("sending partner added event to adapter " + this._adapter.getId() + " (" + internalId + ")"));
            }
            if (this._adapter.isUsingDirectCommunication()) {
                IPartnerEventListener eventListener = (IPartnerEventListener)this._adapter.getAdapterInstance();
                AdapterAccess.doIn(eventListener.getClass().getClassLoader(), () -> {
                    eventListener.partnerAdded(internalId, displayName, isLocal);
                    return null;
                });
            } else {
                Request request = _httpClient.POST(this._adapter.getAddress()).scheme("http").headers(headers -> headers.put("X-COMMAND", "PartnerAdded").put("PartnerID", internalId).put("X-Ponton-PartnerDisplayName", displayName).put("X-Ponton-IsLocalPartner", String.valueOf(isLocal)));
                this.post(request);
            }
        }
    }

    @Override
    public void partnerModifed(String internalId, String oldInternalId, String displayName, boolean isLocal) throws AdapterAccessException {
        if (this._adapter.acceptsPartnerChangeEvents()) {
            if (_log.isTraceEnabled()) {
                _log.trace((Object)("sending partner modified event to adapter " + this._adapter.getId() + " (" + internalId + ")"));
            }
            if (this._adapter.isUsingDirectCommunication()) {
                IPartnerEventListener eventListener = (IPartnerEventListener)this._adapter.getAdapterInstance();
                AdapterAccess.doIn(eventListener.getClass().getClassLoader(), () -> {
                    eventListener.partnerModified(internalId, oldInternalId, displayName, isLocal);
                    return null;
                });
            } else {
                Request request = _httpClient.POST(this._adapter.getAddress()).scheme("http").headers(headers -> headers.put("X-COMMAND", "PartnerModified").put("PartnerID", internalId).put("X-Ponton-PartnerDisplayName", displayName).put("X-Ponton-IsLocalPartner", String.valueOf(isLocal)));
                if (oldInternalId != null && !oldInternalId.isEmpty() && !internalId.equals(oldInternalId)) {
                    request.headers(headers -> headers.put("X-Ponton-OldPartnerID", oldInternalId));
                }
                this.post(request);
            }
        }
    }

    @Override
    public void partnerDeleted(String internalId, String displayName, boolean isLocal) throws AdapterAccessException {
        if (this._adapter.acceptsPartnerChangeEvents()) {
            if (_log.isTraceEnabled()) {
                _log.trace((Object)("sending partner deleted event to adapter " + this._adapter.getId() + " (" + internalId + ")"));
            }
            if (this._adapter.isUsingDirectCommunication()) {
                IPartnerEventListener eventListener = (IPartnerEventListener)this._adapter.getAdapterInstance();
                AdapterAccess.doIn(eventListener.getClass().getClassLoader(), () -> {
                    eventListener.partnerDeleted(internalId, displayName, isLocal);
                    return null;
                });
            } else {
                Request request = _httpClient.POST(this._adapter.getAddress()).scheme("http").headers(headers -> headers.put("X-COMMAND", "PartnerDeleted").put("PartnerID", internalId).put("X-Ponton-PartnerDisplayName", displayName).put("X-Ponton-IsLocalPartner", String.valueOf(isLocal)));
                this.post(request);
            }
        }
    }

    @Override
    public void agreementAdded(String localPartnerId, String remotePartnerId) throws AdapterAccessException {
        if (this._adapter.acceptsAgreementChangeEvents()) {
            if (_log.isTraceEnabled()) {
                _log.trace((Object)("sending agreement added event to adapter " + this._adapter.getId() + " (" + localPartnerId + "/" + remotePartnerId + ")"));
            }
            if (this._adapter.isUsingDirectCommunication()) {
                IAgreementEventListener eventListener = (IAgreementEventListener)this._adapter.getAdapterInstance();
                AdapterAccess.doIn(eventListener.getClass().getClassLoader(), () -> {
                    eventListener.agreementAdded(localPartnerId, remotePartnerId);
                    return null;
                });
            } else {
                Request request = _httpClient.POST(this._adapter.getAddress()).scheme("http").headers(headers -> headers.put("X-COMMAND", "AgreementAdded").put("X-Ponton-Agreement-LocalPartnerId", localPartnerId).put("X-Ponton-Agreement-RemotePartnerId", remotePartnerId));
                this.post(request);
            }
        }
    }

    @Override
    public void agreementModified(String localPartnerId, String remotePartnerId) throws AdapterAccessException {
        if (this._adapter.acceptsAgreementChangeEvents()) {
            if (_log.isTraceEnabled()) {
                _log.trace((Object)("sending agreement modified event to adapter " + this._adapter.getId() + " (" + localPartnerId + "/" + remotePartnerId + ")"));
            }
            if (this._adapter.isUsingDirectCommunication()) {
                IAgreementEventListener eventListener = (IAgreementEventListener)this._adapter.getAdapterInstance();
                AdapterAccess.doIn(eventListener.getClass().getClassLoader(), () -> {
                    eventListener.agreementModified(localPartnerId, remotePartnerId);
                    return null;
                });
            } else {
                Request request = _httpClient.POST(this._adapter.getAddress()).scheme("http").headers(headers -> headers.put("X-COMMAND", "AgreementModified").put("X-Ponton-Agreement-LocalPartnerId", localPartnerId).put("X-Ponton-Agreement-RemotePartnerId", remotePartnerId));
                this.post(request);
            }
        }
    }

    @Override
    public void agreementDeleted(String localPartnerId, String remotePartnerId) throws AdapterAccessException {
        if (this._adapter.acceptsAgreementChangeEvents()) {
            if (_log.isTraceEnabled()) {
                _log.trace((Object)("sending agreement deleted event to adapter " + this._adapter.getId() + " (" + localPartnerId + "/" + remotePartnerId + ")"));
            }
            if (this._adapter.isUsingDirectCommunication()) {
                IAgreementEventListener eventListener = (IAgreementEventListener)this._adapter.getAdapterInstance();
                AdapterAccess.doIn(eventListener.getClass().getClassLoader(), () -> {
                    eventListener.agreementDeleted(localPartnerId, remotePartnerId);
                    return null;
                });
            } else {
                Request request = _httpClient.POST(this._adapter.getAddress()).scheme("http").headers(headers -> headers.put("X-COMMAND", "AgreementDeleted").put("X-Ponton-Agreement-LocalPartnerId", localPartnerId).put("X-Ponton-Agreement-RemotePartnerId", remotePartnerId));
                this.post(request);
            }
        }
    }

    private File[] createTempAttachments(File[] attachments, File[] tempFolder) throws IOException {
        File[] tempAttachments = new File[attachments.length];
        for (int i = 0; i < attachments.length; ++i) {
            File att = attachments[i];
            if (i == 0) {
                File messageFolder = att.getParentFile();
                if ("attachments".equals(messageFolder.getName())) {
                    messageFolder = messageFolder.getParentFile();
                }
                tempFolder[0] = new File(messageFolder, TEMP_FOLDER_NAME);
                tempFolder[0].mkdir();
            }
            File newAttFile = new File(tempFolder[0], att.getName());
            Files.copy(att.toPath(), newAttFile.toPath(), new CopyOption[0]);
            tempAttachments[i] = newAttFile;
        }
        return tempAttachments;
    }

    private void deleteTempAttachments(File tempFolder) {
        File[] files;
        if (tempFolder == null) {
            return;
        }
        for (File file : files = tempFolder.listFiles()) {
            if (file.isDirectory()) {
                this.deleteTempAttachments(file);
                continue;
            }
            this.deleteFile(file);
        }
        this.deleteFile(tempFolder);
    }

    private void deleteFile(File file) {
        if (!file.delete()) {
            _log.warn((Object)("file could not be deleted " + String.valueOf(file)));
        }
    }

    private void replaceAttachments(BackEndMessage beMessage, File[] attachments) throws BackEndMessageException {
        for (int i = 0; i < attachments.length; ++i) {
            File file = attachments[i];
            try {
                beMessage.addAttachment(file);
                continue;
            }
            catch (FileNotFoundException e) {
                throw new BackEndMessageException("Cannot find the attachment.", (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MessageResult sendInboundDocument(XpInboundMessage message, File workInboundFolder) throws AdapterAccessException, BackEndMessageException, AdapterRejectedMessageException, AdapterCustomException, InterruptedException {
        MessageResult result;
        block15: {
            BackEndMessage beMessage = null;
            try {
                try {
                    beMessage = this._converter.getBackEndMessage(message);
                }
                catch (BackEndMessageException e) {
                    Throwable causeExc = e.getCause();
                    String cause = e.getMessage();
                    if (causeExc instanceof IOException || causeExc instanceof SAXParseException || causeExc instanceof NullPointerException || cause != null && (cause.startsWith("Encapsulated exception: org.xml.sax.SAXParseException") || cause.startsWith("File not found:"))) {
                        _log.error((Object)"preventing endless message delivery loop by rejecting the message");
                        MessageResult rejection = new MessageResult(MessageResult.ADAPTER_REJECTED_MESSAGE);
                        rejection.setDescription(cause);
                        throw new AdapterRejectedMessageException(rejection);
                    }
                    throw e;
                }
                this.storeBackEndMessage(message, beMessage, workInboundFolder);
                if (this._adapter.isUsingDirectCommunication()) {
                    String[] atts = beMessage.listAttachments();
                    File[] attachments = new File[atts.length];
                    for (int i = 0; i < atts.length; ++i) {
                        attachments[i] = beMessage.getAttachment(atts[i]);
                    }
                    File[] tempFolder = new File[1];
                    File[] tempAttachments = new File[]{};
                    try {
                        tempAttachments = this.createTempAttachments(attachments, tempFolder);
                    }
                    catch (IOException e) {
                        throw new AdapterAccessException(12012, "Could not create temp Attachments.");
                    }
                    this.replaceAttachments(beMessage, tempAttachments);
                    ISpecificAdapter specificAdapter = this._adapter.getAdapterInstance();
                    BackEndMessage backEndMessage = beMessage;
                    result = AdapterAccess.doIn(specificAdapter.getClass().getClassLoader(), () -> {
                        if (message.isAck() || message.isPong()) {
                            return specificAdapter.receiveAcknowledgement(backEndMessage);
                        }
                        if (message.isStatusResponse()) {
                            return ((IMessageStatusHandler)specificAdapter).receiveStatusResponse(backEndMessage);
                        }
                        if (message.isSignal() && message.isErrorNotification()) {
                            return ((IErrorNotificationHandler)specificAdapter).receiveErrorNotification(backEndMessage);
                        }
                        if (message.isTestMessage()) {
                            return specificAdapter.receiveTestMessage(backEndMessage);
                        }
                        return specificAdapter.receiveMessage(backEndMessage);
                    });
                    this.deleteTempAttachments(tempFolder[0]);
                    this.replaceAttachments(beMessage, attachments);
                    if (result.equals((Object)MessageResult.ADAPTER_REJECTED_MESSAGE)) {
                        throw new AdapterRejectedMessageException(result);
                    }
                    if (result.equals((Object)MessageResult.COULD_NOT_SAVE_MESSAGE_PAYLOAD)) {
                        throw new AdapterRejectedMessageException(result);
                    }
                    if (result.equals((Object)MessageResult.CUSTOM_ERROR)) {
                        throw new AdapterCustomException(result);
                    }
                    if (result.getHttpCode() / 100 != 2) {
                        throw new AdapterAccessException(12008, new String[]{result.getDescription()}, "Adapter reported error:" + result.getDescription());
                    }
                    break block15;
                }
                result = this.sendInboundDocument(beMessage);
            }
            finally {
                if (beMessage != null) {
                    beMessage.cleanupTempResources();
                }
            }
        }
        return result;
    }

    private void storeBackEndMessage(XpInboundMessage message, BackEndMessage beMessage, File workInboundFolder) {
        File work = new File(workInboundFolder, String.valueOf(message.getDatabaseId()));
        File backendEnvelopeFile = new File(work, "xp_backendmessage.xml");
        if (!backendEnvelopeFile.exists()) {
            try {
                beMessage.writeBackEndEnvelopeTo(backendEnvelopeFile);
            }
            catch (Exception e) {
                _log.warn((Object)("BackendEnvelope could not be stored:" + String.valueOf(e)));
            }
        }
    }

    private MessageResult sendInboundDocument(BackEndMessage message) throws AdapterAccessException, AdapterRejectedMessageException, AdapterCustomException, InterruptedException {
        MessageResult messageResult;
        _log.debug((Object)("sending message to adapter: " + this._adapter.getId()));
        MessageResult xpResult = null;
        if ("ReceptionDisabled".equals(this._adapter.getAddress())) {
            _log.debug((Object)"adapter has reception of inbound messages disabled.");
            xpResult = new MessageResult(MessageResult.ADAPTER_REJECTED_MESSAGE);
            xpResult.setDescription("Reception is disabled");
            throw new AdapterRejectedMessageException(xpResult);
        }
        OutputStreamRequestContent content = new OutputStreamRequestContent();
        try {
            HttpResponseListener listener = new HttpResponseListener(this._adapter.getProcessingTimeout(), TimeUnit.SECONDS);
            try (OutputStream out = content.getOutputStream();){
                _httpClient.POST(this._adapter.getAddress()).scheme("http").idleTimeout((long)this._adapter.getProcessingTimeout(), TimeUnit.SECONDS).headers(headers -> headers.put("X-COMMAND", "ReceiveDocument").put(HttpHeader.CONTENT_TYPE, "text/xml; charset=\"UTF-8\"")).body((Request.Content)content).send((Response.CompleteListener)listener);
                DimeMessage dimeMessage = AdapterServlet.getDimeMessageProvider();
                dimeMessage.init(message);
                dimeMessage.writeToStream(out);
                out.flush();
            }
            Response response = listener.getResponse();
            if (response == null) {
                throw new IOException(new TimeoutException(String.format("no response from adapter within %s seconds", this._adapter.getProcessingTimeout())));
            }
            String responseMessage = listener.getContentAsString();
            int postRes = response.getStatus();
            String httpMessage = response.getReason();
            String xpCode = response.getHeaders().get("XPMessageResultCode");
            if (xpCode != null) {
                int xpCodeValue = Integer.parseInt(xpCode);
                xpResult = MessageResult.identify((int)xpCodeValue);
                if (xpResult != null) {
                    xpResult.setDescription(responseMessage);
                    if (xpResult.equals((Object)MessageResult.ADAPTER_REJECTED_MESSAGE)) {
                        throw new AdapterRejectedMessageException(xpResult);
                    }
                    if (xpResult.equals((Object)MessageResult.CUSTOM_ERROR)) {
                        throw new AdapterCustomException(xpResult);
                    }
                }
                if (postRes != 201 && postRes != 200) {
                    throw new AdapterAccessException(12009, new String[]{"" + postRes, responseMessage}, COMMUNICATION_PROBLEM + postRes + responseMessage, xpResult);
                }
            }
            if (postRes != 201 && postRes != 200) {
                throw new AdapterAccessException(12008, new String[]{httpMessage}, "Adapter reported error:" + httpMessage);
            }
            if (xpResult == null) {
                xpResult = new MessageResult(MessageResult.MSG_SUCCESSFULLY_RECEIVED);
                xpResult.setDescription(responseMessage);
            }
            messageResult = xpResult;
        }
        catch (Throwable listener) {
            try {
                try {
                    content.close();
                }
                catch (Throwable throwable) {
                    listener.addSuppressed(throwable);
                }
                throw listener;
            }
            catch (BackEndMessageException e) {
                throw new AdapterAccessException(12099, "Could not create backend message: " + String.valueOf((Object)e));
            }
            catch (ConnectException e) {
                throw new AdapterAccessException(12005, "Communication problem with Adapter:  Adapter address: '" + this._adapter.getAddress() + "'. " + String.valueOf(e));
            }
            catch (IOException e) {
                Throwable throwable = e.getCause();
                if (throwable instanceof ConnectException) {
                    throw new AdapterAccessException(12005, "Communication problem with Adapter:  Adapter address: '" + this._adapter.getAddress() + "'. " + String.valueOf(e));
                }
                throw new AdapterAccessException(12006, COMMUNICATION_PROBLEM + String.valueOf(e));
            }
        }
        content.close();
        return messageResult;
    }

    @Override
    public void partnerCertificateAdded(String internalId, Object certificate, boolean isLocal) throws AdapterAccessException {
        if (this._adapter.acceptsPartnerCertificateChangeEvents()) {
            if (_log.isTraceEnabled()) {
                _log.trace((Object)("sending partner certificate added event to adapter " + this._adapter.getId() + " (" + internalId + ")"));
            }
            if (this._adapter.isUsingDirectCommunication()) {
                IPartnerCertificateEventListener eventListener = (IPartnerCertificateEventListener)this._adapter.getAdapterInstance();
                AdapterAccess.doIn(eventListener.getClass().getClassLoader(), () -> {
                    eventListener.partnerCertificateAdded(internalId, certificate, isLocal);
                    return null;
                });
            } else {
                this.postPartnerCertificate("PartnerCertificateAdded", internalId, (X509Certificate)certificate, isLocal);
            }
        }
    }

    private String encode(X509Certificate certificate) throws CertificateEncodingException {
        String fileToString = Base64Encoder.encode((byte[])certificate.getEncoded());
        String newString = StringUtils.remove((String)fileToString, (char)'\n');
        String result = StringUtils.remove((String)newString, (char)'\r');
        return result;
    }

    @Override
    public void partnerCertificateDeleted(String internalId, Object certificateId, boolean isLocal) throws AdapterAccessException {
        if (this._adapter.acceptsPartnerCertificateChangeEvents()) {
            if (_log.isTraceEnabled()) {
                _log.trace((Object)("sending partner certificate added event to adapter " + this._adapter.getId() + " (" + internalId + ")"));
            }
            if (this._adapter.isUsingDirectCommunication()) {
                IPartnerCertificateEventListener eventListener = (IPartnerCertificateEventListener)this._adapter.getAdapterInstance();
                AdapterAccess.doIn(eventListener.getClass().getClassLoader(), () -> {
                    eventListener.partnerCertificateDeleted(internalId, certificateId, isLocal);
                    return null;
                });
            } else {
                this.postPartnerCertificate("PartnerCertificateDeleted", internalId, (X509Certificate)certificateId, isLocal);
            }
        }
    }

    private void postPartnerCertificate(String command, String internalId, X509Certificate certificate, boolean isLocal) throws AdapterAccessException {
        try {
            String base64Certificate = this.encode(certificate);
            Request request = _httpClient.POST(this._adapter.getAddress()).headers(headers -> headers.put("X-COMMAND", command).put("PartnerID", internalId).put("PartnerCertificate", base64Certificate).put("X-Ponton-IsLocalPartner", String.valueOf(isLocal)));
            this.post(request);
        }
        catch (CertificateEncodingException e) {
            throw new AdapterAccessException(12099, e.toString());
        }
    }

    private ContentResponse post(Request request) throws AdapterAccessException {
        try {
            ContentResponse response = request.timeout((long)this._adapter.getProcessingTimeout(), TimeUnit.SECONDS).send();
            int postRes = response.getStatus();
            String responseMessage = response.getReason();
            String id = response.getHeaders().get("X-AdapterId");
            if (postRes == 500) {
                throw new AdapterAccessException(12001, new String[]{responseMessage}, "Adapter is not working correct:" + responseMessage);
            }
            if (id != null && !this._adapter.getId().equals(id)) {
                throw new AdapterAccessException(12002, new String[]{this._adapter.getId(), id}, "Talking to wrong Adapter. Expected id:" + this._adapter.getId() + "but received: " + id);
            }
            if (postRes != 200) {
                throw new AdapterAccessException(12007, new String[]{"" + postRes}, "HTTP ResponseCode was not 200 it was:" + postRes);
            }
            return response;
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new AdapterAccessException(12006, COMMUNICATION_PROBLEM + String.valueOf(e));
        }
        catch (TimeoutException e) {
            throw new AdapterAccessException(12006, COMMUNICATION_PROBLEM + String.valueOf(e));
        }
        catch (ExecutionException e) {
            Throwable throwable = e.getCause();
            if (throwable instanceof ConnectException) {
                throw new AdapterAccessException(12005, "Communication problem with Adapter:  Adapter address: '" + this._adapter.getAddress() + "'. " + String.valueOf(e));
            }
            throw new AdapterAccessException(12004, COMMUNICATION_PROBLEM + String.valueOf(e));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static <T> T doIn(ClassLoader classLoader, ClassLoaderSwitchCallback<T> callback) {
        ClassLoader threadContext = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(classLoader);
            T t = callback.callback();
            return t;
        }
        finally {
            Thread.currentThread().setContextClassLoader(threadContext);
        }
    }

    static {
        _httpClient.setMaxConnectionsPerDestination(20);
        _httpClient.setConnectTimeout(30000L);
        _httpClient.setDestinationIdleTimeout(10000L);
        _connectionPoolFactory = new HttpConnectionPoolFactory(20, 50);
        _httpClient.getTransport().setConnectionPoolFactory((ConnectionPool.Factory)_connectionPoolFactory);
        try {
            _httpClient.start();
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to start HTTP client", e);
        }
    }

    private static interface ClassLoaderSwitchCallback<T> {
        public T callback();
    }
}

