/*
 * Decompiled with CFR 0.152.
 */
package de.pontonconsulting.xmlpipe.messenger;

import de.pontonconsulting.xmlpipe.adapter.ExtendedMessageResult;
import de.pontonconsulting.xmlpipe.adapter.MessageResult;
import de.pontonconsulting.xmlpipe.adapter.StatusResult;
import de.pontonconsulting.xmlpipe.config.IFolders;
import de.pontonconsulting.xmlpipe.config.IMessengerProperties;
import de.pontonconsulting.xmlpipe.config.MessengerConfig;
import de.pontonconsulting.xmlpipe.cpa.Agreement;
import de.pontonconsulting.xmlpipe.cpa.AgreementException;
import de.pontonconsulting.xmlpipe.cpa.Agreements;
import de.pontonconsulting.xmlpipe.cpp.CppPartner;
import de.pontonconsulting.xmlpipe.cpp.ProfileException;
import de.pontonconsulting.xmlpipe.cpp.ProfileNotFoundException;
import de.pontonconsulting.xmlpipe.cpp.Profiles;
import de.pontonconsulting.xmlpipe.message.PayloadDataExtractor;
import de.pontonconsulting.xmlpipe.message.XpMessage;
import de.pontonconsulting.xmlpipe.messenger.IdGenerator;
import de.pontonconsulting.xmlpipe.messenger.archive.ArchiveProcessor;
import de.pontonconsulting.xmlpipe.messenger.database.DbException;
import de.pontonconsulting.xmlpipe.messenger.database.MessageExistsException;
import de.pontonconsulting.xmlpipe.messenger.database.MessageInfo;
import de.pontonconsulting.xmlpipe.messenger.database.tables.FileRefDAO;
import de.pontonconsulting.xmlpipe.messenger.database.tables.MessageDAO;
import de.pontonconsulting.xmlpipe.messenger.database.tables.MessengerLog;
import de.pontonconsulting.xmlpipe.messenger.filter.MessageRecognitionException;
import java.io.File;
import java.io.IOException;
import org.apache.commons.io.FileUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SendToArchiveOnly {
    public static final String OVERWRITE_MESSAGE_ID = "OverwriteMessageId";
    private static final String PROPERTY_RFC2822_CONFORM_MESSAGE_ID = "ponton.rfc2822.conform.message.id";
    private static final String DEFAULT_RFC2822_CONFORM_MESSAGE_ID = "true";
    private static final String UNKNOWN = "unknown";
    public static final Logger _log = LogManager.getLogger((String)"Messenger.SendToArchiveOnly");
    private final MessengerLog _messengerLog;
    private final Profiles _profiles;
    private final Agreements _agreements;
    private final ArchiveProcessor _archiveProcessor;
    private final FileRefDAO _fileRefDAO;
    private final MessageDAO _messageDAO;
    private final MessengerConfig _messengerConfig;
    private final IFolders _folders;
    private final PayloadDataExtractor payloadDataExtractor;
    private final IdGenerator _idGenerator;
    private final IMessengerProperties messengerProperties;

    public SendToArchiveOnly(MessengerLog messengerLog, Profiles profiles, Agreements agreements, ArchiveProcessor archiveProcessor, FileRefDAO fileRefDAO, MessageDAO messageDAO, MessengerConfig messengerConfig, IFolders folders, PayloadDataExtractor payloadDataExtractor, IdGenerator idGenerator, IMessengerProperties messengerProperties) {
        this._messengerLog = messengerLog;
        this._profiles = profiles;
        this._agreements = agreements;
        this._archiveProcessor = archiveProcessor;
        this._fileRefDAO = fileRefDAO;
        this._messageDAO = messageDAO;
        this._messengerConfig = messengerConfig;
        this._folders = folders;
        this.payloadDataExtractor = payloadDataExtractor;
        this._idGenerator = idGenerator;
        this.messengerProperties = messengerProperties;
        _log.debug("new instance of SendToArchiveOnly created.");
    }

    public ExtendedMessageResult handleMessage(XpMessage message) {
        String localReceiver;
        String localSender;
        String internalReceiver;
        ExtendedMessageResult result = null;
        message.setMessengerId(this._messengerConfig.getMessengerId());
        try {
            if (!"ponton".equals(message.getSchemaSet())) {
                this.payloadDataExtractor.extractData(message);
            }
        }
        catch (MessageRecognitionException e) {
            ExtendedMessageResult messageResult = new ExtendedMessageResult(MessageResult.COULD_NOT_PROCESS_MESSAGE);
            messageResult.appendToDescription((Throwable)e);
            return messageResult;
        }
        if (message.getMessageId() == null || OVERWRITE_MESSAGE_ID.equalsIgnoreCase(message.getMessageId())) {
            message.setMessageId(this._idGenerator.generateMessageId());
            if (_log.isDebugEnabled()) {
                _log.debug("generated new message id");
            }
        }
        if (this.isRFC2822MessageId()) {
            message.setMessageId(this._idGenerator.getStandardMessageId(message.getMessageId()));
        }
        if (message.getConversationId() == null || message.getConversationId().isEmpty()) {
            message.setConversationId(message.getMessageId());
        }
        try {
            int messageStatus;
            message.setProtocol("ARCHIVED");
            try {
                this._messageDAO.registerMessage(message);
                messageStatus = 0;
                if (_log.isInfoEnabled()) {
                    _log.info("New message from adapter registered with Message ID: '{}' database id: '{}'", (Object)message.getMessageId(), (Object)message.getDatabaseId());
                }
            }
            catch (MessageExistsException e) {
                messageStatus = this._messageDAO.getStatusOfMessage(message.getMessageId(), 0);
            }
            if (messageStatus == 0) {
                try {
                    this.moveWorkFolder(message);
                }
                catch (IOException io) {
                    result = new ExtendedMessageResult(MessageResult.COULD_NOT_SAVE_MESSAGE_PAYLOAD);
                    this.setMessageResult(result, message);
                    return result;
                }
            } else if (messageStatus == 4) {
                try {
                    this.deleteArchivedFolder(message);
                    this.moveWorkFolder(message);
                }
                catch (IOException io) {
                    result = new ExtendedMessageResult(MessageResult.COULD_NOT_SAVE_MESSAGE_PAYLOAD);
                    this.setMessageResult(result, message);
                    return result;
                }
            } else {
                if (messageStatus == 3 || messageStatus == 5) {
                    _log.warn("Archive rejected because a message with the same Message ID was already successfully archived: {}", (Object)message.getMessageId());
                    result = new ExtendedMessageResult(MessageResult.DUPLICATE_MESSAGE_ID);
                    this.setMessageResult(result, message);
                    return result;
                }
                _log.warn("Archive rejected because a message with the same Message ID is still in progress: {}", (Object)message.getMessageId());
                result = new ExtendedMessageResult(MessageResult.PENDING_MESSAGE_ID);
                this.setMessageResult(result, message);
                return result;
            }
            this._messengerLog.log2db(68, message.getDatabaseId(), message.getAdapterId());
        }
        catch (DbException de) {
            _log.fatal(de.toString());
            result = new ExtendedMessageResult(MessageResult.MESSAGE_COULD_NOT_BE_REGISTERED);
            result.appendToDescription((Throwable)de);
            this.setMessageResult(result, message);
            return result;
        }
        String internalSender = message.getSenderInternalId();
        if (internalSender == null) {
            internalSender = UNKNOWN;
        }
        if ((internalReceiver = message.getReceiverInternalId()) == null) {
            internalReceiver = UNKNOWN;
        }
        try {
            CppPartner sender = this.fetchSenderProfile(message);
            localSender = sender.getLocalId();
            message.setSenderLocalId(localSender);
            if (sender.isDisabled()) {
                this._messengerLog.log2db(527, message.getDatabaseId(), "SenderId '" + internalSender + "' is disabled:");
                this._archiveProcessor.sendFilesToArchive(message.getDatabaseId(), true);
                this._messageDAO.updateMessageStatus(message.getDatabaseId(), message.getMessageId(), 4);
                _log.warn("Partner '{}' is disabled", (Object)internalSender);
                result = new ExtendedMessageResult(MessageResult.PARTNER_IS_DISABLED);
                result.appendToDescription("Local SenderId: " + internalSender);
                this.setMessageResult(result, message);
                return result;
            }
            if (sender.isRemote()) {
                this._messengerLog.log2db(527, message.getDatabaseId(), "SenderId '" + internalSender + "' is not a local partner");
                this._archiveProcessor.sendFilesToArchive(message.getDatabaseId(), true);
                this._messageDAO.updateMessageStatus(message.getDatabaseId(), message.getMessageId(), 4);
                result = new ExtendedMessageResult(MessageResult.SENDER_IS_NOT_A_LOCAL_PARTNER);
                result.appendToDescription("Sender is not a local partner: " + internalSender);
                _log.fatal("Sender with localId '{}' is not a local partner", (Object)internalSender);
                this.setMessageResult(result, message);
                return result;
            }
        }
        catch (ProfileNotFoundException pnfe) {
            this._messengerLog.log2db(527, message.getDatabaseId(), "SenderId '" + internalSender + "' is unknown:");
            this._archiveProcessor.sendFilesToArchive(message.getDatabaseId(), true);
            this._messageDAO.updateMessageStatus(message.getDatabaseId(), message.getMessageId(), 4);
            _log.fatal("Sender is unknown:{}", (Object)internalSender);
            result = new ExtendedMessageResult(MessageResult.PARTNER_IS_NOT_KNOWN);
            result.appendToDescription("Local SenderId: " + internalSender);
            this.setMessageResult(result, message);
            return result;
        }
        catch (ProfileException pe) {
            this._messengerLog.log2db(527, message.getDatabaseId(), "Partner config for '" + internalSender + "' could not be accessed:");
            this._archiveProcessor.sendFilesToArchive(message.getDatabaseId(), true);
            this._messageDAO.updateMessageStatus(message.getDatabaseId(), message.getMessageId(), 4);
            _log.fatal("Error while getting sender partner data:{}", (Object)pe.getMessage());
            result = new ExtendedMessageResult(MessageResult.PARTNER_STORE_COULD_NOT_BE_ACCESSED);
            result.appendToDescription((Throwable)pe);
            this.setMessageResult(result, message);
            return result;
        }
        try {
            CppPartner receiver = this.fetchReceiverProfile(message);
            localReceiver = receiver.getLocalId();
            message.setReceiverLocalId(localReceiver);
            if (receiver.isDisabled()) {
                this._messengerLog.log2db(527, message.getDatabaseId(), "ReceiverId '" + internalReceiver + "' is disabled");
                this._archiveProcessor.sendFilesToArchive(message.getDatabaseId(), true);
                this._messageDAO.updateMessageStatus(message.getDatabaseId(), message.getMessageId(), 4);
                _log.warn("Partner '{}' is disabled", (Object)internalReceiver);
                result = new ExtendedMessageResult(MessageResult.PARTNER_IS_DISABLED);
                result.appendToDescription("Local ReceiverId: " + internalReceiver);
                this.setMessageResult(result, message);
                return result;
            }
            if (!this._messengerConfig.isLoopback() && !receiver.isRemote()) {
                this._messengerLog.log2db(527, message.getDatabaseId(), "ReceiverId '" + internalReceiver + "' is not a remote partner");
                this._archiveProcessor.sendFilesToArchive(message.getDatabaseId(), true);
                this._messageDAO.updateMessageStatus(message.getDatabaseId(), message.getMessageId(), 4);
                result = new ExtendedMessageResult(MessageResult.RECEIVER_IS_NOT_A_REMOTE_PARTNER);
                result.appendToDescription("Receiver is not a remote partner: " + internalReceiver);
                _log.fatal("Receiver with localId '{}' is not a remote partner", (Object)internalReceiver);
                this.setMessageResult(result, message);
                return result;
            }
        }
        catch (ProfileNotFoundException pnfe) {
            this._messengerLog.log2db(527, message.getDatabaseId(), "ReceiverId '" + internalReceiver + "' is unknown:");
            this._archiveProcessor.sendFilesToArchive(message.getDatabaseId(), true);
            this._messageDAO.updateMessageStatus(message.getDatabaseId(), message.getMessageId(), 4);
            _log.fatal("Receiver is unknown:{}", (Object)internalReceiver);
            result = new ExtendedMessageResult(MessageResult.PARTNER_IS_NOT_KNOWN);
            result.appendToDescription("Local ReceiverId: " + internalReceiver);
            this.setMessageResult(result, message);
            return result;
        }
        catch (ProfileException pe) {
            this._messengerLog.log2db(527, message.getDatabaseId(), "Partner config for '" + internalReceiver + "' could not be accessed:");
            this._archiveProcessor.sendFilesToArchive(message.getDatabaseId(), true);
            this._messageDAO.updateMessageStatus(message.getDatabaseId(), message.getMessageId(), 4);
            _log.fatal("Error while getting receiver partner data:{}", (Object)pe.getMessage());
            result = new ExtendedMessageResult(MessageResult.PARTNER_STORE_COULD_NOT_BE_ACCESSED);
            result.appendToDescription((Throwable)pe);
            this.setMessageResult(result, message);
            return result;
        }
        try {
            if (_log.isDebugEnabled()) {
                _log.debug("Fetching collaboration agreement for sender: {} and receiver: {}", (Object)internalSender, (Object)internalReceiver);
            }
            Agreement agreement = this._agreements.getAgreement(localSender, localReceiver, true);
            message.setAgreement(agreement);
            message.setOwnPartner(this._profiles.getProfileForLocalId(agreement.getOwnPartner().getId(), true));
            message.setCommunicationPartner(this._profiles.getProfileForLocalId(agreement.getCommunicationPartner().getId(), true));
        }
        catch (AgreementException anfe) {
            this._messengerLog.log2db(527, message.getDatabaseId(), "No collaboration agreement for sender '" + internalSender + "' and receiver '" + internalReceiver + "' found.");
            this._archiveProcessor.sendFilesToArchive(message.getDatabaseId(), true);
            this._messageDAO.updateMessageStatus(message.getDatabaseId(), message.getMessageId(), 4);
            _log.fatal("No collaboration agreement for sender '{}' and receiver '{}' found.", (Object)internalSender, (Object)internalReceiver);
            result = new ExtendedMessageResult(MessageResult.NO_AGREEMENT_FOUND);
            result.appendToDescription("Local SenderId: " + internalSender);
            result.appendToDescription("Local ReceiverId: " + internalReceiver);
            this.setMessageResult(result, message);
            return result;
        }
        catch (ProfileException e) {
            this._messengerLog.log2db(527, message.getDatabaseId(), "No profile for sender '" + internalSender + "' and receiver '" + internalReceiver + "' found.");
            this._archiveProcessor.sendFilesToArchive(message.getDatabaseId(), true);
            this._messageDAO.updateMessageStatus(message.getDatabaseId(), message.getMessageId(), 4);
            _log.fatal("No profile for sender '{}' and receiver '{}' found.", (Object)internalSender, (Object)internalReceiver);
            result = new ExtendedMessageResult(MessageResult.PARTNER_IS_NOT_KNOWN);
            result.appendToDescription("Local SenderId: " + internalSender);
            result.appendToDescription("Local ReceiverId: " + internalReceiver);
            this.setMessageResult(result, message);
            return result;
        }
        if (message.isAck()) {
            message.setAckRequested(false);
        }
        try {
            this.validateSchemaSet(message);
        }
        catch (Exception e) {
            this._messengerLog.log2db(527, message.getDatabaseId(), "Cannot set supported schema sets: " + e.getMessage());
            this._archiveProcessor.sendFilesToArchive(message.getDatabaseId(), true);
            this._messageDAO.updateMessageStatus(message.getDatabaseId(), message.getMessageId(), 4);
            _log.fatal("Cannot set supported schema sets: {}", (Object)e.getMessage());
            result = new ExtendedMessageResult(MessageResult.COULD_NOT_PROCESS_MESSAGE);
            result.appendToDescription(e.getMessage());
            this.setMessageResult(result, message);
            return result;
        }
        this._archiveProcessor.sendFilesToArchive(message.getDatabaseId(), false);
        this._messengerLog.log2db(102, message.getDatabaseId(), null);
        _log.info("archiving task completed.");
        try {
            this._messageDAO.updateMessageAndStatus(message, 5);
        }
        catch (DbException dbException) {
            // empty catch block
        }
        result = new ExtendedMessageResult(MessageResult.MSG_SUCCESSFULLY_ARCHIVED);
        this.setMessageResult(result, message);
        result.setTransmissionProtocol("n/a");
        return result;
    }

    private boolean isRFC2822MessageId() {
        String value = this.messengerProperties.getProperty(PROPERTY_RFC2822_CONFORM_MESSAGE_ID, DEFAULT_RFC2822_CONFORM_MESSAGE_ID);
        return Boolean.parseBoolean(value);
    }

    private void moveWorkFolder(XpMessage message) throws IOException {
        if (message.getCurrentContentReferenceFolder() != null) {
            _log.debug("updating current content folder");
            File newWork = new File(this._folders.getWorkOutboundFolder(), String.valueOf(message.getDatabaseId()));
            File tempFolder = message.getCurrentContentReferenceFolder();
            if (!tempFolder.equals(newWork)) {
                _log.debug("try to remove old work directory");
                FileUtils.deleteDirectory((File)newWork);
            }
            if (!tempFolder.renameTo(newWork)) {
                this._messengerLog.log2db(515, message.getDatabaseId(), "file renaming problem");
                this._messageDAO.updateMessageStatus(message.getDatabaseId(), message.getMessageId(), 4);
                _log.error("failed to rename {} to {}", (Object)tempFolder, (Object)newWork);
                throw new IOException("failed to rename");
            }
            message.setCurrentContentReferenceFolder(newWork);
            message.updateAttachments(newWork);
        }
        this._messageDAO.updateMessageFolder(message.getDatabaseId(), message.getCurrentContentReferenceFolder());
        String filename = null;
        if (message.getCurrentContentReference() != null) {
            filename = message.getCurrentContentReference().getName();
        }
        this._fileRefDAO.insertMessageFileReference(message.getDatabaseId(), message.getCurrentContentReferenceFolder(), filename, message.getCurrentContentType());
    }

    private CppPartner fetchReceiverProfile(XpMessage message) throws ProfileNotFoundException, ProfileException {
        CppPartner receiver = null;
        String receiverId = message.getReceiverLocalId();
        if (receiverId == null || receiverId.trim().length() == 0) {
            receiverId = message.getReceiverInternalId();
            _log.debug("Fetching settings for Receiver Partner internal id:{}", (Object)receiverId);
            receiver = this._profiles.getProfileForInternalId(receiverId, true);
        } else {
            _log.debug("Fetching settings for Receiver Partner local id:{}", (Object)receiverId);
            receiver = this._profiles.getProfileForLocalId(receiverId, true);
        }
        return receiver;
    }

    private CppPartner fetchSenderProfile(XpMessage message) throws ProfileNotFoundException, ProfileException {
        CppPartner sender = null;
        String senderId = message.getSenderLocalId();
        if (senderId == null || senderId.trim().length() == 0) {
            senderId = message.getSenderInternalId();
            _log.debug("Fetching settings for Sender Partner internal id:{}", (Object)senderId);
            sender = this._profiles.getProfileForInternalId(senderId, true);
        } else {
            _log.debug("Fetching settings for Sender Partner local id:{}", (Object)senderId);
            sender = this._profiles.getProfileForLocalId(senderId, true);
        }
        return sender;
    }

    private void validateSchemaSet(XpMessage message) throws Exception {
        if (message.getCurrentContentReference() != null && !message.isAck()) {
            if (!message.recognizePayload().isValid()) {
                throw new Exception("No activated XML Schema for MessageType:" + message.getMessageType() + " Version:" + message.getMessageVersion() + " found");
            }
            if (_log.isTraceEnabled()) {
                _log.trace("Message-Type:{} / Message-Version:{} / SchemaSet:{}", (Object)message.getMessageType(), (Object)message.getMessageVersion(), (Object)message.getSchemaSet());
            }
            this._messageDAO.updateMessage(message);
            _log.debug("Supported doctype found in collaboration agreement schemaset:{}", (Object)message.getSchemaSet());
        }
    }

    private void deleteArchivedFolder(XpMessage message) {
        block3: {
            File folder = null;
            try {
                MessageInfo info = this._messageDAO.getMessageInfo(message.getDatabaseId());
                folder = info.getMessageFolder();
                if (folder != null) {
                    FileUtils.deleteDirectory((File)folder);
                }
            }
            catch (Exception e) {
                if (folder == null) break block3;
                _log.warn("No files deleted from archive {}", folder);
            }
        }
    }

    private void setMessageResult(ExtendedMessageResult result, XpMessage xpMessage) {
        result.setMessageId(xpMessage.getMessageId());
        result.setConversationId(xpMessage.getConversationId());
        result.setMessageTime(String.valueOf(xpMessage.getMessageTimestamp().getTime()));
        result.setMessageType(xpMessage.getMessageType());
        result.setSchemaVersion(xpMessage.getMessageVersion());
        result.setSchemaSet(xpMessage.getSchemaSet());
        ExtendedMessageResult extendedResult = result;
        extendedResult.setProcessingDirectives(xpMessage.getProcessingDirectives());
        extendedResult.setSenderId(xpMessage.getSenderInternalId());
        extendedResult.setReceiverId(xpMessage.getReceiverInternalId());
        extendedResult.setTestMessage(xpMessage.isTestMessage());
    }

    public StatusResult checkStatusOfMessage(String messageId) {
        StatusResult result = null;
        int messageStatus = -1;
        try {
            messageStatus = this._messageDAO.getStatusOfMessage(messageId, 0);
        }
        catch (DbException e) {
            _log.error(e.toString());
        }
        switch (messageStatus) {
            case 5: {
                result = new StatusResult(6);
                break;
            }
            case 4: {
                result = new StatusResult(3);
                break;
            }
            case 3: {
                result = new StatusResult(2);
                break;
            }
            case 1: 
            case 2: {
                result = new StatusResult(4);
                break;
            }
            case 0: {
                result = new StatusResult(1);
                break;
            }
            default: {
                result = new StatusResult(5);
            }
        }
        return result;
    }
}

