/*
 * Decompiled with CFR 0.152.
 */
package de.pontonconsulting.xmlpipe.messenger;

import de.pontonconsulting.common.net.ntp.NtpClient;
import de.pontonconsulting.common.net.ntp.NtpClientException;
import de.pontonconsulting.xmlpipe.config.MessengerConfig;
import de.pontonconsulting.xmlpipe.config.NtpServer;
import de.pontonconsulting.xmlpipe.events.ServiceLevel;
import de.pontonconsulting.xmlpipe.events.ShutdownCompleted;
import de.pontonconsulting.xmlpipe.events.ShutdownService;
import de.pontonconsulting.xmlpipe.events.StartupCompleted;
import de.pontonconsulting.xmlpipe.events.StartupService;
import de.pontonconsulting.xmlpipe.events.activation.ValidateActivationEvent;
import de.pontonconsulting.xmlpipe.messenger.IReferenceDateListener;
import de.pontonconsulting.xmlpipe.messenger.IServiceProvider;
import de.pontonconsulting.xmlpipe.messenger.ReferenceDateTaskMBean;
import jakarta.xml.bind.JAXBException;
import java.lang.management.ManagementFactory;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;

public class ReferenceDateTask
implements ReferenceDateTaskMBean,
IServiceProvider,
Runnable {
    private static final long ONE_HOUR = 3600000L;
    private static final String MBEAN_NAME = "de.ponton:type=PontonXP,name=ReferenceDate";
    private static final Logger _log = LogManager.getLogger((String)"Messenger.ReferenceDateTask");
    private static final boolean _runInTestMode;
    private long _synchronizeInterval;
    private int _synchronizeIntervalHours;
    private long _offset;
    private InetAddress _usedNtpServer;
    private final MessengerConfig _messengerConfig;
    private final ApplicationEventPublisher applicationEventPublisher;
    private final ScheduledExecutorService executor;
    private Future<?> referenceDateTaskFuture;
    private final List<IReferenceDateListener> _referenceDateListeners = new ArrayList<IReferenceDateListener>();

    public ReferenceDateTask(MessengerConfig messengerConfig, ApplicationEventPublisher applicationEventPublisher, ScheduledExecutorService executor) {
        this._messengerConfig = messengerConfig;
        this.applicationEventPublisher = applicationEventPublisher;
        this.executor = executor;
        this._offset = 0L;
    }

    public void start() {
        this.updateSynchronizeInterval();
        this.referenceDateTaskFuture = this.executor.scheduleAtFixedRate(this, 0L, this._synchronizeInterval, TimeUnit.MILLISECONDS);
        try {
            MBeanServer mBeanServer = ManagementFactory.getPlatformMBeanServer();
            ObjectName referenceDateName = new ObjectName(MBEAN_NAME);
            mBeanServer.registerMBean(this, referenceDateName);
        }
        catch (Exception e) {
            _log.error("Could not register MBean 'de.ponton:type=PontonXP,name=ReferenceDate'.", (Throwable)e);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reinit() throws JAXBException {
        this.updateSynchronizeInterval();
        if (this._messengerConfig.isNtpEnabled()) {
            if (_log.isTraceEnabled()) {
                _log.trace("Updating clock with ntp servers...");
            }
            ArrayList<NtpServer> ntpServers = this._messengerConfig.getNtpServers();
            boolean success = false;
            if (ntpServers != null && !ntpServers.isEmpty() && this._synchronizeIntervalHours > 0) {
                Iterator<NtpServer> iter = ntpServers.iterator();
                while (iter.hasNext() && !success) {
                    NtpServer ntpServer = iter.next();
                    String ntpHostString = ntpServer.getHostname();
                    int port = ntpServer.getPort();
                    if (ntpHostString.isEmpty()) continue;
                    NtpClient ntp = null;
                    try {
                        InetAddress ntpHost = InetAddress.getByName(ntpHostString);
                        if (_log.isDebugEnabled()) {
                            _log.debug("Synchronizing clock with remote: {} and port: {}", (Object)ntpHost, (Object)port);
                        }
                        ntp = new NtpClient(ntpHost, port);
                        long tempOffset = ntp.getOffset();
                        if (this._offset != 0L) {
                            long delta = tempOffset - this._offset;
                            if (!_runInTestMode && Math.abs(delta) > 4200000L) {
                                throw new NtpClientException("new time offset has a difference of more than " + Math.abs(delta) / 60000L + " minutes to previous offset... probably a broken NTP server so it is ignored.");
                            }
                        }
                        this._offset = tempOffset;
                        success = true;
                        this._usedNtpServer = ntpHost;
                        if (_log.isDebugEnabled()) {
                            _log.debug("Successfully synchronized with remote: {} . Offset is: {}", (Object)ntpHost, (Object)this._offset);
                        }
                        List<IReferenceDateListener> list = this._referenceDateListeners;
                        synchronized (list) {
                            for (IReferenceDateListener referenceDateListener : this._referenceDateListeners) {
                                referenceDateListener.onChange();
                            }
                        }
                    }
                    catch (UnknownHostException uhe) {
                        _log.warn("Unable to get the ntpserver address from: {} . Reason: {}", (Object)ntpHostString, (Object)uhe.toString());
                    }
                    catch (NtpClientException nce) {
                        _log.warn("Unable to get the reference time from: {} . Reason: {}", (Object)ntpHostString, (Object)nce.getMessage());
                    }
                    catch (Exception e) {
                        _log.warn("Unable to get the reference time.  Reason: {}", (Object)e.toString());
                    }
                    finally {
                        if (ntp == null) continue;
                        try {
                            ntp.close();
                        }
                        catch (Exception uhe) {}
                    }
                }
            } else {
                this._offset = 0L;
                this._usedNtpServer = null;
            }
        } else {
            this._offset = 0L;
            this._usedNtpServer = null;
        }
    }

    @Override
    public void updateNow() {
        this.executor.submit(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addReferenceDateListener(IReferenceDateListener referenceDateListener) {
        List<IReferenceDateListener> list = this._referenceDateListeners;
        synchronized (list) {
            if (!this._referenceDateListeners.contains(referenceDateListener)) {
                this._referenceDateListeners.add(referenceDateListener);
            }
        }
    }

    @Override
    public void run() {
        try {
            this.reinit();
            this.applicationEventPublisher.publishEvent((ApplicationEvent)new ValidateActivationEvent(this));
        }
        catch (Exception e) {
            _log.error("Error during updating clock: {}", (Object)e.toString());
        }
    }

    private void updateSynchronizeInterval() {
        try {
            this._synchronizeIntervalHours = this._messengerConfig.getNtpServerSynchronizeIntervalHours();
            if (this._synchronizeIntervalHours > 0) {
                this._synchronizeInterval = 3600000L * (long)this._synchronizeIntervalHours;
                if (_log.isTraceEnabled()) {
                    _log.trace("Synchronizing clock every: {} hours.", (Object)this._synchronizeIntervalHours);
                }
            } else {
                if (_log.isTraceEnabled()) {
                    _log.trace("Never synchronizing the clock with remote ntp server.");
                }
                this._synchronizeInterval = 3600000L;
            }
        }
        catch (Exception e) {
            this._synchronizeInterval = 3600000L;
        }
    }

    @Override
    public String getUsedNtpServer() {
        try {
            this.reinit();
        }
        catch (JAXBException e) {
            _log.error("Error while reinitializing NTP server: {}", (Object)e.getMessage(), (Object)e);
        }
        if (this._usedNtpServer != null) {
            try {
                return this._usedNtpServer.getHostName();
            }
            catch (Exception e1) {
                try {
                    return this._usedNtpServer.getHostAddress();
                }
                catch (Exception e2) {
                    return "No ntp server available.";
                }
            }
        }
        return "No ntp server available.";
    }

    @Override
    public long getOffset() {
        return this._offset;
    }

    public long getReferenceCurrentTimeMillis() {
        return System.currentTimeMillis() + this.getOffset();
    }

    @Override
    public Date getReferenceDate() {
        return new Date(this.getReferenceCurrentTimeMillis());
    }

    public OffsetDateTime getReferenceOffsetDateTime() {
        return this.getReferenceDate().toInstant().atOffset(ZoneOffset.UTC);
    }

    public void shutdown() {
        _log.debug("Stopping ReferenceDateTask.");
        if (this.referenceDateTaskFuture != null) {
            this.referenceDateTaskFuture.cancel(true);
            _log.info("ReferenceDateTask is down");
            this.referenceDateTaskFuture = null;
            try {
                MBeanServer mBeanServer = ManagementFactory.getPlatformMBeanServer();
                ObjectName referenceDateName = new ObjectName(MBEAN_NAME);
                mBeanServer.unregisterMBean(referenceDateName);
            }
            catch (InstanceNotFoundException | MBeanException | MalformedObjectNameException e) {
                _log.error("could not unregister MBean {}", (Object)e.toString());
            }
        } else {
            _log.info("ReferenceDateTask is already down");
        }
    }

    @Override
    public ServiceLevel getServiceLevel() {
        return ServiceLevel.getServiceLevel(this.getClass());
    }

    public void onApplicationEvent(ApplicationEvent event) {
        if (event instanceof StartupService) {
            StartupService startupEvent = (StartupService)event;
            if (this.getServiceLevel() == startupEvent.getServiceLevel()) {
                this.start();
                this.applicationEventPublisher.publishEvent((ApplicationEvent)new StartupCompleted(this));
            }
        } else if (event instanceof ShutdownService) {
            ShutdownService shutdownEvent = (ShutdownService)event;
            if (this.getServiceLevel() == shutdownEvent.getServiceLevel()) {
                this.shutdown();
                this.applicationEventPublisher.publishEvent((ApplicationEvent)new ShutdownCompleted(this));
            }
        }
    }

    @Override
    public String getServiceName() {
        return "ReferenceDateTask";
    }

    static {
        String pontonxpTest = System.getProperty("pontonxpTest");
        _runInTestMode = pontonxpTest != null && pontonxpTest.equalsIgnoreCase("true");
    }
}

