/*
 * Decompiled with CFR 0.152.
 */
package de.pontonconsulting.xmlpipe.messenger;

import de.pontonconsulting.xmlpipe.message.XpMessage;
import de.pontonconsulting.xmlpipe.messenger.IdGenerator;
import de.pontonconsulting.xmlpipe.messenger.database.DbException;
import de.pontonconsulting.xmlpipe.messenger.database.tables.MessageDAO;
import de.pontonconsulting.xmlpipe.messenger.database.tables.MessengerLog;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class MessageRegistrationService {
    private static final Logger LOG = LogManager.getLogger((String)"Messenger.MessageRegistrationService");
    private final MessageDAO messageDAO;
    private final MessengerLog messengerLog;
    private final IdGenerator idGenerator;

    public MessageRegistrationService(MessageDAO messageDAO, MessengerLog messengerLog, IdGenerator idGenerator) {
        this.messageDAO = messageDAO;
        this.messengerLog = messengerLog;
        this.idGenerator = idGenerator;
    }

    public XpMessage registerMessageFromAdapter(String adapterId, String transferId) {
        XpMessage tempMessage = new XpMessage();
        tempMessage.setMessageId(this.idGenerator.generateMessageId());
        tempMessage.setInboundMessage(false);
        tempMessage.setAdapterId(adapterId);
        tempMessage.setTransferId(transferId);
        try {
            this.messageDAO.registerMessage(tempMessage, 0);
            this.messengerLog.log2db(68, tempMessage.getDatabaseId(), tempMessage.getAdapterId());
        }
        catch (DbException e) {
            if (LOG.isDebugEnabled()) {
                LOG.error("message could not be registered in DB: " + e.getMessage(), (Throwable)e);
            }
            LOG.error("message could not be registered in DB: {}", (Object)e.getMessage());
        }
        return tempMessage;
    }

    public XpMessage registerMessageFromAdapter(String adapterId) {
        return this.registerMessageFromAdapter(adapterId, null);
    }

    public void logErrorAndSetFailedStatus(XpMessage tempMessage, String errorText) {
        try {
            LOG.error(errorText);
            if (tempMessage.isInbound()) {
                this.messengerLog.log2db(500, tempMessage.getDatabaseId(), errorText);
            } else {
                this.messengerLog.log2db(515, tempMessage.getDatabaseId(), errorText);
            }
            this.messageDAO.updateMessageAndStatus(tempMessage, 4);
        }
        catch (DbException e) {
            LOG.error("could not store log message to database: {}", (Object)e.getMessage());
        }
    }
}

