/*
 * Decompiled with CFR 0.152.
 */
package de.pontonconsulting.xmlpipe.messenger;

import de.pontonconsulting.xmlpipe.config.MessengerConfig;
import de.pontonconsulting.xmlpipe.messenger.ReferenceDateTask;
import java.util.Date;
import org.apache.logging.log4j.Logger;

public abstract class CleanupTask {
    public static final long DAY = 86400000L;
    private final MessengerConfig _messengerConfig;
    private final ReferenceDateTask referenceDateTask;
    private long maximumEndTime = -1L;

    protected CleanupTask(MessengerConfig messengerConfig, ReferenceDateTask referenceDateTask) {
        this._messengerConfig = messengerConfig;
        this.referenceDateTask = referenceDateTask;
    }

    public final Boolean call() throws Exception {
        try {
            if (!this.isCleanupEnabled()) {
                this.getLogger().debug("Cleanup is disabled");
                return false;
            }
            this.setMaximumEndTime();
            this.getLogger().info("Cleanup Task started");
            this.doCleanup();
            this.getLogger().info("Cleanup Task completed");
        }
        catch (Exception e) {
            this.getLogger().error("Cleanup problem due to {}: {}", (Object)e.getClass().getName(), (Object)e.getMessage());
            return false;
        }
        return true;
    }

    private void setMaximumEndTime() {
        int maxRuntimeInMinutes = 0;
        try {
            maxRuntimeInMinutes = this._messengerConfig.getDatabaseCleanupMaxRuntime();
        }
        catch (Exception e) {
            this.getLogger().error("Can't get CleanupMaxRuntime from config: {}", (Object)e.getMessage());
        }
        long l = this.maximumEndTime = maxRuntimeInMinutes <= 0 ? Long.MAX_VALUE : this.referenceDateTask.getReferenceCurrentTimeMillis() + (long)(maxRuntimeInMinutes * 60) * 1000L;
        if (this.maximumEndTime != Long.MAX_VALUE) {
            this.getLogger().debug("Cleanup-MaximumRuntime configured to {} minutes. Thread will run until {}, at most.", (Object)maxRuntimeInMinutes, (Object)new Date(this.maximumEndTime));
        }
    }

    protected boolean isRuntimeLeft() {
        boolean isRuntimeLeft;
        boolean bl = isRuntimeLeft = this.referenceDateTask.getReferenceCurrentTimeMillis() < this.maximumEndTime;
        if (!isRuntimeLeft) {
            this.getLogger().info("MaxRuntime of CleanupThread expired ({})", (Object)new Date(this.maximumEndTime));
        }
        return isRuntimeLeft;
    }

    protected abstract Logger getLogger();

    protected abstract void doCleanup();

    protected abstract boolean isCleanupEnabled();

    protected MessengerConfig getMessengerConfig() {
        return this._messengerConfig;
    }

    protected ReferenceDateTask getReferenceDateTask() {
        return this.referenceDateTask;
    }
}

