/*
 * Decompiled with CFR 0.152.
 */
package de.pontonconsulting.xmlpipe.messenger;

import de.pontonconsulting.xmlpipe.config.IFolders;
import de.pontonconsulting.xmlpipe.config.MessengerConfig;
import de.pontonconsulting.xmlpipe.config.model.messenger.archive.XpArchiverType;
import de.pontonconsulting.xmlpipe.messenger.CleanupTask;
import de.pontonconsulting.xmlpipe.messenger.ReferenceDateTask;
import de.pontonconsulting.xmlpipe.messenger.database.tables.MessageArchiveDataDAO;
import jakarta.xml.bind.JAXBException;
import java.io.File;
import java.time.Instant;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.util.Date;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ArchiveCleanupTask
extends CleanupTask {
    private static final Logger LOG = LogManager.getLogger((String)"Messenger.ArchiveCleanupThread");
    private final IFolders _folders;
    private final MessageArchiveDataDAO archiveDataDAO;

    public ArchiveCleanupTask(MessengerConfig messengerConfig, IFolders folders, ReferenceDateTask referenceDateTask, MessageArchiveDataDAO archiveDataDAO) {
        super(messengerConfig, referenceDateTask);
        this._folders = folders;
        this.archiveDataDAO = archiveDataDAO;
    }

    @Override
    protected Logger getLogger() {
        return LOG;
    }

    @Override
    protected boolean isCleanupEnabled() {
        try {
            return this.getMessengerConfig().isDeleteArchive();
        }
        catch (JAXBException jAXBException) {
            return false;
        }
    }

    @Override
    protected void doCleanup() {
        try {
            long now = this.getReferenceDateTask().getReferenceCurrentTimeMillis();
            long maxArchiveAge = this.getMaxArchiveAge(now);
            if (this.getMessengerConfig().getArchiverType().equals((Object)XpArchiverType.FILE_SYSTEM)) {
                LOG.info("will delete from filesystem older than {}", (Object)new Date(maxArchiveAge));
                int deleteCount = this.deleteFiles(maxArchiveAge);
                LOG.info("Deleted {} files", (Object)deleteCount);
            } else if (this.getMessengerConfig().getArchiverType().equals((Object)XpArchiverType.DATABASE)) {
                LOG.info("will delete from database older than {}", (Object)new Date(maxArchiveAge));
                int deleteCount = this.archiveDataDAO.deleteMessageArchiveDataOlderThan(maxArchiveAge);
                LOG.info("Deleted {} entries", (Object)deleteCount);
            }
        }
        catch (Exception ex) {
            LOG.error("An Error happend while processing Archive cleanup {}", (Object)ex.getMessage());
        }
    }

    private long getMaxArchiveAge(long now) {
        long days = 365L;
        try {
            days = this.getMessengerConfig().getArchiveMaxAge();
        }
        catch (Exception e1) {
            LOG.error("Could not read messenger config");
        }
        long maxDays = 86400000L * days;
        return now - maxDays;
    }

    private int deleteFiles(long maxAge) {
        AtomicInteger deleteCount = new AtomicInteger();
        File archiveFolderRoot = this._folders.getArchiveFolder();
        this.deleteFile(new File(archiveFolderRoot, "inbound"), maxAge, deleteCount);
        this.deleteFile(new File(archiveFolderRoot, "outbound"), maxAge, deleteCount);
        File archiveFolderFailedRoot = this._folders.getArchiveFailedFolder();
        this.deleteFile(new File(archiveFolderFailedRoot, "inbound"), maxAge, deleteCount);
        this.deleteFile(new File(archiveFolderFailedRoot, "outbound"), maxAge, deleteCount);
        return deleteCount.get();
    }

    private void deleteFile(File rootFolder, long maxAge, AtomicInteger deleteCount) {
        OffsetDateTime dateTime = OffsetDateTime.ofInstant(Instant.ofEpochMilli(maxAge), ZoneOffset.UTC);
        int year = dateTime.getYear();
        int month = dateTime.getMonthValue();
        int day = dateTime.getDayOfMonth();
        if (rootFolder.exists()) {
            File[] subFolderList;
            for (File subFolderYear : subFolderList = rootFolder.listFiles()) {
                File[] subFolderListMonth;
                if (this.isLess(year, subFolderYear.getName())) {
                    if (this.deleteFile(subFolderYear, deleteCount)) continue;
                    LOG.warn("could not remove {} from diskarchive", (Object)subFolderYear);
                    continue;
                }
                if (!this.isEqual(year, subFolderYear.getName())) continue;
                for (File subFolderMonth : subFolderListMonth = subFolderYear.listFiles()) {
                    File[] subFolderListDay;
                    if (this.isLess(month, subFolderMonth.getName())) {
                        if (this.deleteFile(subFolderMonth, deleteCount)) continue;
                        LOG.warn("could not remove {} from diskarchive", (Object)subFolderMonth);
                        continue;
                    }
                    if (!this.isEqual(month, subFolderMonth.getName())) continue;
                    for (File subFolderDay : subFolderListDay = subFolderMonth.listFiles()) {
                        if (!this.isLess(day, subFolderDay.getName()) || this.deleteFile(subFolderDay, deleteCount)) continue;
                        LOG.warn("could not remove {} from diskarchive", (Object)subFolderDay);
                    }
                }
            }
        }
    }

    private boolean isEqual(int ref, String check) {
        try {
            int checkValue = Integer.parseInt(check);
            return ref == checkValue;
        }
        catch (NumberFormatException nfe) {
            return false;
        }
    }

    private boolean isLess(int ref, String check) {
        try {
            int checkValue = Integer.parseInt(check);
            return ref > checkValue;
        }
        catch (NumberFormatException nfe) {
            return false;
        }
    }

    private boolean deleteFile(File file, AtomicInteger deleteCount) {
        if (file == null || !file.exists()) {
            return false;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("deleted {} from diskarchive", (Object)file);
        }
        boolean result = true;
        if (file.isDirectory()) {
            File[] subfiles = file.listFiles();
            for (int i = 0; i < subfiles.length; ++i) {
                boolean temp = this.deleteFile(subfiles[i], deleteCount);
                if (temp) continue;
                result = false;
            }
        }
        if (!file.delete()) {
            result = false;
        }
        deleteCount.incrementAndGet();
        return result;
    }
}

