/*
 * Decompiled with CFR 0.152.
 */
package de.pontonconsulting.xmlpipe.messenger;

import de.pontonconsulting.xmlpipe.cpp.CertificateIdNotFoundException;
import de.pontonconsulting.xmlpipe.cpp.CppPartner;
import de.pontonconsulting.xmlpipe.cpp.PipelineIdNotFoundException;
import de.pontonconsulting.xmlpipe.cpp.ProfileStoreAccessException;
import java.security.GeneralSecurityException;
import java.security.NoSuchProviderException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class AbstractCertificateUpdate {
    protected Log _log;
    protected CertificateFactory _cf;

    public AbstractCertificateUpdate(String logName) throws CertificateException, NoSuchProviderException {
        if (this._log == null) {
            this._log = LogFactory.getFactory().getInstance(logName);
        }
        if (this._cf == null) {
            this._cf = CertificateFactory.getInstance("X.509", "BC");
        }
    }

    protected void updateCertificate(CppPartner partner, X509Certificate cert, int[] updateCount) throws PipelineIdNotFoundException, CertificateIdNotFoundException, ProfileStoreAccessException, GeneralSecurityException {
        String[] pipelines;
        for (String pipelineId : pipelines = partner.getPipelineIds()) {
            boolean addCert = false;
            String[] certRefIds = partner.getCertificateIds();
            if (certRefIds == null || certRefIds.length == 0) {
                addCert = true;
            } else {
                for (String certRefId : certRefIds) {
                    X509Certificate tempCert = partner.getX509Certificate(certRefId);
                    if (tempCert == null || !tempCert.getSerialNumber().equals(cert.getSerialNumber())) continue;
                    this._log.debug((Object)("Certificate for " + partner.getDisplayName() + "[" + partner.getInternalId() + "] is up to date."));
                    return;
                }
                addCert = true;
            }
            if (!addCert) continue;
            String certId = partner.addPartnerCertificate(cert);
            this._log.debug((Object)("Certificate for " + partner.getDisplayName() + "[" + partner.getInternalId() + "] installed."));
            updateCount[0] = updateCount[0] + 1;
            partner.setPipelineCertificate(pipelineId, certId);
            this._log.debug((Object)("Certificate '" + String.valueOf(cert.getSubjectDN()) + "' for " + partner.getDisplayName() + "[" + partner.getInternalId() + "] set as default."));
            partner.save();
        }
    }
}

