/*
 * Decompiled with CFR 0.152.
 */
package de.pontonconsulting.xmlpipe.messagemonitor;

import de.ponton.xmlpipe.queue.InboundQueue;
import de.ponton.xmlpipe.queue.OutboundQueue;
import de.ponton.xmlpipe.queue.QueueMessageConsumer;
import de.ponton.xmlpipe.rest.exception.ResourceNotFoundException;
import de.pontonconsulting.xmlpipe.config.IFolders;
import de.pontonconsulting.xmlpipe.config.MessengerConfig;
import de.pontonconsulting.xmlpipe.message.XpAcknowledgment;
import de.pontonconsulting.xmlpipe.message.XpMessage;
import de.pontonconsulting.xmlpipe.messenger.IdGenerator;
import de.pontonconsulting.xmlpipe.messenger.Messenger;
import de.pontonconsulting.xmlpipe.messenger.ReceiveFromListener;
import de.pontonconsulting.xmlpipe.messenger.ReferenceDateTask;
import de.pontonconsulting.xmlpipe.messenger.archive.ArchiveProcessor;
import de.pontonconsulting.xmlpipe.messenger.database.DbException;
import de.pontonconsulting.xmlpipe.messenger.database.MessageInfo;
import de.pontonconsulting.xmlpipe.messenger.database.tables.FileRefDAO;
import de.pontonconsulting.xmlpipe.messenger.database.tables.MDNDataDAO;
import de.pontonconsulting.xmlpipe.messenger.database.tables.MessageDAO;
import de.pontonconsulting.xmlpipe.messenger.database.tables.MessageLogDAO;
import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

@Service
public class MessageDeleteService {
    private static final Logger AUDIT = LogManager.getLogger((String)"Audit.MessageDeleteService");
    private static final Logger LOG = LogManager.getLogger((String)"Messenger.MessageDeleteService");
    private final MessageDAO messageDAO;
    private final InboundQueue inboundMessageQueue;
    private final OutboundQueue outboundMessageQueue;
    private final MDNDataDAO mdnDataDao;
    private final FileRefDAO fileRefDAO;
    private final MessageLogDAO messageLogDAO;
    private final IdGenerator idGenerator;
    private final ReferenceDateTask referenceDateTask;
    private final ReceiveFromListener receiveFromListener;
    private final ArchiveProcessor archiveProcessor;
    private final IFolders folders;
    private final QueueMessageConsumer inboundMessageConsumer;
    private final MessengerConfig messengerConfig;

    public MessageDeleteService(MessageDAO messageDAO, InboundQueue inboundMessageQueue, OutboundQueue outboundMessageQueue, MDNDataDAO mdnDataDAO, FileRefDAO fileRefDAO, MessageLogDAO messageLogDAO, IdGenerator idGenerator, ReferenceDateTask referenceDateTask, ReceiveFromListener receiveFromListener, IFolders folders, @Qualifier(value="inboundQueueMessageConsumer") QueueMessageConsumer inboundMessageConsumer, ArchiveProcessor archiveProcessor, MessengerConfig messengerConfig) {
        this.messageDAO = Objects.requireNonNull(messageDAO, "MessageDao must not be null");
        this.inboundMessageQueue = Objects.requireNonNull(inboundMessageQueue, "InboundQueueingDao must not be null");
        this.outboundMessageQueue = Objects.requireNonNull(outboundMessageQueue, "OutboundQueueingDao must not be null");
        this.mdnDataDao = Objects.requireNonNull(mdnDataDAO, "MdnDataDao must not be null");
        this.fileRefDAO = Objects.requireNonNull(fileRefDAO, "FileRefDao must not be null");
        this.messageLogDAO = Objects.requireNonNull(messageLogDAO, "MessageLogDao must not be null");
        this.idGenerator = Objects.requireNonNull(idGenerator, "IdGenerator must not be null");
        this.referenceDateTask = Objects.requireNonNull(referenceDateTask, "ReferenceDateTask must not be null");
        this.receiveFromListener = Objects.requireNonNull(receiveFromListener, "ReceiveFromListener must not be null");
        this.archiveProcessor = archiveProcessor;
        this.folders = Objects.requireNonNull(folders, "Folders must not be null");
        this.inboundMessageConsumer = inboundMessageConsumer;
        this.messengerConfig = messengerConfig;
    }

    public void deleteMessage(long databaseId, String user) throws DbException, IOException, ResourceNotFoundException {
        AUDIT.warn("User delete message. [User={}, DatabaseId={}]", (Object)user, (Object)databaseId);
        if (this.messageDAO.getMessage(databaseId) == null) {
            return;
        }
        LOG.info("Start deleting process for message. [DatabaseId={}]", (Object)databaseId);
        this.deleteMessage(this.getMessageInfo(databaseId));
        LOG.info("Deleting message was successful. [DatabaseId={}]", (Object)databaseId);
    }

    private boolean isSignal(MessageInfo messageInfo) {
        return "ponton".equals(messageInfo.getSchemaSet());
    }

    private boolean inTransit(MessageInfo messageInfo) {
        return messageInfo.getStatus() != 3 && messageInfo.getStatus() != 5 && messageInfo.getStatus() != 4;
    }

    private void deleteMessage(MessageInfo messageInfo) throws DbException, IOException {
        LOG.debug("Delete message. [DatabaseId={}]", (Object)messageInfo.getDatabaseId());
        MessageInfo updatedMessageInfo = messageInfo;
        try {
            if (updatedMessageInfo.isInbound()) {
                if (this.inboundMessageConsumer.interruptDelivery(updatedMessageInfo.getDatabaseId())) {
                    throw new IllegalArgumentException("Could not delete message in delivery with id: " + updatedMessageInfo.getDatabaseId() + ".");
                }
            } else {
                if (this.outboundMessageQueue.cancelIfInTransfer(updatedMessageInfo.getDatabaseId())) {
                    throw new IllegalArgumentException("Could not delete message in delivery with id: " + updatedMessageInfo.getDatabaseId() + ".");
                }
                if (!this.isSignal(updatedMessageInfo) && this.inTransit(updatedMessageInfo)) {
                    MessageInfo ackInfo = this.createAndProcessAck(updatedMessageInfo);
                    if (ackInfo != null) {
                        try {
                            Thread.sleep(5000L);
                        }
                        catch (InterruptedException e) {
                            Thread.currentThread().interrupt();
                        }
                        this.deleteMessage(ackInfo);
                    }
                    updatedMessageInfo = this.getMessageInfo(updatedMessageInfo.getDatabaseId());
                }
            }
            this.deleteFilesFromArchive(updatedMessageInfo);
            this.messageDAO.deleteFromMessage(updatedMessageInfo.getDatabaseId());
            LOG.debug("Delete message from archive. [DatabaseId={}]", (Object)updatedMessageInfo.getDatabaseId());
        }
        catch (DbException | IOException e) {
            LOG.error("Unexpected exception during deleting message. [DatabaseId={}]", (Object)updatedMessageInfo.getDatabaseId(), (Object)e);
            throw e;
        }
    }

    private MessageInfo createAndProcessAck(MessageInfo messageInfo) {
        MessageInfo ackMessageInfo = null;
        String messageId = messageInfo.getMessageId();
        LOG.debug("Creating internal XpAcknowledgment for deleted message. [MessageId={}]", (Object)messageInfo.getMessageId());
        String senderId = messageInfo.getSenderId();
        if (senderId != null) {
            XpMessage xpMessage = new XpMessage();
            xpMessage.setIsAck(true);
            xpMessage.setMessageId(this.idGenerator.generateMessageId());
            xpMessage.setConversationId(this.idGenerator.generateConversationId());
            xpMessage.setSenderLocalId(senderId);
            xpMessage.setReceiverLocalId(senderId);
            xpMessage.setMessageType("ACK");
            xpMessage.setMessageVersion("2.1");
            xpMessage.setSchemaSet("ponton");
            xpMessage.setInboundMessage(true);
            xpMessage.setProtocol("Internal");
            xpMessage.setMessageTimestamp(this.referenceDateTask.getReferenceDate());
            xpMessage.setReferenceId(messageInfo.getMessageId());
            xpMessage.setMessengerId(this.messengerConfig.getMessengerId());
            try {
                String destinationAdapter = this.messageDAO.getAdapterId(messageInfo.getDatabaseId());
                xpMessage.setAdapterId(destinationAdapter);
                String transferId = this.messageDAO.getTransferId(messageInfo.getDatabaseId());
                xpMessage.setTransferId(transferId);
                this.messageDAO.registerMessage(xpMessage);
                this.messageLogDAO.log2db(206, messageInfo.getDatabaseId(), null);
                Date date = this.referenceDateTask.getReferenceDate();
                XpAcknowledgment ack = new XpAcknowledgment(xpMessage, messageId, date, date);
                ack.setOverallResult("Error");
                ack.addError("Error", "Message was deleted locally");
                File ackRef = ack.saveToDisk(new File(this.folders.getWorkInboundFolder(), Messenger.getFixedFilename(ack.getMessageId())));
                xpMessage.setCurrentContentReference(ackRef);
                this.receiveFromListener.handleMessage(xpMessage);
                ackMessageInfo = new MessageInfo(xpMessage.getDatabaseId(), xpMessage.getMessageId());
                ackMessageInfo.setInbound(1);
            }
            catch (Exception e) {
                LOG.error("Unexpected error occurred during deleting acknowledgement message.", (Throwable)e);
            }
        } else {
            try {
                this.outboundMessageQueue.deleteFromOutboundQueue(messageInfo.getDatabaseId());
            }
            catch (DbException e) {
                LOG.warn("Unable to delete message from queue. [MessageId={}]", (Object)messageId, (Object)e);
            }
        }
        return ackMessageInfo;
    }

    private List<MessageInfo> getReferenceMessageInfos(long databaseId) throws DbException {
        try {
            return this.messageDAO.getReferenceMessageInfos(databaseId);
        }
        catch (DbException e) {
            LOG.error("Unable to find referenced message infos. [DatabaseId={}]", (Object)databaseId, (Object)e);
            throw e;
        }
    }

    private MessageInfo getMessageInfo(long databaseId) throws DbException {
        try {
            return Optional.ofNullable(this.messageDAO.getMessageInfo(databaseId)).orElseThrow(() -> new ResourceNotFoundException(MessageFormat.format("No message found. [DatabaseId={0}]", databaseId)));
        }
        catch (DbException e) {
            LOG.error("Unable to get MessageInfo. [DatabaseId={}]", (Object)databaseId);
            throw e;
        }
    }

    private void deleteFilesFromArchive(MessageInfo messageInfo) throws IOException {
        this.archiveProcessor.deleteFromArchive(messageInfo);
    }
}

