/*
 * Decompiled with CFR 0.152.
 */
package de.pontonconsulting.xmlpipe.message.identification;

import de.pontonconsulting.common.io.UTF8BOMSkippingInputStream;
import de.pontonconsulting.xmlpipe.config.EnvelopeModel;
import de.pontonconsulting.xmlpipe.config.IEnvelopeConfig;
import de.pontonconsulting.xmlpipe.message.BackEndMessageException;
import de.pontonconsulting.xmlpipe.message.MessageException;
import de.pontonconsulting.xmlpipe.message.StAXXPath;
import de.pontonconsulting.xmlpipe.message.XpEnvelope;
import de.pontonconsulting.xmlpipe.message.identification.IEnvelopeRecognizer;
import de.pontonconsulting.xmlpipe.messenger.XmlMetaData;
import java.io.BufferedInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.stream.FactoryConfigurationError;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class EnvelopeRecognizer
implements IEnvelopeRecognizer {
    public static final Logger _log = LogManager.getLogger((String)"Messenger.EnvelopeRecognizer");
    private static final String EMPTY = "";
    private final IEnvelopeConfig _envelopeConfig;

    public EnvelopeRecognizer(IEnvelopeConfig envelopeConfig) {
        this._envelopeConfig = envelopeConfig;
    }

    @Override
    public XpEnvelope recognizeEnvelope(File xmlFile) throws MessageException {
        XpEnvelope xpEnvelope = null;
        try {
            StringTokenizer st;
            XmlMetaData meta = new XmlMetaData(xmlFile);
            String rootElement = meta.getRootElementName();
            String namespace = meta.getNamespaceUri();
            String schemaLocation = meta.getSchemaLocation();
            String systemId = meta.getSystemId();
            xpEnvelope = new XpEnvelope();
            xpEnvelope.setPayloadElement(rootElement);
            xpEnvelope.setPayloadNamespace(namespace);
            xpEnvelope.setPayloadSchemaLocation(schemaLocation);
            xpEnvelope.setPayloadSystemId(systemId);
            HashMap<String, List<String>> schemaLocations = new HashMap<String, List<String>>();
            String envelopeSchemaLocation = schemaLocation;
            if (schemaLocation != null && (st = new StringTokenizer(schemaLocation)).countTokens() % 2 == 0) {
                while (st.hasMoreTokens()) {
                    String tempNS = st.nextToken();
                    String tempSL = st.nextToken();
                    if (!tempNS.equals(namespace)) continue;
                    envelopeSchemaLocation = tempSL;
                    break;
                }
            }
            List<EnvelopeModel> envelopes = this._envelopeConfig.getMatchedEnvelopes(rootElement, namespace, envelopeSchemaLocation);
            for (EnvelopeModel envelopeModel : envelopes) {
                XpEnvelope tempXpEnvelope = this.readMissingDataFromEnvelope(xmlFile, envelopeModel, schemaLocations);
                if (envelopeModel.getSenderIdXPath() != null && tempXpEnvelope.getSenderId() == null) {
                    _log.warn("{} was not set on envelope {}", (Object)envelopeModel.getSenderIdXPath(), (Object)tempXpEnvelope.getName());
                    continue;
                }
                if (envelopeModel.getReceiverIdXPath() != null && tempXpEnvelope.getReceiverId() == null) {
                    _log.warn("{} was not set on envelope {}", (Object)envelopeModel.getReceiverIdXPath(), (Object)tempXpEnvelope.getName());
                    continue;
                }
                if (envelopeModel.getMessageIdXPath() != null && tempXpEnvelope.getMessageId() == null) {
                    _log.warn("{} was not set on envelope {}", (Object)envelopeModel.getMessageIdXPath(), (Object)tempXpEnvelope.getName());
                    continue;
                }
                if (envelopeModel.getMessageTypeXPath() != null && tempXpEnvelope.getMessageType() == null) {
                    _log.warn("{} was not set on envelope {}", (Object)envelopeModel.getMessageTypeXPath(), (Object)tempXpEnvelope.getName());
                    continue;
                }
                if (envelopeModel.getMessageVersionXPath() != null && tempXpEnvelope.getMessageVersion() == null) {
                    _log.warn("{} was not set on envelope {}", (Object)envelopeModel.getMessageVersionXPath(), (Object)tempXpEnvelope.getName());
                    continue;
                }
                if (envelopeModel.getSchemaSetXPath() != null && tempXpEnvelope.getPayloadSchemaSet() == null) {
                    _log.warn("{} was not set on envelope {}", (Object)envelopeModel.getSchemaSetXPath(), (Object)tempXpEnvelope.getName());
                    continue;
                }
                if (envelopeModel.getLogInfoXPath() != null && tempXpEnvelope.getLogInfo() == null) {
                    _log.warn("{} was not set on envelope {}", (Object)envelopeModel.getLogInfoXPath(), (Object)tempXpEnvelope.getName());
                    continue;
                }
                if (envelopeModel.getTestXPath() != null) {
                    if (tempXpEnvelope.getTestFlag() == null) {
                        _log.warn("{} was not set on envelope {}", (Object)envelopeModel.getTestXPath(), (Object)tempXpEnvelope.getName());
                        continue;
                    }
                    tempXpEnvelope.setTestTrueValue(envelopeModel.getTestValue());
                }
                if (envelopeModel.getPayloadXPath() != null && tempXpEnvelope.getPayloadXPath() == null) {
                    _log.warn("{} was not set on envelope {}", (Object)envelopeModel.getPayloadXPath(), (Object)tempXpEnvelope.getName());
                    continue;
                }
                tempXpEnvelope.setNamespace(namespace);
                tempXpEnvelope.setSchemaFile(envelopeModel.getSchemaFile());
                xpEnvelope = tempXpEnvelope;
                break;
            }
        }
        catch (Exception e) {
            _log.warn("Could not parse document: {}", (Object)e.getMessage());
            throw new MessageException(-1, "Could not parse document.", e);
        }
        return xpEnvelope;
    }

    private XpEnvelope readMissingDataFromEnvelope(File xmlFile, EnvelopeModel envelopeModel, Map<String, List<String>> schemaLocations) throws BackEndMessageException, ParserConfigurationException {
        if (envelopeModel.isPontonXPathType()) {
            return this.usePontonXPath(xmlFile, envelopeModel, schemaLocations);
        }
        return this.useW3CXPath(xmlFile, envelopeModel, schemaLocations);
    }

    private XpEnvelope useW3CXPath(File xmlFile, EnvelopeModel envelopeModel, Map<String, List<String>> schemaLocations) throws BackEndMessageException, ParserConfigurationException {
        XpEnvelope xpEnvelope = new XpEnvelope();
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(true);
        factory.setAttribute("http://javax.xml.XMLConstants/property/accessExternalDTD", EMPTY);
        factory.setAttribute("http://javax.xml.XMLConstants/property/accessExternalSchema", EMPTY);
        Document doc = null;
        try {
            DocumentBuilder builder = factory.newDocumentBuilder();
            long time1 = System.currentTimeMillis();
            doc = builder.parse(xmlFile);
            long time2 = System.currentTimeMillis();
            if (_log.isTraceEnabled()) {
                _log.trace("time to parse xml {}ms", (Object)(time2 - time1));
            }
        }
        catch (ParserConfigurationException e) {
            _log.error("could init xml parser when parsing {}", (Object)xmlFile);
            throw new BackEndMessageException("could not init xml parser while extracting data from xml. " + String.valueOf(e));
        }
        catch (SAXException e) {
            _log.error("could not parse xml {}", (Object)xmlFile);
            throw new BackEndMessageException("could not parse xml for envelope data extraction. " + String.valueOf(e));
        }
        catch (IOException e) {
            _log.error("could not read xml {}", (Object)xmlFile);
            throw new BackEndMessageException("could not read xml for envelope data extraction. " + String.valueOf(e));
        }
        XPathFactory xfactory = XPathFactory.newInstance();
        xpEnvelope.setName(envelopeModel.getEnvelopeName());
        String senderId = envelopeModel.getSenderIdXPath();
        xpEnvelope.setSenderId(this.evaluateXPath(doc, xfactory, senderId));
        String receiverId = envelopeModel.getReceiverIdXPath();
        xpEnvelope.setReceiverId(this.evaluateXPath(doc, xfactory, receiverId));
        String messageId = envelopeModel.getMessageIdXPath();
        xpEnvelope.setMessageId(this.evaluateXPath(doc, xfactory, messageId));
        String messageType = envelopeModel.getMessageTypeXPath();
        xpEnvelope.setMessageType(this.evaluateXPath(doc, xfactory, messageType));
        String messageVersion = envelopeModel.getMessageVersionXPath();
        xpEnvelope.setMessageVersion(this.evaluateXPath(doc, xfactory, messageVersion));
        String schemaSet = envelopeModel.getSchemaSetXPath();
        xpEnvelope.setPayloadSchemaSet(this.evaluateXPath(doc, xfactory, schemaSet));
        String logInfo = envelopeModel.getLogInfoXPath();
        xpEnvelope.setLogInfo(this.evaluateXPath(doc, xfactory, logInfo));
        String testFlag = envelopeModel.getTestXPath();
        xpEnvelope.setTestFlag(this.evaluateXPath(doc, xfactory, testFlag));
        String payloadXpath = envelopeModel.getPayloadXPath();
        this.resolveXPath(doc, xfactory, payloadXpath, xpEnvelope, schemaLocations);
        return xpEnvelope;
    }

    private String evaluateXPath(Document doc, XPathFactory xfactory, String xpathString) throws BackEndMessageException {
        String result = null;
        if (xpathString != null) {
            try {
                XPath xpath = xfactory.newXPath();
                XPathExpression expr = xpath.compile(xpathString);
                long time3 = System.currentTimeMillis();
                result = expr.evaluate(doc);
                long time4 = System.currentTimeMillis();
                if (_log.isTraceEnabled()) {
                    _log.trace("time to evaluate W3C XPATH '{}' {}ms", (Object)xpathString, (Object)(time4 - time3));
                }
            }
            catch (XPathExpressionException e) {
                _log.error("could not evaluate W3C XPATH: {}", (Object)xpathString);
                throw new BackEndMessageException("could not evaluate XPATH " + xpathString + ": " + String.valueOf(e));
            }
        }
        return result;
    }

    private void resolveXPath(Document doc, XPathFactory xfactory, String xpathString, XpEnvelope xpEnvelope, Map<String, List<String>> schemaLocations) throws BackEndMessageException {
        NodeList result = null;
        if (xpathString != null) {
            if (!xpathString.endsWith("*")) {
                throw new BackEndMessageException("envelope mapping failed because payload xpath has to end with a '*' but it is " + xpathString);
            }
            try {
                XPath xpath = xfactory.newXPath();
                XPathExpression expr = xpath.compile(xpathString);
                long time3 = System.currentTimeMillis();
                result = (NodeList)expr.evaluate(doc, XPathConstants.NODESET);
                long time4 = System.currentTimeMillis();
                if (_log.isTraceEnabled()) {
                    _log.trace("time to evaluate W3C XPATH '{}' {}ms", (Object)xpathString, (Object)(time4 - time3));
                }
            }
            catch (XPathExpressionException e) {
                _log.error("could not evaluate W3C XPATH: {}", (Object)xpathString);
                throw new BackEndMessageException("could not evaluate XPATH " + xpathString + ": " + String.valueOf(e));
            }
        }
        if (result != null && result.getLength() > 0) {
            Node payload = result.item(0);
            if (payload.getNodeType() != 1) {
                return;
            }
            String updatedXpath = null;
            String payloadSchemaLocation = null;
            Node schemaLocationNode = null;
            NamedNodeMap attributes = payload.getAttributes();
            schemaLocationNode = payload.getNamespaceURI() != null ? attributes.getNamedItemNS("http://www.w3.org/2001/XMLSchema-instance", "schemaLocation") : attributes.getNamedItemNS("http://www.w3.org/2001/XMLSchema-instance", "noNamespaceSchemaLocation");
            xpEnvelope.setPayloadElement(payload.getLocalName());
            xpEnvelope.setPayloadNamespace(payload.getNamespaceURI());
            int index = xpathString.lastIndexOf("/");
            if (index > -1) {
                updatedXpath = xpathString.substring(0, index);
            }
            xpEnvelope.setPayloadXPath(updatedXpath);
            if (schemaLocationNode != null) {
                payloadSchemaLocation = schemaLocationNode.getTextContent();
                this.setSchemaLocationValue(schemaLocations, xpEnvelope, payloadSchemaLocation);
            }
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private XpEnvelope usePontonXPath(File xmlFile, EnvelopeModel envelopeModel, Map<String, List<String>> schemaLocations) throws FactoryConfigurationError, BackEndMessageException {
        boolean payloadLookup;
        boolean testFlagLookup;
        boolean logInfoLookup;
        boolean schemaSetLookup;
        boolean messageVersionLookup;
        boolean messageTypeLookup;
        boolean messageIdLookup;
        boolean receiverLookup;
        boolean senderLookup;
        XpEnvelope xpEnvelope = new XpEnvelope();
        StAXXPath sender = null;
        StAXXPath receiver = null;
        StAXXPath messageId = null;
        StAXXPath messageType = null;
        StAXXPath messageVersion = null;
        StAXXPath schemaSet = null;
        StAXXPath logInfo = null;
        StAXXPath testFlag = null;
        StAXXPath payload = null;
        boolean bl = senderLookup = envelopeModel.getSenderIdXPath() != null;
        if (senderLookup) {
            sender = new StAXXPath(envelopeModel.getSenderIdXPath());
        }
        boolean bl2 = receiverLookup = envelopeModel.getReceiverIdXPath() != null;
        if (receiverLookup) {
            receiver = new StAXXPath(envelopeModel.getReceiverIdXPath());
        }
        boolean bl3 = messageIdLookup = envelopeModel.getMessageIdXPath() != null;
        if (messageIdLookup) {
            messageId = new StAXXPath(envelopeModel.getMessageIdXPath());
        }
        boolean bl4 = messageTypeLookup = envelopeModel.getMessageTypeXPath() != null;
        if (messageTypeLookup) {
            messageType = new StAXXPath(envelopeModel.getMessageTypeXPath());
        }
        boolean bl5 = messageVersionLookup = envelopeModel.getMessageVersionXPath() != null;
        if (messageVersionLookup) {
            messageVersion = new StAXXPath(envelopeModel.getMessageVersionXPath());
        }
        boolean bl6 = schemaSetLookup = envelopeModel.getSchemaSetXPath() != null;
        if (schemaSetLookup) {
            schemaSet = new StAXXPath(envelopeModel.getSchemaSetXPath());
        }
        boolean bl7 = logInfoLookup = envelopeModel.getLogInfoXPath() != null;
        if (logInfoLookup) {
            logInfo = new StAXXPath(envelopeModel.getLogInfoXPath());
        }
        boolean bl8 = testFlagLookup = envelopeModel.getTestXPath() != null;
        if (testFlagLookup) {
            testFlag = new StAXXPath(envelopeModel.getTestXPath());
        }
        boolean bl9 = payloadLookup = envelopeModel.getPayloadXPath() != null;
        if (payloadLookup) {
            payload = new StAXXPath(envelopeModel.getPayloadXPath());
        }
        XMLStreamReader reader = null;
        UTF8BOMSkippingInputStream in = null;
        try {
            in = new UTF8BOMSkippingInputStream(new BufferedInputStream(Files.newInputStream(xmlFile.toPath(), new OpenOption[0]), 16384));
            XMLInputFactory f = XMLInputFactory.newInstance();
            f.setProperty("javax.xml.stream.supportDTD", Boolean.FALSE);
            f.setProperty("javax.xml.stream.isValidating", Boolean.FALSE);
            reader = f.createXMLStreamReader(in);
            ArrayList<Object> xpath = new ArrayList<Object>();
            Object currentXPath = EMPTY;
            int xpathLevel = 0;
            xpath.add(0, currentXPath);
            while (reader.hasNext() && payloadLookup) {
                switch (reader.getEventType()) {
                    case 1: {
                        currentXPath = (String)xpath.get(xpathLevel) + "/" + reader.getName().getLocalPart();
                        xpath.add(++xpathLevel, currentXPath);
                        if (senderLookup) {
                            sender.handleStartElement(reader, xpathLevel, (String)currentXPath);
                        }
                        if (receiverLookup) {
                            receiver.handleStartElement(reader, xpathLevel, (String)currentXPath);
                        }
                        if (messageIdLookup) {
                            messageId.handleStartElement(reader, xpathLevel, (String)currentXPath);
                        }
                        if (messageTypeLookup) {
                            messageType.handleStartElement(reader, xpathLevel, (String)currentXPath);
                        }
                        if (messageVersionLookup) {
                            messageVersion.handleStartElement(reader, xpathLevel, (String)currentXPath);
                        }
                        if (schemaSetLookup) {
                            schemaSet.handleStartElement(reader, xpathLevel, (String)currentXPath);
                        }
                        if (logInfoLookup) {
                            logInfo.handleStartElement(reader, xpathLevel, (String)currentXPath);
                        }
                        if (testFlagLookup) {
                            testFlag.handleStartElement(reader, xpathLevel, (String)currentXPath);
                        }
                        if (!payloadLookup) break;
                        payload.handleStartElement(reader, xpathLevel, (String)currentXPath);
                        break;
                    }
                    case 2: {
                        if (senderLookup) {
                            sender.handleEndElement(xpathLevel);
                        }
                        if (receiverLookup) {
                            receiver.handleEndElement(xpathLevel);
                        }
                        if (messageIdLookup) {
                            messageId.handleEndElement(xpathLevel);
                        }
                        if (messageTypeLookup) {
                            messageType.handleEndElement(xpathLevel);
                        }
                        if (messageVersionLookup) {
                            messageVersion.handleEndElement(xpathLevel);
                        }
                        if (schemaSetLookup) {
                            schemaSet.handleEndElement(xpathLevel);
                        }
                        if (logInfoLookup) {
                            logInfo.handleEndElement(xpathLevel);
                        }
                        if (testFlagLookup) {
                            testFlag.handleEndElement(xpathLevel);
                        }
                        if (payloadLookup) {
                            payload.handleEndElement(xpathLevel);
                        }
                        --xpathLevel;
                        break;
                    }
                    case 6: {
                        break;
                    }
                    case 4: {
                        if (senderLookup) {
                            sender.handleText(reader);
                        }
                        if (receiverLookup) {
                            receiver.handleText(reader);
                        }
                        if (messageIdLookup) {
                            messageId.handleText(reader);
                        }
                        if (messageTypeLookup) {
                            messageType.handleText(reader);
                        }
                        if (messageVersionLookup) {
                            messageVersion.handleText(reader);
                        }
                        if (schemaSetLookup) {
                            schemaSet.handleText(reader);
                        }
                        if (logInfoLookup) {
                            logInfo.handleText(reader);
                        }
                        if (testFlagLookup) {
                            testFlag.handleText(reader);
                        }
                        if (!payloadLookup) break;
                        payload.handleText(reader);
                        break;
                    }
                }
                reader.next();
                if (senderLookup && sender.isFound()) {
                    senderLookup = false;
                }
                if (receiverLookup && receiver.isFound()) {
                    receiverLookup = false;
                }
                if (messageIdLookup && messageId.isFound()) {
                    messageIdLookup = false;
                }
                if (messageTypeLookup && messageType.isFound()) {
                    messageTypeLookup = false;
                }
                if (messageVersionLookup && messageVersion.isFound()) {
                    messageVersionLookup = false;
                }
                if (schemaSetLookup && schemaSet.isFound()) {
                    schemaSetLookup = false;
                }
                if (logInfoLookup && logInfo.isFound()) {
                    logInfoLookup = false;
                }
                if (testFlagLookup && testFlag.isFound()) {
                    testFlagLookup = false;
                }
                if (payloadLookup && payload.isFound()) {
                    payloadLookup = false;
                }
                if (payloadLookup) continue;
            }
            this.closeQuietly(reader);
            this.closeQuietly(in);
        }
        catch (XMLStreamException xse) {
            try {
                throw new BackEndMessageException("Unable to parse the payload.", (Throwable)xse);
                catch (FileNotFoundException fnfe) {
                    throw new BackEndMessageException("Cannot find the payload xml.", (Throwable)fnfe);
                }
                catch (IOException ioe) {
                    throw new BackEndMessageException("Unable to parse the payload.", (Throwable)ioe);
                }
            }
            catch (Throwable throwable) {
                this.closeQuietly(reader);
                this.closeQuietly(in);
                throw throwable;
            }
        }
        xpEnvelope.setName(envelopeModel.getEnvelopeName());
        if (sender != null && sender.isFound()) {
            xpEnvelope.setSenderId(sender.getValue());
        }
        if (receiver != null && receiver.isFound()) {
            xpEnvelope.setReceiverId(receiver.getValue());
        }
        if (messageId != null && messageId.isFound()) {
            xpEnvelope.setMessageId(messageId.getValue());
        }
        if (messageType != null && messageType.isFound()) {
            xpEnvelope.setMessageType(messageType.getValue());
        }
        if (messageVersion != null && messageVersion.isFound()) {
            xpEnvelope.setMessageVersion(messageVersion.getValue());
        }
        if (schemaSet != null && schemaSet.isFound()) {
            xpEnvelope.setPayloadSchemaSet(schemaSet.getValue());
        }
        if (logInfo != null && logInfo.isFound()) {
            xpEnvelope.setLogInfo(logInfo.getValue());
        }
        if (testFlag != null && testFlag.isFound()) {
            xpEnvelope.setTestFlag(testFlag.getValue());
        }
        if (payload != null && payload.isFound()) {
            String payloadXpath = payload.getXPath();
            int index = payloadXpath.lastIndexOf(47);
            if (index > -1) {
                payloadXpath = payloadXpath.substring(0, index);
            }
            xpEnvelope.setPayloadXPath(payloadXpath);
            String namespace = payload.getQName().getNamespaceURI();
            if (namespace != null && !namespace.equals(EMPTY)) {
                xpEnvelope.setPayloadNamespace(namespace);
            }
            xpEnvelope.setPayloadElement(payload.getElementName());
            String payloadSchemaLocation = payload.getSchemaLocation();
            this.setSchemaLocationValue(schemaLocations, xpEnvelope, payloadSchemaLocation);
        }
        return xpEnvelope;
    }

    private void setSchemaLocationValue(Map<String, List<String>> schemaLocations, XpEnvelope xpEnvelope, String payloadSchemaLocation) {
        if (xpEnvelope.getPayloadNamespace() != null) {
            if (payloadSchemaLocation == null) {
                List<String> locs = schemaLocations.get(xpEnvelope.getPayloadNamespace());
                if (locs != null && locs.size() > 0) {
                    xpEnvelope.setPayloadSchemaLocation(locs.get(0));
                }
            } else {
                StringTokenizer st = new StringTokenizer(payloadSchemaLocation);
                if (st.countTokens() % 2 == 0) {
                    while (st.hasMoreTokens()) {
                        String tempNS = st.nextToken();
                        String tempSL = st.nextToken();
                        if (!xpEnvelope.getPayloadNamespace().equals(tempNS)) continue;
                        xpEnvelope.setPayloadSchemaLocation(tempSL);
                        break;
                    }
                } else {
                    xpEnvelope.setPayloadSchemaLocation(payloadSchemaLocation);
                }
            }
        }
    }

    private void closeQuietly(XMLStreamReader reader) {
        if (reader != null) {
            try {
                reader.close();
            }
            catch (XMLStreamException xMLStreamException) {
                // empty catch block
            }
        }
    }

    private void closeQuietly(Closeable reader) {
        if (reader != null) {
            try {
                reader.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

