/*
 * Decompiled with CFR 0.152.
 */
package de.pontonconsulting.xmlpipe.message;

import de.pontonconsulting.common.xml.DtdFilterStream;
import de.pontonconsulting.xmlpipe.config.ConfigResourceService;
import de.pontonconsulting.xmlpipe.message.XslResolver;
import de.schlichtherle.truezip.file.TFileInputStream;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import javax.xml.transform.Templates;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;

public class ZipXslTransformer {
    private final ConfigResourceService _configResourceService;
    private boolean _cachingEnabled;
    private final HashMap<String, Templates> _cachedTemplates = new HashMap();

    public ZipXslTransformer(ConfigResourceService configResourceService) {
        this(configResourceService, false);
    }

    public ZipXslTransformer(ConfigResourceService configResourceService, boolean enableCaching) {
        this._cachingEnabled = enableCaching;
        this._configResourceService = configResourceService;
    }

    public boolean isCachingEnabled() {
        return this._cachingEnabled;
    }

    public void setCachingEnabled(boolean cachingEnabled) {
        this._cachingEnabled = cachingEnabled;
    }

    public void transform(File xml, File xsl, OutputStream out) throws IOException {
        this.transform((InputStream)new TFileInputStream(xml), xsl, new PrintStream(out, true, StandardCharsets.UTF_8), xml.getName());
    }

    public void transform(InputStream inputStream, String fileName, File xsl, OutputStream out) throws IOException {
        this.transform(inputStream, xsl, new PrintStream(out, true, StandardCharsets.UTF_8), fileName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearCache() {
        HashMap<String, Templates> hashMap = this._cachedTemplates;
        synchronized (hashMap) {
            this._cachedTemplates.clear();
        }
    }

    private Templates createTemplates(File xsl) throws TransformerConfigurationException, IOException {
        TransformerFactory tFactory = TransformerFactory.newDefaultInstance();
        XslResolver resolver = new XslResolver(this._configResourceService, xsl.getParent());
        tFactory.setURIResolver(resolver);
        try {
            return tFactory.newTemplates(new StreamSource(this._configResourceService.getResource(xsl.getPath()).getValue()));
        }
        catch (IOException e) {
            return tFactory.newTemplates(new StreamSource(this._configResourceService.getResource("XSL/genericHtmlOutput.xsl").getValue()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void transform(InputStream in, File xsl, PrintStream out, String fileName) throws IOException {
        Templates template = null;
        Transformer transformer = null;
        if (this._cachingEnabled) {
            HashMap<String, Templates> hashMap = this._cachedTemplates;
            synchronized (hashMap) {
                template = this._cachedTemplates.get(xsl.getPath());
                if (template == null) {
                    try {
                        template = this.createTemplates(xsl);
                        this._cachedTemplates.put(xsl.getPath(), template);
                    }
                    catch (TransformerConfigurationException tce) {
                        out.println("Cannot parse xsl: " + String.valueOf(xsl));
                        out.println(tce.getMessage());
                        out.flush();
                        return;
                    }
                }
            }
        }
        try {
            template = this.createTemplates(xsl);
        }
        catch (TransformerConfigurationException tce) {
            out.println("Cannot parse xsl: " + String.valueOf(xsl));
            out.println(tce.getMessage());
            out.flush();
            return;
        }
        if (template == null) {
            out.println("Cannot parse xsl: " + String.valueOf(xsl));
            out.flush();
            return;
        }
        try {
            transformer = template.newTransformer();
        }
        catch (TransformerConfigurationException e) {
            out.println("Cannot get transformer");
            out.println(e.getMessage());
            out.flush();
            return;
        }
        try (BufferedInputStream xmlFileStream = new BufferedInputStream(in);
             DtdFilterStream xmlStream = new DtdFilterStream(xmlFileStream);){
            StreamSource xmlSource = new StreamSource(xmlStream);
            transformer.transform(xmlSource, new StreamResult(out));
        }
        catch (TransformerException te) {
            out.println("Cannot transform ");
            out.println("XSL File: " + String.valueOf(xsl));
            out.println(", XML File: " + fileName);
            out.println(te.getMessage());
        }
        finally {
            out.flush();
        }
    }
}

