/*
 * Decompiled with CFR 0.152.
 */
package de.pontonconsulting.xmlpipe.message;

import de.pontonconsulting.common.io.UTF8BOMSkippingInputStream;
import de.pontonconsulting.xmlpipe.message.EdiMessage;
import de.pontonconsulting.xmlpipe.message.X12MessageException;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;

public class X12Message
implements EdiMessage {
    private static final String SEGMENT_ISA = "ISA";
    private static final String SEGMENT_GS = "GS";
    private static final String SEGMENT_ST = "ST";
    private final File _x12File;
    private char _elementSeparator = (char)43;
    private char _subelementSeparator = (char)58;
    private char _segmentSeparator = (char)39;
    private boolean _isSegmentSeparatorInit = false;
    private String _senderId;
    private String _receiverId;
    private String _controlNumber;
    private String _messageType;
    private String _messageVersion;

    public X12Message(File x12File) throws IOException, X12MessageException {
        this._x12File = x12File;
        this.parse();
    }

    private void parse() throws IOException, X12MessageException {
        block10: {
            BufferedReader in = null;
            try {
                in = new BufferedReader(new InputStreamReader(new UTF8BOMSkippingInputStream(Files.newInputStream(this._x12File.toPath(), new OpenOption[0]))));
                String segmentIdentifier = this.getSegmentIdentifier(in, 3);
                if (!SEGMENT_ISA.equals(segmentIdentifier)) {
                    throw new X12MessageException(51001, "ISA segment not found.");
                }
                this.parseISA(in);
                segmentIdentifier = this.getSegmentIdentifier(in, 2);
                if (!SEGMENT_GS.equals(segmentIdentifier)) {
                    throw new X12MessageException(51002, "GS segment not found.");
                }
                this.parseGS(in);
                segmentIdentifier = this.getSegmentIdentifier(in, 2);
                if (SEGMENT_ST.equals(segmentIdentifier)) {
                    this.parseST(in);
                    break block10;
                }
                throw new X12MessageException(51003, "ST segment not found.");
            }
            finally {
                try {
                    in.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    private void parseISA(BufferedReader in) throws IOException, X12MessageException {
        this._elementSeparator = (char)in.read();
        for (int i = 0; i < 5; ++i) {
            this.skipElement(in);
        }
        String[] data = this.getNextElement(in);
        if (data.length < 1) {
            throw new X12MessageException(51004, "SenderId is missing.");
        }
        this._senderId = data[0];
        this.skipElement(in);
        data = this.getNextElement(in);
        if (data.length < 1) {
            throw new X12MessageException(51005, "ReceiverId is missing.");
        }
        this._receiverId = data[0];
        for (int i = 0; i < 3; ++i) {
            this.skipElement(in);
        }
        data = this.getNextElement(in);
        if (data.length >= 1) {
            this._messageVersion = data[0];
            try {
                this._messageVersion = "" + Integer.parseInt(this._messageVersion);
            }
            catch (Exception i) {}
        } else {
            throw new X12MessageException(51006, "MessageVersion is missing.");
        }
        data = this.getNextElement(in);
        if (data.length < 1) {
            throw new X12MessageException(51007, "MessageControlNumber is missing.");
        }
        this._controlNumber = data[0];
        for (int i = 0; i < 2; ++i) {
            this.skipElement(in);
        }
        this._subelementSeparator = (char)in.read();
        this._segmentSeparator = (char)in.read();
        this._isSegmentSeparatorInit = true;
    }

    private void parseGS(BufferedReader in) throws IOException {
        this.skipSegment(in);
    }

    private void parseST(BufferedReader in) throws IOException, X12MessageException {
        in.read();
        String[] data = this.getNextElement(in);
        if (data.length < 1) {
            throw new X12MessageException(51008, "MessageType is missing.");
        }
        this._messageType = data[0];
    }

    private String[] getNextElement(BufferedReader in) throws IOException {
        ArrayList<String> elements = new ArrayList<String>();
        StringBuilder element = new StringBuilder();
        while (true) {
            char current;
            if ((current = this.getNextChar(in, false)) == this._elementSeparator) {
                elements.add(element.toString().trim());
                element.setLength(0);
                break;
            }
            if (this._isSegmentSeparatorInit && current == this._subelementSeparator) {
                elements.add(element.toString().trim());
                element.setLength(0);
                continue;
            }
            if (this._isSegmentSeparatorInit && current == this._segmentSeparator) {
                elements.add(element.toString().trim());
                element.setLength(0);
                break;
            }
            element.append(current);
        }
        return elements.toArray(new String[0]);
    }

    private String getSegmentIdentifier(BufferedReader in, int length) throws IOException {
        StringBuilder segmentIdentifier = new StringBuilder();
        while (segmentIdentifier.length() < length) {
            segmentIdentifier.append(this.getNextChar(in, true));
        }
        return segmentIdentifier.toString();
    }

    private void skipSegment(BufferedReader in) throws IOException {
        char current;
        if (!this._isSegmentSeparatorInit) {
            return;
        }
        while ((current = this.getNextChar(in, false)) != this._segmentSeparator) {
        }
    }

    private void skipElement(BufferedReader in) throws IOException {
        char current;
        while (!((current = this.getNextChar(in, false)) == this._elementSeparator || this._isSegmentSeparatorInit && current == this._segmentSeparator)) {
        }
    }

    private char getNextChar(BufferedReader in, boolean skipWhiteSpace) throws IOException {
        char current = (char)in.read();
        if (skipWhiteSpace && (current == ' ' || current == '\r' || current == '\n' || current == '\t')) {
            current = this.getNextChar(in, skipWhiteSpace);
        }
        return current;
    }

    @Override
    public String getSenderId() {
        return this._senderId;
    }

    @Override
    public String getReceiverId() {
        return this._receiverId;
    }

    @Override
    public String getMessageId() {
        return this._controlNumber + "-" + this._messageType + "@" + this._senderId;
    }

    @Override
    public String getMessageType() {
        return this._messageType;
    }

    @Override
    public String getMessageVersion() {
        return this._messageVersion;
    }
}

