/*
 * Decompiled with CFR 0.152.
 */
package de.pontonconsulting.xmlpipe.message;

import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;

public class StAXWriteXPath {
    private String _elementNeeded;
    private String _attributeNeeded;
    private final String _xpath;
    private final String _newValue;
    private boolean _found;

    public StAXWriteXPath(String xpath, String newValue) {
        this._xpath = xpath;
        this._newValue = newValue;
        int offset = xpath.indexOf(64);
        if (offset == -1) {
            this._elementNeeded = xpath;
        } else {
            this._elementNeeded = xpath.substring(0, offset - 1);
            this._attributeNeeded = xpath.substring(offset + 1);
        }
    }

    public boolean handleStartElement(XMLStreamReader reader, XMLStreamWriter writer, int xpathLevel, String currentXpath) throws XMLStreamException {
        boolean result = false;
        if (!this._found && this._elementNeeded.equals(currentXpath) && this._attributeNeeded == null) {
            if (this._newValue != null) {
                writer.writeCharacters(this._newValue);
            }
            this._found = true;
            result = true;
        }
        return result;
    }

    public boolean handleAttributes(XMLStreamReader reader, XMLStreamWriter writer, int xpathLevel, String currentXpath, int attributeId) throws XMLStreamException {
        boolean result = false;
        if (!this._found && this._elementNeeded.equals(currentXpath) && this._attributeNeeded != null && this._attributeNeeded.equals(reader.getAttributeName(attributeId).getLocalPart())) {
            writer.writeAttribute(reader.getAttributePrefix(attributeId), reader.getAttributeNamespace(attributeId), reader.getAttributeLocalName(attributeId), this._newValue);
            this._found = true;
            result = true;
        }
        return result;
    }

    public String getXPath() {
        return this._xpath;
    }

    public boolean isFound() {
        return this._found;
    }

    public void reset() {
        this._found = false;
    }

    public boolean handleNamespaceAttributes(XMLStreamReader reader, XMLStreamWriter writer, int xpathLevel, String currentXpath, int attributeId) throws XMLStreamException {
        boolean result = false;
        if (!this._found && this._elementNeeded.equals(currentXpath) && this._attributeNeeded != null && this._attributeNeeded.equals(reader.getAttributeName(attributeId).getLocalPart())) {
            writer.writeAttribute(reader.getAttributePrefix(attributeId), reader.getAttributeNamespace(attributeId), reader.getAttributeLocalName(attributeId), this._newValue);
            this._found = true;
            result = true;
        }
        return result;
    }
}

