/*
 * Decompiled with CFR 0.152.
 */
package de.pontonconsulting.xmlpipe.message;

import de.pontonconsulting.xmlpipe.config.MultipleSchemaSetFoundException;
import de.pontonconsulting.xmlpipe.config.SchemaData;
import de.pontonconsulting.xmlpipe.config.SchemataConfig;
import de.pontonconsulting.xmlpipe.message.EdiMessage;
import de.pontonconsulting.xmlpipe.message.EdifactMessage;
import de.pontonconsulting.xmlpipe.message.EdifactMessageException;
import de.pontonconsulting.xmlpipe.message.MessageException;
import de.pontonconsulting.xmlpipe.message.StAXXPath;
import de.pontonconsulting.xmlpipe.message.X12Message;
import de.pontonconsulting.xmlpipe.message.X12MessageException;
import de.pontonconsulting.xmlpipe.message.XmlExtractor;
import de.pontonconsulting.xmlpipe.message.XmlParser;
import de.pontonconsulting.xmlpipe.message.XpEnvelope;
import de.pontonconsulting.xmlpipe.message.XpMessage;
import de.pontonconsulting.xmlpipe.message.identification.IEnvelopeRecognizer;
import de.pontonconsulting.xmlpipe.messenger.filter.MessageRecognitionException;
import de.pontonconsulting.xmlpipe.messenger.util.XmlUtil;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class PayloadDataExtractor {
    private static final Logger LOG = LogManager.getLogger((String)"Messenger.PayloadDataExtractor");
    private final IEnvelopeRecognizer envelopeRecognizer;
    private final XmlExtractor xmlExtractor;
    private final SchemataConfig schemataConfig;

    public PayloadDataExtractor(IEnvelopeRecognizer envelopeRecognizer, XmlExtractor xmlExtractor, SchemataConfig schemataConfig) {
        this.envelopeRecognizer = envelopeRecognizer;
        this.xmlExtractor = xmlExtractor;
        this.schemataConfig = schemataConfig;
    }

    private List<SchemaData> recognizeMessageTypeByMarker(XpMessage xpMessage, List<SchemaData> schemaDataList) {
        ArrayList<SchemaData> messageTypes = new ArrayList<SchemaData>();
        try {
            for (SchemaData schemaData : schemaDataList) {
                if (schemaData.getMessageTypeMarkerXPath() == null || schemaData.getMessageTypeMarkerValue() == null) continue;
                try {
                    InputStream inputStream = Files.newInputStream(xpMessage.getCurrentContentReference().toPath(), new OpenOption[0]);
                    try {
                        StAXXPath xpath = new StAXXPath(xpMessage.getPayloadXPath() + schemaData.getMessageTypeMarkerXPath());
                        Map<StAXXPath, String> xpathLookup = new XmlParser().parse(inputStream, List.of(xpath));
                        String foundValue = xpathLookup.get(xpath);
                        if (!schemaData.getMessageTypeMarkerValue().equals(foundValue)) continue;
                        messageTypes.add(schemaData);
                        LOG.info("Recognized message type '{}' by defined message type marker '{}'.", (Object)schemaData, (Object)foundValue);
                    }
                    finally {
                        if (inputStream == null) continue;
                        inputStream.close();
                    }
                }
                catch (XmlParser.XmlParserException e) {
                    LOG.warn("Error occurs while message type recognizing by marker: {}", (Object)e.getMessage());
                }
            }
        }
        catch (Exception e) {
            LOG.error("Could not read payload.", (Throwable)e);
        }
        return messageTypes;
    }

    public void extractData(XpMessage xpMessage) throws MessageRecognitionException {
        File payload = xpMessage.getCurrentContentReference();
        try {
            SchemaData schema = this.findSchemaForcedByAdapter(xpMessage);
            boolean ambiguous = false;
            boolean isXml = XmlUtil.isXml(payload.getPath());
            if (isXml) {
                XpEnvelope xpEnvelope = this.processEnvelope(xpMessage);
                if (schema == null && (schema = this.findSchemaAfterXpEnvelopeRecognizing(xpMessage)) == null) {
                    try {
                        schema = this.findSchemaByMetaData(xpEnvelope);
                        LOG.debug("message type detected by xml meta data {} msg-id:'{}'", (Object)schema, (Object)xpMessage.getMessageId());
                    }
                    catch (MultipleSchemaSetFoundException multipleSchemaSetFoundException) {
                        List<SchemaData> messageTypes = this.recognizeMessageTypeByMarker(xpMessage, multipleSchemaSetFoundException.getSchemas());
                        switch (messageTypes.size()) {
                            case 0: {
                                ambiguous = true;
                                schema = multipleSchemaSetFoundException.getSchemas().getFirst();
                                LOG.warn("search by xml meta data returned multiple results. temporarily using: {}  msg-id:'{}'", (Object)schema, (Object)xpMessage.getMessageId());
                                break;
                            }
                            case 1: {
                                schema = messageTypes.getFirst();
                                LOG.info("message type detected by xml meta data {} msg-id:'{}'", (Object)schema, (Object)xpMessage.getMessageId());
                                break;
                            }
                            default: {
                                ambiguous = true;
                                schema = messageTypes.getFirst();
                                LOG.warn("search by xml meta data returned multiple results. temporarily using: {}  msg-id:'{}'", (Object)schema, (Object)xpMessage.getMessageId());
                            }
                        }
                    }
                }
                if (schema != null && schema.getEnvelopeMapping() != null) {
                    this.xmlExtractor.readMissingDataFromPayload(payload, schema, xpMessage);
                }
            }
            if (schema == null && !isXml) {
                try {
                    EdifactMessage ediMsg = new EdifactMessage(payload);
                    this.readMissingDataFromEdiMessage(ediMsg, xpMessage);
                    schema = this.schemataConfig.getSchemaByTypeVersion(ediMsg.getMessageType(), ediMsg.getMessageVersion());
                    LOG.debug("message type detected as EdiFact {} msg-id:'{}'", (Object)schema, (Object)xpMessage.getMessageId());
                }
                catch (EdifactMessageException | IOException ediMsg) {
                }
                catch (MultipleSchemaSetFoundException e) {
                    LOG.debug("message type detected as EdiFact with multiple matches for type: {}/{} msg-id:'{}'", (Object)xpMessage.getMessageType(), (Object)xpMessage.getMessageVersion(), (Object)xpMessage.getMessageId());
                    ambiguous = true;
                    schema = e.getSchemas().getFirst();
                }
            }
            if (schema == null && !isXml) {
                try {
                    X12Message x12Msg = new X12Message(payload);
                    this.readMissingDataFromEdiMessage(x12Msg, xpMessage);
                    schema = this.schemataConfig.getSchemaByTypeVersion(x12Msg.getMessageType(), x12Msg.getMessageVersion());
                    LOG.debug("message type detected as X12 {} msg-id:'{}'", (Object)schema, (Object)xpMessage.getMessageId());
                }
                catch (X12MessageException | IOException x12Msg) {
                }
                catch (MultipleSchemaSetFoundException e) {
                    LOG.debug("message type detected as X12 with multiple matches for type: {}/{} msg-id:'{}'", (Object)xpMessage.getMessageType(), (Object)xpMessage.getMessageVersion(), (Object)xpMessage.getMessageId());
                    ambiguous = true;
                    schema = e.getSchemas().getFirst();
                }
            }
            if (schema != null && !ambiguous) {
                xpMessage.setMessageType(schema.getMessageType());
                xpMessage.setMessageVersion(schema.getMessageVersion());
                xpMessage.setSchemaSet(schema.getSchemaSetName());
                xpMessage.setSchemaLocation(schema.getName());
                xpMessage.setSchemaNamespace(schema.getNamespace());
                xpMessage.setProcessingDirective("MessageType", xpMessage.getMessageType());
                xpMessage.setProcessingDirective("DtdVersion", xpMessage.getMessageVersion());
                xpMessage.setProcessingDirective("DtdSet", xpMessage.getSchemaSet());
            }
        }
        catch (MessageException messageException) {
            // empty catch block
        }
    }

    private void readMissingDataFromEdiMessage(EdiMessage ediMessage, XpMessage xpMessage) {
        if (xpMessage.getReceiverInternalId() == null) {
            xpMessage.setReceiverInternalId(ediMessage.getReceiverId());
        }
        if (xpMessage.getSenderInternalId() == null) {
            xpMessage.setSenderInternalId(ediMessage.getSenderId());
        }
        if (xpMessage.getMessageId() == null) {
            xpMessage.setMessageId(ediMessage.getMessageId());
        }
    }

    private SchemaData findSchemaForcedByAdapter(XpMessage xpMessage) throws MessageRecognitionException {
        SchemaData schema = null;
        if (this.hasContent(xpMessage.getMessageType()) && this.hasContent(xpMessage.getMessageVersion()) && this.hasContent(xpMessage.getSchemaSet())) {
            schema = this.schemataConfig.getSchemaBySetTypeVersion(xpMessage.getSchemaSet(), xpMessage.getMessageType(), xpMessage.getMessageVersion());
            if (schema == null) {
                String logtext = String.format("adapter forced unknown schema for msg-id:%s  (type:%s version:%s set:%s)", xpMessage.getMessageId(), xpMessage.getMessageType(), xpMessage.getMessageVersion(), xpMessage.getSchemaSet());
                LOG.error(logtext);
                throw new MessageRecognitionException(-1, logtext);
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("schema forced by adapter is: {} msg-id:'{}'", (Object)schema, (Object)xpMessage.getMessageId());
            }
        }
        return schema;
    }

    private SchemaData findSchemaByMetaData(XpEnvelope xpEnvelope) throws MultipleSchemaSetFoundException {
        return this.schemataConfig.fetchSchemaDataFromMetaData(xpEnvelope.getPayloadNamespace(), xpEnvelope.getPayloadSchemaLocation(), xpEnvelope.getPayloadSystemId(), xpEnvelope.getPayloadElement());
    }

    private XpEnvelope processEnvelope(XpMessage xpMessage) throws MessageException {
        XpEnvelope xpEnvelope = this.envelopeRecognizer.recognizeEnvelope(xpMessage.getCurrentContentReference());
        xpMessage.setXpEnvelopeNamespaceUri(xpEnvelope.getNamespace());
        xpMessage.setXpEnvelopeSchemaFile(xpEnvelope.getSchemaFile());
        xpMessage.setXpEnvelopeName(xpEnvelope.getName());
        if (xpEnvelope.getPayloadXPath() != null) {
            xpMessage.setPayloadXPath(xpEnvelope.getPayloadXPath());
        }
        xpMessage.setPayloadRootElement(xpEnvelope.getPayloadElement());
        xpMessage.setPayloadNamespaceUri(xpEnvelope.getPayloadNamespace());
        if (!this.hasContent(xpMessage.getMessageId()) && xpEnvelope.getMessageId() != null) {
            xpMessage.setMessageId(xpEnvelope.getMessageId());
        }
        if (!this.hasContent(xpMessage.getMessageType()) && xpEnvelope.getMessageType() != null) {
            xpMessage.setMessageType(xpEnvelope.getMessageType());
        }
        if (!this.hasContent(xpMessage.getMessageVersion()) && xpEnvelope.getMessageVersion() != null) {
            xpMessage.setMessageVersion(xpEnvelope.getMessageVersion());
        }
        if (!this.hasContent(xpMessage.getSchemaSet()) && xpEnvelope.getPayloadSchemaSet() != null) {
            xpMessage.setSchemaSet(xpEnvelope.getPayloadSchemaSet());
        }
        if (!this.hasContent(xpMessage.getSenderInternalId()) && xpEnvelope.getSenderId() != null) {
            xpMessage.setSenderInternalId(xpEnvelope.getSenderId());
        }
        if (!this.hasContent(xpMessage.getReceiverInternalId()) && xpEnvelope.getReceiverId() != null) {
            xpMessage.setReceiverInternalId(xpEnvelope.getReceiverId());
        }
        if (!this.hasContent(xpMessage.getProcessingDirective("LogInfo")) && xpEnvelope.getLogInfo() != null) {
            xpMessage.setProcessingDirective("LogInfo", xpEnvelope.getLogInfo());
        }
        if (xpMessage.getProcessingDirective("TestFlag") == null && xpEnvelope.getTestFlag() != null) {
            xpMessage.setTestMessage(xpEnvelope.getTestFlag().equals(xpEnvelope.getTestTrueValue()));
            xpMessage.setProcessingDirective("TestFlag", String.valueOf(xpMessage.isTestMessage()));
        }
        return xpEnvelope;
    }

    private SchemaData findSchemaAfterXpEnvelopeRecognizing(XpMessage xpMessage) throws MessageRecognitionException {
        SchemaData schema = null;
        if (this.hasContent(xpMessage.getMessageType()) && this.hasContent(xpMessage.getMessageVersion())) {
            if (this.hasContent(xpMessage.getSchemaSet())) {
                schema = this.schemataConfig.getSchemaBySetTypeVersion(xpMessage.getSchemaSet(), xpMessage.getMessageType(), xpMessage.getMessageVersion());
                if (schema == null) {
                    String logtext = String.format("payload envelope includes unknown schema for msg-id:%s  (type:%s version:%s set:%s)", xpMessage.getMessageId(), xpMessage.getMessageType(), xpMessage.getMessageVersion(), xpMessage.getSchemaSet());
                    LOG.error(logtext);
                    throw new MessageRecognitionException(-1, logtext);
                }
            } else if (!this.schemataConfig.isTypeVersionAmbiguous(xpMessage.getMessageType(), xpMessage.getMessageVersion())) {
                try {
                    schema = this.schemataConfig.getSchemaByTypeVersion(xpMessage.getMessageType(), xpMessage.getMessageVersion());
                }
                catch (MultipleSchemaSetFoundException e) {
                    LOG.warn("multiple schema sets found for type '" + xpMessage.getMessageType() + "' and version '" + xpMessage.getMessageVersion() + "'");
                }
            }
        }
        return schema;
    }

    private boolean hasContent(String text) {
        return text != null && text.trim().length() > 0;
    }
}

