/*
 * Decompiled with CFR 0.152.
 */
package de.pontonconsulting.xmlpipe.message;

import de.pontonconsulting.xmlpipe.Constants;
import de.pontonconsulting.xmlpipe.config.privatepartneragreement.LineEndingType;
import de.pontonconsulting.xmlpipe.config.privatepartneragreement.XmlEncodingType;
import de.pontonconsulting.xmlpipe.cpp.CppPartner;
import de.pontonconsulting.xmlpipe.cpp.ProfileException;
import de.pontonconsulting.xmlpipe.cpp.Profiles;
import de.pontonconsulting.xmlpipe.message.BackEndMessage;
import de.pontonconsulting.xmlpipe.message.BackEndMessageException;
import de.pontonconsulting.xmlpipe.message.XpMessage;
import de.pontonconsulting.xmlpipe.message.XpMessageAttachment;
import de.pontonconsulting.xmlpipe.messenger.database.hibernate.XpInboundMessage;
import java.io.File;
import java.io.FileNotFoundException;
import java.text.SimpleDateFormat;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class BackEndMessageConverter {
    private static final Logger _log = LogManager.getLogger((String)"Messenger.BackEndMessageConverter");
    private final SimpleDateFormat _dateFormatter;
    private final Profiles _profiles;

    public BackEndMessageConverter(Profiles profiles) {
        if (_log.isDebugEnabled()) {
            _log.debug("Initializing BackEndMessageConverter");
        }
        this._profiles = profiles;
        this._dateFormatter = new SimpleDateFormat("yyyy-MM-dd' 'HH:mm:ssz");
    }

    public XpMessage getXpMessage(BackEndMessage beMessage) {
        String[] list;
        XpMessage xpMessage = new XpMessage();
        xpMessage.setSenderInternalId(beMessage.getSenderOrganisationText());
        xpMessage.setReceiverInternalId(beMessage.getReceiverOrganisationText());
        xpMessage.setMessageType(beMessage.getMessageName());
        xpMessage.setMessageVersion(beMessage.getDTDVersionNumberText());
        xpMessage.setSchemaSet(beMessage.getDTDSetText());
        if (this.hasContent(beMessage.getTransferIDText())) {
            xpMessage.setMessageId(beMessage.getTransferIDText());
        }
        if (this.hasContent(beMessage.getConversationIDText())) {
            xpMessage.setConversationId(beMessage.getConversationIDText());
        }
        if (beMessage.getSequenceNumberText() != null) {
            xpMessage.setInternalSequenceNumber(Long.parseLong(beMessage.getSequenceNumberText()));
            xpMessage.setSequenceReset(Boolean.parseBoolean(beMessage.getSequenceResetText()));
        }
        if (beMessage.getTestFlag() != null && !beMessage.getTestFlag().isBlank()) {
            String oldValue = xpMessage.getProcessingDirective("TestFlag");
            xpMessage.setProcessingDirective("TestFlag", String.valueOf(Boolean.parseBoolean(beMessage.getTestFlag())));
            if (oldValue != null) {
                _log.warn("Overwritten value of processing directive 'TestFlag' from '{}' to '{}'", (Object)oldValue, (Object)xpMessage.getProcessingDirective("TestFlag"));
            }
        }
        xpMessage.setTestMessage("Test".equalsIgnoreCase(beMessage.getTestFlag()));
        String transferMode = beMessage.getTransmissionMode();
        if (transferMode != null && transferMode.equals("ExactlyOnce")) {
            xpMessage.setAckRequested(true);
        }
        this.setProcessingDirectives(xpMessage, beMessage);
        for (String attachment : list = beMessage.listAttachments()) {
            xpMessage.addAttachment(new XpMessageAttachment(beMessage.getAttachment(attachment)));
        }
        return xpMessage;
    }

    private void setProcessingDirectives(XpMessage xp, BackEndMessage be) {
        String originalFilename = be.getProcessingDirectiveAsString("OriginalFilename");
        if (originalFilename != null) {
            xp.setProcessingDirective("OriginalFilename", originalFilename);
            xp.setProcessingDirective("ProcessedOriginalFilename", originalFilename);
        }
        if (StringUtils.isNotBlank((CharSequence)be.getConverterProductNameText())) {
            xp.setProcessingDirective("ConverterProductName", be.getConverterProductNameText());
        }
        if (StringUtils.isNotBlank((CharSequence)be.getConverterVendorNameText())) {
            xp.setProcessingDirective("ConverterVendorName", be.getConverterVendorNameText());
        }
        if (StringUtils.isNotBlank((CharSequence)be.getConverterVersionText())) {
            xp.setProcessingDirective("ConverterVersion", be.getConverterVersionText());
        }
        if (StringUtils.isNotBlank((CharSequence)be.getERPProductNameText())) {
            xp.setProcessingDirective("ERPProductName", be.getERPProductNameText());
        }
        if (StringUtils.isNotBlank((CharSequence)be.getERPVendorNameText())) {
            xp.setProcessingDirective("ERPVendorName", be.getERPVendorNameText());
        }
        if (StringUtils.isNotBlank((CharSequence)be.getERPVersionText())) {
            xp.setProcessingDirective("ERPVersion", be.getERPVersionText());
        }
        if (StringUtils.isNotBlank((CharSequence)be.getLogInfoText())) {
            xp.setProcessingDirective("LogInfo", be.getLogInfoText());
        }
        if (StringUtils.isNotBlank((CharSequence)be.getKeyLengthText())) {
            xp.setProcessingDirective("KeyLength", be.getKeyLengthText());
        }
        xp.setProcessingDirective("MessengerProductName", Constants.getXP_NAME());
        xp.setProcessingDirective("MessengerVendorName", Constants.getXP_VENDOR());
        xp.setProcessingDirective("MessengerVersion", Constants.getXP_VERSION());
        xp.setProcessingDirective("TestFlag", String.valueOf(xp.isTestMessage()));
        HashMap bemPd = be.getProcessingDirectivesMap();
        if (bemPd != null && !bemPd.isEmpty()) {
            for (Map.Entry entry : bemPd.entrySet()) {
                if (!StringUtils.isNotBlank((CharSequence)((CharSequence)entry.getValue()))) continue;
                xp.setProcessingDirective((String)entry.getKey(), (String)entry.getValue());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BackEndMessage getBackEndMessage(XpInboundMessage xpQueueMessage) throws BackEndMessageException {
        File payloadFile;
        try {
            payloadFile = xpQueueMessage.getCurrentContentReference();
        }
        catch (NullPointerException e) {
            throw new BackEndMessageException("Payload file not found.", (Throwable)e);
        }
        boolean isXml = false;
        if (payloadFile != null) {
            isXml = payloadFile.getName().toLowerCase().endsWith(".xml");
        }
        if ("BINARY".equals(xpQueueMessage.getSchemaSet()) && "BINARY".equals(xpQueueMessage.getMessageType()) && "1".equals(xpQueueMessage.getMessageVersion())) {
            isXml = false;
        }
        BackEndMessage _beMessage = new BackEndMessage(xpQueueMessage.getCurrentContentReference(), isXml);
        _beMessage.setDatabaseId(String.valueOf(xpQueueMessage.getDatabaseId()));
        _beMessage.setCreationTimestamp(xpQueueMessage.getMessageTimestamp().getTime());
        for (String string : xpQueueMessage.getProcessingDirectives().keySet()) {
            String pdValue = xpQueueMessage.getProcessingDirective(string);
            _beMessage.addProcessingDirective(string, pdValue);
            if (!"LogInfo".equals(string)) continue;
            _beMessage.setLogInfoText(pdValue);
        }
        String originalFilename = xpQueueMessage.getProcessingDirective("OriginalFilename");
        if (originalFilename != null) {
            _beMessage.addProcessingDirective("OriginalFilename", originalFilename);
        } else {
            _beMessage.addProcessingDirective("OriginalFilename", xpQueueMessage.getProcessingDirective("ProcessedOriginalFilename"));
        }
        _beMessage.addProcessingDirective("IsAck", String.valueOf(xpQueueMessage.isAck()));
        _beMessage.setIsAcknowledgement(xpQueueMessage.isAck());
        _beMessage.addProcessingDirective("IsStatusResponse", String.valueOf(xpQueueMessage.isStatusResponse()));
        if (xpQueueMessage.isSignal()) {
            _beMessage.addProcessingDirective("IsErrorNotification", String.valueOf(xpQueueMessage.isErrorNotification()));
        }
        _beMessage.setTransferID(xpQueueMessage.getMessageId());
        _beMessage.setReferenceId(xpQueueMessage.getReferenceId());
        SimpleDateFormat simpleDateFormat = this._dateFormatter;
        synchronized (simpleDateFormat) {
            _beMessage.setTransmissionTimeStamp(this._dateFormatter.format(xpQueueMessage.getMessageTimestamp()));
        }
        _beMessage.setConversationID(xpQueueMessage.getConversationId());
        if (xpQueueMessage.getSequenceNumber() != -1) {
            _beMessage.setSequenceNumber((long)xpQueueMessage.getSequenceNumber());
        }
        _beMessage.setMessageName(xpQueueMessage.getMessageType());
        _beMessage.setDTDSet(xpQueueMessage.getSchemaSet());
        _beMessage.setDTDVersionNumber(xpQueueMessage.getMessageVersion());
        _beMessage.setTransmissionProtocol(xpQueueMessage.getProtocol());
        _beMessage.setCharEncoding(XmlEncodingType.UTF_8.value());
        _beMessage.setLineEnding(LineEndingType.LF.value());
        if (xpQueueMessage.isAckRequested()) {
            _beMessage.setTransmissionMode("ExactlyOnce");
        } else {
            _beMessage.setTransmissionMode("BestEffort");
        }
        if (xpQueueMessage.isTestMessage()) {
            _beMessage.setTestFlag("Test");
        } else {
            _beMessage.setTestFlag("Production");
        }
        try {
            CppPartner cppPartner = this.getSender(xpQueueMessage);
            _beMessage.setSenderOrganisation(cppPartner.getInternalId());
            CppPartner receiver = this.getReceiver(xpQueueMessage);
            _beMessage.setReceiverOrganisation(receiver.getInternalId());
        }
        catch (ProfileException profileException) {
            throw new BackEndMessageException("Cannot obtain mapping to internal id's.", (Throwable)profileException);
        }
        for (de.pontonconsulting.xmlpipe.messenger.database.hibernate.XpMessageAttachment attachement : xpQueueMessage.getAttachments()) {
            try {
                _beMessage.addAttachment(attachement.resolveAttachmentFile(xpQueueMessage.getCurrentContentReferenceFolder()), attachement.getMimeType(), attachement.getDescription(), attachement.getLanguage());
            }
            catch (FileNotFoundException e) {
                throw new BackEndMessageException("Cannot find the attachment.", (Throwable)e);
            }
        }
        return _beMessage;
    }

    private CppPartner getSender(XpInboundMessage xpMessage) throws ProfileException {
        return this.getPartner(xpMessage.getSenderLocalId(), xpMessage.getSenderInternalId());
    }

    private CppPartner getReceiver(XpInboundMessage xpMessage) throws ProfileException {
        return this.getPartner(xpMessage.getReceiverLocalId(), xpMessage.getReceiverInternalId());
    }

    private CppPartner getPartner(String localId, String internalId) throws ProfileException {
        try {
            return this._profiles.getProfileForInternalId(internalId, true);
        }
        catch (ProfileException e) {
            return this._profiles.getProfileForLocalId(localId, true);
        }
    }

    private boolean hasContent(String text) {
        return text != null && text.trim().length() > 0;
    }
}

