/*
 * Decompiled with CFR 0.152.
 */
package de.pontonconsulting.xmlpipe.listener.ebxml2;

import de.pontonconsulting.xmlpipe.cpa.Communication;
import de.pontonconsulting.xmlpipe.cpp.CppPartner;
import de.pontonconsulting.xmlpipe.listener.EbXmlData;
import de.pontonconsulting.xmlpipe.listener.ebxml2.EbXml2Data;
import de.pontonconsulting.xmlpipe.listener.ebxml2.IEbXml2Service;
import de.pontonconsulting.xmlpipe.messenger.IdGenerator;
import de.pontonconsulting.xmlpipe.messenger.ProcessingResult;
import de.pontonconsulting.xmlpipe.messenger.ReceiveFromListener;
import de.pontonconsulting.xmlpipe.messenger.ReferenceDateTask;
import de.pontonconsulting.xmlpipe.messenger.database.tables.MessageDAO;
import de.pontonconsulting.xmlpipe.messenger.database.tables.MessengerLog;
import de.pontonconsulting.xmlpipe.registry.RegistryProfileUpdater;
import de.pontonconsulting.xmlpipe.security.CertificateUtility;
import de.pontonconsulting.xmlpipe.security.util.SignCertInfo;
import de.pontonconsulting.xmlpipe.soap.ebxml.EbXmlException;
import de.pontonconsulting.xmlpipe.soap.ebxml.EbXmlMessage;
import java.security.cert.X509Certificate;
import java.util.List;
import java.util.Set;
import javax.security.auth.x500.X500Principal;
import javax.xml.soap.MessageFactory;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPMessage;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class EbXml2Service
implements IEbXml2Service {
    private static final String EN = "en";
    private static final String TRUE = "true";
    private static final Logger LOG = LogManager.getLogger((String)"Messenger.EbXml2Service");
    protected final ReferenceDateTask _referenceDate;
    protected final ReceiveFromListener _receiveFromListener;
    protected final MessageDAO _messageDAO;
    protected final MessengerLog _messengerLog;
    protected final RegistryProfileUpdater _registryProfileUpdater;
    protected final IdGenerator _idGenerator;
    protected final CertificateUtility _certificateUtility;

    public EbXml2Service(ReferenceDateTask referenceDate, ReceiveFromListener receiveFromListener, MessageDAO messageDAO, MessengerLog messengerLog, RegistryProfileUpdater registryProfileUpdater, IdGenerator idGenerator, CertificateUtility certificateUtility) {
        this._referenceDate = referenceDate;
        this._receiveFromListener = receiveFromListener;
        this._messageDAO = messageDAO;
        this._messengerLog = messengerLog;
        this._registryProfileUpdater = registryProfileUpdater;
        this._idGenerator = idGenerator;
        this._certificateUtility = certificateUtility;
    }

    @Override
    public abstract EbXmlMessage handleMessage(int var1, EbXml2Data var2) throws EbXmlException;

    protected EbXmlMessage buildErrorMessage(ProcessingResult[] result, EbXml2Data data) {
        EbXmlMessage message = data.getInboundMessage();
        EbXmlMessage response = null;
        try {
            SOAPMessage msg = MessageFactory.newInstance().createMessage();
            msg.setProperty("javax.xml.soap.write-xml-declaration", (Object)TRUE);
            msg.setProperty("javax.xml.soap.character-set-encoding", (Object)"UTF-8");
            LOG.debug("creating ebXML ErrorMessage from processing results");
            response = new EbXmlMessage(msg, this._referenceDate);
            response.prepareErrorMessage(message.getMessageId());
            this.mapErrorCodes(result, response);
            this.mirrorMessage(message, response);
            try {
                this.signResponse(data, response);
            }
            catch (Exception e) {
                LOG.debug("ErrorMessage could not be signed. " + e.getMessage());
            }
        }
        catch (SOAPException sOAPException) {
            // empty catch block
        }
        return response;
    }

    private void mapErrorCodes(ProcessingResult[] result, EbXmlMessage response) {
        if (result.length > 0) {
            for (int i = 0; i < result.length; ++i) {
                int code = result[i].getResultCode();
                if (result[i].getResultCode() == 0) continue;
                switch (code) {
                    case 2: 
                    case 4: {
                        response.addError("Error", "SecurityFailure", result[i].getLocation());
                        break;
                    }
                    case 5: 
                    case 6: {
                        response.addError("Error", "Unknown", result[i].getLocation());
                        break;
                    }
                    case 1: {
                        response.addError("Error", "OtherXml", result[i].getLocation());
                        break;
                    }
                    default: {
                        response.addError("Warning", "Unknown", result[i].getLocation());
                    }
                }
                response.setDescriptionToCurrentError(result[i].getDescription(), EN);
            }
        }
    }

    protected EbXmlMessage buildAcknowledgement(ProcessingResult[] result, EbXml2Data data) {
        EbXmlMessage message = data.getInboundMessage();
        EbXmlMessage response = null;
        try {
            SOAPMessage msg = MessageFactory.newInstance().createMessage();
            msg.setProperty("javax.xml.soap.write-xml-declaration", (Object)TRUE);
            msg.setProperty("javax.xml.soap.character-set-encoding", (Object)"UTF-8");
            LOG.debug("creating ebXML-ACK from processing results");
            response = new EbXmlMessage(msg, this._referenceDate);
            List<SOAPElement> references = null;
            if (message.isSignedAckRequested()) {
                try {
                    references = data.getInboundMessage().getSignatureReferences();
                }
                catch (Exception e) {
                    LOG.error("could not fetch Signature References from received message.", e.getCause());
                }
            }
            response.prepareAcknowledgment(message.getMessageId(), this._referenceDate.getReferenceDate(), references);
            this.mapErrorCodes(result, response);
            this.mirrorMessage(message, response);
            if (message.isSignedAckRequested()) {
                LOG.debug("sender requested a signed ACK");
                this.signResponse(data, response);
            }
        }
        catch (SOAPException e) {
            LOG.error("unexpected error", (Throwable)e);
        }
        return response;
    }

    private void mirrorMessage(EbXmlMessage message, EbXmlMessage response) {
        response.setCPAId(message.getCPAId());
        response.setConversationId(message.getConversationId());
        response.setFromIds(message.getToIds());
        response.setToIds(message.getFromIds());
        response.setMessageId(this._idGenerator.generateMessageId());
        response.setMessageTimestamp(this._referenceDate.getReferenceDate());
    }

    private void signResponse(EbXmlData data, EbXmlMessage response) {
        try {
            Communication communication = data.getCommunication(data.getReceiver().getLocalId(), data.getSender().getLocalId());
            SignCertInfo signCertInfo = communication.getPackagingSignKey();
            response.sign(signCertInfo.getPrivateKey(), signCertInfo.getCertificateChain());
            LOG.debug("ACK was signed");
        }
        catch (Exception e) {
            this._messengerLog.log2db(521, data.getXpMessage().getDatabaseId(), e.getMessage());
            LOG.warn("Ack could not be signed: " + String.valueOf(e));
        }
    }

    protected void checkSignature(EbXml2Data data) throws EbXmlException {
        block6: {
            block7: {
                EbXmlMessage _incomingMessage = data.getInboundMessage();
                CppPartner _sender = data.getSender();
                if (!_incomingMessage.isSigned()) break block7;
                try {
                    boolean verify;
                    block9: {
                        block8: {
                            verify = false;
                            X509Certificate foundCertificate = this.checkSenderCertificate(data);
                            if (foundCertificate == null) break block8;
                            if (!_incomingMessage.verifySignature(foundCertificate.getPublicKey())) break block9;
                            verify = true;
                            LOG.debug("Signature ok");
                            this._messengerLog.log2db(72, data.getXpMessage().getDatabaseId(), this._certificateUtility.toUsingInfoText(foundCertificate, "used certificate"));
                            break block9;
                        }
                        Set<X509Certificate> senderCerts = _sender.getAllCertificates();
                        if (senderCerts.isEmpty()) {
                            throw new EbXmlException(30020, "Error", "SecurityFailure", "No certificates installed for: " + _sender.getLocalId());
                        }
                        for (X509Certificate cert : senderCerts) {
                            LOG.debug(this._certificateUtility.toUsingInfoText(cert, "Signature check with certificate"));
                            if (!_incomingMessage.verifySignature(cert.getPublicKey())) continue;
                            verify = true;
                            LOG.debug("Signature ok");
                            this._messengerLog.log2db(72, data.getXpMessage().getDatabaseId(), this._certificateUtility.toUsingInfoText(cert, "used certificate"));
                            break;
                        }
                    }
                    if (!verify) {
                        throw new EbXmlException(30021, "Error", "SecurityFailure", "XML Signature is not valid");
                    }
                    break block6;
                }
                catch (EbXmlException ebxml) {
                    this._messengerLog.log2db(521, data.getXpMessage().getDatabaseId(), ebxml.getMessage());
                    this._messageDAO.updateMessageStatus(data.getXpMessage().getDatabaseId(), data.getXpMessage().getMessageId(), 4);
                    throw ebxml;
                }
                catch (Exception e) {
                    LOG.error("unexpected error", (Throwable)e);
                    this._messengerLog.log2db(521, data.getXpMessage().getDatabaseId(), e.toString());
                    this._messageDAO.updateMessageStatus(data.getXpMessage().getDatabaseId(), data.getXpMessage().getMessageId(), 4);
                    throw new EbXmlException(30022, "Error", "SecurityFailure", "XML Signature could not be validated");
                }
            }
            LOG.debug("No XML signature found.");
        }
    }

    private X509Certificate checkSenderCertificate(EbXml2Data data) throws EbXmlException {
        try {
            EbXmlMessage _incomingMessage = data.getInboundMessage();
            CppPartner _sender = data.getSender();
            X509Certificate receivedCert = (X509Certificate)_incomingMessage.extractSenderCertificate();
            if (receivedCert != null) {
                return this.updateCertificate(_sender, receivedCert);
            }
        }
        catch (EbXmlException e) {
            throw e;
        }
        catch (Exception e) {
            LOG.info("Could not extract Certificate from EbXmlMessage:" + String.valueOf(e));
        }
        return null;
    }

    private X509Certificate updateCertificate(CppPartner _sender, X509Certificate receivedCert) throws Exception {
        X500Principal receivedIssuerX500Principal = receivedCert.getIssuerX500Principal();
        X500Principal receivedSubjectX500Principal = receivedCert.getSubjectX500Principal();
        EbXmlException error = new EbXmlException(-1, "Error", "SecurityFailure", "Error while verifying ebXML signature: " + this._certificateUtility.getSignatureUnknownErrorText(receivedCert));
        Set<X509Certificate> allCerts = _sender.getAllCertificates();
        boolean receivedCertificateIsAlreadyInstalled = allCerts.contains(receivedCert);
        if (receivedCertificateIsAlreadyInstalled) {
            LOG.debug("We already have the right certificate installed for localId:" + _sender.getLocalId());
            return receivedCert;
        }
        if (_sender.isFromRegistry() && _sender.isAutoupdate()) {
            LOG.debug("Checking for updated profile.");
            CppPartner updated = this._registryProfileUpdater.updateProfile(_sender);
            if (updated != null && updated.getAllCertificates().contains(receivedCert)) {
                LOG.debug("updated profile contained new certificate");
                return receivedCert;
            }
            throw error;
        }
        if (_sender.isCertUpdateAllowed()) {
            StringBuilder oldCertNames = new StringBuilder();
            for (X509Certificate certificate : allCerts) {
                X500Principal oldSubjectX500Principal = certificate.getSubjectX500Principal();
                if (receivedSubjectX500Principal.equals(oldSubjectX500Principal) && receivedIssuerX500Principal.equals(certificate.getIssuerX500Principal())) {
                    LOG.debug("Trying to install a new Certificate for localId:" + _sender.getLocalId());
                    _sender.addPartnerCertificate(receivedCert);
                    _sender.save();
                    return receivedCert;
                }
                oldCertNames.append("[");
                oldCertNames.append(oldSubjectX500Principal.getName("RFC2253"));
                oldCertNames.append("] ");
            }
            LOG.warn("new Certificate received but the subject is different from our current. New:" + receivedSubjectX500Principal.getName("RFC2253") + " Current certificates:" + String.valueOf(oldCertNames));
        }
        throw error;
    }
}

