/*
 * Decompiled with CFR 0.152.
 */
package de.pontonconsulting.xmlpipe.listener;

import de.ponton.xmlpipe.metrics.MetricsService;
import de.pontonconsulting.activation.ActivationException;
import de.pontonconsulting.common.encoding.Base64Decoder;
import de.pontonconsulting.xmlpipe.activation.ActivationControl;
import de.pontonconsulting.xmlpipe.activation.MessengerActivation;
import de.pontonconsulting.xmlpipe.config.IMessengerProperties;
import de.pontonconsulting.xmlpipe.cpa.Agreement;
import de.pontonconsulting.xmlpipe.cpa.AgreementException;
import de.pontonconsulting.xmlpipe.cpa.AgreementNotFoundException;
import de.pontonconsulting.xmlpipe.cpa.Agreements;
import de.pontonconsulting.xmlpipe.cpa.Communication;
import de.pontonconsulting.xmlpipe.cpp.CppPartner;
import de.pontonconsulting.xmlpipe.cpp.OptionNotFoundException;
import de.pontonconsulting.xmlpipe.cpp.ProfileException;
import de.pontonconsulting.xmlpipe.cpp.ProfileNotFoundException;
import de.pontonconsulting.xmlpipe.cpp.Profiles;
import de.pontonconsulting.xmlpipe.listener.AbstractMessageReceiver;
import de.pontonconsulting.xmlpipe.listener.DuplicateMessageException;
import de.pontonconsulting.xmlpipe.listener.IMessageReceiver;
import de.pontonconsulting.xmlpipe.listener.MessageRequest;
import de.pontonconsulting.xmlpipe.listener.MessageResponse;
import de.pontonconsulting.xmlpipe.listener.PlainListenerException;
import de.pontonconsulting.xmlpipe.listener.PlainMessage;
import de.pontonconsulting.xmlpipe.listener.PlainProcessor;
import de.pontonconsulting.xmlpipe.listener.PlainProcessorFactory;
import de.pontonconsulting.xmlpipe.message.XpMessage;
import de.pontonconsulting.xmlpipe.messenger.MaintenanceManager;
import de.pontonconsulting.xmlpipe.messenger.ReferenceDateTask;
import jakarta.mail.Header;
import jakarta.mail.MessagingException;
import jakarta.mail.internet.ContentType;
import jakarta.mail.internet.MimeMessage;
import jakarta.mail.internet.MimeUtility;
import jakarta.mail.internet.ParseException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.bouncycastle.mail.smime.util.SharedFileInputStream;

public class PlainListener
extends AbstractMessageReceiver<Map<String, String>>
implements IMessageReceiver {
    private static final String PLAIN_MESSAGING_IS_DISABLED = "Plain messaging is disabled.";
    private static final String PLAIN_LISTENER = "PlainListener";
    private static final String PASSWORD = "/password";
    private static final String CPA_DELIMITER = "\\$";
    private static final String COLON = ":";
    private static final String SPACE = " ";
    private static final String AUTHORIZATION = "Authorization";
    private static final String PASS = "pass";
    private static final String CPA = "cpa";
    private static final String BASIC_REALM_XP_PLAIN_LISTENER = "Basic realm=\"XP-PlainListener\", charset=\"UTF-8\"";
    public static final String WWW_AUTHENTICATE = "WWW-Authenticate";
    private static int _processCount = 0;
    private int _myProcessNumber;
    private final Agreements _agreements;
    private final Profiles _profiles;
    private final PlainProcessorFactory _plainProcessorFactory;
    private Log _log;

    public PlainListener(ActivationControl activationControl, MessengerActivation activationProvider, MaintenanceManager maintenanceManager, ReferenceDateTask referenceDateTask, IMessengerProperties messengerProperties, Agreements agreements, Profiles profiles, PlainProcessorFactory plainProcessorFactory, MetricsService metricsService) {
        super(activationControl, activationProvider, maintenanceManager, referenceDateTask, messengerProperties, metricsService);
        this._agreements = agreements;
        this._profiles = profiles;
        this._plainProcessorFactory = plainProcessorFactory;
        this.initLog();
    }

    private synchronized void initLog() {
        this._myProcessNumber = ++_processCount;
        String instanceName = "PlainListener[" + this._myProcessNumber + "]";
        if (this._log == null) {
            this._log = LogFactory.getFactory().getInstance("Messenger." + instanceName);
            this._log.debug((Object)"new instance");
        }
    }

    @Override
    protected Log getLogger() {
        return this._log;
    }

    private Communication checkAuthorization(String url, String[] authHeaders, Map<String, String> resultHeaders) throws IOException {
        String authHeader;
        String cpa = null;
        String password = null;
        if (Objects.nonNull(authHeaders) && (authHeader = authHeaders[0]) != null) {
            this._log.debug((Object)("Received authorization header '" + authHeader + "'"));
            String[] token = authHeader.split(SPACE);
            String base64 = new String(Base64Decoder.decode(token[1]), StandardCharsets.UTF_8);
            String[] part = base64.split(COLON);
            cpa = part[0];
            password = part[1];
        }
        if (cpa == null) {
            List<String> passwords;
            Map<String, List<String>> params = this.getQueryParams(url);
            List<String> cpas = params.get(CPA);
            if (cpas != null) {
                cpa = cpas.get(0);
            }
            if ((passwords = params.get(PASS)) != null) {
                password = passwords.get(0);
            }
        }
        if (cpa == null) {
            this._log.warn((Object)"no authentication or cpa parameter was supplied. request cannot be processed.");
            resultHeaders.put(WWW_AUTHENTICATE, BASIC_REALM_XP_PLAIN_LISTENER);
            resultHeaders.put("X-Result-Code", String.valueOf(401));
            resultHeaders.put("X-Result-Description", "Authentication required");
            return null;
        }
        String[] cpapartner = cpa.split(CPA_DELIMITER);
        if (cpapartner.length != 2) {
            this._log.warn((Object)("received incorrect authorization:" + cpa));
            resultHeaders.put(WWW_AUTHENTICATE, BASIC_REALM_XP_PLAIN_LISTENER);
            resultHeaders.put("X-Result-Code", String.valueOf(401));
            resultHeaders.put("X-Result-Description", "Authentication required");
            return null;
        }
        Communication com = null;
        try {
            CppPartner local = this._profiles.getProfileForLocalId(cpapartner[0], true);
            if (!local.isLocal()) {
                this._log.error((Object)("Partner with id " + cpapartner[0] + " is not a local partner. aborting reception."));
                resultHeaders.put(WWW_AUTHENTICATE, BASIC_REALM_XP_PLAIN_LISTENER);
                resultHeaders.put("X-Result-Code", String.valueOf(403));
                resultHeaders.put("X-Result-Description", "Receiver is not known");
                return null;
            }
            Agreement agreement = this._agreements.getAgreement(cpapartner[0], cpapartner[1], true);
            com = agreement.getCommunication(cpapartner[1], cpapartner[0]);
            String expected = com.getPackagingOptionValue(PASSWORD);
            if (expected != null && expected.equals(password)) {
                this._log.debug((Object)("received correct authorization for cpa: " + cpa));
                return com;
            }
            this._log.warn((Object)("wrong password supplied for cpa: " + cpa + SPACE + password));
            resultHeaders.put("X-Result-Code", String.valueOf(401));
            resultHeaders.put("X-Result-Description", "Authentication required");
        }
        catch (OptionNotFoundException e) {
            this._log.warn((Object)("No Password defined in cpa: " + cpa));
            return com;
        }
        catch (AgreementNotFoundException e) {
            this._log.warn((Object)("no agreement does not exist: " + cpa));
            resultHeaders.put("X-Result-Code", String.valueOf(500));
            resultHeaders.put("X-Result-Description", "No Agreement for " + cpapartner[0] + " and " + cpapartner[1]);
        }
        catch (AgreementException e) {
            this._log.warn((Object)"communication not found ! ");
            resultHeaders.put("X-Result-Code", String.valueOf(500));
            resultHeaders.put("X-Result-Description", "Error in communication settings of agreement for " + cpapartner[0] + " and " + cpapartner[1]);
        }
        catch (ProfileNotFoundException e) {
            this._log.error((Object)("There is no local profile with id: " + cpapartner[0]));
            resultHeaders.put("X-Result-Code", String.valueOf(500));
            resultHeaders.put("X-Result-Description", "Local profile with id " + cpapartner[0] + " does not exist");
        }
        catch (ProfileException e) {
            this._log.error((Object)("Error while loading profile " + e.getMessage()));
            resultHeaders.put("X-Result-Code", String.valueOf(500));
            resultHeaders.put("X-Result-Description", "Profile could not be loaded.");
        }
        resultHeaders.put(WWW_AUTHENTICATE, BASIC_REALM_XP_PLAIN_LISTENER);
        return null;
    }

    @Override
    protected void processResult(Map<String, String> resultHeaders, MessageResponse messageResponse) throws Exception {
        for (Map.Entry<String, String> resultHeader : resultHeaders.entrySet()) {
            messageResponse.addHeader(resultHeader.getKey(), resultHeader.getValue());
        }
    }

    @Override
    protected void handleException(Throwable exception, MessageResponse messageResponse) throws IOException {
        if (exception instanceof DuplicateMessageException) {
            DuplicateMessageException e = (DuplicateMessageException)exception;
            messageResponse.setResult(200, "OK");
            this._log.warn((Object)("Duplicate Message received. Not processed and OK status returned (mid:" + e.getMessageId() + ")"));
        } else {
            messageResponse.setResult(500, exception.getMessage());
            String result = "Error while receiving message: " + exception.getMessage();
            this._log.error((Object)result);
            OutputStream os = messageResponse.getOutputStream();
            os.write(result.getBytes());
            os.flush();
        }
    }

    @Override
    protected boolean isFeatureEnabled() throws ActivationException {
        return this.activationProvider.isPlainMessagingEnabled();
    }

    @Override
    protected String getMessengerExceptionText() {
        return PLAIN_MESSAGING_IS_DISABLED;
    }

    @Override
    protected Map<String, String> processRequest(MessageRequest messageRequest) throws Exception {
        HashMap<String, String> result = new HashMap<String, String>();
        try (SharedFileInputStream sharedInputStream = new SharedFileInputStream(messageRequest.getRequestDataFile());){
            ContentType contentType;
            String protocol;
            MimeMessage mimeMessage = new MimeMessage(null, (InputStream)sharedInputStream);
            Communication communication = this.checkAuthorization(messageRequest.getRequestURL(), mimeMessage.getHeader(AUTHORIZATION), result);
            if (Objects.isNull(communication)) {
                HashMap<String, String> hashMap = result;
                return hashMap;
            }
            String realProtocol = messageRequest.getHeader("X-inbound-protocol");
            if (realProtocol != null) {
                protocol = realProtocol;
            } else {
                try {
                    protocol = new URI(messageRequest.getRequestURL()).getScheme().toUpperCase();
                }
                catch (Exception e) {
                    protocol = "unknown";
                }
            }
            this.logUserInformation(mimeMessage);
            String[] contentTypeValues = mimeMessage.getHeader("Content-Type");
            if (contentTypeValues == null || contentTypeValues.length < 1) {
                throw new PlainListenerException(43001, "Missing Content-Type in HTTP header");
            }
            try {
                contentType = new ContentType(contentTypeValues[0]);
            }
            catch (ParseException e) {
                throw new PlainListenerException(43009, "Content-Type cannot be parsed." + e.getMessage());
            }
            this._log.debug((Object)("Receiving incoming " + protocol + " message Content-Type:" + contentType.toString().replace('\n', ' ').replace('\r', ' ')));
            if (contentType.match("multipart/*")) {
                throw new PlainListenerException(43009, "Multipart not supported.");
            }
            PlainMessage message = this.createPlainMessage(mimeMessage, contentType, communication, protocol);
            PlainProcessor processor = this._plainProcessorFactory.getPlainProcessor();
            processor.processMessage(message);
            sharedInputStream.dispose();
        }
        result.put("X-Result-Code", String.valueOf(200));
        result.put("X-Result-Description", "OK");
        return result;
    }

    private PlainMessage createPlainMessage(MimeMessage mimeMessage, ContentType contentType, Communication communication, String protocol) throws MessagingException {
        String processedOrigialFilename;
        String decoded;
        String originalFilename;
        XpMessage xp = new XpMessage();
        xp.setAgreement(communication.getAgreement());
        try {
            xp.setOwnPartner(this._profiles.getProfileForLocalId(communication.getAgreement().getOwnPartner().getId(), true));
            xp.setCommunicationPartner(this._profiles.getProfileForLocalId(communication.getAgreement().getCommunicationPartner().getId(), true));
        }
        catch (ProfileException e) {
            this._log.error((Object)("ProfileException: " + e.getMessage()));
            throw new MessagingException(e.getMessage(), (Exception)e);
        }
        xp.setInboundMessage(true);
        xp.setMessageTimestamp(this.getReferenceDateTask().getReferenceDate());
        xp.setReceiverLocalId(communication.getReceiverLocalId());
        xp.setSenderLocalId(communication.getSenderLocalId());
        xp.setProtocol(protocol);
        xp.setCommunication(communication);
        xp.setAdapterId(xp.getAgreement().getDefaultAdapterId());
        String[] originalFilenameValues = mimeMessage.getHeader("X-Original-Filename");
        if (originalFilenameValues != null && originalFilenameValues.length > 0 && StringUtils.isNotBlank((CharSequence)(originalFilename = originalFilenameValues[0]))) {
            decoded = "";
            try {
                decoded = MimeUtility.decodeText((String)originalFilename);
            }
            catch (UnsupportedEncodingException ex) {
                this._log.error((Object)ex.getMessage());
                decoded = originalFilename;
            }
            xp.setProcessingDirective("OriginalFilename", decoded);
            if (this._log.isTraceEnabled()) {
                this._log.trace((Object)("Set processing directive OriginalFilename to " + decoded));
            }
        }
        if (StringUtils.isNotBlank((CharSequence)(processedOrigialFilename = contentType.getParameter("name")))) {
            decoded = "";
            try {
                decoded = MimeUtility.decodeText((String)processedOrigialFilename);
            }
            catch (UnsupportedEncodingException ex) {
                this._log.error((Object)ex.getMessage());
                decoded = processedOrigialFilename;
            }
            xp.setProcessingDirective("ProcessedOriginalFilename", decoded);
            if (this._log.isTraceEnabled()) {
                this._log.trace((Object)("Set processing directive ProcessedOriginalFilename to " + decoded));
            }
        }
        PlainMessage message = new PlainMessage();
        message.setMimeMessage(mimeMessage);
        message.setContentType(contentType);
        message.setXpMessage(xp);
        return message;
    }

    protected HashMap<String, String> convertInternetHeadersToHashMap(Enumeration<?> headersEnum) {
        HashMap<String, String> result = new HashMap<String, String>();
        while (headersEnum.hasMoreElements()) {
            Header header = (Header)headersEnum.nextElement();
            String value = header.getValue();
            result.put(header.getName(), value);
        }
        return result;
    }

    @Override
    public String getServiceName() {
        return PLAIN_LISTENER;
    }
}

