/*
 * Decompiled with CFR 0.152.
 */
package de.pontonconsulting.xmlpipe.listener;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;

public class MessageResponse {
    public static final String HEADER_RESULT_CODE = "X-Result-Code";
    public static final String HEADER_RESULT_TEXT = "X-Result-Description";
    private final Map<String, String> responseHeaders = new HashMap<String, String>();
    private final ByteArrayOutputStream responseData = new ByteArrayOutputStream();

    public void addHeader(String header, String value) {
        this.responseHeaders.put(header, value);
    }

    public String getHeader(String header) {
        return this.responseHeaders.get(header);
    }

    public Map<String, String> getHeaders() {
        return this.responseHeaders;
    }

    public OutputStream getOutputStream() {
        return this.responseData;
    }

    public void write(String content) throws IOException {
        this.responseData.write(content.getBytes(StandardCharsets.UTF_8));
    }

    public void write(byte[] bytes) throws IOException {
        this.responseData.write(bytes);
    }

    public void write(int b) {
        this.responseData.write(b);
    }

    public int getDataSize() {
        return this.responseData.size();
    }

    public void setResult(int resultCode, String resultText) {
        this.addHeader(HEADER_RESULT_CODE, String.valueOf(resultCode));
        this.addHeader(HEADER_RESULT_TEXT, resultText);
    }

    public int getResultCode() {
        try {
            return Integer.parseInt(this.getHeader(HEADER_RESULT_CODE));
        }
        catch (Exception e) {
            return -1;
        }
    }

    public String getResultText() {
        return this.getHeader(HEADER_RESULT_TEXT);
    }

    public byte[] getData() {
        return this.responseData.toByteArray();
    }
}

