/*
 * Decompiled with CFR 0.152.
 */
package de.pontonconsulting.xmlpipe.listener;

import de.pontonconsulting.activation.ActivationException;
import de.pontonconsulting.xmlpipe.listener.IMessageReceiver;
import jakarta.annotation.PreDestroy;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.context.ApplicationContext;

public class ListenerManager {
    private static Log _log = LogFactory.getFactory().getInstance("Messenger.ListenerManager");
    private final Map<String, IMessageReceiver> _listeners;
    private final List<String> _activatedServices;
    private final ApplicationContext applicationContext;

    public ListenerManager(ApplicationContext applicationContext) throws ActivationException {
        this.applicationContext = applicationContext;
        this._listeners = new ConcurrentHashMap<String, IMessageReceiver>();
        this._activatedServices = new CopyOnWriteArrayList<String>();
    }

    public void loadAllListeners() {
        _log.trace((Object)"Searching for HTTP listeners.");
        ArrayList listeners = new ArrayList();
        listeners.addAll(this.applicationContext.getBeansOfType(IMessageReceiver.class).values());
        for (IMessageReceiver listener : listeners) {
            _log.trace((Object)("Loaded instance of " + listener.getClass().getCanonicalName()));
            this._listeners.put(listener.getServiceName(), listener);
            this._activatedServices.add(listener.getServiceName());
        }
    }

    public List<String> getActivatedServices() {
        return Collections.unmodifiableList(this._activatedServices);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IMessageReceiver getListener(String serviceName) {
        ListenerManager listenerManager = this;
        synchronized (listenerManager) {
            if (this._listeners.isEmpty()) {
                this.loadAllListeners();
            }
        }
        IMessageReceiver httpMessageReceiver = this._listeners.get(serviceName);
        if (httpMessageReceiver == null) {
            _log.warn((Object)("No HTTP Message Receiver found for '" + serviceName + "'."));
        }
        return httpMessageReceiver;
    }

    @PreDestroy
    public void shutdown() {
        for (String serviceName : this._listeners.keySet()) {
            IMessageReceiver iMessageReceiver = this._listeners.get(serviceName);
        }
    }
}

