/*
 * Decompiled with CFR 0.152.
 */
package de.pontonconsulting.xmlpipe.listener;

import com.codahale.metrics.Timer;
import de.ponton.xmlpipe.metrics.MetricsService;
import de.ponton.xmlpipe.metrics.XPMetrics;
import de.pontonconsulting.activation.ActivationException;
import de.pontonconsulting.xmlpipe.Constants;
import de.pontonconsulting.xmlpipe.activation.ActivationControl;
import de.pontonconsulting.xmlpipe.activation.MessengerActivation;
import de.pontonconsulting.xmlpipe.config.IMessengerProperties;
import de.pontonconsulting.xmlpipe.cpa.Agreements;
import de.pontonconsulting.xmlpipe.cpp.Profiles;
import de.pontonconsulting.xmlpipe.listener.IMessageReceiver;
import de.pontonconsulting.xmlpipe.listener.MessageRequest;
import de.pontonconsulting.xmlpipe.listener.MessageResponse;
import de.pontonconsulting.xmlpipe.messenger.MaintenanceException;
import de.pontonconsulting.xmlpipe.messenger.MaintenanceManager;
import de.pontonconsulting.xmlpipe.messenger.MessengerException;
import de.pontonconsulting.xmlpipe.messenger.ReferenceDateTask;
import jakarta.mail.MessagingException;
import jakarta.mail.internet.MimeMessage;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;

public abstract class AbstractMessageReceiver<T>
implements IMessageReceiver {
    private static final String DEFAULT_HIDE_SERVERNAME = "false";
    private static final String PROPERTY_HIDE_SERVERNAME = "ponton.hide-servername";
    protected static final String BASE64 = "base64";
    protected static final String SERVER = "Server";
    private static final String TEXT_HTML = "text/html";
    public static final String MAINTENANCE_HTTP_HEADER = "x-pontonxp-downtime-end";
    private final ActivationControl _activationControl;
    protected final MessengerActivation activationProvider;
    private final MaintenanceManager _maintenanceManager;
    private final ReferenceDateTask referenceDateTask;
    private final IMessengerProperties _messengerProperties;
    private static final String HEADER;
    private static final String FOOTER;
    private static final String PROPERTY_MESSENGER_NAME = "messenger.name";
    public static final String MESSENGER_NAME;
    private final MetricsService metricsService;

    protected AbstractMessageReceiver(ActivationControl activationControl, MessengerActivation activationProvider, MaintenanceManager maintenanceManager, ReferenceDateTask referenceDateTask, IMessengerProperties messengerProperties, MetricsService metricsService) {
        this._activationControl = activationControl;
        this.activationProvider = activationProvider;
        this._maintenanceManager = maintenanceManager;
        this.referenceDateTask = referenceDateTask;
        this._messengerProperties = messengerProperties;
        this.metricsService = metricsService;
    }

    private String getOutputFor(String param, String value, String fontType) {
        String result = "                     <tr>\r\n                        <td height=\"10\" style=\"padding-left: 5;\"><font class=\"font2\" id=\"content\">" + param + ":</font></td>\r\n                        <td height=\"10\"><font class=\"font2\" id=\"" + fontType + "\">" + value + "</font></td>\r\n                        <td colspan=\"4\">&nbsp;</td>\r\n                     </tr>\r\n";
        return result;
    }

    private String getOutputForEmptyRow() {
        String result = "                     <tr>\r\n                        <td colspan=\"6\">&nbsp;</td>\r\n                     </tr>\r\n";
        return "                     <tr>\r\n                        <td colspan=\"6\">&nbsp;</td>\r\n                     </tr>\r\n";
    }

    protected void logUserInformation(MimeMessage mimeMessage) throws MessagingException {
        String[] server;
        String[] agent = mimeMessage.getHeader("User-Agent");
        if (agent != null && agent.length > 0) {
            this.getLogger().debug((Object)("http-user-agent: " + agent[0]));
        }
        if ((server = mimeMessage.getHeader(SERVER)) != null && server.length > 0) {
            this.getLogger().debug((Object)("http-server: " + server[0]));
        }
    }

    protected abstract Log getLogger();

    protected void storeWiredData(File ouputFile, Map<String, String> headers, byte[] dataBytes) throws IOException {
        try (BufferedOutputStream out = new BufferedOutputStream(Files.newOutputStream(ouputFile.toPath(), new OpenOption[0]));){
            for (Map.Entry<String, String> header : headers.entrySet()) {
                ((OutputStream)out).write((header.getKey() + ": " + header.getValue() + "\r\n").getBytes());
            }
            ((OutputStream)out).write("\r\n".getBytes());
            ((OutputStream)out).write(dataBytes);
        }
    }

    protected void printStatusPage(MessageResponse messageResponse, String requestorIP) throws IOException {
        Object content = this.getOutputFor("Messenger Version", Constants.getXP_VERSION(), "content");
        if (MESSENGER_NAME != null) {
            content = (String)content + this.getOutputFor("Messenger Name", MESSENGER_NAME, "content");
        }
        boolean isFeatureEnabled = false;
        try {
            isFeatureEnabled = this.isFeatureEnabled();
        }
        catch (ActivationException activationException) {
            // empty catch block
        }
        String color = "ok";
        Object text = "This Service is accepting Messages";
        if (!this._activationControl.isActive()) {
            color = "error";
            text = "This Service is currently NOT accepting Messages";
        } else if (!isFeatureEnabled) {
            color = "error";
            text = this.getMessengerExceptionText();
        } else if (this._maintenanceManager.isRejectInboundMSGs()) {
            color = "error";
            text = "Server is currently not accepting messages: Messenger is running in a Maintenance Mode until " + String.valueOf(this._maintenanceManager.getEndTime());
        }
        content = (String)content + this.getOutputFor("Status of " + this.getServiceName(), (String)text, color);
        String licenseText = null;
        try {
            licenseText = !this._activationControl.isLicensed() ? "TRIAL Version" : this.activationProvider.getCompanyName();
        }
        catch (Exception e) {
            licenseText = "Problem with License detected";
        }
        content = (String)content + this.getOutputFor("Licensed for", licenseText, "ok");
        content = (String)content + this.getOutputForEmptyRow();
        content = (String)content + this.getOutputFor("Status Request came from IP", requestorIP, "content");
        Date refTime = this.referenceDateTask.getReferenceDate();
        Date sysTime = new Date();
        content = (String)content + this.getOutputFor("Status Request system time", sysTime.toString(), "content");
        content = (String)content + this.getOutputFor("Status Request reference time", refTime.toString(), "content");
        messageResponse.write(HEADER);
        messageResponse.write((String)content);
        messageResponse.write(FOOTER);
    }

    protected void processResult(T request, MessageResponse messageResponse) throws Exception {
    }

    protected void handleException(Throwable exception, MessageResponse messageResponse) throws IOException {
    }

    protected void putLock(Object lock) {
        this._maintenanceManager.putLock(lock);
    }

    protected void removeLock(Object lock) {
        this._maintenanceManager.removeLock(lock);
    }

    public Map<String, List<String>> getQueryParams(String url) {
        HashMap<String, List<String>> params = new HashMap<String, List<String>>();
        String[] urlParts = url.split("\\?");
        if (urlParts.length > 1) {
            String query = urlParts[1];
            for (String param : query.split("&")) {
                String[] pair = param.split("=");
                String key = URLDecoder.decode(pair[0], StandardCharsets.UTF_8);
                String value = pair.length > 1 ? URLDecoder.decode(pair[1], StandardCharsets.UTF_8) : "";
                ArrayList<String> values = (ArrayList<String>)params.get(key);
                if (values == null) {
                    values = new ArrayList<String>();
                    params.put(key, values);
                }
                values.add(value);
            }
        }
        return params;
    }

    protected void checkIfMessengerIsReady() throws MessengerException, MaintenanceException {
        if (!this._activationControl.isActive()) {
            throw new MessengerException(2000, "Server is currently not accepting messages");
        }
        if (!this.activationProvider.isTrialVersion()) {
            try {
                if (!this.isFeatureEnabled()) {
                    throw new MessengerException(1026, this.getMessengerExceptionText());
                }
            }
            catch (ActivationException ex) {
                this.getLogger().warn((Object)ex.toString());
                throw new MessengerException(1026, ex.toString());
            }
        }
        if (this._maintenanceManager.isRejectInboundMSGs()) {
            throw new MaintenanceException(this._maintenanceManager.getEndTime(), "Server is currently not accepting messages: Messenger is running in a Maintenance Mode until " + String.valueOf(this._maintenanceManager.getEndTime()));
        }
    }

    protected boolean isFeatureEnabled() throws ActivationException {
        return true;
    }

    protected String getMessengerExceptionText() {
        return "";
    }

    @Override
    public MessageResponse receiveGetRequest(MessageRequest messageRequest) throws IOException {
        this.getLogger().info((Object)("received GET request to " + messageRequest.getRequestServletPath()));
        MessageResponse messageResponse = new MessageResponse();
        messageResponse.addHeader("Content-Type", "text/html; charset=UTF-8");
        messageResponse.addHeader(SERVER, Constants.getHTTP_XP_NAME());
        String ipAddress = messageRequest.getHeader("X-Forwarded-For");
        this.printStatusPage(messageResponse, ipAddress);
        messageResponse.setResult(200, "OK");
        return messageResponse;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MessageResponse receivePostRequest(MessageRequest messageRequest) throws IOException {
        this.getLogger().info((Object)("received POST request to " + messageRequest.getRequestServletPath()));
        MessageResponse messageResponse = new MessageResponse();
        if (!this.isHideServerName()) {
            messageResponse.addHeader(SERVER, Constants.getHTTP_XP_NAME());
        }
        Profiles.initThreadCache();
        Agreements.initThreadCache();
        Object lockObject = new Object();
        try (Timer.Context adapterQueueTimer = this.metricsService.getTimer(XPMetrics.MESSAGES_INBOUND_LISTENER_QUEUE_TIME).time();){
            this.putLock(lockObject);
            this.checkIfMessengerIsReady();
            T result = this.processRequest(messageRequest);
            messageResponse.addHeader("X-Result-Description", "OK");
            if (result == null) {
                messageResponse.addHeader("X-Result-Code", "204");
            } else {
                messageResponse.addHeader("X-Result-Code", "200");
                this.processResult(result, messageResponse);
            }
        }
        catch (MessengerException me) {
            this.getLogger().error((Object)("Received POST, but messenger is not accepting messages. " + me.getMessage()));
            messageResponse.setResult(500, "Messenger is currently not accepting messages");
        }
        catch (MaintenanceException me) {
            this.getLogger().debug((Object)me.toString());
            if (me.getEndTime() == null) {
                this.getLogger().warn((Object)"Maintenance end time currently not detectable.");
            } else {
                messageResponse.addHeader(MAINTENANCE_HTTP_HEADER, String.valueOf(me.getEndTime().getTime()));
            }
            messageResponse.setResult(500, me.getMessage());
        }
        catch (Throwable e) {
            this.handleException(e, messageResponse);
        }
        finally {
            this.removeLock(lockObject);
            Agreements.clearThreadCache();
            Profiles.clearThreadCache();
        }
        return messageResponse;
    }

    protected abstract T processRequest(MessageRequest var1) throws Exception;

    protected boolean isHideServerName() {
        String value = this._messengerProperties.getProperty(PROPERTY_HIDE_SERVERNAME, DEFAULT_HIDE_SERVERNAME);
        return Boolean.parseBoolean(value);
    }

    @Override
    public abstract String getServiceName();

    protected ReferenceDateTask getReferenceDateTask() {
        return this.referenceDateTask;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        String messengerName = System.getProperty(PROPERTY_MESSENGER_NAME);
        MESSENGER_NAME = messengerName != null && !messengerName.trim().isEmpty() ? (messengerName.length() > 40 ? messengerName.substring(0, 40) : messengerName) : null;
        InputStream headerIS = null;
        StringBuilder headerSB = new StringBuilder();
        try {
            headerIS = AbstractMessageReceiver.class.getResourceAsStream("/listener-status-header.html");
            int i = headerIS.read();
            while (i != -1) {
                headerSB.append((char)i);
                i = headerIS.read();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                headerIS.close();
            }
            catch (Exception e) {}
        }
        HEADER = headerSB.toString();
        InputStream footerIS = null;
        StringBuilder footerSB = new StringBuilder();
        try {
            footerIS = AbstractMessageReceiver.class.getResourceAsStream("/listener-status-footer.html");
            int i = footerIS.read();
            while (i != -1) {
                footerSB.append((char)i);
                i = footerIS.read();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                footerIS.close();
            }
            catch (Exception exception) {}
        }
        FOOTER = footerSB.toString().replace("%YEAR%", Integer.toString(Calendar.getInstance().get(1)));
    }
}

