/*
 * Decompiled with CFR 0.152.
 */
package de.pontonconsulting.xmlpipe.listener;

import de.ponton.xmlpipe.metrics.MetricsService;
import de.ponton.xmlpipe.queue.OutboundQueue;
import de.pontonconsulting.activation.ActivationException;
import de.pontonconsulting.xmlpipe.activation.ActivationControl;
import de.pontonconsulting.xmlpipe.activation.MessengerActivation;
import de.pontonconsulting.xmlpipe.as.AS3ObjectFactory;
import de.pontonconsulting.xmlpipe.as.ASException;
import de.pontonconsulting.xmlpipe.as.ASMessage;
import de.pontonconsulting.xmlpipe.as.ASReport;
import de.pontonconsulting.xmlpipe.as.ASReportException;
import de.pontonconsulting.xmlpipe.as.IAS3Object;
import de.pontonconsulting.xmlpipe.config.IFolders;
import de.pontonconsulting.xmlpipe.config.IMessengerProperties;
import de.pontonconsulting.xmlpipe.listener.AS3Processor;
import de.pontonconsulting.xmlpipe.listener.AbstractMessageReceiver;
import de.pontonconsulting.xmlpipe.listener.IASProcessorFactory;
import de.pontonconsulting.xmlpipe.listener.IMessageReceiver;
import de.pontonconsulting.xmlpipe.listener.MessageRequest;
import de.pontonconsulting.xmlpipe.listener.MessageResponse;
import de.pontonconsulting.xmlpipe.message.XpMessage;
import de.pontonconsulting.xmlpipe.messenger.MaintenanceManager;
import de.pontonconsulting.xmlpipe.messenger.Messenger;
import de.pontonconsulting.xmlpipe.messenger.ReferenceDateTask;
import de.pontonconsulting.xmlpipe.messenger.database.DbException;
import jakarta.mail.Header;
import jakarta.mail.MessagingException;
import jakarta.mail.internet.MimeBodyPart;
import jakarta.mail.internet.MimeMessage;
import jakarta.mail.internet.ParseException;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Enumeration;
import java.util.HashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.bouncycastle.mail.smime.util.SharedFileInputStream;

public class AS3Listener
extends AbstractMessageReceiver<ASReport>
implements IMessageReceiver {
    private static final String AS3_MESSAGING_IS_DISABLED = "AS3 messaging is disabled.";
    private Log _log;
    private final IASProcessorFactory _asProcessorFactory;
    private final OutboundQueue _outboundMessageQueue;
    private final IFolders _folders;
    private final AS3ObjectFactory _as3ObjectFactory;

    public AS3Listener(ActivationControl activationControl, MessengerActivation activationProvider, MaintenanceManager maintenanceManager, ReferenceDateTask referenceDateTask, IMessengerProperties messengerProperties, IASProcessorFactory asProcessorFactory, OutboundQueue outboundMessageQueue, IFolders folders, AS3ObjectFactory as3ObjectFactory, MetricsService metricsService) {
        super(activationControl, activationProvider, maintenanceManager, referenceDateTask, messengerProperties, metricsService);
        this._asProcessorFactory = asProcessorFactory;
        this._outboundMessageQueue = outboundMessageQueue;
        this._folders = folders;
        this._as3ObjectFactory = as3ObjectFactory;
        this.initLog();
    }

    @Override
    protected Log getLogger() {
        return this._log;
    }

    private synchronized void initLog() {
        String instanceName = "AS3Listener";
        if (this._log == null) {
            this._log = LogFactory.getFactory().getInstance("Messenger.AS3Listener");
        }
        this._log.debug((Object)"new instance");
    }

    private void storeMDNData(ASReport report) throws FileNotFoundException, IOException, MessagingException, ASReportException {
        String fixedMessageId = Messenger.getFixedFilename(report.getMessageId());
        File work = new File(this._folders.getWorkOutboundFolder(), fixedMessageId);
        work.mkdirs();
        File mdnFile = new File(work, "headers.txt");
        this._log.debug((Object)("Storing MDN data to: " + mdnFile.getAbsolutePath()));
        try (BufferedOutputStream mdnOut = new BufferedOutputStream(Files.newOutputStream(mdnFile.toPath(), new OpenOption[0]));){
            report.getReportMimePart().writeTo((OutputStream)mdnOut);
        }
    }

    @Override
    protected ASReport processRequest(MessageRequest messageRequest) throws Exception {
        String uri = messageRequest.getRequestURL().toString();
        return this.processRequest(messageRequest, uri);
    }

    @Override
    protected void processResult(ASReport report, MessageResponse messageResponse) throws Exception {
        this.storeMDNData(report);
        this.sendAsynchronousReply(report);
    }

    @Override
    protected void handleException(Throwable exception, MessageResponse messageResponse) throws IOException {
        String result = "Error while receiving AS2 message: " + exception.toString();
        this._log.error((Object)result);
        messageResponse.setResult(500, result);
        OutputStream os = messageResponse.getOutputStream();
        os.write(result.getBytes());
        os.flush();
    }

    @Override
    protected boolean isFeatureEnabled() throws ActivationException {
        return this.activationProvider.isASxMessagingEnabled();
    }

    @Override
    protected String getMessengerExceptionText() {
        return AS3_MESSAGING_IS_DISABLED;
    }

    protected ASReport processRequest(MessageRequest messageRequest, String uri) throws ASException, IOException, ParseException, MessagingException, DbException {
        try (SharedFileInputStream sharedInputStream = new SharedFileInputStream(messageRequest.getRequestDataFile());){
            ASReport asReport;
            String protocol;
            MimeMessage mimeMessage = new MimeMessage(null, (InputStream)sharedInputStream);
            String realProtocol = messageRequest.getHeader("X-inbound-protocol");
            if (realProtocol != null) {
                protocol = realProtocol;
            } else {
                try {
                    protocol = new URI(uri).getScheme().toUpperCase();
                }
                catch (Exception e) {
                    protocol = "unknown";
                }
            }
            this.logUserInformation(mimeMessage);
            AS3Processor processor = this._asProcessorFactory.getAS3Processor();
            IAS3Object as3Object = this._as3ObjectFactory.createAS3Object(mimeMessage);
            if (as3Object instanceof ASReport) {
                processor.processReport((ASReport)((Object)as3Object), protocol);
                asReport = null;
            } else {
                asReport = processor.processMessage((ASMessage)((Object)as3Object), protocol);
            }
            sharedInputStream.dispose();
            ASReport aSReport = asReport;
            return aSReport;
        }
    }

    private void sendAsynchronousReply(ASReport report) {
        report.getXpMessage().setMessagePackaging("AS3");
        File work = new File(this._folders.getWorkOutboundFolder(), String.valueOf(report.getXpMessage().getDatabaseId()));
        work.mkdirs();
        File messageFile = new File(work, "xp_message.dat");
        File messageHeaderFile = new File(work, "xp_message_header.dat");
        try {
            String partnerUrl = report.getXpMessage().getCommunication().getTransportURL();
            Object destination = report.getMDNParameters().getDispositionNotificationTo();
            if (this.checkURL((String)destination)) {
                if (partnerUrl.toLowerCase().startsWith("ftps://")) {
                    destination = "ftps://" + ((String)destination).substring("ftp://".length());
                }
            } else {
                destination = partnerUrl;
            }
            report.getXpMessage().setProtocol(((String)destination).trim().toLowerCase().startsWith("ftps://") ? "FTPS" : "FTP");
            try (BufferedOutputStream messageOut = new BufferedOutputStream(Files.newOutputStream(messageFile.toPath(), new OpenOption[0]));
                 BufferedOutputStream headersOut = new BufferedOutputStream(Files.newOutputStream(messageHeaderFile.toPath(), new OpenOption[0]));){
                MimeBodyPart response = report.getMimePart();
                InputStream in = response.getInputStream();
                in.transferTo(messageOut);
                ((OutputStream)messageOut).flush();
                response.addHeader("Content-Length", "" + messageFile.length());
                try (ObjectOutputStream oos = new ObjectOutputStream(headersOut);){
                    Enumeration mimeHeader = response.getAllHeaders();
                    HashMap<String, String> header2 = this.convertInternetHeadersToHashMap(mimeHeader);
                    oos.writeObject(header2);
                }
                this._log.debug((Object)"Sending Async response");
                if (report.getXpMessage().getAdapterId() == null) {
                    report.getXpMessage().setAdapterId("NullAdapter");
                }
                XpMessage xpMessage = report.getXpMessage();
                xpMessage.setDestinationUrl((String)destination);
                this._outboundMessageQueue.deliverMessageToPartner(report.getXpMessage());
            }
        }
        catch (Exception e) {
            this._log.fatal((Object)"Unable send send asynchonous reply", (Throwable)e);
        }
    }

    private boolean checkURL(String url) {
        if (url == null || !url.trim().toLowerCase().startsWith("ftp://")) {
            return false;
        }
        try {
            URI destination = new URI(url);
            String temp = destination.getHost();
            if (temp == null || temp.length() == 0) {
                return false;
            }
        }
        catch (URISyntaxException e) {
            return false;
        }
        return true;
    }

    protected HashMap<String, String> convertInternetHeadersToHashMap(Enumeration<Header> headersEnum) {
        HashMap<String, String> result = new HashMap<String, String>();
        while (headersEnum.hasMoreElements()) {
            Header header = headersEnum.nextElement();
            String value = header.getValue();
            result.put(header.getName(), value);
        }
        return result;
    }

    @Override
    public String getServiceName() {
        return "AS3Listener";
    }
}

