/*
 * Decompiled with CFR 0.152.
 */
package de.pontonconsulting.xmlpipe.listener;

import de.pontonconsulting.xmlpipe.as.AS2ObjectFactory;
import de.pontonconsulting.xmlpipe.as.AS2Report;
import de.pontonconsulting.xmlpipe.as.ASException;
import de.pontonconsulting.xmlpipe.as.ASMessage;
import de.pontonconsulting.xmlpipe.as.ASReport;
import de.pontonconsulting.xmlpipe.config.IFolders;
import de.pontonconsulting.xmlpipe.config.MessengerConfig;
import de.pontonconsulting.xmlpipe.cpa.Agreements;
import de.pontonconsulting.xmlpipe.cpp.CppPartner;
import de.pontonconsulting.xmlpipe.cpp.ProfileException;
import de.pontonconsulting.xmlpipe.cpp.ProfileNotFoundException;
import de.pontonconsulting.xmlpipe.cpp.Profiles;
import de.pontonconsulting.xmlpipe.listener.ASProcessor;
import de.pontonconsulting.xmlpipe.listener.ErrorNotificationService;
import de.pontonconsulting.xmlpipe.message.XpMessage;
import de.pontonconsulting.xmlpipe.messenger.IdGenerator;
import de.pontonconsulting.xmlpipe.messenger.ReceiveFromListener;
import de.pontonconsulting.xmlpipe.messenger.ReferenceDateTask;
import de.pontonconsulting.xmlpipe.messenger.archive.ArchiveProcessor;
import de.pontonconsulting.xmlpipe.messenger.database.tables.FileRefDAO;
import de.pontonconsulting.xmlpipe.messenger.database.tables.MDNDataDAO;
import de.pontonconsulting.xmlpipe.messenger.database.tables.MessageDAO;
import de.pontonconsulting.xmlpipe.messenger.database.tables.MessageWorkDataDAO;
import de.pontonconsulting.xmlpipe.messenger.database.tables.MessengerLog;
import de.pontonconsulting.xmlpipe.registry.RegistryProfileUpdater;
import de.pontonconsulting.xmlpipe.security.CertificateUtility;
import de.pontonconsulting.xmlpipe.security.MessageDigestCalculator;
import de.pontonconsulting.xmlpipe.security.SecurityException;
import de.pontonconsulting.xmlpipe.security.smime.SMIMEDecompressor;
import de.pontonconsulting.xmlpipe.security.smime.SMIMEDecrypter;
import de.pontonconsulting.xmlpipe.security.smime.SMIMEVerifier;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class AS2Processor
extends ASProcessor {
    private static final Logger _log = LogManager.getLogger((String)"Messenger.AS2Processor");
    private final AS2ObjectFactory _as2ObjectFactory;

    public AS2Processor(Agreements agreements, MessengerConfig messengerConfig, Profiles profiles, ReceiveFromListener receiveFromListener, ReferenceDateTask referenceDate, MessengerLog messengerLog, MessageDAO messageDAO, FileRefDAO fileRefDAO, MDNDataDAO mdnDataDAO, IFolders folders, IdGenerator idGenerator, ArchiveProcessor archiveProcessor, CertificateUtility certificateUtility, ErrorNotificationService errorNotificationService, SMIMEVerifier smimeVerifier, SMIMEDecrypter smimeDecrypter, SMIMEDecompressor smimeDecompressor, RegistryProfileUpdater registryProfileUpdater, AS2ObjectFactory as2ObjectFactory, MessageWorkDataDAO messageWorkDataDAO) {
        super(agreements, messengerConfig, profiles, receiveFromListener, referenceDate, messengerLog, messageDAO, fileRefDAO, mdnDataDAO, folders, idGenerator, archiveProcessor, certificateUtility, errorNotificationService, smimeVerifier, smimeDecrypter, smimeDecompressor, registryProfileUpdater, messageWorkDataDAO);
        this._as2ObjectFactory = as2ObjectFactory;
        this.setLogger(_log);
    }

    @Override
    protected CppPartner identifyReceiver() throws ASException {
        CppPartner receiver = null;
        try {
            String as2To = this._incomingMessage.getTo();
            String receiverLocalId = this._profiles.getLocalId("AS2-Name", as2To);
            if (receiverLocalId == null) {
                _log.error("Receiver's AS2Name is not known to the System '{}'", (Object)as2To);
                throw new ASException(43000, "AS2Name " + as2To + " is unknown");
            }
            this._xpMessage.setReceiverLocalId(receiverLocalId);
            receiver = this._profiles.getProfileForLocalId(this._xpMessage.getReceiverLocalId(), true);
            if (receiver.isRemote()) {
                _log.fatal("Receiver is a remote partner. Reception denied. localId={}", (Object)receiver.getLocalId());
                throw new ASException(43000, "Receiver is a remote partner. Reception denied.");
            }
            if (receiver.isDisabled()) {
                _log.fatal("Receiver is disabled. Reception denied. localId={}", (Object)receiver.getLocalId());
                throw new ASException(43000, "Receive is disabled. Reception denied.");
            }
        }
        catch (ProfileNotFoundException e) {
            _log.error("Receiver is not known to the System. {}", (Object)e.toString());
            throw new ASException(43000, "Receiver is not known to the System.");
        }
        catch (ProfileException e) {
            _log.fatal("Could not access Receiver information from local data: {}", (Object)e.toString());
            throw new ASException(43000, "Could not access Receiver information from local data: " + String.valueOf(e));
        }
        return receiver;
    }

    @Override
    protected CppPartner identifySender() throws ASException {
        CppPartner sender = null;
        try {
            String as2From = this._incomingMessage.getFrom();
            String senderLocalId = this._profiles.getLocalId("AS2-Name", as2From);
            if (senderLocalId == null) {
                _log.error("Sender's AS2Name is not known to the System '{}'", (Object)as2From);
                throw new ASException(43000, "AS2Name " + as2From + " is unknown");
            }
            this._xpMessage.setSenderLocalId(senderLocalId);
            sender = this._profiles.getProfileForLocalId(this._xpMessage.getSenderLocalId(), true);
            if (sender.isDisabled()) {
                _log.fatal("Sender is disabled. Reception denied. localId={}", (Object)sender.getLocalId());
                throw new ASException(43000, "Sender is disabled. Reception denied.");
            }
        }
        catch (ProfileNotFoundException e) {
            _log.error("Sender is not known to the System. {}", (Object)e.toString());
            throw new ASException(43000, "Sender is not known to the System.");
        }
        catch (ProfileException e) {
            _log.fatal("Could not access Sender information from local data: {}", (Object)e.toString());
            throw new ASException(43000, "Could not access Sender information from local data: " + e.getMessage());
        }
        return sender;
    }

    @Override
    protected ASReport createOkReport(String statusDescription) {
        AS2Report report = this._as2ObjectFactory.createOKReport((ASMessage)this._incomingMessage, statusDescription);
        report.setMessengerLog(this._messengerLog);
        return report;
    }

    @Override
    protected ASReport createErrorReport(ASReport.DispositionModifier dispositionModifier, ASReport.DispositionModifierExtension dispositionModifierExtension, String statusDescription, List<String> details) {
        AS2Report report = this._as2ObjectFactory.createErrorReport((ASMessage)this._incomingMessage, dispositionModifier, dispositionModifierExtension, statusDescription, details);
        report.setMessengerLog(this._messengerLog);
        return report;
    }

    @Override
    protected MessageDigestCalculator createMessageDigestCalculator(String digestAlgorithm) throws SecurityException {
        return new MessageDigestCalculator(this._incomingMessage.getMimePart(), this._includeHeaderInDigestCalculation, digestAlgorithm, false);
    }

    @Override
    void validateSupportedPackager(XpMessage xpMessage) throws ASException {
        if (!"AS2".equals(xpMessage.getCommunication().getPackagingId())) {
            _log.error("Agreement supports {} and not AS2.", (Object)xpMessage.getCommunication().getPackagingId());
            throw new ASException(43000, "Agreement supports only " + xpMessage.getCommunication().getPackagingId() + ".");
        }
    }
}

