/*
 * Decompiled with CFR 0.152.
 */
package de.pontonconsulting.xmlpipe.listener;

import de.ponton.xmlpipe.queue.OutboundQueue;
import de.pontonconsulting.xmlpipe.as.AS1ObjectFactory;
import de.pontonconsulting.xmlpipe.as.AS1Report;
import de.pontonconsulting.xmlpipe.as.ASException;
import de.pontonconsulting.xmlpipe.as.ASMessage;
import de.pontonconsulting.xmlpipe.as.ASReport;
import de.pontonconsulting.xmlpipe.as.IAS1Object;
import de.pontonconsulting.xmlpipe.config.IFolders;
import de.pontonconsulting.xmlpipe.config.MessengerConfig;
import de.pontonconsulting.xmlpipe.cpa.Agreements;
import de.pontonconsulting.xmlpipe.cpp.CppPartner;
import de.pontonconsulting.xmlpipe.cpp.ProfileException;
import de.pontonconsulting.xmlpipe.cpp.ProfileNotFoundException;
import de.pontonconsulting.xmlpipe.cpp.Profiles;
import de.pontonconsulting.xmlpipe.listener.ASProcessingResult;
import de.pontonconsulting.xmlpipe.listener.ASProcessor;
import de.pontonconsulting.xmlpipe.listener.ErrorNotificationService;
import de.pontonconsulting.xmlpipe.listener.IASProcessor;
import de.pontonconsulting.xmlpipe.message.XpMessage;
import de.pontonconsulting.xmlpipe.messenger.IdGenerator;
import de.pontonconsulting.xmlpipe.messenger.ReceiveFromListener;
import de.pontonconsulting.xmlpipe.messenger.ReferenceDateTask;
import de.pontonconsulting.xmlpipe.messenger.archive.ArchiveProcessor;
import de.pontonconsulting.xmlpipe.messenger.database.tables.FileRefDAO;
import de.pontonconsulting.xmlpipe.messenger.database.tables.MDNDataDAO;
import de.pontonconsulting.xmlpipe.messenger.database.tables.MessageDAO;
import de.pontonconsulting.xmlpipe.messenger.database.tables.MessageWorkDataDAO;
import de.pontonconsulting.xmlpipe.messenger.database.tables.MessengerLog;
import de.pontonconsulting.xmlpipe.registry.RegistryProfileUpdater;
import de.pontonconsulting.xmlpipe.security.CertificateUtility;
import de.pontonconsulting.xmlpipe.security.MessageDigestCalculator;
import de.pontonconsulting.xmlpipe.security.SecurityException;
import de.pontonconsulting.xmlpipe.security.smime.SMIMEDecompressor;
import de.pontonconsulting.xmlpipe.security.smime.SMIMEDecrypter;
import de.pontonconsulting.xmlpipe.security.smime.SMIMEVerifier;
import jakarta.mail.Header;
import jakarta.mail.internet.InternetAddress;
import jakarta.mail.internet.MimeBodyPart;
import jakarta.mail.internet.MimeMessage;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.InputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class AS1Processor
extends ASProcessor
implements IASProcessor {
    private static final Logger _log = LogManager.getLogger((String)"Messenger.AS1Processor");
    protected final OutboundQueue _outboundMessageQueue;
    protected final AS1ObjectFactory _as1ObjectFactory;

    public AS1Processor(Agreements agreements, MessengerConfig messengerConfig, Profiles profiles, ReceiveFromListener receiveFromListener, ReferenceDateTask referenceDate, MessengerLog messengerLog, MessageDAO messageDAO, FileRefDAO fileRefDAO, MDNDataDAO mdnDataDAO, IFolders folders, IdGenerator idGenerator, ArchiveProcessor archiveProcessor, CertificateUtility certificateUtility, ErrorNotificationService errorNotificationService, SMIMEVerifier smimeVerifier, SMIMEDecrypter smimeDecrypter, SMIMEDecompressor smimeDecompressor, RegistryProfileUpdater registryProfileUpdater, OutboundQueue outboundMessageQueue, AS1ObjectFactory as1ObjectFactory, MessageWorkDataDAO messageWorkDataDAO) {
        super(agreements, messengerConfig, profiles, receiveFromListener, referenceDate, messengerLog, messageDAO, fileRefDAO, mdnDataDAO, folders, idGenerator, archiveProcessor, certificateUtility, errorNotificationService, smimeVerifier, smimeDecrypter, smimeDecompressor, registryProfileUpdater, messageWorkDataDAO);
        this._outboundMessageQueue = outboundMessageQueue;
        this._as1ObjectFactory = as1ObjectFactory;
        this.setLogger(_log);
    }

    public ASProcessingResult processRequest(MimeMessage mimeMessage, String protocol) {
        ASProcessingResult result = new ASProcessingResult();
        try {
            String[] server;
            String[] agent = mimeMessage.getHeader("User-Agent");
            if (agent != null && agent.length > 0) {
                _log.debug("http-user-agent: {}", (Object)agent[0]);
            }
            if ((server = mimeMessage.getHeader("Server")) != null && server.length > 0) {
                _log.debug("http-server: {}", (Object)server[0]);
            }
            ASReport resultReport = null;
            IAS1Object as1Object = this._as1ObjectFactory.createAS1Object(mimeMessage);
            if (as1Object instanceof ASReport) {
                this.processReport((ASReport)((Object)as1Object), protocol);
            } else {
                resultReport = this.processMessage((ASMessage)((Object)as1Object), protocol);
            }
            if (resultReport == null || !"Failure".equalsIgnoreCase(resultReport.getMDN().getDispositionModifier()) && !"Error".equalsIgnoreCase(resultReport.getMDN().getDispositionModifier())) {
                result.setSuccess(true);
            }
            if (resultReport != null) {
                this.sendAsynchronousReply(resultReport);
            }
        }
        catch (Exception e) {
            _log.fatal("Unexpected end of message processing. {}", (Object)e.toString());
            result.setSendMDN(true);
        }
        result.setIncomingXpMessage(this._xpMessage);
        return result;
    }

    @Override
    protected CppPartner identifyReceiver() throws ASException {
        CppPartner receiver = null;
        try {
            receiver = this.identifyPartnerByEmailAdress(((IAS1Object)((Object)this._incomingMessage)).getToEMailAddresses());
            this._xpMessage.setReceiverLocalId(receiver.getLocalId());
            if (receiver.isRemote()) {
                _log.fatal("Receiver is a remote partner. Reception denied. localId={}", (Object)receiver.getLocalId());
                throw new ASException(43000, "Receiver is a remote partner. Reception denied.");
            }
            if (receiver.isDisabled()) {
                _log.fatal("Receiver is disabled. Reception denied. localId={}", (Object)receiver.getLocalId());
                throw new ASException(43000, "Receive is disabled. Reception denied.");
            }
        }
        catch (ProfileNotFoundException e) {
            _log.error("Receiver is not known to the System. {}", (Object)e.toString());
            throw new ASException(43000, "Receiver is not known to the System.");
        }
        catch (ProfileException e) {
            _log.fatal("Could not access Receiver information from local data: {}", (Object)e.getMessage());
            throw new ASException(43000, "Could not access Receiver information from local data: " + e.getMessage());
        }
        return receiver;
    }

    @Override
    protected CppPartner identifySender() throws ASException {
        CppPartner sender = null;
        try {
            sender = this.identifyPartnerByEmailAdress(((IAS1Object)((Object)this._incomingMessage)).getFromEMailAddresses());
            this._xpMessage.setSenderLocalId(sender.getLocalId());
            if (sender.isDisabled()) {
                _log.fatal("Sender is disabled. Reception denied. localId={}", (Object)sender.getLocalId());
                throw new ASException(43000, "Sender is disabled. Reception denied.");
            }
        }
        catch (ProfileNotFoundException e) {
            _log.error("Sender is not known to the System. {}", (Object)e.toString());
            throw new ASException(43000, "Sender is not known to the System.");
        }
        catch (ProfileException e) {
            _log.fatal("Could not access Sender information from local data: {}", (Object)e.getMessage());
            throw new ASException(43000, "Could not access Sender information from local data: " + e.getMessage());
        }
        return sender;
    }

    private CppPartner identifyPartnerByEmailAdress(InternetAddress[] emails) throws ProfileException {
        CppPartner partner = null;
        for (InternetAddress email : emails) {
            String id = this._profiles.getLocalId("E-Mail", email.getAddress());
            if (!StringUtils.isNotEmpty((CharSequence)id)) continue;
            partner = this._profiles.getProfileForLocalId(id, true);
            break;
        }
        if (partner == null) {
            StringBuilder error = new StringBuilder("No partner found with an email address out of the list: [");
            for (int i = 0; i < emails.length; ++i) {
                error.append(emails[i]);
                if (i + 1 >= emails.length) continue;
                error.append(",");
            }
            error.append("];");
            throw new ProfileNotFoundException(23000, error.toString());
        }
        return partner;
    }

    private void sendAsynchronousReply(ASReport report) {
        _log.debug("Preparing asynchronous response");
        report.getXpMessage().setProtocol("MAILTO");
        File work = new File(this._folders.getWorkOutboundFolder(), String.valueOf(report.getXpMessage().getDatabaseId()));
        work.mkdirs();
        File messageFile = new File(work, "xp_message.dat");
        File messageHeaderFile = new File(work, "xp_message_header.dat");
        try {
            Object destinationUri;
            MimeBodyPart response = report.getReportMimePart();
            try (BufferedOutputStream messageOut = new BufferedOutputStream(Files.newOutputStream(messageFile.toPath(), new OpenOption[0]));
                 BufferedOutputStream headersOut = new BufferedOutputStream(Files.newOutputStream(messageHeaderFile.toPath(), new OpenOption[0]));
                 InputStream in = response.getInputStream();
                 ObjectOutputStream oos = new ObjectOutputStream(headersOut);){
                in.transferTo(messageOut);
                ((OutputStream)messageOut).flush();
                response.addHeader("Content-Length", "" + messageFile.length());
                HashMap<String, String> header2 = this.convertInternetHeadersToHashMap(response.getAllHeaders());
                oos.writeObject(header2);
            }
            _log.debug("Sending Async response");
            if (report.getXpMessage().getAdapterId() == null) {
                report.getXpMessage().setAdapterId("NullAdapter");
            }
            if (((destinationUri = report.getMDNParameters().getDispositionNotificationTo()) == null || ((String)destinationUri).length() == 0) && ((String)(destinationUri = report.getXpMessage().getCommunication().getTransportURL())).startsWith("smime:")) {
                destinationUri = ((String)destinationUri).substring(6);
            }
            if (destinationUri != null && ((String)destinationUri).indexOf(58) == -1) {
                destinationUri = "mailto:" + (String)destinationUri;
            }
            if (destinationUri == null || ((String)destinationUri).length() == 0) {
                this._messengerLog.log2db(518, report.getXpMessage().getDatabaseId(), "Could not set recipient url of asynchronous reply.");
                throw new Exception("Could not set recipient url of asynchronous reply.");
            }
            XpMessage xpMessage = report.getXpMessage();
            xpMessage.setDestinationUrl((String)destinationUri);
            this._outboundMessageQueue.deliverMessageToPartner(report.getXpMessage());
        }
        catch (Exception e) {
            _log.fatal("Unable to send asynchronous reply", (Throwable)e);
        }
    }

    protected HashMap<String, String> convertInternetHeadersToHashMap(Enumeration<?> headersEnum) {
        HashMap<String, String> result = new HashMap<String, String>();
        while (headersEnum.hasMoreElements()) {
            Header header = (Header)headersEnum.nextElement();
            String value = header.getValue();
            result.put(header.getName(), value);
        }
        return result;
    }

    @Override
    protected ASReport createOkReport(String statusDescription) {
        AS1Report report = this._as1ObjectFactory.createOKReport((ASMessage)this._incomingMessage, statusDescription);
        report.setMessengerLog(this._messengerLog);
        return report;
    }

    @Override
    protected ASReport createErrorReport(ASReport.DispositionModifier dispositionModifier, ASReport.DispositionModifierExtension dispositionModifierExtension, String statusDescription, List<String> details) {
        AS1Report report = this._as1ObjectFactory.createErrorReport((ASMessage)this._incomingMessage, dispositionModifier, dispositionModifierExtension, statusDescription, details);
        report.setMessengerLog(this._messengerLog);
        report.getMDNParameters().setDispositionNotificationTo(this._incomingMessage.getFrom());
        return report;
    }

    @Override
    protected MessageDigestCalculator createMessageDigestCalculator(String digestAlgorithm) throws SecurityException {
        return new MessageDigestCalculator(this._incomingMessage.getMimePart(), this._includeHeaderInDigestCalculation, digestAlgorithm, false);
    }

    @Override
    void validateSupportedPackager(XpMessage xpMessage) throws ASException {
        if (!xpMessage.isAck() && !"AS1".equals(xpMessage.getCommunication().getPackagingId())) {
            _log.error("Agreement supports {} and not AS1.", (Object)xpMessage.getCommunication().getPackagingId());
            throw new ASException(43000, "Agreement supports only " + xpMessage.getCommunication().getPackagingId() + ".");
        }
    }
}

