/*
 * Decompiled with CFR 0.152.
 */
package de.pontonconsulting.xmlpipe.events;

import de.ponton.xmlpipe.websocket.WebsocketClient;
import de.pontonconsulting.xmlpipe.adapter.EventNotifier;
import de.pontonconsulting.xmlpipe.cluster.GlobalTaskManager;
import de.pontonconsulting.xmlpipe.cpa.Agreements;
import de.pontonconsulting.xmlpipe.cpp.Profiles;
import de.pontonconsulting.xmlpipe.listener.MailListener;
import de.pontonconsulting.xmlpipe.messenger.MaintenanceManager;
import de.pontonconsulting.xmlpipe.messenger.Messenger;
import de.pontonconsulting.xmlpipe.messenger.ReferenceDateTask;
import de.pontonconsulting.xmlpipe.messenger.archive.ArchiveProcessor;
import de.pontonconsulting.xmlpipe.messenger.database.DatabaseBean;
import de.pontonconsulting.xmlpipe.messenger.emailnotification.EMailNotification;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public enum ServiceLevel {
    LEVEL_1,
    LEVEL_2,
    LEVEL_3,
    LEVEL_4,
    LEVEL_5,
    LEVEL_6,
    LEVEL_7,
    LEVEL_8,
    LEVEL_9,
    LEVEL_10,
    LEVEL_11,
    LEVEL_12;

    private static final Map<Class<?>, ServiceLevel> LOOKUP_TABLE;
    public static final List<ServiceLevel> SERVICE_LEVELS;

    public static ServiceLevel getServiceLevel(Class<?> clazz) {
        ServiceLevel serviceLevel = LOOKUP_TABLE.get(clazz);
        if (serviceLevel == null) {
            throw new IllegalArgumentException("No Service Level found for the class " + clazz.getName());
        }
        return serviceLevel;
    }

    static {
        LOOKUP_TABLE = new HashMap();
        LOOKUP_TABLE.put(DatabaseBean.class, LEVEL_1);
        LOOKUP_TABLE.put(Messenger.class, LEVEL_2);
        LOOKUP_TABLE.put(EventNotifier.class, LEVEL_3);
        LOOKUP_TABLE.put(ReferenceDateTask.class, LEVEL_4);
        LOOKUP_TABLE.put(EMailNotification.class, LEVEL_5);
        LOOKUP_TABLE.put(GlobalTaskManager.class, LEVEL_6);
        LOOKUP_TABLE.put(Profiles.class, LEVEL_7);
        LOOKUP_TABLE.put(Agreements.class, LEVEL_8);
        LOOKUP_TABLE.put(MaintenanceManager.class, LEVEL_9);
        LOOKUP_TABLE.put(MailListener.class, LEVEL_10);
        LOOKUP_TABLE.put(WebsocketClient.class, LEVEL_11);
        LOOKUP_TABLE.put(ArchiveProcessor.class, LEVEL_12);
        ArrayList<ServiceLevel> serviceLevels = new ArrayList<ServiceLevel>();
        serviceLevels.add(LEVEL_1);
        serviceLevels.add(LEVEL_2);
        serviceLevels.add(LEVEL_3);
        serviceLevels.add(LEVEL_4);
        serviceLevels.add(LEVEL_5);
        serviceLevels.add(LEVEL_6);
        serviceLevels.add(LEVEL_7);
        serviceLevels.add(LEVEL_8);
        serviceLevels.add(LEVEL_9);
        serviceLevels.add(LEVEL_10);
        serviceLevels.add(LEVEL_11);
        serviceLevels.add(LEVEL_12);
        SERVICE_LEVELS = Collections.unmodifiableList(serviceLevels);
    }
}

