/*
 * Decompiled with CFR 0.152.
 */
package de.pontonconsulting.xmlpipe.cpp;

import de.pontonconsulting.common.security.IPasswordCrypt;
import de.pontonconsulting.common.util.CacheEntry;
import de.pontonconsulting.xmlpipe.Constants;
import de.pontonconsulting.xmlpipe.admintool.partner.update.ProfileUpdate;
import de.pontonconsulting.xmlpipe.config.DistributionConfigFinder;
import de.pontonconsulting.xmlpipe.config.IServerConfigBean;
import de.pontonconsulting.xmlpipe.config.KeystoreBean;
import de.pontonconsulting.xmlpipe.config.SchemaData;
import de.pontonconsulting.xmlpipe.config.SchemataConfig;
import de.pontonconsulting.xmlpipe.config.XpValidationEventHandler;
import de.pontonconsulting.xmlpipe.config.partnerprofile.Certificate;
import de.pontonconsulting.xmlpipe.config.partnerprofile.Certificates;
import de.pontonconsulting.xmlpipe.config.partnerprofile.Contact;
import de.pontonconsulting.xmlpipe.config.partnerprofile.ContactInformations;
import de.pontonconsulting.xmlpipe.config.partnerprofile.DefaultCertificate;
import de.pontonconsulting.xmlpipe.config.partnerprofile.Document;
import de.pontonconsulting.xmlpipe.config.partnerprofile.Messenger;
import de.pontonconsulting.xmlpipe.config.partnerprofile.Package;
import de.pontonconsulting.xmlpipe.config.partnerprofile.Packaging;
import de.pontonconsulting.xmlpipe.config.partnerprofile.Partner;
import de.pontonconsulting.xmlpipe.config.partnerprofile.PartyIds;
import de.pontonconsulting.xmlpipe.config.partnerprofile.PayloadDocuments;
import de.pontonconsulting.xmlpipe.config.partnerprofile.Pipeline;
import de.pontonconsulting.xmlpipe.config.partnerprofile.ProcessingPipelines;
import de.pontonconsulting.xmlpipe.config.partnerprofile.Transport;
import de.pontonconsulting.xmlpipe.config.partnerprofile.Transports;
import de.pontonconsulting.xmlpipe.config.partnerprofile.X509Certificate;
import de.pontonconsulting.xmlpipe.config.privatepartnerprofile.CertificateStatus;
import de.pontonconsulting.xmlpipe.config.privatepartnerprofile.MaintenancePeriod;
import de.pontonconsulting.xmlpipe.config.privatepartnerprofile.ObjectFactory;
import de.pontonconsulting.xmlpipe.config.privatepartnerprofile.PrivateKeyPassword;
import de.pontonconsulting.xmlpipe.config.privatepartnerprofile.PrivatePartner;
import de.pontonconsulting.xmlpipe.cp.AdditionalSchema;
import de.pontonconsulting.xmlpipe.cp.DocumentType;
import de.pontonconsulting.xmlpipe.cp.DocumentTypeResolver;
import de.pontonconsulting.xmlpipe.cp.Option;
import de.pontonconsulting.xmlpipe.cp.PartyId;
import de.pontonconsulting.xmlpipe.cpa.AgreementException;
import de.pontonconsulting.xmlpipe.cpa.update.AgreementUpdateUtility;
import de.pontonconsulting.xmlpipe.cpp.CertificateIdNotFoundException;
import de.pontonconsulting.xmlpipe.cpp.CppContactInformation;
import de.pontonconsulting.xmlpipe.cpp.IdNotFoundException;
import de.pontonconsulting.xmlpipe.cpp.OptionNotFoundException;
import de.pontonconsulting.xmlpipe.cpp.PackageIdNotFoundException;
import de.pontonconsulting.xmlpipe.cpp.PipelineIdNotFoundException;
import de.pontonconsulting.xmlpipe.cpp.ProfileException;
import de.pontonconsulting.xmlpipe.cpp.ProfileStoreAccessException;
import de.pontonconsulting.xmlpipe.cpp.Profiles;
import de.pontonconsulting.xmlpipe.cpp.TransportIdNotFoundException;
import de.pontonconsulting.xmlpipe.cpp.util.PrivateKeyPasswordPredicate;
import de.pontonconsulting.xmlpipe.cpp.util.PrivateKeyPredicate;
import de.pontonconsulting.xmlpipe.cpp.util.X509CertificatePredicate;
import de.pontonconsulting.xmlpipe.messenger.IPipelineFactory;
import de.pontonconsulting.xmlpipe.messenger.ReferenceDateTask;
import de.pontonconsulting.xmlpipe.messenger.RemoteMaintenanceInterval;
import de.pontonconsulting.xmlpipe.messenger.database.tables.PartnerProfileDAO;
import de.pontonconsulting.xmlpipe.messenger.migration.ConfigMigrationService;
import de.pontonconsulting.xmlpipe.messenger.packaging.IPackagingManager;
import de.pontonconsulting.xmlpipe.security.CertificateRequest;
import de.pontonconsulting.xmlpipe.security.CertificateUtility;
import de.pontonconsulting.xmlpipe.security.CryptoFactory;
import de.pontonconsulting.xmlpipe.security.CryptoUtil;
import de.pontonconsulting.xmlpipe.security.util.SignCertInfo;
import de.pontonconsulting.xmlpipe.uiconfig.UIConfig;
import de.pontonconsulting.xmlpipe.uioption.UIOption;
import de.pontonconsulting.xmlpipe.util.IOUtil;
import jakarta.xml.bind.JAXBContext;
import jakarta.xml.bind.JAXBException;
import jakarta.xml.bind.Marshaller;
import jakarta.xml.bind.Unmarshaller;
import jakarta.xml.bind.ValidationEventHandler;
import jakarta.xml.bind.util.ValidationEventCollector;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.security.GeneralSecurityException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateNotYetValidException;
import java.security.interfaces.RSAKey;
import java.security.spec.InvalidKeySpecException;
import java.text.MessageFormat;
import java.time.Instant;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.Predicate;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.wss4j.common.crypto.Crypto;
import org.bouncycastle.operator.OperatorCreationException;
import org.bouncycastle.pkcs.PKCS8EncryptedPrivateKeyInfo;
import org.bouncycastle.pkcs.PKCSException;

public class CppPartner
implements Comparable<CppPartner>,
CacheEntry {
    private static final Log log = LogFactory.getLog((String)"Messenger.CppPartner");
    private static final String PROFILES_CONFIG_CLASSES = "de.pontonconsulting.xmlpipe.config.partnerprofile";
    private static final String PRIVATE_PROFILES_CONFIG_CLASSES = "de.pontonconsulting.xmlpipe.config.privatepartnerprofile";
    private static final String CERTIFICATE_ID_PREFIX = "c";
    private static JAXBContext JC_PUBLIC;
    private static JAXBContext JC_PRIVATE;
    private List<DocumentType> documentTypes = null;
    private Map<String, List<DocumentType>> schemaSets = null;
    private static final String PARTNER_CERT_ALIAS_SEPARATOR = "_";
    private final boolean readOnly = false;
    private OffsetDateTime lastChange;
    private Partner profile;
    private PrivatePartner privateProfile;
    private URL publicPart;
    private File filePrivate;
    private static final de.pontonconsulting.xmlpipe.config.partnerprofile.ObjectFactory factoryPublic;
    private static final ObjectFactory factoryPrivate;
    private final Map<String, java.security.cert.X509Certificate> allCertificates = new TreeMap<String, java.security.cert.X509Certificate>();
    private final Map<String, PrivateKey> privateKeys = new TreeMap<String, PrivateKey>();
    private final AtomicReference<Crypto> crypto = new AtomicReference();
    private final Map<String, Transport> allTransportIds = new TreeMap<String, Transport>();
    private final Map<String, Transport> allTransportUrls = new TreeMap<String, Transport>();
    private final Map<String, Option> transportOptionLookup = new TreeMap<String, Option>();
    private boolean transportDirty;
    private final Map<String, Package> allPackagingIds = new TreeMap<String, Package>();
    private final Map<String, Option> packagingOptionLookup = new TreeMap<String, Option>();
    private boolean packagingDirty;
    private final Map<String, Pipeline> allPipelineIds = new TreeMap<String, Pipeline>();
    private final Map<String, Option> pipelineOptionLookup = new TreeMap<String, Option>();
    private boolean pipelineDirty;
    private IServerConfigBean serverConfig;
    private ConfigMigrationService configMigrationService;
    private DistributionConfigFinder distributionConfigFinder;
    private Profiles profiles;
    private KeystoreBean keystoreBean;
    private IPasswordCrypt passwordCrypt;
    private SchemataConfig schemataConfig;
    private UIConfig uiConfig;
    private IPipelineFactory pipelineFactory;
    private IPackagingManager packagingManager;
    private AgreementUpdateUtility agreementUpdateUtility;
    private ReferenceDateTask referenceDateTask;
    private ProfileUpdate profileUpdate;
    private DocumentTypeResolver documentTypeResolver;
    private CertificateUtility certificateUtility;
    private PartnerProfileDAO partnerProfileDAO;
    private CryptoFactory cryptoFactory;

    public void init(String localId, String internalId, String displayname, boolean remote) {
        this.profile = factoryPublic.createPartner();
        this.privateProfile = factoryPrivate.createPrivatePartner();
        this.privateProfile.setLocalId(localId);
        this.privateProfile.setDisabled(Boolean.FALSE);
        this.profile.setDisplayName(displayname);
        this.privateProfile.setRemote(Boolean.valueOf(remote));
        this.privateProfile.setInternalId(internalId);
        this.privateProfile.setDisplayName(displayname);
        this.privateProfile.setRegistry(factoryPrivate.createRegistry());
        this.privateProfile.getRegistry().setAutoupdate(Boolean.FALSE);
        this.privateProfile.getRegistry().setAgreementAutoupdate(Boolean.FALSE);
        this.privateProfile.getRegistry().setRemoteFile("");
        PartyIds partyIds = factoryPublic.createPartyIds();
        this.profile.setPartyIds(partyIds);
        List<String> defaultPartyIdTypes = this.distributionConfigFinder.getDefaultPartyIdTypes();
        for (String defaultPartyIdType : defaultPartyIdTypes) {
            this.addPartyId(defaultPartyIdType, internalId);
        }
        Certificates certs = factoryPublic.createCertificates();
        this.profile.setCertificates(certs);
        Transports transports = factoryPublic.createTransports();
        this.profile.setTransports(transports);
        this.createPackaging(this.profile);
        this.setPreferredPackagingId(this.profile);
        this.createProcessingPipelines(this.profile);
        this.setPreferredPipelineId(this.profile);
        PayloadDocuments documents = factoryPublic.createPayloadDocuments();
        this.profile.setPayloadDocuments(documents);
        Messenger messengerInfo = factoryPublic.createMessenger();
        messengerInfo.setVendorName(Constants.getXP_VENDOR());
        messengerInfo.setProductName(Constants.getXP_NAME());
        messengerInfo.setProductVersion(Constants.getXP_VERSION());
        this.profile.setMessenger(messengerInfo);
        this.updateLookupTables();
        this.loadTempKeysFromProfile();
    }

    private void loadTempKeysFromProfile() {
        this.privateProfile.getPrivateKey().stream().filter(key -> key.getAlias() != null && key.getAlias().startsWith("temp_$")).forEach(key -> this.privateProfile.getPrivateKeyPassword().stream().filter(pass -> pass.getAlias() != null && pass.getAlias().equals(key.getAlias())).findFirst().ifPresent(password -> {
            try {
                this.privateKeys.put(key.getAlias(), this.getPrivateKey(this.passwordCrypt.decryptPassword(password.getValue()), key.getAlias()));
            }
            catch (GeneralSecurityException e) {
                log.debug((Object)MessageFormat.format("Password for key {0} did not work", key.getAlias()), (Throwable)e);
            }
        }));
    }

    void init(String localId, InputStream publicPartInputStream, InputStream privatePartInputStream) throws ProfileException {
        if (localId == null || localId.isEmpty()) {
            throw new ProfileException(34001, "Could not create instance.");
        }
        try {
            this.readPublicFile(publicPartInputStream);
        }
        catch (JAXBException je) {
            log.error((Object)("init failed on public part with error: " + String.valueOf((Object)je)));
            throw new ProfileException(34001, "Could not create instance.", je);
        }
        try {
            this.readPrivateFile(privatePartInputStream);
        }
        catch (JAXBException je) {
            log.error((Object)("init failed on private part with error: " + String.valueOf((Object)je)));
            throw new ProfileException(34001, "Could not create instance.", je);
        }
        this.updateLookupTables();
    }

    public boolean doUpdates(boolean readOnly) {
        boolean changed = false;
        this.updateLookupTables();
        this.loadTempKeysFromProfile();
        this.loadDocumentTypes();
        this.determineSchemaSets();
        if (!readOnly && this.isUpdateAllowed()) {
            try {
                changed = this.profileUpdate.update(this);
                if (changed) {
                    this.saveToDB();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this.configMigrationService.migratePartner(this)) {
            changed = true;
        }
        return changed;
    }

    public void init(URL publicPart, URL privatePart, String localId) throws ProfileException {
        try {
            this.readPublicPart(publicPart);
        }
        catch (JAXBException je) {
            log.error((Object)("init failed on public part " + publicPart.toExternalForm() + " with error:" + String.valueOf((Object)je)));
            throw new ProfileException(34001, "Could not create instance.", je);
        }
        try {
            this.readPrivateFile(privatePart, localId);
        }
        catch (JAXBException je) {
            log.error((Object)("init failed on private part " + publicPart.toExternalForm() + " with error:" + String.valueOf((Object)je)));
            throw new ProfileException(34001, "Could not create instance.", je);
        }
    }

    public boolean isUpdateAllowed() {
        return !this.isRemote() || !this.isAutoupdate() || this.getRemoteFile() == null || this.getRemoteFile().isEmpty();
    }

    private void createProcessingPipelines(Partner profile) {
        ProcessingPipelines pipelinesType = factoryPublic.createProcessingPipelines();
        List pipelines = pipelinesType.getPipeline();
        String[] pipelineIds = this.pipelineFactory.getPipelineIds();
        if (pipelineIds == null) {
            pipelineIds = new String[]{};
        }
        for (String pipelineId : pipelineIds) {
            Pipeline pipelineType = factoryPublic.createPipeline();
            pipelineType.setId(pipelineId);
            pipelines.add(pipelineType);
        }
        profile.setProcessingPipelines(pipelinesType);
    }

    private void setPreferredPipelineId(Partner profile) {
        Pipeline pipelineType;
        boolean preferredSet = false;
        List pipelines = profile.getProcessingPipelines().getPipeline();
        for (Pipeline pipeline : pipelines) {
            pipelineType = pipeline;
            if (!"NONE".equals(pipelineType.getId())) continue;
            pipelineType.setPreferred(Boolean.TRUE);
            preferredSet = true;
        }
        if (!preferredSet && !pipelines.isEmpty()) {
            pipelineType = (Pipeline)pipelines.getFirst();
            pipelineType.setPreferred(Boolean.TRUE);
        }
    }

    private void addPipeline(String pipelineId) {
        ProcessingPipelines pipelinesType = this.profile.getProcessingPipelines();
        List pipelines = pipelinesType.getPipeline();
        Pipeline pipelineType = factoryPublic.createPipeline();
        pipelineType.setId(pipelineId);
        pipelines.add(pipelineType);
        this.profile.setProcessingPipelines(pipelinesType);
        this.updateLookupTables();
    }

    private void deletePipeline(String pipelineId) {
        ProcessingPipelines pipelinesType = this.profile.getProcessingPipelines();
        List pipelines = pipelinesType.getPipeline();
        ArrayList pipelines_copy = new ArrayList(pipelines);
        for (Pipeline pipelineType : pipelines_copy) {
            if (!pipelineType.getId().equals(pipelineId)) continue;
            pipelines.remove(pipelineType);
        }
        this.profile.setProcessingPipelines(pipelinesType);
        this.allPipelineIds.remove(pipelineId);
        this.updateLookupTables();
    }

    private void createPackaging(Partner profile) {
        Packaging packaging = factoryPublic.createPackaging();
        List packages = packaging.getPackage();
        String[] packagingIds = this.packagingManager.getPackagingIds();
        if (packagingIds == null) {
            packagingIds = new String[]{};
        }
        for (String packagingId : packagingIds) {
            Package packageType = factoryPublic.createPackage();
            packageType.setId(packagingId);
            packages.add(packageType);
        }
        profile.setPackaging(packaging);
    }

    private void setPreferredPackagingId(Partner profile) {
        Package packageType;
        boolean preferredSet = false;
        List packages = profile.getPackaging().getPackage();
        for (Package aPackage : packages) {
            packageType = aPackage;
            if (!"EbXml20".equals(packageType.getId())) continue;
            packageType.setPreferred(Boolean.TRUE);
            preferredSet = true;
            break;
        }
        if (!preferredSet && !packages.isEmpty()) {
            packageType = (Package)packages.getFirst();
            packageType.setPreferred(Boolean.TRUE);
        }
    }

    private void addPackage(String packagingId) {
        Packaging packaging = this.profile.getPackaging();
        List packages = packaging.getPackage();
        Package packageType = factoryPublic.createPackage();
        packageType.setId(packagingId);
        packages.add(packageType);
        this.profile.setPackaging(packaging);
        this.updateLookupTables();
    }

    private void deletePackage(String packagingId) {
        Packaging packaging = this.profile.getPackaging();
        List packages = packaging.getPackage();
        ArrayList packages_copy = new ArrayList(packages);
        for (Package packageType : packages_copy) {
            if (!packageType.getId().equals(packagingId)) continue;
            packages.remove(packageType);
        }
        this.profile.setPackaging(packaging);
        this.allPackagingIds.remove(packagingId);
        this.updateLookupTables();
    }

    public void deletePipelines() {
        for (String pipelineId : this.getPipelineIds()) {
            this.deletePipeline(pipelineId);
        }
    }

    public boolean deleteUnknownPipelines() {
        String[] prntPipelineIds;
        boolean changed = false;
        Set<String> msngPipelineIds = Set.of(this.pipelineFactory.getPipelineIds());
        for (String pipelineId : prntPipelineIds = this.getPipelineIds()) {
            String prntPipelineId = pipelineId;
            if (msngPipelineIds.contains(prntPipelineId)) continue;
            this.deletePipeline(prntPipelineId);
            changed = true;
        }
        return changed;
    }

    public boolean addPipelines() {
        boolean changed = false;
        String[] msngPipelineIds = this.pipelineFactory.getPipelineIds();
        String[] prntPipelineIds = this.getPipelineIds();
        List<String> prntPipelineIds_asList = Arrays.asList(prntPipelineIds);
        for (String pipelineId : msngPipelineIds) {
            String msngPipelineId = pipelineId;
            if (prntPipelineIds_asList.contains(msngPipelineId)) continue;
            try {
                this.addPipeline(msngPipelineId);
                this.setAllPipelineOptionsForId(msngPipelineId, true);
                changed = true;
            }
            catch (PipelineIdNotFoundException pipelineIdNotFoundException) {
                // empty catch block
            }
        }
        return changed;
    }

    public String getDisplayName() {
        String displayName = this.profile.getDisplayName();
        if (this.privateProfile.getDisplayName() != null && !this.privateProfile.getDisplayName().isEmpty()) {
            displayName = this.privateProfile.getDisplayName();
        }
        return displayName;
    }

    public void setDisplayName(String displayName) {
        if (!this.privateProfile.isRemote().booleanValue()) {
            this.profile.setDisplayName(displayName);
        }
        this.privateProfile.setDisplayName(displayName);
    }

    public String getLocalId() {
        return this.privateProfile.getLocalId();
    }

    public void setLocalId(String localId) {
        this.privateProfile.setLocalId(localId);
    }

    public String getInternalId() {
        return this.privateProfile.getInternalId();
    }

    public void setInternalId(String internalId) {
        this.privateProfile.setInternalId(internalId);
    }

    public boolean isDisabled() {
        return this.privateProfile.isDisabled();
    }

    public void setDisabled(boolean disabled) {
        this.privateProfile.setDisabled(Boolean.valueOf(disabled));
    }

    public boolean isRemote() {
        return this.privateProfile.isRemote();
    }

    public boolean isLocal() {
        return !this.isRemote();
    }

    public void setRemote(boolean remote) {
        this.privateProfile.setRemote(Boolean.valueOf(remote));
    }

    public boolean isAutoupdate() {
        return this.privateProfile.getRegistry().isAutoupdate();
    }

    public void setAutoupdate(boolean autoupdate) {
        this.privateProfile.getRegistry().setAutoupdate(Boolean.valueOf(autoupdate));
    }

    public boolean isAgreementAutoupdate() {
        return this.privateProfile.getRegistry().isAgreementAutoupdate();
    }

    public void setAgreementAutoupdate(boolean agreementAutoupdate) {
        this.privateProfile.getRegistry().setAgreementAutoupdate(Boolean.valueOf(agreementAutoupdate));
    }

    public String getRemoteFile() {
        return this.privateProfile.getRegistry().getRemoteFile();
    }

    public void setRemoteFile(String remoteFile) {
        this.privateProfile.getRegistry().setRemoteFile(remoteFile);
    }

    public synchronized void exportPublicPart(OutputStream publicOut) throws ProfileStoreAccessException {
        XpValidationEventHandler validationEventHandler = new XpValidationEventHandler();
        try {
            Marshaller publicMarshaller = JC_PUBLIC.createMarshaller();
            publicMarshaller.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
            publicMarshaller.setProperty("jaxb.encoding", (Object)"UTF-8");
            publicMarshaller.setEventHandler((ValidationEventHandler)validationEventHandler);
            publicMarshaller.marshal((Object)this.profile, publicOut);
        }
        catch (JAXBException e) {
            if (validationEventHandler.getMessage() != null) {
                throw new ProfileStoreAccessException(22004, "Xml Error in (" + validationEventHandler.getLine() + ", " + validationEventHandler.getColumn() + "): " + validationEventHandler.getMessage(), e);
            }
            throw new ProfileStoreAccessException(22004, "Public profile could not be processed: " + e.getMessage(), e);
        }
    }

    public synchronized void exportPrivatePart(OutputStream privateOut) throws ProfileStoreAccessException {
        XpValidationEventHandler validationEventHandler = new XpValidationEventHandler();
        try {
            Marshaller privateMarshaller = JC_PRIVATE.createMarshaller();
            privateMarshaller.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
            privateMarshaller.setProperty("jaxb.encoding", (Object)"UTF-8");
            privateMarshaller.setEventHandler((ValidationEventHandler)validationEventHandler);
            privateMarshaller.marshal((Object)this.privateProfile, privateOut);
        }
        catch (JAXBException e) {
            if (validationEventHandler.getMessage() != null) {
                throw new ProfileStoreAccessException(22004, "Xml Error in (" + validationEventHandler.getLine() + ", " + validationEventHandler.getColumn() + "): " + validationEventHandler.getMessage(), e);
            }
            throw new ProfileStoreAccessException(22004, "Private profile could not be processed: " + e.getMessage(), e);
        }
    }

    public long getLastModified() {
        return this.privateProfile.getRegistry().getLastModified();
    }

    public void setLastModified(long lastModified) {
        this.privateProfile.getRegistry().setLastModified(lastModified);
    }

    public String getMessengerVendorName() {
        return this.profile.getMessenger().getVendorName();
    }

    public void setMessengerVendorName(String messengerVendorName) {
        this.profile.getMessenger().setVendorName(messengerVendorName);
    }

    public String getMessengerProductName() {
        return this.profile.getMessenger().getProductName();
    }

    public void setMessengerProductName(String messengerProductName) {
        this.profile.getMessenger().setProductName(messengerProductName);
    }

    public String getMessengerProductVersion() {
        return this.profile.getMessenger().getProductVersion();
    }

    public void setMessengerProductVersion(String messengerProductVersion) {
        this.profile.getMessenger().setProductVersion(messengerProductVersion);
    }

    public Map<String, List<DocumentType>> getSchemaSets() {
        if (this.schemaSets == null) {
            this.determineSchemaSets();
        }
        return this.schemaSets;
    }

    private void determineSchemaSets() {
        List<DocumentType> docs = this.getDocumentTypes();
        HashMap<String, List<DocumentType>> result = new HashMap<String, List<DocumentType>>();
        block0: for (DocumentType tempDocType : docs) {
            String schemaLocation = tempDocType.getSchemalocation();
            ArrayList<String> names = this.schemataConfig.getSchemaSetNames(new String[]{schemaLocation});
            if (names == null || names.isEmpty()) continue;
            for (String schemaSetName : names) {
                SchemaData schemaData = this.schemataConfig.getSchemaBySetTypeVersion(schemaSetName, tempDocType.getType(), tempDocType.getVersion());
                if (schemaData == null) continue;
                this.putDocumentType(schemaSetName, tempDocType, result);
                continue block0;
            }
        }
        this.schemaSets = result;
    }

    private void putDocumentType(String schemaSetName, DocumentType docType, Map<String, List<DocumentType>> schemaSets) {
        List<DocumentType> setDocs;
        List<DocumentType> currentSetDocs = schemaSets.get(schemaSetName);
        if (currentSetDocs == null) {
            setDocs = new ArrayList<DocumentType>();
            schemaSets.put(schemaSetName, setDocs);
        } else {
            setDocs = currentSetDocs;
        }
        docType.setSchemaSet(schemaSetName);
        SchemaData schema = this.schemataConfig.getSchemaBySetTypeVersion(docType.getSchemaSet(), docType.getType(), docType.getVersion());
        if (schema != null) {
            for (AdditionalSchema additionalSchema : schema.getAdditionalSchemata()) {
                docType.addAdditionalSchema(additionalSchema);
            }
        }
        setDocs.add(docType);
    }

    public void setAllPipelineOptions(boolean useUIConfig) {
        String[] pipelineIds = this.getPipelineIds();
        if (pipelineIds == null) {
            return;
        }
        for (String pipelineId : pipelineIds) {
            try {
                this.setAllPipelineOptionsForId(pipelineId, useUIConfig);
            }
            catch (PipelineIdNotFoundException e) {
                log.warn((Object)e.toString());
            }
        }
    }

    public void setAllPipelineOptionsForId(String pipelineId, boolean useUIConfig) throws PipelineIdNotFoundException {
        UIOption[] uiOptions = this.pipelineFactory.getPipelineOptions(pipelineId);
        try {
            if (useUIConfig) {
                List<UIOption> uiOptionsList = this.uiConfig.getDefaultPipelineUIOptions(pipelineId, uiOptions);
                uiOptions = uiOptionsList.toArray(new UIOption[0]);
            }
        }
        catch (Exception e) {
            log.warn((Object)("could not set pipeline options for pipeline:" + pipelineId + " " + String.valueOf(e)));
        }
        for (UIOption uiOption : uiOptions) {
            this.setPipelineOptionValue(pipelineId, uiOption.getOptionPath(), uiOption.getValues(), uiOption.getType());
        }
    }

    public void setAllPackagingOptions(boolean useUIConfig) {
        String[] packagingIds = this.getPackagingIds();
        if (packagingIds == null) {
            return;
        }
        for (String packagingId : packagingIds) {
            try {
                this.setAllPackagingOptionsForId(packagingId, useUIConfig);
            }
            catch (PackageIdNotFoundException e) {
                log.warn((Object)("packaging id not found:" + packagingId));
            }
        }
    }

    public void setAllPackagingOptionsForId(String packagingId, boolean useUIConfig) throws PackageIdNotFoundException {
        UIOption[] uiOptions = this.packagingManager.getPackagingOptions(packagingId);
        try {
            if (useUIConfig) {
                List<UIOption> uiOptionsList = this.uiConfig.getDefaultPackageUIOptions(packagingId, uiOptions);
                uiOptions = uiOptionsList.toArray(new UIOption[0]);
            }
        }
        catch (Exception e) {
            log.warn((Object)("could not set packaging options for packager:" + packagingId + " " + String.valueOf(e)));
        }
        for (UIOption uiOption : uiOptions) {
            this.setPackagingOptionValue(packagingId, uiOption.getOptionPath(), uiOption.getValues(), uiOption.getType());
        }
    }

    public void addPartyId(String type, String value) {
        this.addPartyId(type, value, true, true);
    }

    public void addPartyId(String type, String value, boolean useInEbXml, boolean useInAS4) {
        de.pontonconsulting.xmlpipe.config.partnerprofile.PartyId partyId = factoryPublic.createPartyId();
        partyId.setType(type);
        if ("E-Mail".equals(type)) {
            value = StringUtils.lowerCase((String)value);
        }
        partyId.setValue(value);
        Object packager = "";
        if (useInEbXml) {
            packager = (String)packager + "EbXml20";
        }
        if (useInAS4) {
            if (StringUtils.isNotBlank((CharSequence)packager)) {
                packager = (String)packager + ",";
            }
            packager = (String)packager + "AS4";
        }
        partyId.setIncludeInPackager((String)packager);
        this.profile.getPartyIds().getPartyId().add(partyId);
    }

    public void deleteAllPartyIds() {
        this.profile.getPartyIds().getPartyId().clear();
    }

    public List<de.pontonconsulting.xmlpipe.config.partnerprofile.PartyId> getPartyIdList() {
        return this.profile.getPartyIds().getPartyId();
    }

    public PartyId[] getPartyIds() {
        ArrayList<PartyId> result = new ArrayList<PartyId>();
        for (de.pontonconsulting.xmlpipe.config.partnerprofile.PartyId partyId : this.getPartyIdList()) {
            List<String> packagers = this.splitPackager(partyId.getIncludeInPackager());
            result.add(new PartyId(partyId.getValue(), partyId.getType(), packagers.contains("EbXml20"), packagers.contains("AS4")));
        }
        return result.toArray(new PartyId[0]);
    }

    private List<String> splitPackager(String packagersAsString) {
        ArrayList<String> packagers = new ArrayList<String>();
        for (String packager : packagersAsString.split(",")) {
            if (!StringUtils.isNotBlank((CharSequence)packager)) continue;
            packagers.add(packager.trim());
        }
        return packagers;
    }

    public PartyId[] getPartyIds(String packagingId) {
        ArrayList<PartyId> result = new ArrayList<PartyId>();
        for (de.pontonconsulting.xmlpipe.config.partnerprofile.PartyId partyId : this.getPartyIdList()) {
            List<String> packagers = this.splitPackager(partyId.getIncludeInPackager());
            if (!packagers.contains(packagingId)) continue;
            result.add(new PartyId(partyId.getValue(), partyId.getType(), packagers.contains("EbXml20"), packagers.contains("AS4")));
        }
        return result.toArray(new PartyId[0]);
    }

    public String getPartyIdValue(String partyIdType) {
        String partyIdValue = null;
        for (de.pontonconsulting.xmlpipe.config.partnerprofile.PartyId partyId : this.getPartyIdList()) {
            if (!StringUtils.equals((CharSequence)partyId.getType(), (CharSequence)partyIdType)) continue;
            partyIdValue = partyId.getValue();
            break;
        }
        return partyIdValue;
    }

    private void readPublicFile(InputStream inputStream) throws JAXBException {
        Unmarshaller unmarshaller = JC_PUBLIC.createUnmarshaller();
        this.profile = (Partner)unmarshaller.unmarshal(inputStream);
    }

    private void readPrivateFile(InputStream inputStream) throws JAXBException {
        Unmarshaller unmarshaller = JC_PRIVATE.createUnmarshaller();
        this.privateProfile = (PrivatePartner)unmarshaller.unmarshal(inputStream);
    }

    private void readPublicPart(URL publicPart) throws JAXBException {
        this.publicPart = publicPart;
        Unmarshaller u = JC_PUBLIC.createUnmarshaller();
        ValidationEventCollector vce = new ValidationEventCollector();
        u.setEventHandler((ValidationEventHandler)vce);
        this.profile = (Partner)u.unmarshal(this.publicPart);
    }

    private void readPrivateFile(URL privatePart, String localId) throws JAXBException {
        if (privatePart != null) {
            Unmarshaller u = JC_PRIVATE.createUnmarshaller();
            this.privateProfile = (PrivatePartner)u.unmarshal(privatePart);
        } else {
            this.filePrivate = null;
            this.privateProfile = factoryPrivate.createPrivatePartner();
            this.privateProfile.setDisabled(Boolean.FALSE);
            this.privateProfile.setRemote(Boolean.TRUE);
            this.privateProfile.setRegistry(factoryPrivate.createRegistry());
            this.privateProfile.getRegistry().setAutoupdate(Boolean.FALSE);
            this.privateProfile.getRegistry().setRemoteFile("");
            this.privateProfile.setLocalId(localId);
        }
    }

    private String getFilename(URL url) {
        return FilenameUtils.getName((String)url.getPath());
    }

    private void updateDefaultCertRefId() {
        List certs;
        if (this.getDefaultCertRefId() == null && !(certs = this.profile.getCertificates().getX509Certificate()).isEmpty()) {
            String certId = ((X509Certificate)certs.getFirst()).getId();
            this.setDefaultCertRefId(certId);
        }
    }

    private void updateLookupTables() {
        this.allCertificates.clear();
        List<Object> certs = Collections.synchronizedList(this.profile.getCertificates().getX509Certificate());
        for (Object element : certs) {
            String certId = element.getId();
            this.addCertificateToCache(certId, element.getValue());
            this.updateDefaultCertRefId();
        }
        this.rebuildCrypto();
        this.allTransportIds.clear();
        this.allTransportUrls.clear();
        this.transportOptionLookup.clear();
        List<Object> transports = Collections.synchronizedList(this.profile.getTransports().getTransport());
        for (Object element : transports) {
            String idStr;
            if (!element.equals(this.allTransportIds.put(idStr = element.getId(), (Transport)element))) {
                List<de.pontonconsulting.xmlpipe.config.partnerprofile.Option> options = Collections.synchronizedList(element.getOption());
                Option allOptions = new Option("id", idStr, null);
                Option[] subOptions = this.getSubOptions(options, "/" + idStr, this.transportOptionLookup);
                allOptions.setSubOptions(subOptions);
                this.transportOptionLookup.put("/" + idStr, allOptions);
            } else {
                log.warn((Object)("duplicate transport id :" + idStr + " in partner " + this.getLocalId()));
            }
            if (!element.equals(this.allTransportUrls.put(element.getURL().toLowerCase(), (Transport)element))) continue;
            log.warn((Object)("duplicate transport id :" + idStr + " in partner " + this.getLocalId()));
        }
        this.allPackagingIds.clear();
        this.packagingOptionLookup.clear();
        List<Package> packagings = Collections.synchronizedList(this.profile.getPackaging().getPackage());
        for (Package element : packagings) {
            String idStr;
            if (!element.equals(this.allPackagingIds.put(idStr = element.getId(), element))) {
                List<de.pontonconsulting.xmlpipe.config.partnerprofile.Option> options = Collections.synchronizedList(element.getOption());
                Option allOptions = new Option("id", idStr, null);
                allOptions.setSubOptions(this.getSubOptions(options, "/" + idStr, this.packagingOptionLookup));
                this.packagingOptionLookup.put("/" + idStr, allOptions);
                continue;
            }
            log.warn((Object)("duplicate package id :" + idStr + " in partner " + this.getLocalId()));
        }
        this.allPipelineIds.clear();
        this.pipelineOptionLookup.clear();
        List<Pipeline> pipelines = Collections.synchronizedList(this.profile.getProcessingPipelines().getPipeline());
        for (Pipeline element : pipelines) {
            String pipelineId;
            if (!element.equals(this.allPipelineIds.put(pipelineId = element.getId(), element))) {
                List<de.pontonconsulting.xmlpipe.config.partnerprofile.Option> options = Collections.synchronizedList(element.getOption());
                Option allOptions = new Option("id", pipelineId, null);
                allOptions.setSubOptions(this.getSubOptions(options, "/" + pipelineId, this.pipelineOptionLookup));
                this.pipelineOptionLookup.put("/" + pipelineId, allOptions);
                continue;
            }
            log.warn((Object)("duplicate pipeline id :" + pipelineId + " in partner " + this.getLocalId()));
        }
    }

    private void addCertificateToCache(String certId, byte[] rawCertificate) {
        try {
            java.security.cert.X509Certificate x509Certificate = this.certificateUtility.getX509Certificate(rawCertificate);
            this.allCertificates.put(certId, x509Certificate);
            if (this.isLocal()) {
                String certAlias = this.buildAliasForPartnerCertificate(x509Certificate);
                String password = this.getPrivateKeyPassword(certAlias);
                if (StringUtils.isNotBlank((CharSequence)password)) {
                    PrivateKey privateKey = this.loadPrivateKey(x509Certificate, password);
                    if (privateKey != null) {
                        this.privateKeys.put(certId, privateKey);
                    }
                } else {
                    log.error((Object)("Could not get password for the alias '" + certAlias + "' for partner '" + this.getLocalId() + "'."));
                }
            }
        }
        catch (Exception e) {
            log.error((Object)("Could not cache certificate with the id '" + certId + "' for partner '" + this.getLocalId() + "': " + String.valueOf(e)));
        }
    }

    private void removeCertificateFromCache(String certId) {
        this.allCertificates.remove(certId);
        this.privateKeys.remove(certId);
        this.rebuildCrypto();
    }

    private void rebuildCrypto() {
        Crypto crypto = this.isRemote() ? this.cryptoFactory.createSignatureVerificationCrypto(Optional.ofNullable(this.getAllCertificates()).orElse(Collections.emptySet()).stream().toList()) : this.cryptoFactory.createDecryptionCrypto(Optional.ofNullable(this.getAllKeys()).orElse(Collections.emptyList()));
        this.crypto.set(crypto);
    }

    public Crypto getCrypto() {
        return this.crypto.get();
    }

    public List<DocumentType> getDocumentTypes() {
        if (this.documentTypes == null) {
            this.loadDocumentTypes();
        }
        return this.documentTypes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadDocumentTypes() {
        ArrayList<DocumentType> result = new ArrayList<DocumentType>();
        Partner partner = this.profile;
        synchronized (partner) {
            List docs = this.profile.getPayloadDocuments().getDocument();
            for (Document element : docs) {
                ArrayList<String> schemaSetNames = this.schemataConfig.getSchemaSetNames(new String[]{element.getSchemaLocation()});
                for (String schemaSetName : schemaSetNames) {
                    SchemaData schemaData = this.schemataConfig.getSchemaBySetTypeVersion(schemaSetName, element.getType(), element.getVersion());
                    if (schemaData == null) continue;
                    DocumentType temp = this.documentTypeResolver.resolveDocument(element.getType(), element.getVersion(), element.getNameSpace(), element.getSchemaLocation(), schemaSetName);
                    result.add(temp);
                }
            }
        }
        this.documentTypes = result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDocumentTypes(List<DocumentType> allDocTypes) {
        ArrayList<DocumentType> documentTypes = new ArrayList<DocumentType>(allDocTypes);
        Collections.sort(documentTypes);
        this.documentTypes = documentTypes;
        this.determineSchemaSets();
        Partner partner = this.profile;
        synchronized (partner) {
            List docs = this.profile.getPayloadDocuments().getDocument();
            docs.clear();
            for (DocumentType tempDocType : documentTypes) {
                Document doc = factoryPublic.createDocument();
                doc.setType(tempDocType.getType());
                doc.setVersion(tempDocType.getVersion());
                doc.setSchemaLocation(tempDocType.getSchemalocation());
                doc.setNameSpace(tempDocType.getNamespace());
                if (!docs.stream().noneMatch(document -> Objects.equals(document.getType(), doc.getType()) && Objects.equals(document.getVersion(), doc.getVersion()) && Objects.equals(document.getSchemaLocation(), doc.getSchemaLocation()) && Objects.equals(document.getNameSpace(), doc.getNameSpace()))) continue;
                docs.add(doc);
            }
        }
    }

    public int getNumberOfParallelDeliveries() {
        return this.privateProfile.getNumberOfParallelDeliveries();
    }

    public void setNumberOfParallelDeliveries(int numberOfParallelDeliveries) {
        if (numberOfParallelDeliveries < 1) {
            throw new IllegalArgumentException("numberOfParallelDeliveries must be greater than 0.");
        }
        this.privateProfile.setNumberOfParallelDeliveries(Integer.valueOf(numberOfParallelDeliveries));
    }

    public void save(boolean transport, boolean processing, boolean packaging, boolean partyIds, boolean schemaSet) throws ProfileStoreAccessException, AgreementException {
        this.save(transport, processing, packaging, partyIds, schemaSet, "SYSTEM");
    }

    public void save(boolean transport, boolean processing, boolean packaging, boolean partyIds, boolean schemaSet, String username) throws ProfileStoreAccessException, AgreementException {
        if (!this.isRemote() || this.isUpdateAllowed()) {
            this.setLastModified(System.currentTimeMillis());
        }
        this.saveToDBWithoutTimeStampModify(username);
        this.agreementUpdateUtility.updateAllAgreementsFor(this, transport, processing, packaging, partyIds, schemaSet);
    }

    public void save() throws ProfileStoreAccessException {
        this.setCompatibilityVersion();
        this.saveToDB();
    }

    @Deprecated
    public boolean isDirty() {
        if (this.isUpdateAllowed()) {
            try {
                return this.getLastModified() != this.toFile(this.publicPart).lastModified();
            }
            catch (ProfileException e) {
                return false;
            }
        }
        return false;
    }

    private File toFile(URL url) throws ProfileStoreAccessException {
        if ("file".equalsIgnoreCase(url.getProtocol()) && !url.getPath().toLowerCase().contains(".jar")) {
            try {
                return Path.of(url.toURI()).toFile();
            }
            catch (URISyntaxException e) {
                throw new ProfileStoreAccessException(-1, "Could not access public part.", e);
            }
        }
        throw new ProfileStoreAccessException(-1, "Could not access public part. Public part is not a file.");
    }

    public void saveUpdatedProfile() throws ProfileStoreAccessException, AgreementException {
        this.saveToDBWithoutTimeStampModify("SYSTEM");
        this.agreementUpdateUtility.updateAllAgreementsFor(this, true, true, true, true, true);
    }

    private void saveToDBWithoutTimeStampModify(String username) throws ProfileStoreAccessException {
        if (this.isLocal()) {
            if (!this.getMessengerProductName().equals(Constants.getXP_NAME())) {
                this.setMessengerProductName(Constants.getXP_NAME());
            }
            if (!this.getMessengerProductVersion().equals(Constants.getXP_VERSION())) {
                this.setMessengerProductVersion(Constants.getXP_VERSION());
            }
            if (!this.getMessengerVendorName().equals(Constants.getXP_VENDOR())) {
                this.setMessengerVendorName(Constants.getXP_VENDOR());
            }
        }
        this.saveToDB(username, Optional.of(this.getLastModified()));
        this.updateLookupTables();
    }

    private void updatePackagingElement() {
        List packages = this.profile.getPackaging().getPackage();
        for (Package element : packages) {
            List optionElements = element.getOption();
            optionElements.clear();
            Option options = this.packagingOptionLookup.get("/" + element.getId());
            List<de.pontonconsulting.xmlpipe.config.partnerprofile.Option> sub = this.createSubOptions(options.getSubOptions());
            optionElements.addAll(sub);
        }
        this.packagingDirty = false;
    }

    private void updatePipelineElement() {
        List pipelines = this.profile.getProcessingPipelines().getPipeline();
        for (Pipeline element : pipelines) {
            List optionElements = element.getOption();
            optionElements.clear();
            Option options = this.pipelineOptionLookup.get("/" + element.getId());
            List<de.pontonconsulting.xmlpipe.config.partnerprofile.Option> sub = this.createSubOptions(options.getSubOptions());
            optionElements.addAll(sub);
        }
        this.pipelineDirty = false;
    }

    private void updateTransportElement() {
        List transports = this.profile.getTransports().getTransport();
        for (Transport element : transports) {
            List optionElements = element.getOption();
            optionElements.clear();
            Option options = this.transportOptionLookup.get("/" + element.getId());
            if (options == null) continue;
            List<de.pontonconsulting.xmlpipe.config.partnerprofile.Option> sub = this.createSubOptions(options.getSubOptions());
            optionElements.addAll(sub);
        }
        this.transportDirty = false;
    }

    private List<de.pontonconsulting.xmlpipe.config.partnerprofile.Option> createSubOptions(Option[] options) {
        ArrayList<de.pontonconsulting.xmlpipe.config.partnerprofile.Option> result = new ArrayList<de.pontonconsulting.xmlpipe.config.partnerprofile.Option>();
        for (Option option : options) {
            Option[] subOptions = option.getSubOptions();
            List<de.pontonconsulting.xmlpipe.config.partnerprofile.Option> subOptionElement = this.createSubOptions(subOptions);
            de.pontonconsulting.xmlpipe.config.partnerprofile.Option optionType = factoryPublic.createOption();
            optionType.setName(option.getName());
            optionType.setType(option.getType());
            optionType.setValue(option.getValue());
            optionType.getOption().addAll(subOptionElement);
            result.add(optionType);
        }
        return result;
    }

    public void saveToDB() throws ProfileStoreAccessException {
        this.saveToDB("SYSTEM", Optional.of(System.currentTimeMillis()));
    }

    public void saveToDB(String username, Optional<Long> lastModified) throws ProfileStoreAccessException {
        if (this.transportDirty) {
            this.updateTransportElement();
        }
        if (this.packagingDirty) {
            this.updatePackagingElement();
        }
        if (this.pipelineDirty) {
            this.updatePipelineElement();
        }
        if (lastModified.isPresent()) {
            this.partnerProfileDAO.storePartnerProfile(this, lastModified.get(), username);
        } else {
            this.partnerProfileDAO.storePartnerProfile(this, username);
        }
        this.profiles.sendReloadProfileRequest(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public void saveToFile(URL url) throws ProfileStoreAccessException {
        this.publicPart = url;
        if (this.transportDirty) {
            this.updateTransportElement();
        }
        if (this.packagingDirty) {
            this.updatePackagingElement();
        }
        if (this.pipelineDirty) {
            this.updatePipelineElement();
        }
        File filePublic = this.toFile(this.publicPart);
        File filePublicTemp = new File(filePublic.getParentFile(), this.getFilename(this.publicPart) + System.nanoTime());
        try {
            try (BufferedOutputStream bos = new BufferedOutputStream(Files.newOutputStream(filePublicTemp.toPath(), new OpenOption[0]));){
                Marshaller m = JC_PUBLIC.createMarshaller();
                m.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
                m.setProperty("jaxb.encoding", (Object)"UTF-8");
                Partner partner = this.profile;
                synchronized (partner) {
                    m.marshal((Object)this.profile, (OutputStream)bos);
                }
            }
            catch (JAXBException je) {
                throw new ProfileStoreAccessException(22005, "Could not save profile: " + this.getLocalId(), je);
            }
            catch (FileNotFoundException fnfe) {
                throw new ProfileStoreAccessException(22004, "Destination file not found.", fnfe);
            }
            catch (MalformedURLException fnfe) {
            }
            catch (IOException e1) {
                log.warn((Object)("error on closing stream:" + String.valueOf(e1)));
            }
            try {
                Files.move(filePublicTemp.toPath(), filePublic.toPath(), StandardCopyOption.REPLACE_EXISTING);
                this.savePrivateFile();
            }
            catch (JAXBException | IOException e) {
                throw new ProfileStoreAccessException(22004, "Could not save profile: " + this.getLocalId(), e);
            }
        }
        finally {
            filePublicTemp.delete();
        }
        this.profiles.sendReloadProfileRequest(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void savePrivateFile() throws JAXBException, IOException {
        File privateFolder = new File(this.serverConfig.getConfigFolder(), Profiles.PRIVATE_FOLDER_PATH);
        if (!privateFolder.exists()) {
            privateFolder.mkdirs();
        }
        Marshaller m = JC_PRIVATE.createMarshaller();
        m.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
        m.setProperty("jaxb.encoding", (Object)"UTF-8");
        BufferedOutputStream bos = null;
        File filePrivateTemp = new File(privateFolder, this.getFilename(this.publicPart) + System.nanoTime());
        try {
            try {
                this.filePrivate = new File(privateFolder, this.getFilename(this.publicPart));
                bos = new BufferedOutputStream(Files.newOutputStream(filePrivateTemp.toPath(), new OpenOption[0]));
                PrivatePartner privatePartner = this.privateProfile;
                synchronized (privatePartner) {
                    m.marshal((Object)this.privateProfile, (OutputStream)bos);
                }
            }
            catch (Throwable throwable) {
                IOUtil.closeStreamQuietly(bos);
                throw throwable;
            }
            IOUtil.closeStreamQuietly(bos);
            Files.move(filePrivateTemp.toPath(), this.filePrivate.toPath(), StandardCopyOption.REPLACE_EXISTING);
        }
        finally {
            filePrivateTemp.delete();
        }
    }

    public String[] getCertificateIds() {
        List partnerCertificates = this.profile.getCertificates().getX509Certificate();
        String[] result = new String[partnerCertificates.size()];
        int i = 0;
        for (X509Certificate certificate : partnerCertificates) {
            result[i++] = certificate.getId();
        }
        return result;
    }

    private void addX509Certificate(String certId, byte[] rawData) {
        X509Certificate cert = factoryPublic.createX509Certificate();
        cert.setId(certId);
        cert.setValue(rawData);
        this.profile.getCertificates().getX509Certificate().add(cert);
        this.updateDefaultCertRefId();
    }

    public void setDefaultCertRefId(String certRefId) {
        if (certRefId == null) {
            this.profile.getCertificates().setDefaultCertificate(null);
            this.updateDefaultCertRefId();
        } else {
            DefaultCertificate defaultCertificate = this.profile.getCertificates().getDefaultCertificate();
            if (defaultCertificate == null) {
                defaultCertificate = factoryPublic.createDefaultCertificate();
                this.profile.getCertificates().setDefaultCertificate(defaultCertificate);
            }
            defaultCertificate.setRefId(certRefId);
        }
    }

    public String getDefaultCertRefId() {
        DefaultCertificate defaultCertificate = this.profile.getCertificates().getDefaultCertificate();
        if (defaultCertificate != null) {
            return defaultCertificate.getRefId();
        }
        return null;
    }

    public java.security.cert.X509Certificate getX509Certificate(String certId) throws CertificateIdNotFoundException {
        java.security.cert.X509Certificate result = this.allCertificates.get(certId);
        if (result == null) {
            throw new CertificateIdNotFoundException(-1, "No certificate found for the certificate Id '" + certId + "' in the profile '" + this.getLocalId() + "'.");
        }
        return result;
    }

    public String getCertificateId(java.security.cert.X509Certificate certificate) {
        for (Map.Entry<String, java.security.cert.X509Certificate> entry : this.allCertificates.entrySet()) {
            if (!certificate.equals(entry.getValue())) continue;
            return entry.getKey();
        }
        return null;
    }

    public void deleteCertificate(String certId) {
        List certs = this.profile.getCertificates().getX509Certificate();
        X509Certificate cert = (X509Certificate)CollectionUtils.find((Collection)certs, (Predicate)new X509CertificatePredicate(certId));
        certs.remove(cert);
        this.removeCertificateFromCache(certId);
        if (certId.equals(this.getDefaultCertRefId())) {
            this.setDefaultCertRefId(null);
        }
        this.removePipelineCertificate(certId);
        this.removePackagingCertificate(certId);
    }

    public void deletePartnerCertificate(String certRefId) throws CertificateIdNotFoundException {
        java.security.cert.X509Certificate cert = this.getX509Certificate(certRefId);
        if (this.isLocal()) {
            this.deletePrivateKey(cert);
        }
        this.deleteCertificate(certRefId);
    }

    public void setPackagingCertificate(String packagingId, String certId) throws PackageIdNotFoundException, CertificateIdNotFoundException {
        Package jaxbPackage = this.findPackage(packagingId);
        if (certId == null) {
            jaxbPackage.setCertificate(null);
        } else {
            Object[] certIds = this.getCertificateIds();
            if (!ArrayUtils.contains((Object[])certIds, (Object)certId)) {
                throw new CertificateIdNotFoundException(-1, "Certificate Id '" + certId + "' not found.");
            }
            Certificate certType = factoryPublic.createCertificate();
            certType.setRefId(certId);
            jaxbPackage.setCertificate(certType);
        }
        this.packagingDirty = true;
    }

    private void removePackagingCertificate(String certId) {
        List packagings = this.profile.getPackaging().getPackage();
        for (Package packaging : packagings) {
            Certificate certificate = packaging.getCertificate();
            if (certificate == null || !certId.equals(certificate.getRefId())) continue;
            packaging.setCertificate(null);
        }
        this.packagingDirty = true;
    }

    private void removePipelineCertificate(String certId) {
        List pipelines = this.profile.getProcessingPipelines().getPipeline();
        for (Pipeline pipeline : pipelines) {
            Certificate certificate = pipeline.getCertificate();
            if (certificate == null || !certId.equals(certificate.getRefId())) continue;
            pipeline.setCertificate(null);
        }
        this.pipelineDirty = true;
    }

    public String getPackagingCertificateId(String packagingId) throws PackageIdNotFoundException {
        if (this.hasNoPackagingId(packagingId)) {
            throw new PackageIdNotFoundException(-1, "Package Id '" + packagingId + "' not found.");
        }
        Package jaxbPackage = this.allPackagingIds.get(packagingId);
        Certificate certificate = jaxbPackage.getCertificate();
        if (certificate != null) {
            return certificate.getRefId();
        }
        return null;
    }

    public SignCertInfo getPrivateKey(String certId) throws ProfileException, CertificateException {
        java.security.cert.X509Certificate clientCertificate = this.getX509Certificate(certId);
        java.security.cert.X509Certificate[] certificateChain = this.keystoreBean.getKeystore().getCertificateChain(clientCertificate);
        PrivateKey privateKey = this.privateKeys.get(certId);
        if (privateKey == null) {
            throw new ProfileException(-1, "No private key found for the certificate Id '" + certId + "' in the profile '" + this.getLocalId() + "'.");
        }
        return new SignCertInfo(this.getPrivateKeyPassword(this.buildAliasForPartnerCertificate(clientCertificate)), privateKey, certificateChain);
    }

    public Set<java.security.cert.X509Certificate> getAllCertificates() {
        return new HashSet<java.security.cert.X509Certificate>(this.allCertificates.values());
    }

    public Set<java.security.cert.X509Certificate> getAllValidCertificates() {
        HashSet<java.security.cert.X509Certificate> validCertificates = new HashSet<java.security.cert.X509Certificate>();
        for (Map.Entry<String, java.security.cert.X509Certificate> x509Certificate : this.allCertificates.entrySet()) {
            try {
                x509Certificate.getValue().checkValidity();
                if (!this.isCertificateTrusted(x509Certificate.getKey())) continue;
                validCertificates.add(x509Certificate.getValue());
            }
            catch (Exception exception) {}
        }
        return validCertificates;
    }

    public boolean isCertificateTrusted(String id) {
        for (CertificateStatus status : this.privateProfile.getCertificateStatus()) {
            if (!id.equals(status.getId()) || !status.isRevoked()) continue;
            return false;
        }
        return true;
    }

    public List<SignCertInfo> getAllKeys() {
        ArrayList<SignCertInfo> allKeys = new ArrayList<SignCertInfo>();
        for (String certId : this.allCertificates.keySet()) {
            java.security.cert.X509Certificate x509Certificate = this.allCertificates.get(certId);
            try {
                java.security.cert.X509Certificate[] certificateChain = this.keystoreBean.getKeystore().getCertificateChain(x509Certificate);
                PrivateKey privateKey = this.privateKeys.get(certId);
                if (privateKey == null) {
                    throw new ProfileException(-1, "No private key found for the certificate Id '" + certId + "' in the profile '" + this.getLocalId() + "'.");
                }
                allKeys.add(new SignCertInfo(null, privateKey, certificateChain));
            }
            catch (CertificateException e) {
                log.warn((Object)("Error occurs while getting all valid keys. Could not build certificate chain: " + String.valueOf(e)));
            }
            catch (ProfileException e) {
                log.warn((Object)("Error occurs while getting all valid keys. " + e.getMessage()));
            }
        }
        return allKeys;
    }

    public List<SignCertInfo> getAllValidKeys() {
        ArrayList<SignCertInfo> validKeys = new ArrayList<SignCertInfo>();
        for (SignCertInfo signCertInfo : this.getAllKeys()) {
            java.security.cert.X509Certificate x509Certificate = signCertInfo.getCertificateChain()[0];
            try {
                x509Certificate.checkValidity();
                validKeys.add(signCertInfo);
            }
            catch (CertificateExpiredException | CertificateNotYetValidException certificateException) {}
        }
        return validKeys;
    }

    public String getPrivateKeyPassword(String alias) {
        String pw = null;
        byte[] pwBytes = null;
        List pwds = this.privateProfile.getPrivateKeyPassword();
        for (PrivateKeyPassword password : pwds) {
            String tempAlias = password.getAlias();
            if (tempAlias != null && !tempAlias.trim().isEmpty()) {
                if (!tempAlias.equals(alias)) continue;
                pwBytes = password.getValue();
                break;
            }
            if (alias != null && !alias.trim().isEmpty()) continue;
            pwBytes = password.getValue();
            break;
        }
        if (pwBytes != null) {
            try {
                pw = this.passwordCrypt.decryptPassword(pwBytes);
            }
            catch (Exception e) {
                log.error((Object)("could not decrypt password:" + String.valueOf(e)));
            }
        }
        return pw;
    }

    public byte[] getEncryptedPrivateKeyPassword(String alias) {
        String password = this.getPrivateKeyPassword(alias);
        byte[] encryptedPassword = null;
        try {
            encryptedPassword = this.passwordCrypt.encryptPassword(password);
        }
        catch (Exception e) {
            log.error((Object)("Could not encrypt password:" + String.valueOf(e)));
        }
        return encryptedPassword;
    }

    public void deletePrivateKey(java.security.cert.X509Certificate certificate) {
        String alias = this.buildAliasForPartnerCertificate(certificate);
        de.pontonconsulting.xmlpipe.config.privatepartnerprofile.PrivateKey privateKey = (de.pontonconsulting.xmlpipe.config.privatepartnerprofile.PrivateKey)CollectionUtils.find((Collection)this.privateProfile.getPrivateKey(), (Predicate)new PrivateKeyPredicate(alias));
        this.privateProfile.getPrivateKey().remove(privateKey);
        this.deletePrivateKeyPassword(alias);
    }

    private void deletePrivateKeyPassword(String alias) {
        boolean aliasEmpty = alias == null || alias.trim().isEmpty();
        PrivateKeyPassword pkPwd = null;
        List pwds = this.privateProfile.getPrivateKeyPassword();
        for (PrivateKeyPassword pwd : pwds) {
            String tempAlias = pwd.getAlias();
            if (tempAlias != null && !tempAlias.trim().isEmpty()) {
                if (!tempAlias.equals(alias)) continue;
                pkPwd = pwd;
                break;
            }
            if (!aliasEmpty) continue;
            pkPwd = pwd;
            break;
        }
        if (pkPwd != null) {
            pwds.remove(pkPwd);
        }
    }

    public List<Transport> getTransportList() {
        return this.profile.getTransports().getTransport();
    }

    public Transport getTransport(String transportId) {
        return this.allTransportIds.get(transportId);
    }

    public String[] getTransportIds() {
        return this.allTransportIds.keySet().toArray(new String[0]);
    }

    public String getPreferredTransportId() {
        String preferredId = null;
        Collection<Transport> transports = this.allTransportIds.values();
        for (Transport transportType : transports) {
            if (!transportType.isPreferred()) continue;
            preferredId = transportType.getId();
            break;
        }
        return preferredId;
    }

    public String getFallbackTransportId() {
        String fallbackId = null;
        Collection<Transport> transports = this.allTransportIds.values();
        for (Transport transportType : transports) {
            if (!transportType.isFallback()) continue;
            fallbackId = transportType.getId();
            break;
        }
        return fallbackId;
    }

    public void setPreferredTransportId(String preferredTransportId) {
        Collection<Transport> transports = this.allTransportIds.values();
        for (Transport transportType : transports) {
            String tempTransportId = transportType.getId();
            if (tempTransportId.equals(preferredTransportId)) {
                transportType.setPreferred(Boolean.TRUE);
                continue;
            }
            transportType.setPreferred(Boolean.FALSE);
        }
    }

    public void setFallbackTransportId(String fallbackTransportId) {
        Collection<Transport> transports = this.allTransportIds.values();
        for (Transport transportType : transports) {
            String tempTransportId = transportType.getId();
            if (tempTransportId.equals(fallbackTransportId)) {
                transportType.setFallback(Boolean.valueOf(!transportType.isPreferred()));
                continue;
            }
            transportType.setFallback(Boolean.FALSE);
        }
    }

    public void deleteTransportCert(String transportId) {
        Certificate certType;
        Transport transport = this.getTransport(transportId);
        if (transport != null && (certType = transport.getCertificate()) != null) {
            this.deleteCertificate(certType.getRefId());
            transport.setCertificate(null);
        }
        this.transportDirty = true;
    }

    public void deleteAllTransports() {
        List<Transport> transports = this.getTransportList();
        for (Transport transport : transports) {
            this.deleteTransportCert(transport.getId());
        }
        transports.clear();
        this.allTransportIds.clear();
    }

    public String getTransportUrl(String id) throws TransportIdNotFoundException {
        Transport transport = this.findTransport(id);
        return transport.getURL();
    }

    public void setTransportUrl(String id, String url) {
        Transport transport = this.findOrCreateTransport(id);
        transport.setURL(url);
    }

    private Transport createTransport(String id) {
        Transport newTransport = factoryPublic.createTransport();
        newTransport.setId(id);
        this.profile.getTransports().getTransport().add(newTransport);
        this.allTransportIds.put(id, newTransport);
        return newTransport;
    }

    public String getTransportCertificateId(String transportId) throws TransportIdNotFoundException {
        if (transportId == null) {
            return null;
        }
        Transport transport = this.findTransport(transportId);
        Certificate certType = transport.getCertificate();
        if (certType != null) {
            return certType.getRefId();
        }
        return null;
    }

    private Transport findOrCreateTransport(String id) {
        Transport transport;
        try {
            transport = this.findTransport(id);
        }
        catch (TransportIdNotFoundException e) {
            transport = this.createTransport(id);
        }
        return transport;
    }

    private Transport findTransport(String id) throws TransportIdNotFoundException {
        if (id == null) {
            throw new TransportIdNotFoundException();
        }
        Transport result = this.allTransportIds.get(id);
        if (result == null) {
            throw new TransportIdNotFoundException();
        }
        return result;
    }

    public String[] getPackagingIds() {
        return this.allPackagingIds.keySet().toArray(new String[0]);
    }

    public boolean hasPackagingId(String id) {
        return this.allPackagingIds.containsKey(id);
    }

    public String getPreferredPackagingId() {
        String preferredId = null;
        Collection<Package> packages = this.allPackagingIds.values();
        for (Package packageType : packages) {
            if (!packageType.isPreferred()) continue;
            preferredId = packageType.getId();
            break;
        }
        return preferredId;
    }

    public void setPreferredPackagingId(String preferredPackagingId) throws PackageIdNotFoundException {
        if (this.hasNoPackagingId(preferredPackagingId)) {
            throw new PackageIdNotFoundException();
        }
        this.writePreferredPackagingId(preferredPackagingId);
    }

    private void writePreferredPackagingId(String preferredPackagingId) {
        Collection<Package> packages = this.allPackagingIds.values();
        for (Package packageType : packages) {
            String tempPackagingId = packageType.getId();
            if (tempPackagingId.equals(preferredPackagingId)) {
                packageType.setPreferred(Boolean.TRUE);
                continue;
            }
            packageType.setPreferred(Boolean.FALSE);
        }
    }

    private boolean hasNoPackagingId(String id) {
        return !this.allPackagingIds.containsKey(id);
    }

    public Option[] getPackagingOptions(String id) throws PackageIdNotFoundException {
        Option all = this.packagingOptionLookup.get("/" + id);
        if (all == null) {
            throw new PackageIdNotFoundException();
        }
        return all.getSubOptions();
    }

    private Option getPipelineRootOption(String pipelineId) {
        return this.pipelineOptionLookup.get("/" + pipelineId);
    }

    public void deleteAllPipelineCertificateOptions(String pipelineId) {
        Option[] certOptions;
        Option rootOption = this.getPipelineRootOption(pipelineId);
        for (Option certOption : certOptions = this.getAllCertOptions(rootOption.getSubOptions())) {
            rootOption.deleteSubOption(certOption);
        }
        this.pipelineDirty = true;
    }

    private Option[] getAllCertOptions(Option[] options) {
        ArrayList<Option> certOptions = new ArrayList<Option>();
        for (Option option : options) {
            if (!"string".equals(option.getType()) || !"certificateRefId".equals(option.getName()) && !"nextDefaultCertificateRefId".equals(option.getName())) continue;
            certOptions.add(option);
        }
        return certOptions.toArray(new Option[0]);
    }

    private Option[] getSubOptions(List<de.pontonconsulting.xmlpipe.config.partnerprofile.Option> options, String parentPath, Map<String, Option> lookupMap) {
        ArrayList<Option> result = new ArrayList<Option>();
        for (de.pontonconsulting.xmlpipe.config.partnerprofile.Option element : options) {
            Option option = new Option(element.getName(), element.getValue(), element.getType());
            String path = parentPath + "/" + option.getName();
            lookupMap.put(path, option);
            List subOptions = element.getOption();
            Option[] subOptionsArray = this.getSubOptions(subOptions, path, lookupMap);
            option.setSubOptions(subOptionsArray);
            result.add(option);
        }
        return result.toArray(new Option[0]);
    }

    public String getPackagingOptionValue(String id, String optionPath) throws PackageIdNotFoundException {
        Option opt = this.packagingOptionLookup.get("/" + id + optionPath);
        if (opt == null) {
            throw new PackageIdNotFoundException();
        }
        return opt.getValue();
    }

    public void setPackagingOptionValue(String id, String optionPath, String value, String type) throws PackageIdNotFoundException {
        Option opt = this.packagingOptionLookup.get("/" + id + optionPath);
        if (opt == null) {
            try {
                opt = this.createOptionPath(id, optionPath, new PackageIdNotFoundException(), this.packagingOptionLookup);
            }
            catch (IdNotFoundException e) {
                throw (PackageIdNotFoundException)e;
            }
            opt.setType(type);
        }
        opt.setValue(value);
        this.packagingDirty = true;
    }

    protected Option createOptionPath(String id, String optionPath, IdNotFoundException exception, Map<String, Option> optionLookup) throws IdNotFoundException {
        Option lastOption;
        String lastOptionPath = "/" + id + optionPath;
        int offset = lastOptionPath.length();
        do {
            if ((offset = lastOptionPath.lastIndexOf("/", offset)) <= 0) {
                throw exception;
            }
            String parentOption = lastOptionPath.substring(0, offset);
            lastOption = optionLookup.get(parentOption);
            --offset;
        } while (lastOption == null);
        int newOffset = -1;
        ++offset;
        ++offset;
        while (offset != 0) {
            Object newOptionLookupId;
            String newOptionName;
            newOffset = lastOptionPath.indexOf("/", offset);
            if (newOffset != -1) {
                newOptionName = lastOptionPath.substring(offset, newOffset);
                newOptionLookupId = lastOptionPath.substring(0, newOffset);
            } else {
                newOptionName = lastOptionPath.substring(offset);
                newOptionLookupId = lastOptionPath;
            }
            Option[] oldOptions = lastOption.getSubOptions();
            ArrayList<Option> oldOptionsA = new ArrayList<Option>();
            Collections.addAll(oldOptionsA, oldOptions);
            Option newOption = new Option(newOptionName, null, null);
            oldOptionsA.add(newOption);
            Option[] newOptions = oldOptionsA.toArray(new Option[0]);
            lastOption.setSubOptions(newOptions);
            optionLookup.put((String)newOptionLookupId, newOption);
            lastOption = newOption;
            offset = newOffset + 1;
        }
        return lastOption;
    }

    public String[] getPipelineIds() {
        return this.allPipelineIds.keySet().toArray(new String[0]);
    }

    public String getPreferredPipelineId() {
        String preferredId = null;
        Collection<Pipeline> pipelines = this.allPipelineIds.values();
        for (Pipeline pipelineType : pipelines) {
            if (!pipelineType.isPreferred()) continue;
            preferredId = pipelineType.getId();
            break;
        }
        return preferredId;
    }

    public boolean hasPipelineId(String id) {
        return this.allPipelineIds.containsKey(id);
    }

    public String getPipelineCertRef(String pipelineId) throws PipelineIdNotFoundException {
        String result = null;
        Pipeline pipe = this.findPipeline(pipelineId);
        if (pipe.getCertificate() != null) {
            result = pipe.getCertificate().getRefId();
        }
        return result;
    }

    public void setPipelineCertificate(String pipeId, String certId) throws PipelineIdNotFoundException, CertificateIdNotFoundException {
        Pipeline pipe = this.findPipeline(pipeId);
        if (certId == null) {
            pipe.setCertificate(null);
        } else {
            Object[] certIds = this.getCertificateIds();
            if (!ArrayUtils.contains((Object[])certIds, (Object)certId)) {
                throw new CertificateIdNotFoundException(-1, "Certificate Id '" + certId + "' not found.");
            }
            Certificate certType = factoryPublic.createCertificate();
            certType.setRefId(certId);
            pipe.setCertificate(certType);
        }
    }

    public Option[] getPipelineOptions(String id) throws PipelineIdNotFoundException {
        Option all = this.getPipelineRootOption(id);
        if (all == null) {
            throw new PipelineIdNotFoundException();
        }
        return all.getSubOptions();
    }

    private Pipeline findPipeline(String id) throws PipelineIdNotFoundException {
        if (id == null) {
            throw new PipelineIdNotFoundException();
        }
        Pipeline result = this.allPipelineIds.get(id);
        if (result == null) {
            throw new PipelineIdNotFoundException();
        }
        return result;
    }

    private Package findPackage(String packageId) throws PackageIdNotFoundException {
        if (packageId == null) {
            throw new PackageIdNotFoundException();
        }
        Package result = this.allPackagingIds.get(packageId);
        if (result == null) {
            throw new PackageIdNotFoundException();
        }
        return result;
    }

    public String getPipelineOptionValue(String id, String optionPath) throws OptionNotFoundException {
        Option opt = this.getPipelineOption(id, optionPath);
        return opt.getValue();
    }

    public Option getPipelineOption(String id, String optionPath) throws OptionNotFoundException {
        Option opt = this.pipelineOptionLookup.get("/" + id + optionPath);
        if (opt == null) {
            throw new OptionNotFoundException();
        }
        return opt;
    }

    public void setPipelineOptionValue(String id, String optionPath, String value, String type) throws PipelineIdNotFoundException {
        Option opt = this.pipelineOptionLookup.get("/" + id + optionPath);
        if (opt == null) {
            this.addPipelineOption(id, optionPath, value, type);
        } else {
            opt.setValue(value);
            if (type != null) {
                opt.setType(type);
            }
        }
        this.pipelineDirty = true;
    }

    private void addPipelineOption(String id, String optionPath, String value, String type) throws PipelineIdNotFoundException {
        Option opt;
        try {
            opt = this.createOptionPath(id, optionPath, new PipelineIdNotFoundException(), this.pipelineOptionLookup);
        }
        catch (IdNotFoundException e) {
            throw (PipelineIdNotFoundException)e;
        }
        opt.setValue(value);
        if (type != null) {
            opt.setType(type);
        }
    }

    @Override
    public int compareTo(CppPartner partner) {
        return this.getDisplayName().toLowerCase().compareTo(partner.getDisplayName().toLowerCase());
    }

    public boolean isFromRegistry() {
        return this.getRemoteFile() != null && !this.getRemoteFile().trim().isEmpty();
    }

    public String toString() {
        return this.getDisplayName() + "[" + this.getLocalId() + "][" + this.getInternalId() + "]";
    }

    public boolean isCertUpdateAllowed() {
        return this.privateProfile.isAllowCertificateUpdate();
    }

    public void setCertUpdateAllowed(boolean flag) {
        this.privateProfile.setAllowCertificateUpdate(Boolean.valueOf(flag));
    }

    public String addPartnerCertificate(java.security.cert.X509Certificate cert) throws CertificateEncodingException {
        Optional<String> existing = this.allCertificates.entrySet().stream().filter(entry -> cert.equals(entry.getValue())).map(Map.Entry::getKey).findFirst();
        if (existing.isPresent()) {
            return existing.get();
        }
        String nextCertId = this.createNextCertId();
        byte[] encoded = cert.getEncoded();
        this.addX509Certificate(nextCertId, encoded);
        this.allCertificates.put(nextCertId, cert);
        this.rebuildCrypto();
        return nextCertId;
    }

    private String createNextCertId() {
        String[] certIds = this.getCertificateIds();
        return this.createNextCertId(certIds, "c1", 1);
    }

    private String createNextCertId(String[] certIds, String certId, int nextCert) {
        if (!ArrayUtils.contains((Object[])certIds, (Object)certId)) {
            return certId;
        }
        return this.createNextCertId(certIds, CERTIFICATE_ID_PREFIX + ++nextCert, nextCert);
    }

    public void deletePackages() {
        for (String packagingId : this.getPackagingIds()) {
            this.deletePackage(packagingId);
        }
    }

    public boolean deleteUnknownPackages() {
        String[] prntPackIds;
        boolean changed = false;
        Set<String> msngPackIds = Set.of(this.packagingManager.getPackagingIds());
        for (String packId : prntPackIds = this.getPackagingIds()) {
            String prntPackId = packId;
            if (msngPackIds.contains(prntPackId)) continue;
            this.deletePackage(prntPackId);
            changed = true;
        }
        return changed;
    }

    public boolean addPackages() {
        boolean changed = false;
        String[] msngPackIds = this.packagingManager.getPackagingIds();
        String[] prntPackIds = this.getPackagingIds();
        List<String> prntPackIds_asList = Arrays.asList(prntPackIds);
        for (String packId : msngPackIds) {
            String msngPackId = packId;
            if (prntPackIds_asList.contains(msngPackId)) continue;
            try {
                this.addPackage(msngPackId);
                this.setAllPackagingOptionsForId(msngPackId, true);
                changed = true;
            }
            catch (PackageIdNotFoundException packageIdNotFoundException) {
                // empty catch block
            }
        }
        return changed;
    }

    public String buildAliasForPartnerCertificate(java.security.cert.X509Certificate cert) {
        return this.getLocalId() + PARTNER_CERT_ALIAS_SEPARATOR + cert.getSerialNumber().toString();
    }

    public static Partner parse(File publicPartnerFile) {
        try {
            Unmarshaller unmarshaller = JC_PUBLIC.createUnmarshaller();
            return (Partner)unmarshaller.unmarshal(publicPartnerFile);
        }
        catch (Exception ex) {
            log.error((Object)ex.getMessage());
            return null;
        }
    }

    public void setProfiles(Profiles profiles) {
        this.profiles = profiles;
    }

    public void setSchemataConfig(SchemataConfig schemataConfig) {
        this.schemataConfig = schemataConfig;
    }

    public void setUiConfig(UIConfig uiConfig) {
        this.uiConfig = uiConfig;
    }

    public void setPipelineFactory(IPipelineFactory pipelineFactory) {
        this.pipelineFactory = pipelineFactory;
    }

    public void setPackagingManager(IPackagingManager packagingManager) {
        this.packagingManager = packagingManager;
    }

    public void setAgreementUpdateUtility(AgreementUpdateUtility agreementUpdateUtility) {
        this.agreementUpdateUtility = agreementUpdateUtility;
    }

    public void setPasswordCrypt(IPasswordCrypt passwordCrypt) {
        this.passwordCrypt = passwordCrypt;
    }

    public void setKeystoreBean(KeystoreBean keystore) {
        this.keystoreBean = keystore;
    }

    public void setReferenceDateTask(ReferenceDateTask referenceDateTask) {
        this.referenceDateTask = referenceDateTask;
    }

    public void setProfileUpdate(ProfileUpdate profileUpdate) {
        this.profileUpdate = profileUpdate;
    }

    public void setDocumentTypeResolver(DocumentTypeResolver documentTypeResolver) {
        this.documentTypeResolver = documentTypeResolver;
    }

    public void setDistributionConfigFinder(DistributionConfigFinder distributionConfigFinder) {
        this.distributionConfigFinder = distributionConfigFinder;
    }

    public void setConfigMigrationService(ConfigMigrationService configMigrationService) {
        this.configMigrationService = configMigrationService;
    }

    public CppContactInformation getContactInformation() {
        ContactInformations contacts = this.profile.getContactInformations();
        if (contacts == null) {
            return null;
        }
        if (contacts.getContact().isEmpty()) {
            return null;
        }
        Contact contact = (Contact)contacts.getContact().getFirst();
        CppContactInformation contactInformation = new CppContactInformation();
        contactInformation.setName(contact.getName());
        contactInformation.setEmail(contact.getEmail());
        contactInformation.setPhone(contact.getPhone());
        return contactInformation;
    }

    public void setContactInformation(CppContactInformation contactInformation) {
        if (contactInformation == null) {
            return;
        }
        String name = contactInformation.getName();
        String email = contactInformation.getEmail();
        String phone = contactInformation.getPhone();
        if (StringUtils.isBlank((CharSequence)name) && StringUtils.isBlank((CharSequence)email) && StringUtils.isBlank((CharSequence)phone)) {
            this.profile.setContactInformations(null);
            return;
        }
        ContactInformations contacts = this.profile.getContactInformations();
        if (contacts == null) {
            contacts = factoryPublic.createContactInformations();
        } else {
            contacts.getContact().clear();
        }
        Contact contact = factoryPublic.createContact();
        if (StringUtils.isNotBlank((CharSequence)name)) {
            contact.setName(name);
        }
        if (StringUtils.isNotBlank((CharSequence)email)) {
            contact.setEmail(email);
        }
        if (StringUtils.isNotBlank((CharSequence)phone)) {
            contact.setPhone(phone);
        }
        contacts.getContact().add(contact);
        this.profile.setContactInformations(contacts);
    }

    public boolean isMigrated() {
        String compatibilityVersion = this.profile.getCompatibilityVersion();
        return StringUtils.isNotBlank((CharSequence)compatibilityVersion) && compatibilityVersion.equals("3.3");
    }

    private void setCompatibilityVersion() {
        this.profile.setCompatibilityVersion("3.3");
    }

    public String addPrivateKey(java.security.cert.X509Certificate certificate, PrivateKey privateKey, String password) throws GeneralSecurityException {
        String certId = this.allCertificates.containsValue(certificate) ? this.findCertId(privateKey) : this.addPartnerCertificate(certificate);
        String alias = this.buildAliasForPartnerCertificate(certificate);
        if (StringUtils.isBlank((CharSequence)alias)) {
            throw new NullPointerException("Can't add private key with empty alias for Partner '" + this.getLocalId() + "'");
        }
        if (privateKey == null) {
            throw new NullPointerException("Can't add private key with null private key for Partner '" + this.getLocalId() + "'");
        }
        this.savePrivateKeyAndPassword(privateKey, password, alias, certId);
        this.privateKeys.put(certId, privateKey);
        this.rebuildCrypto();
        return certId;
    }

    private String findCertId(PrivateKey privateKey) {
        String certId = null;
        for (String certKey : this.allCertificates.keySet()) {
            java.security.cert.X509Certificate cert = this.allCertificates.get(certKey);
            RSAKey c = (RSAKey)((Object)cert.getPublicKey());
            RSAKey p = (RSAKey)((Object)privateKey);
            if (!c.getModulus().equals(p.getModulus())) continue;
            certId = certKey;
            break;
        }
        return certId;
    }

    private void updateOrCreatePrivateKey(String certId, String alias, byte[] encoded) {
        boolean isNew = false;
        de.pontonconsulting.xmlpipe.config.privatepartnerprofile.PrivateKey jaxbPrivateKey = (de.pontonconsulting.xmlpipe.config.privatepartnerprofile.PrivateKey)CollectionUtils.find((Collection)this.privateProfile.getPrivateKey(), (Predicate)new PrivateKeyPredicate(alias));
        if (jaxbPrivateKey == null) {
            jaxbPrivateKey = factoryPrivate.createPrivateKey();
            isNew = true;
        }
        jaxbPrivateKey.setId(certId);
        jaxbPrivateKey.setAlias(alias);
        jaxbPrivateKey.setValue(encoded);
        if (isNew) {
            this.privateProfile.getPrivateKey().add(jaxbPrivateKey);
        }
    }

    private void updateOrCreatePrivateKeyPassword(String certId, String alias, byte[] encoded) {
        boolean isNew = false;
        PrivateKeyPassword jaxbPrivateKeyPassword = (PrivateKeyPassword)CollectionUtils.find((Collection)this.privateProfile.getPrivateKeyPassword(), (Predicate)new PrivateKeyPasswordPredicate(alias));
        if (jaxbPrivateKeyPassword == null) {
            jaxbPrivateKeyPassword = factoryPrivate.createPrivateKeyPassword();
            isNew = true;
        }
        jaxbPrivateKeyPassword.setId(certId);
        jaxbPrivateKeyPassword.setAlias(alias);
        jaxbPrivateKeyPassword.setValue(encoded);
        if (isNew) {
            this.privateProfile.getPrivateKeyPassword().add(jaxbPrivateKeyPassword);
        }
    }

    public void addCertificateRequest(PrivateKey privateKey, String password, CertificateRequest certificateRequest) throws GeneralSecurityException, IOException {
        this.savePrivateKeyAndPassword(privateKey, password, certificateRequest.getId(), certificateRequest.getId());
        de.pontonconsulting.xmlpipe.config.privatepartnerprofile.CertificateRequest jaxbCertificateRequest = factoryPrivate.createCertificateRequest();
        jaxbCertificateRequest.setValue(certificateRequest.getDER());
        jaxbCertificateRequest.setId(certificateRequest.getId());
        this.privateProfile.getCertificateRequest().add(jaxbCertificateRequest);
        this.privateKeys.put(certificateRequest.getId(), privateKey);
    }

    public List<CertificateRequest> getAllCertificateRequests() throws IOException {
        List jaxbCertificateRequests = this.privateProfile.getCertificateRequest();
        ArrayList<CertificateRequest> result = new ArrayList<CertificateRequest>();
        for (de.pontonconsulting.xmlpipe.config.privatepartnerprofile.CertificateRequest jaxbCertRequest : jaxbCertificateRequests) {
            result.add(new CertificateRequest(jaxbCertRequest.getId(), jaxbCertRequest.getValue()));
        }
        return result;
    }

    private void savePrivateKeyAndPassword(PrivateKey privateKey, String password, String alias, String certId) throws GeneralSecurityException {
        byte[] encryptPassword;
        byte[] encoded;
        try {
            PKCS8EncryptedPrivateKeyInfo privateKeyInfo = CryptoUtil.createPkcs8PrivateKeyInfo(password, privateKey);
            encoded = privateKeyInfo.getEncoded();
            log.trace((Object)"Successfully created private key in pkcs8 format.");
            encryptPassword = this.passwordCrypt.encryptPassword(password);
            log.trace((Object)"Successfully encrypted private key password.");
        }
        catch (IOException | OperatorCreationException e) {
            log.error((Object)e.getMessage());
            throw new GeneralSecurityException(e);
        }
        this.updateOrCreatePrivateKey(certId, alias, encoded);
        this.updateOrCreatePrivateKeyPassword(certId, alias, encryptPassword);
    }

    public PrivateKey loadPrivateKey(java.security.cert.X509Certificate certificate, String password) {
        return this.getPrivateKey(password, this.buildAliasForPartnerCertificate(certificate));
    }

    private PrivateKey getPrivateKey(String password, String alias) {
        List keys = this.privateProfile.getPrivateKey();
        de.pontonconsulting.xmlpipe.config.privatepartnerprofile.PrivateKey key = (de.pontonconsulting.xmlpipe.config.privatepartnerprofile.PrivateKey)CollectionUtils.find((Collection)keys, (Predicate)new PrivateKeyPredicate(alias));
        if (key == null) {
            return null;
        }
        try {
            return CryptoUtil.createPrivateKey(password, key.getValue());
        }
        catch (IOException | NoSuchAlgorithmException | NoSuchProviderException | InvalidKeySpecException | OperatorCreationException | PKCSException e) {
            log.error((Object)e.getMessage());
            return null;
        }
    }

    public Partner getPublicPart() {
        return this.profile;
    }

    public PrivatePartner getPrivatePart() {
        return this.privateProfile;
    }

    public void setCertificateUtility(CertificateUtility certificateUtility) {
        this.certificateUtility = certificateUtility;
    }

    public PrivateKey findPrivateKey(java.security.cert.X509Certificate cert) {
        return CryptoUtil.findPrivateKey(cert, this.privateKeys.values());
    }

    public void removeCertificateRequestData(java.security.cert.X509Certificate cert, String password) {
        Optional<String> aliasForCertificateRequest = this.findAliasForCertificateRequest(cert, password);
        aliasForCertificateRequest.ifPresent(this::removeCertificateRequestData);
    }

    public void removeCertificateRequestData(String aliasForCertificateRequestId) {
        this.privateProfile.getPrivateKey().stream().filter(key -> key.getAlias().equals(aliasForCertificateRequestId)).findFirst().ifPresent(this.privateProfile.getPrivateKey()::remove);
        this.privateProfile.getPrivateKeyPassword().stream().filter(privateKeyPassword -> aliasForCertificateRequestId.equals(privateKeyPassword.getAlias()) && privateKeyPassword.getAlias().startsWith("temp_$")).findFirst().ifPresent(this.privateProfile.getPrivateKeyPassword()::remove);
        this.privateProfile.getCertificateRequest().stream().filter(certificateRequest -> aliasForCertificateRequestId.equals(certificateRequest.getId()) && certificateRequest.getId().startsWith("temp_$")).findFirst().ifPresent(this.privateProfile.getCertificateRequest()::remove);
        this.privateKeys.remove(aliasForCertificateRequestId);
    }

    private Optional<String> findAliasForCertificateRequest(java.security.cert.X509Certificate cert, String password) {
        PrivateKey privateKey = this.findPrivateKey(cert);
        Optional<de.pontonconsulting.xmlpipe.config.privatepartnerprofile.PrivateKey> firstKey = this.privateProfile.getPrivateKey().stream().filter(key -> {
            try {
                return privateKey.equals(CryptoUtil.createPrivateKey(password, key.getValue())) && key.getAlias().startsWith("temp_$");
            }
            catch (Exception e) {
                return false;
            }
        }).findFirst();
        return firstKey.map(de.pontonconsulting.xmlpipe.config.privatepartnerprofile.PrivateKey::getAlias);
    }

    public boolean isValid() {
        return this.getAllCertificates().size() == this.getAllValidCertificates().size();
    }

    public void setCertificateRevoked(java.security.cert.X509Certificate certificate, boolean revoked) {
        Optional<CertificateStatus> status = this.getCertificateStatus(certificate);
        if (status.isEmpty()) {
            status = this.getNewRevocationStatus(certificate);
        }
        if (!revoked) {
            status.get().setLastSuccessfulQuery(Long.valueOf(this.referenceDateTask.getReferenceCurrentTimeMillis()));
        }
        status.get().setRevoked(Boolean.valueOf(revoked));
    }

    public Optional<CertificateStatus> getNewRevocationStatus(java.security.cert.X509Certificate certificate) {
        CertificateStatus newStatus = new CertificateStatus();
        newStatus.setId(this.getCertificateId(certificate));
        newStatus.setLastSuccessfulQuery(Long.valueOf(this.referenceDateTask.getReferenceCurrentTimeMillis()));
        this.privateProfile.getCertificateStatus().add(newStatus);
        Optional<CertificateStatus> status = Optional.of(newStatus);
        return status;
    }

    public Optional<CertificateStatus> getCertificateStatus(java.security.cert.X509Certificate certificate) {
        String id = this.getCertificateId(certificate);
        List statusList = this.privateProfile.getCertificateStatus();
        CertificateStatus status = null;
        for (CertificateStatus next : statusList) {
            if (!next.getId().equals(id)) continue;
            status = next;
            break;
        }
        return Optional.ofNullable(status);
    }

    public Optional<Instant> getTimestampOfLastSuccessfulRevocationCheck(java.security.cert.X509Certificate certificate) {
        return this.getCertificateStatus(certificate).map(certificateStatus -> Instant.ofEpochMilli(certificateStatus.getLastSuccessfulQuery()));
    }

    public List<RemoteMaintenanceInterval> getMaintenanceIntervals() {
        ArrayList<RemoteMaintenanceInterval> result = new ArrayList<RemoteMaintenanceInterval>();
        List maintenancePeriods = this.privateProfile.getMaintenancePeriod();
        if (maintenancePeriods != null) {
            for (MaintenancePeriod maintenancePeriod : maintenancePeriods) {
                result.add(new RemoteMaintenanceInterval(maintenancePeriod.getStart(), maintenancePeriod.getEnd()));
            }
        }
        return result;
    }

    public void setServerConfig(IServerConfigBean serverConfig) {
        this.serverConfig = serverConfig;
    }

    public void setPartnerProfileDAO(PartnerProfileDAO partnerProfileDAO) {
        this.partnerProfileDAO = partnerProfileDAO;
    }

    public void setCryptoFactory(CryptoFactory cryptoFactory) {
        this.cryptoFactory = cryptoFactory;
    }

    @Override
    public void setReadOnly() {
    }

    @Override
    public OffsetDateTime getLastChange() {
        return this.lastChange;
    }

    public CppPartner setLastChange(OffsetDateTime lastChange) {
        this.lastChange = lastChange;
        return this;
    }

    static {
        factoryPublic = new de.pontonconsulting.xmlpipe.config.partnerprofile.ObjectFactory();
        factoryPrivate = new ObjectFactory();
        try {
            JC_PUBLIC = JAXBContext.newInstance((String)PROFILES_CONFIG_CLASSES);
            JC_PRIVATE = JAXBContext.newInstance((String)PRIVATE_PROFILES_CONFIG_CLASSES);
        }
        catch (JAXBException e) {
            log.error((Object)"Can't create Jaxb Context", (Throwable)e);
        }
    }
}

