/*
 * Decompiled with CFR 0.152.
 */
package de.pontonconsulting.xmlpipe.cpa;

import de.pontonconsulting.common.file.GenericFileFilter;
import de.pontonconsulting.common.util.DataCache;
import de.pontonconsulting.xmlpipe.adapter.IAgreementEventListener;
import de.pontonconsulting.xmlpipe.config.DistributionConfigFinder;
import de.pontonconsulting.xmlpipe.config.IServerConfigBean;
import de.pontonconsulting.xmlpipe.config.MessengerConfig;
import de.pontonconsulting.xmlpipe.config.SchemataConfig;
import de.pontonconsulting.xmlpipe.config.partneragreement.CollaborationAgreement;
import de.pontonconsulting.xmlpipe.cp.DocumentType;
import de.pontonconsulting.xmlpipe.cpa.Agreement;
import de.pontonconsulting.xmlpipe.cpa.AgreementException;
import de.pontonconsulting.xmlpipe.cpa.AgreementNotFoundException;
import de.pontonconsulting.xmlpipe.cpa.AgreementStoreAccessException;
import de.pontonconsulting.xmlpipe.cpa.Communication;
import de.pontonconsulting.xmlpipe.cpa.IAgreementFactory;
import de.pontonconsulting.xmlpipe.cpp.CppPartner;
import de.pontonconsulting.xmlpipe.cpp.ProfileException;
import de.pontonconsulting.xmlpipe.cpp.Profiles;
import de.pontonconsulting.xmlpipe.events.ServiceLevel;
import de.pontonconsulting.xmlpipe.events.ShutdownCompleted;
import de.pontonconsulting.xmlpipe.events.ShutdownService;
import de.pontonconsulting.xmlpipe.events.StartupCompleted;
import de.pontonconsulting.xmlpipe.events.StartupService;
import de.pontonconsulting.xmlpipe.messenger.IServiceProvider;
import de.pontonconsulting.xmlpipe.messenger.database.hibernate.AgreementListItem;
import de.pontonconsulting.xmlpipe.messenger.database.hibernate.PartnerAgreement;
import de.pontonconsulting.xmlpipe.messenger.database.tables.EventLog;
import de.pontonconsulting.xmlpipe.messenger.database.tables.PartnerAgreementDAO;
import de.pontonconsulting.xmlpipe.messenger.migration.ConfigMigrationService;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Queue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.LinkedBlockingQueue;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;

public class Agreements
implements IServiceProvider {
    private static final Logger _log = LogManager.getLogger((String)"Messenger.Agreements");
    private static final ThreadLocal<ThreadCache> AGREEMENT_THREAD_CACHE = new ThreadLocal();
    private final File configFolder;
    private final File privateConfigFolder;
    private final SchemataConfig schemataConfig;
    private final MessengerConfig messengerConfig;
    private final Profiles profiles;
    private final ConfigMigrationService configMigrationService;
    private final IAgreementFactory agreementFactory;
    private final List<IAgreementEventListener> listener = new ArrayList<IAgreementEventListener>();
    private final ApplicationEventPublisher applicationEventPublisher;
    private final DistributionConfigFinder distributionConfigFinder;
    private final PartnerAgreementDAO partnerAgreementDAO;
    private final EventLog eventLog;
    public static String CONFIG_PARTNER_AGREEMENTS = "partneragreements";
    public static String AGREEMENT_PRIVATE_FOLDER = "private";
    private final DataCache<String, Agreement> agreementDataCache;

    public static void initThreadCache() {
        AGREEMENT_THREAD_CACHE.set(new ThreadCache());
        _log.trace("Agreement thread cache initialized");
    }

    public static void clearThreadCache() {
        AGREEMENT_THREAD_CACHE.remove();
        _log.trace("Agreement thread cache cleared");
    }

    private Agreement loadAgreementToCache(String agreementId) {
        try {
            return this.loadAgreement(agreementId);
        }
        catch (AgreementException e) {
            return null;
        }
    }

    public Agreements(IServerConfigBean serverConfig, SchemataConfig schemataConfig, MessengerConfig messengerConfig, Profiles profiles, ConfigMigrationService configMigrationService, IAgreementFactory agreementFactory, ApplicationEventPublisher applicationEventPublisher, DistributionConfigFinder distributionConfigFinder, PartnerAgreementDAO partnerAgreementDAO, EventLog eventLog) throws AgreementException {
        int maxCapacity;
        this.schemataConfig = schemataConfig;
        this.messengerConfig = messengerConfig;
        this.profiles = profiles;
        this.configMigrationService = configMigrationService;
        this.agreementFactory = agreementFactory;
        this.applicationEventPublisher = applicationEventPublisher;
        this.distributionConfigFinder = distributionConfigFinder;
        this.partnerAgreementDAO = partnerAgreementDAO;
        this.eventLog = eventLog;
        try {
            maxCapacity = Integer.parseInt(System.getProperty("messenger.cache.agreement.size", "1000"));
            if (maxCapacity <= 0) {
                _log.warn("System property messenger.cache.agreement.size system property must be greater than 0. Using default value 1000.");
                maxCapacity = 1000;
            }
        }
        catch (NumberFormatException e) {
            _log.warn("Can't parse system property messenger.cache.agreement.size to int. Using default value 1000.");
            maxCapacity = 1000;
        }
        this.agreementDataCache = new DataCache<String, Agreement>(this::loadAgreementToCache, partnerAgreementDAO::getLastChanged, maxCapacity);
        if (_log.isTraceEnabled()) {
            _log.trace("ctor");
        }
        if (serverConfig == null || serverConfig.getConfigFolder() == null) {
            throw new AgreementException(35000, "No configuration given!!!");
        }
        this.configFolder = new File(serverConfig.getConfigFolder(), CONFIG_PARTNER_AGREEMENTS);
        if (!this.configFolder.isDirectory()) {
            throw new AgreementException(35001, new String[]{this.configFolder.getAbsolutePath()}, "Config folder is missing.");
        }
        this.privateConfigFolder = new File(this.configFolder, AGREEMENT_PRIVATE_FOLDER);
        if (!this.privateConfigFolder.isDirectory()) {
            throw new AgreementException(35001, new String[]{this.privateConfigFolder.getAbsolutePath()}, "Config folder is missing.");
        }
    }

    public void init() {
        if (this.partnerAgreementDAO.getAllAgreementIds().isEmpty()) {
            this.importAgreementsFromConfigFolder();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Deprecated
    private void importAgreementsFromConfigFolder() {
        File[] agreementPublicFiles = this.configFolder.listFiles(new GenericFileFilter(new String[]{"xml"}, false));
        if (agreementPublicFiles == null) return;
        File[] fileArray = agreementPublicFiles;
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            block27: {
                File publicFile = fileArray[n2];
                Path privatePartFile = Paths.get(this.privateConfigFolder.getAbsolutePath(), publicFile.getName());
                try {
                    block28: {
                        CppPartner communicationPartner;
                        CppPartner ownPartner;
                        BufferedInputStream publicPart = new BufferedInputStream(Files.newInputStream(publicFile.toPath(), new OpenOption[0]));
                        BufferedInputStream privatePart = new BufferedInputStream(Files.newInputStream(privatePartFile, new OpenOption[0]));
                        Agreement agreement = this.convertAgreementParts(publicPart, privatePart);
                        try {
                            ownPartner = this.profiles.getProfileForLocalId(agreement.getPartner1LocalId(), true);
                            communicationPartner = this.profiles.getProfileForLocalId(agreement.getPartner2LocalId(), true);
                        }
                        catch (ProfileException e) {
                            _log.warn("Can't import agreement '{}' because: {}", (Object)publicFile, (Object)e.getMessage());
                            ((InputStream)privatePart).close();
                            ((InputStream)publicPart).close();
                            break block27;
                        }
                        if (Objects.isNull(agreement.getId())) {
                            if (ownPartner.isRemote()) {
                                _log.warn("Switching partners for agreement '{}' because OwnPartner ({}) is remote", (Object)publicFile, (Object)agreement.getOwnPartner().getId());
                                agreement.switchPartners();
                            }
                            _log.warn("The agreement '{}' does not have an id. Trying to create a new one.", (Object)publicFile);
                            agreement.setId(this.getId(agreement.getPartner1LocalId(), agreement.getPartner2LocalId()));
                            _log.info("Created agreement id: {}.", (Object)agreement.getId());
                            agreement.save();
                            try {
                                if (!ownPartner.isLocal() || !communicationPartner.isLocal()) break block28;
                                String ownPartnerId = agreement.getOwnPartner().getId();
                                String communicationPartnerId = agreement.getCommunicationPartner().getId();
                                String loopBackAgreementId = this.getId(communicationPartnerId, ownPartnerId);
                                if (!this.partnerAgreementDAO.agreementExists(loopBackAgreementId)) {
                                    _log.debug("Creating second loop back agreement (id:{}) between '{}' and '{}'", (Object)loopBackAgreementId, (Object)communicationPartnerId, (Object)ownPartnerId);
                                    agreement.setId(loopBackAgreementId);
                                    agreement.setPartner1LocalId(communicationPartnerId);
                                    agreement.setPartner2LocalId(ownPartnerId);
                                    agreement.save();
                                }
                            }
                            catch (AgreementException e) {
                                _log.error("Could not create loop back agreement for the file {}.", (Object)publicFile, (Object)e);
                            }
                        } else {
                            _log.info("Imported agreement (id: {}) from config folder {}", (Object)agreement.getId(), (Object)agreementPublicFiles);
                            agreement.save();
                        }
                    }
                    if (Files.deleteIfExists(publicFile.toPath())) {
                        _log.info("Deleted public agreement file {}", (Object)publicFile.getName());
                    } else {
                        _log.error("Can't delete public agreement file {}", (Object)publicFile.getName());
                    }
                    if (Files.deleteIfExists(privatePartFile)) {
                        _log.info("Deleted private agreement file {}", (Object)publicFile.getName());
                    } else {
                        _log.error("Can't delete private agreement file {}", (Object)publicFile.getName());
                    }
                }
                catch (AgreementException | IOException e) {
                    _log.error("Can't import Agreement file {}", (Object)publicFile.getName(), (Object)e);
                }
            }
            ++n2;
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private Agreement convertPartnerAgreement(PartnerAgreement partnerAgreement) throws AgreementNotFoundException, AgreementStoreAccessException {
        try (ByteArrayInputStream publicPart = new ByteArrayInputStream(partnerAgreement.getPublicAgreement());){
            Agreement agreement;
            try (ByteArrayInputStream privatePart = new ByteArrayInputStream(partnerAgreement.getPrivateAgreement());){
                Agreement agreement2 = this.convertAgreementParts(publicPart, privatePart);
                agreement2.setId(partnerAgreement.getId());
                agreement2.initUrlValidity(partnerAgreement.urlIsValid(), partnerAgreement.fallbackUrlIsValid());
                agreement2.setLastChange(partnerAgreement.getLastChange());
                agreement = agreement2;
            }
            return agreement;
        }
        catch (IOException e) {
            throw new AgreementStoreAccessException(38001, null, "Could not load agreement.", e);
        }
    }

    private Agreement convertAgreementParts(InputStream publicPart, InputStream privatePart) throws AgreementNotFoundException, AgreementStoreAccessException {
        Agreement agreement = this.agreementFactory.create();
        agreement.init(publicPart, privatePart);
        this.updateDocumentTypes(agreement);
        this.configMigrationService.migrateAgreement(agreement);
        return agreement;
    }

    private void updateDocumentTypes(Agreement agreement) {
        List<DocumentType> docs = agreement.getDocumentTypes();
        _log.trace("Agreement {} contains {} DocumentTypes", (Object)agreement.getId(), (Object)docs.size());
        ArrayList<DocumentType> newDocs = new ArrayList<DocumentType>();
        boolean changed = false;
        for (DocumentType doc : docs) {
            String schemaSetName = doc.getSchemaSet();
            if (schemaSetName == null || schemaSetName.trim().isEmpty()) {
                String schemaLocation = doc.getSchemalocation();
                ArrayList<String> names = this.schemataConfig.getSchemaSetNames(new String[]{schemaLocation});
                if (names != null && !names.isEmpty()) {
                    Iterator iterator = names.iterator();
                    while (iterator.hasNext()) {
                        String name;
                        schemaSetName = name = (String)iterator.next();
                        DocumentType newDoc = new DocumentType(doc.getType(), doc.getVersion(), doc.getNamespace(), schemaLocation, schemaSetName, doc.getDtd(), doc.getRootElement());
                        newDocs.add(newDoc);
                        changed = true;
                    }
                    continue;
                }
                _log.warn("SchemaSetName for location {} not found", (Object)schemaLocation);
                continue;
            }
            newDocs.add(doc);
        }
        if (changed) {
            _log.trace("Updated {} DocumentTypes of agreement {}", (Object)newDocs.size(), (Object)agreement.getId());
            agreement.setDocumentTypes(newDocs);
            try {
                agreement.save();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public Agreement createAgreementProposal(String ownPartnerLocalId, String communicationPartnerLocalId, String template) throws AgreementException {
        Agreement agreement = this.createAgreement(ownPartnerLocalId, communicationPartnerLocalId, template);
        agreement.setId(null);
        _log.info("Agreement proposal ({}/{}/{}) created", (Object)ownPartnerLocalId, (Object)communicationPartnerLocalId, (Object)template);
        return agreement;
    }

    Agreement createAndRegisterAgreement(String ownPartnerLocalId, String communicationPartnerLocalId, String template) throws AgreementException {
        Agreement agreement = this.createAgreement(ownPartnerLocalId, communicationPartnerLocalId, template);
        agreement.save();
        return agreement;
    }

    public Agreement createAgreement(String ownPartnerLocalId, String communicationPartnerLocalId, String templateId) throws AgreementException {
        String[] args = new String[]{ownPartnerLocalId, communicationPartnerLocalId};
        try {
            CppPartner ownPartner = this.profiles.getProfileForLocalId(ownPartnerLocalId, true);
            CppPartner communicationPartner = this.profiles.getProfileForLocalId(communicationPartnerLocalId, true);
            args = new String[]{ownPartner.getDisplayName(), communicationPartner.getDisplayName()};
            return this.createAgreement(ownPartner, communicationPartner, templateId);
        }
        catch (AgreementNotFoundException e) {
            throw e;
        }
        catch (Exception e) {
            throw new AgreementNotFoundException(36001, args, "Cannot create the agreement.", e);
        }
    }

    private Agreement createAgreement(CppPartner ownPartner, CppPartner communicationPartner, String templateId) throws AgreementException {
        this.checkPreconditionsForAgreementCreation(ownPartner, communicationPartner);
        String[] args = new String[]{ownPartner.getDisplayName(), communicationPartner.getDisplayName()};
        try {
            Agreement agreement = this.agreementFactory.create();
            agreement.init(ownPartner, communicationPartner, templateId);
            agreement.setId(this.getId(ownPartner.getLocalId(), communicationPartner.getLocalId()));
            _log.info("Agreement with ID '{}' ({}/{}) created", (Object)agreement.getId(), (Object)ownPartner.getLocalId(), (Object)communicationPartner.getLocalId());
            return agreement;
        }
        catch (AgreementNotFoundException e) {
            throw e;
        }
        catch (Exception e) {
            throw new AgreementException(36001, args, "Cannot create the agreement.", e);
        }
    }

    private void checkPreconditionsForAgreementCreation(CppPartner ownPartner, CppPartner communicationPartner) throws AgreementException {
        if (ownPartner.isRemote()) {
            throw new AgreementNotFoundException(-1, "Could not create agreement. Given own partner with ID '" + ownPartner.getLocalId() + "' is a remote partner");
        }
        if (Objects.equals(ownPartner.getLocalId(), communicationPartner.getLocalId())) {
            throw new AgreementNotFoundException(-1, "Partner '" + ownPartner.getLocalId() + "' and partner '" + communicationPartner.getLocalId() + "' is the same partner.");
        }
        if (ownPartner.isRemote() && communicationPartner.isRemote()) {
            throw new AgreementNotFoundException(-1, "The both partners '" + ownPartner.getLocalId() + "' and '" + communicationPartner.getLocalId() + "' are remote partners.");
        }
        if (!this.messengerConfig.isLoopback() && ownPartner.isLocal() && communicationPartner.isLocal()) {
            throw new AgreementNotFoundException(-1, "Agreement between local partners is not allowed.");
        }
    }

    public Agreement recreateAndRegisterAgreement(Agreement oldAgreement) throws Exception {
        CollaborationAgreement.Partner partner1 = oldAgreement.getOwnPartner();
        CollaborationAgreement.Partner partner2 = oldAgreement.getCommunicationPartner();
        CppPartner cppPartner1 = this.profiles.getProfileForLocalId(partner1.getId(), oldAgreement.isReadOnly());
        CppPartner cppPartner2 = this.profiles.getProfileForLocalId(partner2.getId(), oldAgreement.isReadOnly());
        String templateId = Objects.requireNonNullElse(oldAgreement.getTemplateId(), this.distributionConfigFinder.getDefaultAgreementTemplateId());
        Agreement newAgreement = this.createAgreement(cppPartner1, cppPartner2, templateId);
        oldAgreement.clonePrivatePartTo(newAgreement);
        newAgreement.setId(this.getId(partner1.getId(), partner2.getId()));
        newAgreement.save();
        return newAgreement;
    }

    public void removeAgreement(String agreementId, boolean useCache) throws AgreementException {
        Agreement agreement = this.getAgreement(agreementId, useCache);
        if (Objects.nonNull(agreement) && Objects.nonNull(agreement.getId())) {
            ThreadCache agreementThreadCache = AGREEMENT_THREAD_CACHE.get();
            if (agreementThreadCache != null) {
                agreementThreadCache.remove(agreementId);
            }
            this.partnerAgreementDAO.deletePartnerAgreement(agreementId);
            _log.info("Agreement with ID '{}' ({}/{}) has been removed.", (Object)agreementId, (Object)agreement.getPartner1LocalId(), (Object)agreement.getPartner2LocalId());
            try {
                CppPartner cppPartner1 = this.profiles.getProfileForLocalId(agreement.getOwnPartner().getId(), useCache);
                CppPartner cppPartner2 = this.profiles.getProfileForLocalId(agreement.getCommunicationPartner().getId(), useCache);
                String ownPartnerInternalId = cppPartner1.getInternalId();
                String commPartnerInternalId = cppPartner2.getInternalId();
                for (IAgreementEventListener listener : this.listener) {
                    listener.agreementDeleted(ownPartnerInternalId, commPartnerInternalId);
                }
            }
            catch (ProfileException profileException) {
                // empty catch block
            }
        }
    }

    public void removeAgreementsOfPartner(String partnerLocalId) {
        this.eventLog.deleteEventsForAgreement(EventLog.AGR_EVENT_ID, partnerLocalId, "%");
        this.eventLog.deleteEventsForAgreement(EventLog.AGR_EVENT_ID, "%", partnerLocalId);
        this.eventLog.deleteEventsForAgreement(EventLog.AGR_UPDATE_EVENT_ID, partnerLocalId, "%");
        this.eventLog.deleteEventsForAgreement(EventLog.AGR_UPDATE_EVENT_ID, "%", partnerLocalId);
    }

    private Agreement getExistingAgreement(String ownPartnerId, String communicationPartnerId, boolean useCache) throws AgreementException {
        Map.Entry<String, OffsetDateTime> agreement = this.partnerAgreementDAO.getAgreementIdFor(ownPartnerId, communicationPartnerId);
        if (Objects.isNull(agreement)) {
            return null;
        }
        return this.getAgreement(agreement.getKey(), useCache);
    }

    public Agreement getAgreement(String agreementId, boolean useCache) throws AgreementException {
        Agreement agreement;
        ThreadCache agreementThreadCache = AGREEMENT_THREAD_CACHE.get();
        if (agreementThreadCache != null && (agreement = agreementThreadCache.getAgreement(agreementId)) != null) {
            return agreement;
        }
        if (useCache) {
            Optional<Agreement> agreementOptional = this.agreementDataCache.get(agreementId);
            if (agreementOptional.isEmpty()) {
                throw new AgreementNotFoundException(-1, "Could not find agreement with ID '" + agreementId + "'.");
            }
            agreement = agreementOptional.get();
        } else {
            agreement = this.loadAgreement(agreementId);
        }
        if (agreementThreadCache != null) {
            agreementThreadCache.putAgreement(agreement);
        }
        return agreement;
    }

    private Agreement loadAgreement(String agreementId) throws AgreementNotFoundException, AgreementStoreAccessException {
        _log.trace("Loading agreement with ID '{}' from database", (Object)agreementId);
        PartnerAgreement partnerAgreement = this.partnerAgreementDAO.loadPartnerAgreement(agreementId);
        if (Objects.isNull(partnerAgreement)) {
            throw new AgreementNotFoundException(-1, "Could not find agreement with ID '" + agreementId + "'.");
        }
        Agreement agreement = this.convertPartnerAgreement(partnerAgreement);
        return agreement;
    }

    public String getLocalPartnerOfAgreement(String agreementId) {
        return this.partnerAgreementDAO.getLocalPartnerOfAgreement(agreementId);
    }

    public Agreement getAgreement(String ownPartnerId, String communicationPartnerId, boolean readOnly, boolean useCache) throws AgreementException {
        Agreement agreement;
        ThreadCache agreementThreadCache = AGREEMENT_THREAD_CACHE.get();
        if (agreementThreadCache != null && (agreement = agreementThreadCache.getAgreement(ownPartnerId, communicationPartnerId)) != null) {
            return agreement;
        }
        agreement = this.getExistingAgreement(ownPartnerId, communicationPartnerId, useCache);
        if (Objects.isNull(agreement) && !readOnly && this.isAutomaticPartnerCreationEnabled()) {
            agreement = this.createAgreementFromRegistryPartner(ownPartnerId, communicationPartnerId, readOnly, useCache);
        }
        if (Objects.isNull(agreement)) {
            String[] args = new String[]{ownPartnerId, communicationPartnerId};
            try {
                CppPartner partner1 = this.profiles.getProfileForLocalId(ownPartnerId, useCache);
                CppPartner partner2 = this.profiles.getProfileForLocalId(communicationPartnerId, useCache);
                args = new String[]{partner1.getDisplayName(), partner2.getDisplayName()};
            }
            catch (Exception partner1) {
                // empty catch block
            }
            String sb = "[" + args[0] + "," + args[1] + "]";
            throw new AgreementNotFoundException(36001, args, sb);
        }
        if (agreementThreadCache != null) {
            agreementThreadCache.putAgreement(agreement);
        }
        return agreement;
    }

    private synchronized Agreement createAgreementFromRegistryPartner(String ownPartnerId, String communicationPartnerId, boolean readOnly, boolean useCache) throws AgreementException {
        Agreement agreement = this.getExistingAgreement(ownPartnerId, communicationPartnerId, useCache);
        if (Objects.isNull(agreement) && !readOnly && this.isAutomaticPartnerCreationEnabled()) {
            try {
                agreement = this.createAndRegisterAgreement(ownPartnerId, communicationPartnerId, this.distributionConfigFinder.getDefaultAgreementTemplateId());
                _log.info("automatically created agreement for {} and {}", (Object)ownPartnerId, (Object)communicationPartnerId);
            }
            catch (AgreementException e) {
                _log.error("Could not create auto-Agreement.", (Throwable)e);
                throw new AgreementNotFoundException(-1, "Could not create Agreement.", e);
            }
        }
        return agreement;
    }

    public Agreement getAgreement(String ownPartnerId, String communicationPartnerId, boolean useCache) throws AgreementException {
        return this.getAgreement(ownPartnerId, communicationPartnerId, false, useCache);
    }

    private boolean isAutomaticPartnerCreationEnabled() {
        return this.messengerConfig.isRegistryPartnerCreationEnabled();
    }

    public List<String> getAllAgreementIds() {
        return List.copyOf(this.partnerAgreementDAO.getAllAgreementIds().keySet());
    }

    public List<String> getAgreementIdsForPartner(String partnerLocalId) {
        return List.copyOf(this.partnerAgreementDAO.getAgreementIdsFor(partnerLocalId).keySet());
    }

    public List<AgreementListItem> getAgreementList() {
        return this.partnerAgreementDAO.loadAgreementList();
    }

    private String getId(String ownPartnerId, String communicationPartnerId) {
        try {
            String idInfo = ownPartnerId + "|" + communicationPartnerId;
            byte[] hash = MessageDigest.getInstance("SHA-1").digest(idInfo.getBytes(StandardCharsets.UTF_8));
            StringBuilder id = new StringBuilder();
            for (byte b : hash) {
                id.append(String.format("%02X", b));
            }
            return id.toString();
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("Could not instantiate MessageDigest for SHA-1.", e);
        }
    }

    public void save(Agreement agreement) {
        try {
            String ownLocalId = agreement.getOwnPartner().getId();
            String commLocalId = agreement.getCommunicationPartner().getId();
            Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
            Communication communication = agreement.getCommunication(ownLocalId, commLocalId);
            PartnerAgreement partnerAgreement = new PartnerAgreement().setId(agreement.getId()).setOwnPartnerId(ownLocalId).setCommunicationPartnerId(commLocalId).setAdapterId(agreement.getDefaultAdapterId()).setPackagingId(communication.getPackagingId()).setPingAllEnabled(agreement.isPingAllEnabled()).setPrivateAgreement(agreement.getPrivatePart()).setPublicAgreement(agreement.getPublicPart()).setUrlIsValid(communication.isTransportURLValid()).setFallbackUrlIsValid(communication.isFallbackTransportURLValid()).setLastChange(OffsetDateTime.now(ZoneOffset.UTC)).setUsername(Objects.isNull(authentication) ? "SYSTEM" : authentication.getName());
            boolean isNewAgreement = this.partnerAgreementDAO.storePartnerAgreement(partnerAgreement);
            CppPartner ownPartner = this.profiles.getProfileForLocalId(ownLocalId, agreement.isReadOnly());
            CppPartner commPartner = this.profiles.getProfileForLocalId(commLocalId, agreement.isReadOnly());
            String ownInternalId = ownPartner.getInternalId();
            String commInternalId = commPartner.getInternalId();
            _log.info("{} Agreement {} ({}/{}) was saved into database.", (Object)(isNewAgreement ? "new" : "existing"), (Object)agreement.getId(), (Object)ownInternalId, (Object)commInternalId);
            ThreadCache agreementThreadCache = AGREEMENT_THREAD_CACHE.get();
            if (agreementThreadCache != null) {
                agreementThreadCache.putAgreement(agreement);
            }
            this.agreementDataCache.purgeEntry(agreement.getId());
            if (isNewAgreement) {
                for (IAgreementEventListener listener : this.listener) {
                    listener.agreementAdded(ownInternalId, commInternalId);
                }
            } else {
                for (IAgreementEventListener listener : this.listener) {
                    listener.agreementModified(ownInternalId, commInternalId);
                }
            }
        }
        catch (ProfileException e) {
            _log.warn("partner profile was missing when agreement was saved. {}", (Object)e.getMessage());
        }
        catch (AgreementException e) {
            throw new RuntimeException(e);
        }
    }

    public void saveUrlIsValid(String agreementId, boolean urlIsValid) {
        this.partnerAgreementDAO.saveUrlIsValid(agreementId, urlIsValid);
        _log.debug("Set Url-IsValid to '{}' on agreement {}", (Object)urlIsValid, (Object)agreementId);
    }

    public void saveFallbackUrlIsValid(String agreementId, boolean urlIsValid) {
        this.partnerAgreementDAO.saveFallbackUrlIsValid(agreementId, urlIsValid);
        _log.debug("Set FallbackUrl-IsValid to '{}' on agreement {}", (Object)urlIsValid, (Object)agreementId);
    }

    public boolean exists(String localId, String localId2) {
        return this.exists(this.getId(localId, localId2));
    }

    public boolean exists(String agreementId) {
        return this.partnerAgreementDAO.agreementExists(agreementId);
    }

    @Override
    public ServiceLevel getServiceLevel() {
        return ServiceLevel.getServiceLevel(this.getClass());
    }

    @Override
    public String getServiceName() {
        return "Agreements";
    }

    public void onApplicationEvent(ApplicationEvent event) {
        if (event instanceof StartupService) {
            StartupService startupEvent = (StartupService)event;
            if (this.getServiceLevel() == startupEvent.getServiceLevel()) {
                this.profiles.getLocalInternalIds();
                this.init();
                this.applicationEventPublisher.publishEvent((ApplicationEvent)new StartupCompleted(this));
            }
        }
        if (event instanceof ShutdownService) {
            ShutdownService shutdownEvent = (ShutdownService)event;
            if (this.getServiceLevel() == shutdownEvent.getServiceLevel()) {
                this.applicationEventPublisher.publishEvent((ApplicationEvent)new ShutdownCompleted(this));
            }
        }
    }

    public void addAgreementEventListener(IAgreementEventListener listener) {
        this.listener.add(listener);
    }

    private static class ThreadCache {
        private final int limit = 5;
        private final Queue<Agreement> agreements = new LinkedBlockingQueue<Agreement>(5);
        private final Map<String, Agreement> dbIdd2Agreement = new ConcurrentHashMap<String, Agreement>();
        private final Map<String, Agreement> partnerIds2Agreement = new ConcurrentHashMap<String, Agreement>();
        private static final String SEPARATOR = ":-)";

        private ThreadCache() {
        }

        private Agreement getAgreement(String dbId) {
            return this.dbIdd2Agreement.get(dbId);
        }

        private Agreement getAgreement(String ownPartnerId, String communicationPartnerId) {
            return this.partnerIds2Agreement.get(ownPartnerId + SEPARATOR + communicationPartnerId);
        }

        private void putAgreement(Agreement agreement) {
            if (this.agreements.size() == 5) {
                Agreement removedAgreement = this.agreements.remove();
                this.dbIdd2Agreement.remove(removedAgreement.getId());
                this.partnerIds2Agreement.remove(agreement.getOwnPartner().getId() + SEPARATOR + agreement.getCommunicationPartner().getId());
            }
            this.agreements.add(agreement);
            this.dbIdd2Agreement.put(agreement.getId(), agreement);
            this.partnerIds2Agreement.put(agreement.getOwnPartner().getId() + SEPARATOR + agreement.getCommunicationPartner().getId(), agreement);
        }

        private void remove(String agreementId) {
            Agreement removedAgreement = this.dbIdd2Agreement.remove(agreementId);
            if (removedAgreement != null) {
                this.agreements.remove(removedAgreement);
                this.partnerIds2Agreement.remove(removedAgreement.getOwnPartner().getId() + SEPARATOR + removedAgreement.getCommunicationPartner().getId());
            }
        }
    }
}

