/*
 * Decompiled with CFR 0.152.
 */
package de.pontonconsulting.xmlpipe.cpa;

import de.pontonconsulting.xmlpipe.config.AgreementTemplateBundle;
import de.pontonconsulting.xmlpipe.config.DistributionConfigFinder;
import de.pontonconsulting.xmlpipe.config.MessengerConfig;
import de.pontonconsulting.xmlpipe.config.SchemaData;
import de.pontonconsulting.xmlpipe.config.SchemataConfig;
import de.pontonconsulting.xmlpipe.cp.AdditionalSchema;
import de.pontonconsulting.xmlpipe.cp.DocumentType;
import de.pontonconsulting.xmlpipe.cpa.AgreementModel;
import de.pontonconsulting.xmlpipe.cpa.CertificateModel;
import de.pontonconsulting.xmlpipe.cpa.PartnerModel;
import de.pontonconsulting.xmlpipe.cpp.CppPartner;
import de.pontonconsulting.xmlpipe.cpp.TransportIdNotFoundException;
import jakarta.xml.bind.JAXBException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.Writer;
import java.nio.file.Files;
import java.security.cert.CertificateParsingException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.io.output.FileWriterWithEncoding;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.velocity.Template;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.context.Context;
import org.apache.velocity.tools.generic.EscapeTool;
import org.bouncycastle.asn1.x509.KeyPurposeId;

public class AgreementFileFactory {
    private static final String UTF_8 = "UTF-8";
    private static final Log LOG = LogFactory.getLog((String)"Messenger.PrivateAgreementFileFactory");
    private final DistributionConfigFinder distributionConfigFinder;
    private final MessengerConfig messengerConfig;
    private final VelocityEngine velocityEngine;
    private final SchemataConfig schemataConfig;

    public AgreementFileFactory(DistributionConfigFinder distributionConfigFinder, MessengerConfig messengerConfig, VelocityEngine velocityEngine, SchemataConfig schemataConfig) {
        this.distributionConfigFinder = distributionConfigFinder;
        this.messengerConfig = messengerConfig;
        this.velocityEngine = velocityEngine;
        this.schemataConfig = schemataConfig;
    }

    public File createAgreementPrivateFile(CppPartner ownPartner, CppPartner communicationPartner, String agreementTemplateId) throws JAXBException, IOException, TransportIdNotFoundException {
        AgreementTemplateBundle agreementTemplateBundle = this.distributionConfigFinder.getAgreementTemplateBundle(agreementTemplateId);
        String templateLocation = agreementTemplateBundle.getAgreementPrivateTemplate();
        return this.createFile(templateLocation, ownPartner, communicationPartner);
    }

    public File createAgreementFile(CppPartner ownPartner, CppPartner communicationPartner, String agreementTemplateId) throws JAXBException, IOException, TransportIdNotFoundException {
        AgreementTemplateBundle agreementTemplateBundle = this.distributionConfigFinder.getAgreementTemplateBundle(agreementTemplateId);
        String templateLocation = agreementTemplateBundle.getAgreementTemplate();
        return this.createFile(templateLocation, ownPartner, communicationPartner);
    }

    private File createFile(String templateLocation, CppPartner ownPartner, CppPartner communicationPartner) throws IOException, JAXBException, TransportIdNotFoundException {
        PartnerModel communicationPartnerModel;
        PartnerModel ownPartnerModel;
        if (ownPartner.isLocal()) {
            ownPartnerModel = this.createPartnerModel(ownPartner);
            communicationPartnerModel = this.createPartnerModel(communicationPartner);
        } else {
            ownPartnerModel = this.createPartnerModel(communicationPartner);
            communicationPartnerModel = this.createPartnerModel(ownPartner);
        }
        AgreementModel agreementModel = new AgreementModel().setOwnPartner(ownPartnerModel).setCommunicationPartner(communicationPartnerModel).setAdapterId(this.messengerConfig.getDefaultAdapterId()).setDocumentTypes(this.getAllSupportedDocumentTypes(ownPartner, communicationPartner)).setRetries(this.messengerConfig.getDefaultRetransmissionRetries()).setRetryIntervals(this.messengerConfig.getDefaultRetransmissionRetryIntervals());
        File tempFile = File.createTempFile("temp_", ".agr");
        try {
            this.writeFile(tempFile, agreementModel, templateLocation);
        }
        catch (IOException e) {
            Files.deleteIfExists(tempFile.toPath());
            throw e;
        }
        return tempFile;
    }

    private List<DocumentType> getAllSupportedDocumentTypes(CppPartner ownPartner, CppPartner communicationPartner) {
        List<DocumentType> supportedDocumentTypes = ownPartner.getDocumentTypes().stream().filter(communicationPartner.getDocumentTypes()::contains).collect(Collectors.toList());
        supportedDocumentTypes.forEach(documentType -> {
            SchemaData schema = this.schemataConfig.getSchemaBySetTypeVersion(documentType.getSchemaSet(), documentType.getType(), documentType.getVersion());
            if (schema != null) {
                for (AdditionalSchema additionalSchema : schema.getAdditionalSchemata()) {
                    documentType.addAdditionalSchema(additionalSchema);
                }
                documentType.setDtd(schema.getDtdFile());
            }
        });
        Collections.sort(supportedDocumentTypes);
        return supportedDocumentTypes;
    }

    private PartnerModel createPartnerModel(CppPartner cppPartner) throws TransportIdNotFoundException {
        HashMap<String, String> partyIds = new HashMap<String, String>();
        cppPartner.getPartyIdList().forEach(partyId -> partyIds.put(partyId.getType(), partyId.getValue()));
        PartnerModel.UrlModel primaryUrl = cppPartner.getPreferredTransportId() != null ? new PartnerModel.UrlModel().setId(cppPartner.getPreferredTransportId()).setUrl(cppPartner.getTransportUrl(cppPartner.getPreferredTransportId())) : null;
        PartnerModel.UrlModel fallbackUrl = cppPartner.getFallbackTransportId() != null ? new PartnerModel.UrlModel().setId(cppPartner.getFallbackTransportId()).setUrl(cppPartner.getTransportUrl(cppPartner.getFallbackTransportId())) : null;
        ArrayList<CertificateModel> certificates = new ArrayList<CertificateModel>();
        cppPartner.getAllValidCertificates().forEach(x509Certificate -> {
            CertificateModel certificateModel = new CertificateModel(cppPartner.getCertificateId((X509Certificate)x509Certificate), x509Certificate.getNotAfter());
            boolean[] keyUsageFlags = x509Certificate.getKeyUsage();
            if (keyUsageFlags != null) {
                if (keyUsageFlags[0]) {
                    certificateModel.addKeyUsage(CertificateModel.KeyUsage.DIGITAL_SIGNATURE);
                }
                if (keyUsageFlags[1]) {
                    certificateModel.addKeyUsage(CertificateModel.KeyUsage.NON_REPUDIATION);
                }
                if (keyUsageFlags[2]) {
                    certificateModel.addKeyUsage(CertificateModel.KeyUsage.KEY_ENCIPHERMENT);
                }
                if (keyUsageFlags[3]) {
                    certificateModel.addKeyUsage(CertificateModel.KeyUsage.DATA_ENCIPHERMENT);
                }
                if (keyUsageFlags[4]) {
                    certificateModel.addKeyUsage(CertificateModel.KeyUsage.KEY_AGREEMENT);
                }
                if (keyUsageFlags[5]) {
                    certificateModel.addKeyUsage(CertificateModel.KeyUsage.KEY_CERT_SIGN);
                }
                if (keyUsageFlags[6]) {
                    certificateModel.addKeyUsage(CertificateModel.KeyUsage.C_RL_SIGN);
                }
                if (keyUsageFlags[7]) {
                    certificateModel.addKeyUsage(CertificateModel.KeyUsage.ENCIPHER_ONLY);
                }
                if (keyUsageFlags[8]) {
                    certificateModel.addKeyUsage(CertificateModel.KeyUsage.DECIPHER_ONLY);
                }
            }
            try {
                List<String> extendedKeyUsage = x509Certificate.getExtendedKeyUsage();
                if (extendedKeyUsage != null) {
                    if (extendedKeyUsage.contains(KeyPurposeId.id_kp_serverAuth.getId())) {
                        certificateModel.addExtendedKeyUsage(CertificateModel.ExtendedKeyUsage.SERVER_AUTH);
                    }
                    if (extendedKeyUsage.contains(KeyPurposeId.id_kp_clientAuth.getId())) {
                        certificateModel.addExtendedKeyUsage(CertificateModel.ExtendedKeyUsage.CLIENT_AUTH);
                    }
                    if (extendedKeyUsage.contains(KeyPurposeId.id_kp_codeSigning.getId())) {
                        certificateModel.addExtendedKeyUsage(CertificateModel.ExtendedKeyUsage.CODE_SIGNING);
                    }
                    if (extendedKeyUsage.contains(KeyPurposeId.id_kp_emailProtection.getId())) {
                        certificateModel.addExtendedKeyUsage(CertificateModel.ExtendedKeyUsage.EMAIL_PROTECTION);
                    }
                    if (extendedKeyUsage.contains(KeyPurposeId.id_kp_timeStamping.getId())) {
                        certificateModel.addExtendedKeyUsage(CertificateModel.ExtendedKeyUsage.TIME_STAMPING);
                    }
                    if (extendedKeyUsage.contains(KeyPurposeId.id_kp_OCSPSigning.getId())) {
                        certificateModel.addExtendedKeyUsage(CertificateModel.ExtendedKeyUsage.OCSP_SIGNING);
                    }
                    if (extendedKeyUsage.contains(KeyPurposeId.id_kp_ipsecIKE.getId())) {
                        certificateModel.addExtendedKeyUsage(CertificateModel.ExtendedKeyUsage.IPSEC_IKE);
                    }
                }
            }
            catch (CertificateParsingException e) {
                LOG.error((Object)"Could not read extended key usage from certificate.", (Throwable)e);
            }
            certificates.add(certificateModel);
            Collections.sort(certificates);
        });
        return new PartnerModel().setId(cppPartner.getLocalId()).setBackendPartnerId(cppPartner.getInternalId()).setDisplayName(cppPartner.getDisplayName()).setPartyIds(partyIds).setPrimaryUrl(primaryUrl).setFallbackUrl(fallbackUrl).addCertificates(certificates);
    }

    private void writeFile(File tempFile, AgreementModel model, String templateLocation) throws IOException {
        try (FileWriterWithEncoding writer = new FileWriterWithEncoding(tempFile, UTF_8);){
            HashMap<String, AgreementModel> map = new HashMap<String, AgreementModel>();
            map.put("agreement", model);
            VelocityContext velocityContext = new VelocityContext(map);
            velocityContext.put("esc", (Object)new EscapeTool());
            Template template = this.velocityEngine.getTemplate(templateLocation, UTF_8);
            if (Objects.isNull(template)) {
                throw new FileNotFoundException(templateLocation);
            }
            template.merge((Context)velocityContext, (Writer)writer);
        }
    }
}

