/*
 * Decompiled with CFR 0.152.
 */
package de.pontonconsulting.xmlpipe.cpa;

import de.pontonconsulting.activation.ActivationException;
import de.pontonconsulting.common.security.IPasswordCrypt;
import de.pontonconsulting.common.util.CacheEntry;
import de.pontonconsulting.xmlpipe.config.MessengerConfig;
import de.pontonconsulting.xmlpipe.config.SchemaData;
import de.pontonconsulting.xmlpipe.config.SchemataConfig;
import de.pontonconsulting.xmlpipe.config.partneragreement.CollaborationAgreement;
import de.pontonconsulting.xmlpipe.config.partneragreement.CommunicationType;
import de.pontonconsulting.xmlpipe.config.privatepartneragreement.DoctypeActionType;
import de.pontonconsulting.xmlpipe.config.privatepartneragreement.LineEndingType;
import de.pontonconsulting.xmlpipe.config.privatepartneragreement.ObjectFactory;
import de.pontonconsulting.xmlpipe.config.privatepartneragreement.PrivateCollaborationAgreement;
import de.pontonconsulting.xmlpipe.config.privatepartneragreement.RuleType;
import de.pontonconsulting.xmlpipe.config.privatepartneragreement.RulesType;
import de.pontonconsulting.xmlpipe.config.privatepartneragreement.XmlEncodingType;
import de.pontonconsulting.xmlpipe.config.privatepartneragreement.XmlModificationType;
import de.pontonconsulting.xmlpipe.cp.DocumentType;
import de.pontonconsulting.xmlpipe.cp.DocumentTypeResolver;
import de.pontonconsulting.xmlpipe.cpa.AgreementException;
import de.pontonconsulting.xmlpipe.cpa.AgreementFileFactory;
import de.pontonconsulting.xmlpipe.cpa.AgreementNotFoundException;
import de.pontonconsulting.xmlpipe.cpa.AgreementStoreAccessException;
import de.pontonconsulting.xmlpipe.cpa.Agreements;
import de.pontonconsulting.xmlpipe.cpa.Communication;
import de.pontonconsulting.xmlpipe.cpa.CommunicationNotFoundException;
import de.pontonconsulting.xmlpipe.cpp.CppPartner;
import de.pontonconsulting.xmlpipe.cpp.PartnerCertificateManager;
import de.pontonconsulting.xmlpipe.cpp.Profiles;
import de.pontonconsulting.xmlpipe.cpp.TransportIdNotFoundException;
import de.pontonconsulting.xmlpipe.message.PayloadRecognizer;
import de.pontonconsulting.xmlpipe.message.identification.IEnvelopeRecognizer;
import de.pontonconsulting.xmlpipe.messenger.ReferenceDateTask;
import de.pontonconsulting.xmlpipe.messenger.packaging.BasePackager;
import de.pontonconsulting.xmlpipe.messenger.packaging.IPackagingManager;
import de.pontonconsulting.xmlpipe.messenger.packaging.PackagingException;
import de.pontonconsulting.xmlpipe.security.CertificateReader;
import de.pontonconsulting.xmlpipe.security.CertificateUtility;
import de.pontonconsulting.xmlpipe.security.certificate.CertificateChooser;
import jakarta.xml.bind.JAXBContext;
import jakarta.xml.bind.JAXBException;
import jakarta.xml.bind.Marshaller;
import jakarta.xml.bind.Unmarshaller;
import jakarta.xml.bind.ValidationEventHandler;
import jakarta.xml.bind.util.ValidationEventCollector;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Agreement
implements CacheEntry {
    private static final Logger LOGGER = LogManager.getLogger((String)("Messenger." + Agreement.class.getName()));
    private static final String JAXB_CONFIG_PACKAGE = "de.pontonconsulting.xmlpipe.config.partneragreement";
    private static final String JAXB_CONFIG_PACKAGE_PRIVATE = "de.pontonconsulting.xmlpipe.config.privatepartneragreement";
    private static JAXBContext JC_PUBLIC;
    private static JAXBContext JC_PRIVATE;
    private static final de.pontonconsulting.xmlpipe.config.partneragreement.ObjectFactory _factory;
    private static final ObjectFactory _privateFactory;
    private CollaborationAgreement _agreement;
    private PrivateCollaborationAgreement _private;
    private final Map<String, Communication> _communications;
    private List<DocumentType> _documentTypes = null;
    private Map<String, List<DocumentType>> _schemaSets = null;
    private PayloadRecognizer _payloadRecognizer;
    private final IPackagingManager _packagingManager;
    private final Agreements _agreements;
    private final Profiles _profiles;
    private final IPasswordCrypt _passwordCrypt;
    private final IEnvelopeRecognizer _envelopeRecognizer;
    private final DocumentTypeResolver _documentTypeResolver;
    private final ReferenceDateTask referenceDateTask;
    private final CertificateUtility certificateUtility;
    private final CertificateReader certificateInfo;
    private final CertificateChooser certificateChooser;
    private final PartnerCertificateManager partnerCertificateManager;
    private final AgreementFileFactory agreementFileFactory;
    private final MessengerConfig messengerConfig;
    private final SchemataConfig _schemataConfig;
    private OffsetDateTime lastModified;
    private boolean readOnly = false;

    public Agreement(IPackagingManager packagingManager, Agreements agreements, Profiles profiles, IPasswordCrypt passwordCrypt, IEnvelopeRecognizer envelopeRecognizer, DocumentTypeResolver documentTypeResolver, ReferenceDateTask referenceDateTask, CertificateUtility certificateUtility, CertificateReader certificateInfo, CertificateChooser certificateChooser, PartnerCertificateManager partnerCertificateManager, AgreementFileFactory agreementFileFactory, MessengerConfig messengerConfig, SchemataConfig schemataConfig) {
        this._packagingManager = packagingManager;
        this._agreements = agreements;
        this._profiles = profiles;
        this._passwordCrypt = passwordCrypt;
        this._envelopeRecognizer = envelopeRecognizer;
        this._documentTypeResolver = documentTypeResolver;
        this.referenceDateTask = referenceDateTask;
        this.certificateUtility = certificateUtility;
        this.certificateInfo = certificateInfo;
        this.certificateChooser = certificateChooser;
        this.partnerCertificateManager = partnerCertificateManager;
        this.agreementFileFactory = agreementFileFactory;
        this.messengerConfig = messengerConfig;
        this._schemataConfig = schemataConfig;
        this._communications = new HashMap<String, Communication>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init(CppPartner cppPartner1, CppPartner cppPartner2, String agreementTemplateId) throws AgreementException {
        try {
            File publicTemplateFile = this.agreementFileFactory.createAgreementFile(cppPartner1, cppPartner2, agreementTemplateId);
            File privateTemplateFile = this.agreementFileFactory.createAgreementPrivateFile(cppPartner1, cppPartner2, agreementTemplateId);
            try (BufferedInputStream publicPart = new BufferedInputStream(Files.newInputStream(publicTemplateFile.toPath(), new OpenOption[0]));
                 BufferedInputStream privatePart = new BufferedInputStream(Files.newInputStream(privateTemplateFile.toPath(), new OpenOption[0]));){
                this.init(publicPart, privatePart);
            }
            finally {
                Files.deleteIfExists(publicTemplateFile.toPath());
                Files.deleteIfExists(privateTemplateFile.toPath());
            }
        }
        catch (TransportIdNotFoundException | JAXBException | IOException | IllegalStateException e) {
            throw new AgreementException(35003, "Could not create agreement instance (" + cppPartner1.getLocalId() + "/" + cppPartner2.getLocalId() + "): " + e.getMessage(), e);
        }
    }

    public void setId(String id) {
        if (this.readOnly) {
            throw new IllegalStateException("Cannot set ID on a read-only agreement.");
        }
        this._private.setId(id);
    }

    public String getId() {
        return this._private.getId();
    }

    public void init(InputStream publicPart, InputStream privatePart) throws AgreementNotFoundException, AgreementStoreAccessException {
        try {
            this.loadPublicPart(publicPart);
            this.loadPrivatePart(privatePart);
            this.loadDocumentTypes();
            this.determineSchemaSets();
        }
        catch (JAXBException je) {
            throw new AgreementStoreAccessException(38001, null, "Could not load agreement.", je);
        }
    }

    void clonePrivatePartTo(Agreement newAgreement) throws IOException, JAXBException, AgreementException {
        try (ByteArrayInputStream privatePart = new ByteArrayInputStream(this.getPrivatePart());){
            newAgreement.loadPrivatePart(privatePart);
        }
    }

    private void loadPrivatePart(InputStream inputStream) throws JAXBException {
        ValidationEventCollector vce = new ValidationEventCollector();
        Unmarshaller uPrivate = JC_PRIVATE.createUnmarshaller();
        uPrivate.setEventHandler((ValidationEventHandler)vce);
        this._private = (PrivateCollaborationAgreement)uPrivate.unmarshal(inputStream);
    }

    private void loadPublicPart(InputStream inputStream) throws JAXBException {
        Unmarshaller u = JC_PUBLIC.createUnmarshaller();
        ValidationEventCollector vce = new ValidationEventCollector();
        u.setEventHandler((ValidationEventHandler)vce);
        this._agreement = (CollaborationAgreement)u.unmarshal(inputStream);
    }

    protected Agreements getAgreements() {
        return this._agreements;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save() throws AgreementException {
        if (this.readOnly) {
            throw new IllegalStateException("Cannot save a read-only agreement.");
        }
        Agreements agreements = this.getAgreements();
        synchronized (agreements) {
            this.setCompatibilityVersion();
            this.updateCommunicationElements();
            this.getAgreements().save(this);
        }
    }

    public byte[] getPublicPart() throws AgreementException {
        try {
            Marshaller m = JC_PUBLIC.createMarshaller();
            m.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
            m.setProperty("jaxb.encoding", (Object)"UTF-8");
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            m.marshal((Object)this._agreement, (OutputStream)outputStream);
            return outputStream.toByteArray();
        }
        catch (JAXBException e) {
            throw new AgreementException(35004, "Could not marshal public parf of agreement.", e);
        }
    }

    public byte[] getPrivatePart() throws AgreementException {
        try {
            Marshaller m = JC_PRIVATE.createMarshaller();
            m.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
            m.setProperty("jaxb.encoding", (Object)"UTF-8");
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            m.marshal((Object)this._private, (OutputStream)outputStream);
            return outputStream.toByteArray();
        }
        catch (JAXBException e) {
            throw new AgreementException(35004, "Could not marshal public parf of agreement.", e);
        }
    }

    private void updateCommunicationElements() {
        for (Communication communication : this._communications.values()) {
            communication.updateCommunicationOptions();
        }
    }

    private CollaborationAgreement.Partner getPartner(int index) {
        return (CollaborationAgreement.Partner)this._agreement.getPartner().get(index);
    }

    public void switchPartners() {
        CollaborationAgreement.Partner partner1 = (CollaborationAgreement.Partner)this._agreement.getPartner().get(0);
        CollaborationAgreement.Partner partner2 = (CollaborationAgreement.Partner)this._agreement.getPartner().get(1);
        this._agreement.getPartner().set(0, partner2);
        this._agreement.getPartner().set(1, partner1);
    }

    public String getPartner1LocalId() {
        return this.getPartner(0).getId();
    }

    public CollaborationAgreement.Partner getOwnPartner() {
        return this.getPartner(0);
    }

    public CollaborationAgreement.Partner getCommunicationPartner() {
        return this.getPartner(1);
    }

    public void setPartner1LocalId(String localId) {
        if (this.readOnly) {
            throw new IllegalStateException("Cannot set local ID for partner on a read-only agreement.");
        }
        this.getPartner(0).setId(localId);
    }

    public String getPartner2LocalId() {
        return this.getPartner(1).getId();
    }

    public void setPartner2LocalId(String localId) {
        if (this.readOnly) {
            throw new IllegalStateException("Cannot set local ID for partner on a read-only agreement.");
        }
        this.getPartner(1).setId(localId);
    }

    private void loadDocumentTypes() {
        ArrayList<DocumentType> result = new ArrayList<DocumentType>();
        List docs = this._agreement.getPayloadDocuments().getDocument();
        for (CollaborationAgreement.PayloadDocuments.Document document : docs) {
            DocumentType type;
            SchemaData schema = this._schemataConfig.getSchemaBySetTypeVersion(document.getSchemaSet(), document.getType(), document.getVersion());
            if (schema == null || (type = this._documentTypeResolver.resolveDocument(document)) == null) continue;
            result.add(type);
        }
        this._documentTypes = result;
        this._payloadRecognizer = null;
    }

    public List<DocumentType> getDocumentTypes() {
        if (this._documentTypes == null) {
            this.loadDocumentTypes();
        }
        return this._documentTypes;
    }

    public void setDocumentTypes(List<DocumentType> allDocTypes) {
        if (this.readOnly) {
            throw new IllegalStateException("Cannot set document types on a read-only agreement.");
        }
        List docs = this._agreement.getPayloadDocuments().getDocument();
        docs.clear();
        for (int i = 0; i < allDocTypes.size(); ++i) {
            DocumentType tempDocType = allDocTypes.get(i);
            CollaborationAgreement.PayloadDocuments.Document doc = _factory.createCollaborationAgreementPayloadDocumentsDocument();
            doc.setType(tempDocType.getType());
            doc.setVersion(tempDocType.getVersion());
            doc.setSchemaLocation(tempDocType.getSchemalocation());
            if (tempDocType.getSchemaSet() != null) {
                doc.setSchemaSet(tempDocType.getSchemaSet());
            }
            if (tempDocType.getNamespace() != null) {
                doc.setNameSpace(tempDocType.getNamespace());
            }
            docs.add(doc);
        }
        this._documentTypes = new ArrayList<DocumentType>();
        this._documentTypes.addAll(allDocTypes);
        this.determineSchemaSets();
        this._payloadRecognizer = null;
    }

    public Map<String, List<DocumentType>> getSchemaSets() {
        if (this._schemaSets == null) {
            this.determineSchemaSets();
        }
        return this._schemaSets;
    }

    public String getTemplateId() {
        return this._private.getTemplateId();
    }

    private void determineSchemaSets() {
        List<DocumentType> docs = this.getDocumentTypes();
        HashMap<String, List<DocumentType>> result = new HashMap<String, List<DocumentType>>();
        Iterator<DocumentType> iterator = docs.iterator();
        while (iterator.hasNext()) {
            DocumentType tempDocType = iterator.next();
            String schemaSetName = tempDocType.getSchemaSet();
            if (schemaSetName == null) {
                iterator.remove();
                continue;
            }
            List setDocs = result.computeIfAbsent(schemaSetName, k -> new ArrayList());
            setDocs.add(tempDocType);
        }
        this._schemaSets = result;
    }

    private String buildCommunicationKey(String senderLocalId, String receiverLocalId) {
        return senderLocalId + "|" + receiverLocalId;
    }

    public Communication getCommunication(String senderLocalId, String receiverLocalId) throws CommunicationNotFoundException {
        CommunicationType cType1 = (CommunicationType)this._agreement.getCommunications().getCommunication().get(0);
        CommunicationType cType2 = (CommunicationType)this._agreement.getCommunications().getCommunication().get(1);
        String key = this.buildCommunicationKey(senderLocalId, receiverLocalId);
        Communication communication = this.extractCommunication(cType1, key, senderLocalId, receiverLocalId);
        if (Objects.isNull(communication)) {
            communication = this.extractCommunication(cType2, key, senderLocalId, receiverLocalId);
        }
        if (communication == null) {
            throw new CommunicationNotFoundException(37001, new String[]{senderLocalId, receiverLocalId}, "Communication not found for given partners.");
        }
        this._communications.put(key, communication);
        return communication;
    }

    private Communication extractCommunication(CommunicationType comType, String key, String senderLocalId, String receiverLocalId) {
        if (comType.getSenderRefId().equals(senderLocalId) && comType.getReceiverRefId().equals(receiverLocalId)) {
            if (this._communications.containsKey(key)) {
                return this._communications.get(key);
            }
            Communication communication = new Communication(comType, this, this._passwordCrypt, this.referenceDateTask, this.certificateInfo, this.certificateUtility, this.certificateChooser, this.partnerCertificateManager, this.messengerConfig, this._profiles, this._agreements);
            List<RuleType> rules = this.getContentRules(senderLocalId, receiverLocalId);
            communication.setContentRules(rules);
            return communication;
        }
        return null;
    }

    public BasePackager getPackager(String packagingId) throws PackagingException, ActivationException {
        return this._packagingManager.getPackager(packagingId);
    }

    public Communication getCommunication(String senderId, String receiverId, Locale locale, String[] localizedErrorMsgHolder) {
        Communication comm = null;
        try {
            comm = this.getCommunication(senderId, receiverId);
        }
        catch (CommunicationNotFoundException e) {
            localizedErrorMsgHolder[0] = e.getMessage();
        }
        return comm;
    }

    private List<RuleType> getContentRules(String senderId, String receiverId) {
        List result = null;
        List rules = this._private.getRules();
        for (RulesType contentRules : rules) {
            if (!contentRules.getReceiverRefId().equals(receiverId) || !contentRules.getSenderRefId().equals(senderId)) continue;
            result = contentRules.getRule();
        }
        if (result == null) {
            RulesType newRules = _privateFactory.createRulesType();
            newRules.setReceiverRefId(receiverId);
            newRules.setSenderRefId(senderId);
            rules.add(newRules);
            return newRules.getRule();
        }
        return result;
    }

    public String getDefaultAdapterId() {
        return this._private.getDefaultAdapterId();
    }

    public void setDefaultAdapterId(String defaultAdapterId) {
        if (this.readOnly) {
            throw new IllegalStateException("Cannot set default adapter ID on a read-only agreement.");
        }
        this._private.setDefaultAdapterId(defaultAdapterId);
    }

    public String getLocalPartnerId() {
        String localPartnerId = null;
        String partner1_Id = this.getPartner1LocalId();
        String partner2_Id = this.getPartner2LocalId();
        Set<String> localLocalIds = this._profiles.getLocalLocalIds();
        if (localLocalIds.contains(partner1_Id)) {
            localPartnerId = partner1_Id;
        } else if (localLocalIds.contains(partner2_Id)) {
            localPartnerId = partner2_Id;
        }
        return localPartnerId;
    }

    public String getRemotePartnerId() {
        String remotePartnerId = null;
        String partner1_Id = this.getPartner1LocalId();
        String partner2_Id = this.getPartner2LocalId();
        List<String> remoteLocalIds = this._profiles.getRemoteLocalIds();
        Set<String> localLocalIds = this._profiles.getLocalLocalIds();
        if (remoteLocalIds.contains(partner1_Id)) {
            remotePartnerId = partner1_Id;
        } else if (remoteLocalIds.contains(partner2_Id) || localLocalIds.contains(partner2_Id)) {
            remotePartnerId = partner2_Id;
        }
        return remotePartnerId;
    }

    private XmlModificationType getXmlModificationType(String senderLocalId, String receiverLocalId) {
        if (this._private.getXmlModification() != null) {
            List mods = this._private.getXmlModification();
            for (XmlModificationType type : mods) {
                if (!type.getSenderRefId().trim().equals(senderLocalId.trim()) || !type.getReceiverRefId().trim().equals(receiverLocalId.trim())) continue;
                return type;
            }
        }
        return null;
    }

    public String getXmlEncoding(String senderLocalId, String receiverLocalId) {
        XmlModificationType type = this.getXmlModificationType(senderLocalId, receiverLocalId);
        if (type == null) {
            return null;
        }
        return type.getXmlEncoding().value();
    }

    public String getLineEnding(String senderLocalId, String receiverLocalId) {
        XmlModificationType type = this.getXmlModificationType(senderLocalId, receiverLocalId);
        if (type == null) {
            return null;
        }
        return type.getLineEnding().value();
    }

    public boolean getPrettyPrint(String senderLocalId, String receiverLocalId) {
        XmlModificationType type = this.getXmlModificationType(senderLocalId, receiverLocalId);
        if (type == null) {
            return false;
        }
        return type.isPrettyPrint();
    }

    public boolean getUpdatePapinet1Envelope(String senderLocalId, String receiverLocalId) {
        XmlModificationType type = this.getXmlModificationType(senderLocalId, receiverLocalId);
        if (type == null) {
            return false;
        }
        return type.isUpdatePapinet1Envelope();
    }

    public String getDoctypeAction(String senderLocalId, String receiverLocalId) {
        XmlModificationType type = this.getXmlModificationType(senderLocalId, receiverLocalId);
        if (type == null) {
            return null;
        }
        return type.getDoctypeAction().value();
    }

    public boolean getXmlModificationEnabled(String senderLocalId, String receiverLocalId) {
        XmlModificationType type = this.getXmlModificationType(senderLocalId, receiverLocalId);
        if (type == null) {
            return false;
        }
        return type.isEnabled();
    }

    public void setXmlEncoding(String xmlEncoding, String senderLocalId, String receiverLocalId) {
        if (this.readOnly) {
            throw new IllegalStateException("Cannot set XML encoding on a read-only agreement.");
        }
        XmlModificationType type = this.getXmlModificationType(senderLocalId, receiverLocalId);
        if (type == null) {
            type = _privateFactory.createXmlModificationType();
            type.setSenderRefId(senderLocalId);
            type.setReceiverRefId(receiverLocalId);
            this._private.getXmlModification().add(type);
        }
        type.setXmlEncoding(XmlEncodingType.fromValue((String)xmlEncoding));
    }

    public void setLineEnding(String lineEnding, String senderLocalId, String receiverLocalId) {
        if (this.readOnly) {
            throw new IllegalStateException("Cannot set line ending on a read-only agreement.");
        }
        XmlModificationType type = this.getXmlModificationType(senderLocalId, receiverLocalId);
        if (type == null) {
            type = _privateFactory.createXmlModificationType();
            type.setSenderRefId(senderLocalId);
            type.setReceiverRefId(receiverLocalId);
            this._private.getXmlModification().add(type);
        }
        type.setLineEnding(LineEndingType.fromValue((String)lineEnding));
    }

    public void setPrettyPrint(boolean prettyPrint, String senderLocalId, String receiverLocalId) {
        if (this.readOnly) {
            throw new IllegalStateException("Cannot set pretty print on a read-only agreement.");
        }
        XmlModificationType type = this.getXmlModificationType(senderLocalId, receiverLocalId);
        if (type == null) {
            type = _privateFactory.createXmlModificationType();
            type.setSenderRefId(senderLocalId);
            type.setReceiverRefId(receiverLocalId);
            this._private.getXmlModification().add(type);
        }
        type.setPrettyPrint(Boolean.valueOf(prettyPrint));
    }

    public void setUpdatePapinet1Envelope(boolean updatePapinet1Envelope, String senderLocalId, String receiverLocalId) {
        if (this.readOnly) {
            throw new IllegalStateException("Cannot set update Papinet1 envelope on a read-only agreement.");
        }
        XmlModificationType type = this.getXmlModificationType(senderLocalId, receiverLocalId);
        if (type == null) {
            type = _privateFactory.createXmlModificationType();
            type.setSenderRefId(senderLocalId);
            type.setReceiverRefId(receiverLocalId);
            this._private.getXmlModification().add(type);
        }
        type.setUpdatePapinet1Envelope(Boolean.valueOf(updatePapinet1Envelope));
    }

    public void setDoctypeAction(String doctypeAction, String senderLocalId, String receiverLocalId) {
        if (this.readOnly) {
            throw new IllegalStateException("Cannot set doctype action on a read-only agreement.");
        }
        XmlModificationType type = this.getXmlModificationType(senderLocalId, receiverLocalId);
        if (type == null) {
            type = _privateFactory.createXmlModificationType();
            type.setSenderRefId(senderLocalId);
            type.setReceiverRefId(receiverLocalId);
            this._private.getXmlModification().add(type);
        }
        type.setDoctypeAction(DoctypeActionType.fromValue((String)doctypeAction));
    }

    public void setXmlModificationEnabled(boolean enabled, String senderLocalId, String receiverLocalId) {
        if (this.readOnly) {
            throw new IllegalStateException("Cannot set XML modification enabled on a read-only agreement.");
        }
        XmlModificationType type = this.getXmlModificationType(senderLocalId, receiverLocalId);
        if (type == null) {
            type = _privateFactory.createXmlModificationType();
            type.setSenderRefId(senderLocalId);
            type.setReceiverRefId(receiverLocalId);
            this._private.getXmlModification().add(type);
        }
        type.setEnabled(enabled);
    }

    public OffsetDateTime getLastModified() {
        return this.lastModified;
    }

    public PayloadRecognizer getPayloadRecognizer() {
        if (this._payloadRecognizer == null) {
            this._payloadRecognizer = new PayloadRecognizer(this.getDocumentTypes(), this._schemataConfig);
        }
        return this._payloadRecognizer;
    }

    public IEnvelopeRecognizer getEnvelopeRecognizer() {
        return this._envelopeRecognizer;
    }

    public void setPayloadRecognizer(PayloadRecognizer payloadRecognizer) {
        if (this.readOnly) {
            throw new IllegalStateException("Cannot set payload recognizer on a read-only agreement.");
        }
        this._payloadRecognizer = payloadRecognizer;
    }

    public boolean isPingAllEnabled() {
        Boolean pingAllEnabled = this._private.isPingAllEnabled();
        if (pingAllEnabled == null) {
            return false;
        }
        return pingAllEnabled;
    }

    public boolean isMigrated() {
        String compatibilityVersion = this._agreement.getCompatibilityVersion();
        return StringUtils.isNotBlank((CharSequence)compatibilityVersion) && compatibilityVersion.equals("3.3");
    }

    private void setCompatibilityVersion() {
        if (this.readOnly) {
            throw new IllegalStateException("Cannot set compatibility version on a read-only agreement.");
        }
        this._agreement.setCompatibilityVersion("3.3");
    }

    public void setPingAllEnabled(boolean pingAllEnabled) {
        if (this.readOnly) {
            throw new IllegalStateException("Cannot set ping all enabled on a read-only agreement.");
        }
        this._private.setPingAllEnabled(Boolean.valueOf(pingAllEnabled));
    }

    public String getAS4CertUpdateID() {
        return this._private.getAS4CertUpdateID();
    }

    public void setAS4CertUpdateID(String certId) {
        if (this.readOnly) {
            throw new IllegalStateException("Cannot set AS4 certificate update ID on a read-only agreement.");
        }
        this._private.setAS4CertUpdateID(certId);
    }

    public void setAS4UpdatedAgreementRef(String updatedAgreementRef) {
        if (this.readOnly) {
            throw new IllegalStateException("Cannot set AS4 updated agreement reference on a read-only agreement.");
        }
        this._private.setAS4UpdatedAgreementRef(updatedAgreementRef);
    }

    public boolean isAS4CertificateUpdateTestServiceEnabled() {
        return this._private.isAS4CertificateUpdateTestServiceEnabled() != null ? this._private.isAS4CertificateUpdateTestServiceEnabled() : false;
    }

    public void setAS4CertificateUpdateTestServiceEnabled(boolean as4CertificateUpdateTestServiceEnabled) {
        if (this.readOnly) {
            throw new IllegalStateException("Cannot set AS4 certificate update test service enabled on a read-only agreement.");
        }
        this._private.setAS4CertificateUpdateTestServiceEnabled(Boolean.valueOf(as4CertificateUpdateTestServiceEnabled));
    }

    public String getAS4UpdatedAgreementRef() {
        return this._private.getAS4UpdatedAgreementRef();
    }

    public void setAS4UpdatedAgreementRefType(String updatedAgreementRefType) {
        if (this.readOnly) {
            throw new IllegalStateException("Cannot set AS4 updated agreement reference type on a read-only agreement.");
        }
        this._private.setAS4UpdatedAgreementRefType(updatedAgreementRefType);
    }

    public String getAS4UpdatedAgreementRefType() {
        return this._private.getAS4UpdatedAgreementRefType();
    }

    public boolean isAS4UpdatedAgreementInboundTestSuccessful() {
        return this._private.isAS4UpdatedAgreementInboundTestSuccessful() != null ? this._private.isAS4UpdatedAgreementInboundTestSuccessful() : false;
    }

    public void setAS4UpdatedAgreementInboundTestSuccessful(boolean value) {
        if (this.readOnly) {
            throw new IllegalStateException("Cannot set AS4 updated agreement inbound test successful on a read-only agreement.");
        }
        this._private.setAS4UpdatedAgreementInboundTestSuccessful(Boolean.valueOf(value));
    }

    public boolean isAS4UpdatedAgreementOutboundTestSuccessful() {
        return this._private.isAS4UpdatedAgreementOutboundTestSuccessful() != null ? this._private.isAS4UpdatedAgreementOutboundTestSuccessful() : false;
    }

    public void setAS4UpdatedAgreementOutboundTestSuccessful(boolean value) {
        if (this.readOnly) {
            throw new IllegalStateException("Cannot set AS4 updated agreement outbound test successful on a read-only agreement.");
        }
        this._private.setAS4UpdatedAgreementOutboundTestSuccessful(Boolean.valueOf(value));
    }

    public void setAS4CertUpdateActivateBy(String activateBy) {
        if (this.readOnly) {
            throw new IllegalStateException("Cannot set AS4 certificate update activate by on a read-only agreement.");
        }
        this._private.setAS4CertUpdateActivateBy(activateBy);
    }

    public String getAS4CertUpdateActivateBy() {
        return this._private.getAS4CertUpdateActivateBy();
    }

    public void setAS4CertUpdateInitiator(String initiator) {
        if (this.readOnly) {
            throw new IllegalStateException("Cannot set AS4 certificate update initiator on a read-only agreement.");
        }
        this._private.setAS4CertUpdateInitiator(initiator);
    }

    public String getAS4CertUpdateInitiator() {
        return this._private.getAS4CertUpdateInitiator();
    }

    public void initUrlValidity(boolean transportURLisValid, boolean fallbackTransportURLisValid) {
        try {
            String ownLocalId = this.getOwnPartner().getId();
            String commLocalId = this.getCommunicationPartner().getId();
            Communication communication = this.getCommunication(ownLocalId, commLocalId);
            communication.initUrlValidity(transportURLisValid, fallbackTransportURLisValid);
        }
        catch (CommunicationNotFoundException e) {
            LOGGER.error("Can't initialize url validity due to {}: {}", (Object)e.getClass().getName(), (Object)e.toString());
        }
    }

    @Override
    public OffsetDateTime getLastChange() {
        return this.lastModified;
    }

    public Agreement setLastChange(OffsetDateTime lastModified) {
        this.lastModified = lastModified;
        return this;
    }

    @Override
    public void setReadOnly() {
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    static {
        _factory = new de.pontonconsulting.xmlpipe.config.partneragreement.ObjectFactory();
        _privateFactory = new ObjectFactory();
        try {
            JC_PUBLIC = JAXBContext.newInstance((String)JAXB_CONFIG_PACKAGE);
            JC_PRIVATE = JAXBContext.newInstance((String)JAXB_CONFIG_PACKAGE_PRIVATE);
        }
        catch (JAXBException e) {
            LOGGER.error("could not initialize JAXB context");
        }
    }
}

