/*
 * Decompiled with CFR 0.152.
 */
package de.pontonconsulting.xmlpipe.cp;

import de.pontonconsulting.xmlpipe.config.SchemaData;
import de.pontonconsulting.xmlpipe.config.SchemataConfig;
import de.pontonconsulting.xmlpipe.config.partneragreement.CollaborationAgreement;
import de.pontonconsulting.xmlpipe.config.partneragreement.ObjectFactory;
import de.pontonconsulting.xmlpipe.cp.AdditionalSchema;
import de.pontonconsulting.xmlpipe.cp.DocumentType;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class DocumentTypeResolver {
    private static final char SEP_CHAR = '_';
    private static final ObjectFactory OBJ_FAC = new ObjectFactory();
    private final Map<String, DocumentType> _documentTypeMap = new HashMap<String, DocumentType>();
    private final SchemataConfig _schemataConfig;

    public DocumentTypeResolver(SchemataConfig schemataConfig) {
        this._schemataConfig = schemataConfig;
    }

    public CollaborationAgreement.PayloadDocuments.Document createDocumentType(DocumentType docType) {
        CollaborationAgreement.PayloadDocuments.Document result = OBJ_FAC.createCollaborationAgreementPayloadDocumentsDocument();
        result.setNameSpace(docType.getNamespace());
        result.setSchemaLocation(docType.getSchemalocation());
        result.setSchemaSet(docType.getSchemaSet());
        result.setType(docType.getType());
        result.setVersion(docType.getVersion());
        return result;
    }

    public synchronized DocumentType resolveDocument(CollaborationAgreement.PayloadDocuments.Document document) {
        String key = this.getUniqueKey(document);
        if (!this._documentTypeMap.containsKey(key)) {
            DocumentType documentType = this.create(document);
            this._documentTypeMap.put(key, documentType);
            return documentType;
        }
        return this._documentTypeMap.get(key);
    }

    public synchronized DocumentType resolveDocument(String type, String version, String nameSpace, String location, String schemaSetName) {
        String key = this.getUniqueKey(type, version, nameSpace, location, schemaSetName);
        if (!this._documentTypeMap.containsKey(key)) {
            CollaborationAgreement.PayloadDocuments.Document document = OBJ_FAC.createCollaborationAgreementPayloadDocumentsDocument();
            document.setType(type);
            document.setVersion(version);
            document.setNameSpace(nameSpace);
            document.setSchemaLocation(location);
            document.setSchemaSet(schemaSetName);
            DocumentType documentType = this.create(document);
            this._documentTypeMap.put(key, documentType);
            if (!this._documentTypeMap.containsKey(this.getUniqueKey(document))) {
                this._documentTypeMap.put(this.getUniqueKey(document), documentType);
            }
            return documentType;
        }
        return this._documentTypeMap.get(key);
    }

    private DocumentType create(CollaborationAgreement.PayloadDocuments.Document document) {
        String schemaSetName = document.getSchemaSet();
        String messageType = document.getType();
        String version = document.getVersion();
        DocumentType type = null;
        if (StringUtils.isNotBlank((CharSequence)schemaSetName)) {
            SchemaData schemaData = this._schemataConfig.getSchemaBySetTypeVersion(schemaSetName, messageType, version);
            if (schemaData != null) {
                type = new DocumentType(messageType, version, document.getNameSpace(), document.getSchemaLocation(), schemaSetName, schemaData.getDtdFile(), schemaData.getRootElement());
                for (AdditionalSchema additionalSchema : schemaData.getAdditionalSchemata()) {
                    type.addAdditionalSchema(additionalSchema);
                }
            } else {
                type = new DocumentType(messageType, version, document.getNameSpace(), document.getSchemaLocation());
            }
        } else {
            type = new DocumentType(messageType, version, document.getNameSpace(), document.getSchemaLocation());
        }
        return type;
    }

    private String getUniqueKey(CollaborationAgreement.PayloadDocuments.Document document) {
        return this.getUniqueKey(document.getType(), document.getVersion(), document.getNameSpace(), document.getSchemaLocation(), document.getSchemaSet());
    }

    private String getUniqueKey(String type, String version, String nameSpace, String location, String schemaSetName) {
        StringBuilder result = new StringBuilder();
        if (StringUtils.isNotBlank((CharSequence)nameSpace)) {
            result.append(nameSpace.toLowerCase());
            result.append('_');
        }
        if (StringUtils.isNotBlank((CharSequence)location)) {
            result.append(location.toLowerCase());
            result.append('_');
        }
        if (StringUtils.isNotBlank((CharSequence)schemaSetName)) {
            result.append(schemaSetName.toLowerCase());
            result.append('_');
        }
        if (StringUtils.isNotBlank((CharSequence)type)) {
            result.append(type.toLowerCase());
            result.append('_');
        }
        if (StringUtils.isNotBlank((CharSequence)version)) {
            result.append(version.toLowerCase());
        }
        return result.toString();
    }

    public SchemataConfig getSchemataConfig() {
        return this._schemataConfig;
    }
}

