/*
 * Decompiled with CFR 0.152.
 */
package de.pontonconsulting.xmlpipe.cp;

import de.pontonconsulting.xmlpipe.cp.AdditionalSchema;
import java.util.ArrayList;
import java.util.List;

public class DocumentType
implements Comparable<DocumentType> {
    private final String version;
    private final String type;
    private final String namespace;
    private final String schemalocation;
    private String schemaSet;
    private String dtd;
    private String rootElement;
    private final List<AdditionalSchema> _additionalSchemata = new ArrayList<AdditionalSchema>();

    public DocumentType(String type, String version, String namespace, String schemaLocation) {
        this(type, version, namespace, schemaLocation, null, null, null);
    }

    public DocumentType(String type, String version, String namespace, String schemaLocation, String schemaSet, String dtd, String rootElement) {
        this.type = type;
        this.version = version;
        this.namespace = namespace != null && !namespace.isEmpty() ? namespace : null;
        this.schemalocation = schemaLocation;
        this.schemaSet = schemaSet;
        this.dtd = dtd;
        this.rootElement = rootElement;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public String getSchemalocation() {
        return this.schemalocation;
    }

    public String getType() {
        return this.type;
    }

    public String getVersion() {
        return this.version;
    }

    public boolean equals(Object anObject) {
        return this.equals(anObject, false);
    }

    public boolean equals(Object anObject, boolean checkLocationOnly) {
        if (this == anObject) {
            return true;
        }
        if (anObject instanceof DocumentType) {
            DocumentType anotherDocumentType = (DocumentType)anObject;
            if (checkLocationOnly) {
                return this.equals(this.getSchemalocation(), anotherDocumentType.getSchemalocation());
            }
            return this.equals(this.getNamespace(), anotherDocumentType.getNamespace()) && this.equals(this.getSchemalocation(), anotherDocumentType.getSchemalocation()) && this.equals(this.getType(), anotherDocumentType.getType()) && this.equals(this.getVersion(), anotherDocumentType.getVersion()) && this.equals(this.getSchemaSet(), anotherDocumentType.getSchemaSet());
        }
        return false;
    }

    private boolean equals(String attr1, String attr2) {
        if (attr1 == null) {
            return attr2 == null;
        }
        return attr1.equals(attr2);
    }

    public String getSchemaSet() {
        return this.schemaSet;
    }

    public void setSchemaSet(String schemaSet) {
        this.schemaSet = schemaSet;
    }

    public String getDtd() {
        return this.dtd;
    }

    public void setDtd(String dtd) {
        this.dtd = dtd;
    }

    public String getRootElement() {
        if (this.rootElement == null) {
            return this.getType();
        }
        return this.rootElement;
    }

    public void setRootElement(String rootElement) {
        this.rootElement = rootElement;
    }

    public List<AdditionalSchema> getAdditionalSchemata() {
        return this._additionalSchemata;
    }

    public void addAdditionalSchema(AdditionalSchema additionalSchema) {
        this._additionalSchemata.add(additionalSchema);
    }

    public String toString() {
        StringBuilder str = new StringBuilder();
        if (this.namespace != null) {
            str.append("'");
            str.append(this.namespace);
            str.append("' - ");
        }
        if (this.schemalocation != null) {
            str.append("'");
            str.append(this.schemalocation);
            str.append("' - ");
        }
        if (this.schemaSet != null) {
            str.append("'");
            str.append(this.schemaSet);
            str.append("' - ");
        }
        if (this.type != null) {
            str.append("'");
            str.append(this.type);
            str.append("' - ");
        }
        if (this.version != null) {
            str.append("'");
            str.append(this.version);
            str.append("' - ");
        }
        if (this.rootElement != null) {
            str.append("'");
            str.append(this.rootElement);
            str.append("' - ");
        }
        return str.toString();
    }

    @Override
    public int compareTo(DocumentType documentType) {
        int result = this.compare(this.schemaSet, documentType.getSchemaSet(), true);
        if (result == 0) {
            result = this.compare(this.type, documentType.getType(), true);
        }
        if (result == 0) {
            result = this.compare(this.version, documentType.getVersion(), true);
        }
        return result;
    }

    private int compare(String str1, String str2, boolean nullIsLess) {
        if (str1 == str2) {
            return 0;
        }
        if (str1 == null) {
            return nullIsLess ? -1 : 1;
        }
        if (str2 == null) {
            return nullIsLess ? 1 : -1;
        }
        return str1.compareTo(str2);
    }
}

