/*
 * Decompiled with CFR 0.152.
 */
package de.pontonconsulting.xmlpipe.config.listener;

import de.ponton.securelistener.administration.certs.Certificate;
import de.ponton.securelistener.config.ListenerProperties;
import de.pontonconsulting.xmlpipe.config.ListenerConfig;
import de.pontonconsulting.xmlpipe.config.MessengerConfig;
import de.pontonconsulting.xmlpipe.config.listener.ListenerConfigException;
import de.pontonconsulting.xmlpipe.cpp.ProfileException;
import de.pontonconsulting.xmlpipe.cpp.Profiles;
import de.pontonconsulting.xmlpipe.messenger.ReferenceDateTask;
import de.pontonconsulting.xmlpipe.messenger.adapter.IPartnerUpdateListener;
import de.pontonconsulting.xmlpipe.messenger.database.tables.EventLog;
import de.pontonconsulting.xmlpipe.messenger.database.tables.PartnerProfileDAO;
import de.pontonconsulting.xmlpipe.security.CertificateUtility;
import de.pontonconsulting.xmlpipe.security.RevocationVerifier;
import de.pontonconsulting.xmlpipe.security.RevocationVerifierFactory;
import jakarta.annotation.PostConstruct;
import jakarta.xml.bind.JAXBException;
import java.io.IOException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateRevokedException;
import java.security.cert.X509Certificate;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ClientCertificateInstaller
implements IPartnerUpdateListener {
    private static final Logger _log = LogManager.getLogger((String)"Messenger.InstallListenerClientCertificate");
    private final Profiles _profiles;
    private final EventLog eventLog;
    private final ListenerConfig listenerConfig;
    private final MessengerConfig messengerConfig;
    private final RevocationVerifierFactory revocationVerifierFactory;
    private final PartnerProfileDAO partnerProfileDAO;
    private final ReferenceDateTask referenceDateTask;
    private final CertificateUtility certificateUtility;

    public ClientCertificateInstaller(Profiles profiles, EventLog eventLog, ListenerConfig listenerConfig, MessengerConfig messengerConfig, RevocationVerifierFactory revocationVerifierFactory, PartnerProfileDAO partnerProfileDAO, ReferenceDateTask referenceDateTask, CertificateUtility certificateUtility) {
        this._profiles = profiles;
        this.eventLog = eventLog;
        this.listenerConfig = listenerConfig;
        this.messengerConfig = messengerConfig;
        this.revocationVerifierFactory = revocationVerifierFactory;
        this.partnerProfileDAO = partnerProfileDAO;
        this.referenceDateTask = referenceDateTask;
        this.certificateUtility = certificateUtility;
    }

    @PostConstruct
    public void postConstruct() {
        this._profiles.addPartnerEventListener(this);
    }

    private Set<X509Certificate> getPartnerPipelineCertificates(String remotePartnerId) {
        return this.partnerProfileDAO.getAllValidPartnerCertificatesForPartnerId(remotePartnerId, this.referenceDateTask.getReferenceOffsetDateTime()).stream().map(e -> {
            try {
                return this.certificateUtility.getX509Certificate(e.getCertificate());
            }
            catch (Exception ex) {
                return null;
            }
        }).filter(Objects::nonNull).collect(Collectors.toSet());
    }

    public boolean updatePartnerCertificate(String remotePartnerId) {
        if (this.isListenerAdminDisabled() || !this.isSynchronizePartnerCertificatesEnabled()) {
            return false;
        }
        AtomicBoolean listenerRestartNeeded = new AtomicBoolean(false);
        RevocationVerifier revocationVerifier = this.revocationVerifierFactory.createRevocationVerifier();
        for (X509Certificate partnerPipelineCert : this.getPartnerPipelineCertificates(remotePartnerId)) {
            try {
                this.verifyAndInstallCertificate(partnerPipelineCert, revocationVerifier, remotePartnerId, listenerRestartNeeded);
            }
            catch (Exception e) {
                _log.error("Could not install secure listener client certificate from partner profile {}: {}", (Object)remotePartnerId, (Object)e.toString());
                String eventId = "secure.listener.install.partner.cert." + remotePartnerId;
                try {
                    this.eventLog.deleteEvent(eventId);
                }
                catch (Exception e2) {
                    _log.debug("Could not delete event {}: {}", (Object)eventId, (Object)e2.toString());
                }
                try {
                    String location = "/private/listeners/ShowListenersTab.do?tabName=clientcert&subTabName=install&remoteLocalID=" + remotePartnerId + "&importType=profile";
                    this.eventLog.writeError(eventId, "listener.install.remote.partner.certificate.component", "listener.install.remote.partner.certificate.description", null, new String[]{this._profiles.getProfileForLocalId(remotePartnerId, true).getDisplayName()}, location);
                }
                catch (Exception e1) {
                    _log.error("Could not write event {}: {}", (Object)eventId, (Object)e1.toString());
                }
            }
        }
        return listenerRestartNeeded.get();
    }

    private void verifyAndInstallCertificate(X509Certificate partnerPipelineCert, RevocationVerifier revocationVerifier, String remotePartnerId, AtomicBoolean listenerRestartNeeded) throws ListenerConfigException, CertificateRevokedException, IOException, CertificateEncodingException {
        Certificate clientCertificate = new Certificate(partnerPipelineCert.getEncoded());
        ListenerProperties properties = this.listenerConfig.getProperties(false);
        if (properties.isSecureListenerHttpsEnabled() && properties.getSynchronizePartnerCertificates()) {
            if (this.messengerConfig.isPartnerCertificateRevocationCheckEnabled()) {
                revocationVerifier.verifyCertificateCRLs(partnerPipelineCert);
            }
            this.listenerConfig.installClientCertificate(clientCertificate, false);
            listenerRestartNeeded.set(true);
            _log.info("Installed partner certificate for partner {} on listener.", (Object)remotePartnerId);
        }
    }

    public boolean installAllPartnerCertificate() {
        if (this.isListenerAdminDisabled() || !this.isSynchronizePartnerCertificatesEnabled()) {
            return false;
        }
        List<String> partnerLocalIds = this._profiles.getRemoteLocalIds();
        if (this.messengerConfig.isLoopback()) {
            partnerLocalIds.addAll(this._profiles.getLocalLocalIds());
        }
        boolean listenerRestartNeeded = false;
        for (String partnerLocalId : partnerLocalIds) {
            if (!this.updatePartnerCertificate(partnerLocalId)) continue;
            listenerRestartNeeded = true;
        }
        return listenerRestartNeeded;
    }

    private boolean isListenerAdminDisabled() {
        return !this.listenerConfig.isConnected();
    }

    private void restartListener() {
        try {
            this.listenerConfig.restartServices();
        }
        catch (ListenerConfigException e) {
            _log.error("Could not restart listener services.", (Throwable)e);
        }
    }

    private boolean isSynchronizePartnerCertificatesEnabled() {
        try {
            return this.listenerConfig.isSynchronizePartnerCertificatesEnabled();
        }
        catch (ListenerConfigException e) {
            _log.error("Could not get SynchronizePartnerCertificates Property: {}", (Object)e.toString());
            return false;
        }
    }

    public void partnerAdded(String partnerId, String displayName, boolean isLocalPartner) {
    }

    public void partnerDeleted(String partnerId, String displayName, boolean isLocalPartner) {
    }

    public void partnerModified(String partnerId, String oldPartnerId, String displayName, boolean isLocalPartner) {
    }

    @Override
    public void partnerCertificateUpdated(String partnerId, String displayName, boolean isLocalPartner) {
        block5: {
            try {
                if (!this.messengerConfig.isListenerEnabled() || isLocalPartner && !this.messengerConfig.isLoopback() || !this.isSynchronizePartnerCertificatesEnabled()) break block5;
                try {
                    if (this.updatePartnerCertificate(this._profiles.getProfileForInternalId(partnerId, true).getLocalId())) {
                        this.restartListener();
                    }
                }
                catch (ProfileException e) {
                    _log.error(e.getMessage());
                    _log.debug(e.getMessage(), (Throwable)e);
                }
            }
            catch (JAXBException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

