/*
 * Decompiled with CFR 0.152.
 */
package de.pontonconsulting.xmlpipe.config;

public enum SupportedDatabases {
    MSSQL_SERVER_2019("Microsoft SQL Server", 15, 0, "jdbc:sqlserver://<hostname>:<port>;databaseName=<db>;encrypt=true;trustServerCertificate=true;sendStringParametersAsUnicode=false"),
    MSSQL_SERVER_2022("Microsoft SQL Server", 16, 0, "jdbc:sqlserver://<hostname>:<port>;databaseName=<db>;encrypt=true;trustServerCertificate=true;sendStringParametersAsUnicode=false"),
    AZURE_SQL_1("Microsoft SQL Server", 15, 0, "jdbc:sqlserver://<hostname>:<port>;databaseName=<db>;encrypt=true;trustServerCertificate=true;sendStringParametersAsUnicode=false"),
    AZURE_SQL_2("Microsoft SQL Server", 16, 0, "jdbc:sqlserver://<hostname>:<port>;databaseName=<db>;encrypt=true;trustServerCertificate=true;sendStringParametersAsUnicode=false"),
    ORACLE_19C("Oracle", 19, null, "jdbc:oracle:thin:@tcps://<hostname>:<port>/<service>"),
    ORACLE_21C("Oracle", 21, null, "jdbc:oracle:thin:@tcps://<hostname>:<port>/<service>"),
    ORACLE_23AI("Oracle", 23, null, "jdbc:oracle:thin:@tcps://<hostname>:<port>/<service>"),
    MYSQL_80("MySQL", 8, 0, "jdbc:mysql://<hostname>:<port>/<database>?useSSL=true"),
    MYSQL_84("MySQL", 8, 4, "jdbc:mysql://<hostname>:<port>/<database>?useSSL=true"),
    MYSQL_90("MySQL", 9, 0, "jdbc:mysql://<hostname>:<port>/<database>?useSSL=true"),
    POSTGRES_13("PostgreSQL", 13, null, "jdbc:postgresql://<hostname>/<databasename>?ssl=true"),
    POSTGRES_14("PostgreSQL", 14, null, "jdbc:postgresql://<hostname>/<databasename>?ssl=true"),
    POSTGRES_15("PostgreSQL", 15, null, "jdbc:postgresql://<hostname>/<databasename>?ssl=true"),
    POSTGRES_16("PostgreSQL", 16, null, "jdbc:postgresql://<hostname>/<databasename>?ssl=true");

    private String databaseName;
    private Integer majorVersion;
    private Integer minorVersion;
    private String urlSample;

    private SupportedDatabases(String name, Integer major, Integer minor, String urlSample) {
        this.databaseName = name;
        this.majorVersion = major;
        this.minorVersion = minor;
        this.urlSample = urlSample;
    }

    public static SupportedDatabases valueOf(String databaseProductName, int databaseMajorVersion, int databaseMinorVersion) {
        for (SupportedDatabases db : SupportedDatabases.values()) {
            if (!db.databaseName.equals(databaseProductName) || db.majorVersion != databaseMajorVersion || db.minorVersion != null && db.minorVersion != databaseMinorVersion) continue;
            return db;
        }
        throw new IllegalArgumentException("database not supported");
    }

    public String getUrlSample() {
        return this.urlSample;
    }

    private static class Constants {
        public static final String MICROSOFT_SQL_SERVER = "Microsoft SQL Server";
        public static final String ORACLE = "Oracle";
        public static final String MY_SQL = "MySQL";
        public static final String POSTGRE_SQL = "PostgreSQL";
        public static final String JDBC_URL_POSTGRES = "jdbc:postgresql://<hostname>/<databasename>?ssl=true";
        public static final String JDBC_URL_MSSQL = "jdbc:sqlserver://<hostname>:<port>;databaseName=<db>;encrypt=true;trustServerCertificate=true;sendStringParametersAsUnicode=false";
        public static final String JDBC_URL_ORACLE = "jdbc:oracle:thin:@tcps://<hostname>:<port>/<service>";
        public static final String JDBC_URL_MYSQL = "jdbc:mysql://<hostname>:<port>/<database>?useSSL=true";

        private Constants() {
        }
    }
}

