/*
 * Decompiled with CFR 0.152.
 */
package de.pontonconsulting.xmlpipe.config;

import de.ponton.securelistener.administration.certs.CertRequest;
import de.ponton.securelistener.administration.certs.Certificate;
import de.ponton.securelistener.administration.certs.ServerCertificate;
import de.ponton.securelistener.config.ListenerProperties;
import de.ponton.securelistener.ftp.FtpExchangeUserProperties;
import de.ponton.xmlpipe.websocket.AbstractEndpoint;
import de.ponton.xmlpipe.websocket.ConfigEndpoint;
import de.ponton.xmlpipe.websocket.WebsocketClient;
import de.pontonconsulting.xmlpipe.config.listener.AdminConnection;
import de.pontonconsulting.xmlpipe.config.listener.DeleteCertificate;
import de.pontonconsulting.xmlpipe.config.listener.ExportServerCertificate;
import de.pontonconsulting.xmlpipe.config.listener.GenerateCertificateRequest;
import de.pontonconsulting.xmlpipe.config.listener.GetAlias;
import de.pontonconsulting.xmlpipe.config.listener.GetCertificate;
import de.pontonconsulting.xmlpipe.config.listener.GetIpAdresses;
import de.pontonconsulting.xmlpipe.config.listener.GetStatus;
import de.pontonconsulting.xmlpipe.config.listener.InstallCertificate;
import de.pontonconsulting.xmlpipe.config.listener.InstallServerCertificate;
import de.pontonconsulting.xmlpipe.config.listener.ListCertAliases;
import de.pontonconsulting.xmlpipe.config.listener.ListenerConfigException;
import de.pontonconsulting.xmlpipe.config.listener.LoadConfiguration;
import de.pontonconsulting.xmlpipe.config.listener.LoadFtpExchangeUserConfiguration;
import de.pontonconsulting.xmlpipe.config.listener.RestartServices;
import de.pontonconsulting.xmlpipe.config.listener.UpdateConfiguration;
import de.pontonconsulting.xmlpipe.config.listener.UpdateFtpExchangeUserProperties;
import de.pontonconsulting.xmlpipe.config.model.listener.XpListenerConfigurationDto;
import de.pontonconsulting.xmlpipe.events.ListenerCertificatesChanged;
import de.pontonconsulting.xmlpipe.events.ListenerConfigChanged;
import de.pontonconsulting.xmlpipe.messenger.database.hibernate.ListenerCertificate;
import java.time.Instant;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;

public class ListenerConfig {
    private static final Logger log = LogManager.getLogger((String)"Messenger.ListenerConfig");
    private ListenerProperties properties;
    private Instant propertiesTimestamp;
    private final AdminConnection connection;
    private final ApplicationEventPublisher applicationEventPublisher;
    private final WebsocketClient websocketClient;
    private FtpExchangeUserProperties ftpExchangeUsersProperties;

    public ListenerConfig(WebsocketClient websocketClient, ApplicationEventPublisher applicationEventPublisher) {
        this.websocketClient = websocketClient;
        this.connection = new AdminConnection(websocketClient);
        this.applicationEventPublisher = applicationEventPublisher;
        this.propertiesTimestamp = Instant.ofEpochMilli(0L);
    }

    public List<ConfigEndpoint> getConfigEndpoints() {
        return this.websocketClient.getConfigEndpoints();
    }

    public ListenerProperties getProperties(boolean load) throws ListenerConfigException {
        try {
            if (load || this.properties == null) {
                this.loadConfiguration();
            }
        }
        catch (Exception le) {
            log.error("error while loading listener configuration: {}", (Object)le.getMessage());
            if (le instanceof ListenerConfigException) {
                throw (ListenerConfigException)le;
            }
            throw new ListenerConfigException(47000, le.getMessage());
        }
        return this.properties;
    }

    public void setProperties(ListenerProperties properties) {
        this.properties = properties;
        this.propertiesTimestamp = Instant.now();
    }

    public FtpExchangeUserProperties getFtpExchangeUserProperties(boolean load) throws ListenerConfigException {
        try {
            if (load || this.ftpExchangeUsersProperties == null) {
                this.loadFtpUsersConfiguration();
            }
        }
        catch (ListenerConfigException le) {
            log.error("error while loading listener ftp user configuration: {}", (Object)le.getMessage());
            throw le;
        }
        return this.ftpExchangeUsersProperties;
    }

    public void setFtpExchangeUserProperties(FtpExchangeUserProperties properties) {
        this.ftpExchangeUsersProperties = properties;
    }

    public void updateFtpUserProperties() throws ListenerConfigException {
        if (log.isTraceEnabled()) {
            log.trace("Updating Listener ftp users configuration.");
        }
        this.connection.executeCommand(new UpdateFtpExchangeUserProperties(this));
    }

    public XpListenerConfigurationDto getListenerConfiguration() throws ListenerConfigException {
        return new XpListenerConfigurationDto().setListenerProperties(this.getProperties(true)).setFtpExchangeUserProperties(this.getFtpExchangeUserProperties(true));
    }

    public void updateListenerConfiguration(XpListenerConfigurationDto configuration, String userName) throws ListenerConfigException {
        this.properties = configuration.getListenerProperties();
        this.ftpExchangeUsersProperties = configuration.getFtpExchangeUserProperties();
        this.updateConfiguration();
        this.updateFtpUserProperties();
        this.restartServices();
        this.applicationEventPublisher.publishEvent((ApplicationEvent)new ListenerConfigChanged(userName));
    }

    public void updateConfiguration() throws ListenerConfigException {
        if (log.isTraceEnabled()) {
            log.trace("Updating Listener configuration");
        }
        this.connection.executeCommand(new UpdateConfiguration(this));
    }

    public GetStatus getStatus(ConfigEndpoint configEndpoint) throws ListenerConfigException {
        if (log.isTraceEnabled()) {
            log.trace("getting Listener status");
        }
        GetStatus result = new GetStatus();
        this.connection.executeCommandSingle(result, configEndpoint);
        return result;
    }

    public void installClientCertificate(Certificate cer, boolean checkCertificate) throws ListenerConfigException {
        InstallCertificate instCer = new InstallCertificate("addClientCertificate", cer.getCertificate(), checkCertificate);
        this.connection.executeCommand(instCer);
        this.applicationEventPublisher.publishEvent((ApplicationEvent)new ListenerCertificatesChanged(ListenerCertificate.Type.CLIENT));
    }

    public void restartServices() throws ListenerConfigException {
        RestartServices restartServices = new RestartServices("restart");
        this.connection.executeCommand(restartServices);
    }

    public Certificate getClientCertificate(String alias) throws ListenerConfigException {
        GetCertificate getCert = new GetCertificate("getClientCertificate", alias);
        this.connection.executeCommand(getCert);
        return new Certificate(getCert.getContent());
    }

    public String getAliasForClientCertificate(Certificate cert) throws ListenerConfigException {
        GetAlias getAlias = new GetAlias("getClientCertificateAlias", cert);
        this.connection.executeCommand(getAlias);
        return getAlias.getAlias();
    }

    public void deleteClientCertificate(String alias) throws ListenerConfigException {
        DeleteCertificate delCert = new DeleteCertificate("deleteClientCertificate", alias);
        this.connection.executeCommand(delCert);
        this.applicationEventPublisher.publishEvent((ApplicationEvent)new ListenerCertificatesChanged(ListenerCertificate.Type.CLIENT));
    }

    public Set<String> listClientCertificates() throws ListenerConfigException {
        ListCertAliases listAliases = new ListCertAliases("listClientCertificates");
        this.connection.executeCommand(listAliases);
        return listAliases.getAliases();
    }

    public void installClientCACertificate(Certificate cer) throws ListenerConfigException {
        InstallCertificate instCer = new InstallCertificate("addClientCaCertificate", cer.getCertificate(), false);
        this.connection.executeCommand(instCer);
        this.applicationEventPublisher.publishEvent((ApplicationEvent)new ListenerCertificatesChanged(ListenerCertificate.Type.CLIENT_CA));
    }

    public Certificate getClientCACertificate(String alias) throws ListenerConfigException {
        GetCertificate getCert = new GetCertificate("getClientCaCertificate", alias);
        this.connection.executeCommand(getCert);
        return new Certificate(getCert.getContent());
    }

    public String getAliasForClientCACertificate(Certificate cert) throws ListenerConfigException {
        GetAlias getAlias = new GetAlias("getClientCACertificateAlias", cert);
        this.connection.executeCommand(getAlias);
        return getAlias.getAlias();
    }

    public void deleteClientCACertificate(String alias) throws ListenerConfigException {
        DeleteCertificate delCert = new DeleteCertificate("deleteClientCACertificate", alias);
        this.connection.executeCommand(delCert);
        this.applicationEventPublisher.publishEvent((ApplicationEvent)new ListenerCertificatesChanged(ListenerCertificate.Type.CLIENT_CA));
    }

    public Set<String> listClientCACertificates() throws ListenerConfigException {
        ListCertAliases listAliases = new ListCertAliases("listClientCACertificates");
        this.connection.executeCommand(listAliases);
        return listAliases.getAliases();
    }

    public void installServerCACertificate(Certificate cer, String alias) throws ListenerConfigException {
        InstallCertificate instCer = new InstallCertificate("addServerCaCertificate", cer.getCertificate(), true);
        if (alias != null && !alias.isEmpty() && !alias.isBlank()) {
            instCer.getHeaders().put("X-Ponton-SecureListener-CertAlias", alias);
        }
        this.connection.executeCommand(instCer);
        this.applicationEventPublisher.publishEvent((ApplicationEvent)new ListenerCertificatesChanged(ListenerCertificate.Type.SERVER_CA));
    }

    public void installServerCACertificate(Certificate cer) throws ListenerConfigException {
        this.installServerCACertificate(cer, null);
    }

    public Certificate getServerCACertificate(String alias) throws ListenerConfigException {
        GetCertificate getCert = new GetCertificate("getServerCACertificate", alias);
        this.connection.executeCommand(getCert);
        return new Certificate(getCert.getContent());
    }

    public String getAliasForServerCACertificate(Certificate cert) throws ListenerConfigException {
        GetAlias getAlias = new GetAlias("getServerCACertificateAlias", cert);
        this.connection.executeCommand(getAlias);
        return getAlias.getAlias();
    }

    public void deleteServerCACertificate(String alias) throws ListenerConfigException {
        DeleteCertificate delCert = new DeleteCertificate("deleteServerCACertificate", alias);
        this.connection.executeCommand(delCert);
        this.applicationEventPublisher.publishEvent((ApplicationEvent)new ListenerCertificatesChanged(ListenerCertificate.Type.SERVER_CA));
    }

    public Set<String> listServerCACertificates() throws ListenerConfigException {
        ListCertAliases listAliases = new ListCertAliases("listServerCACertificates");
        this.connection.executeCommand(listAliases);
        return listAliases.getAliases();
    }

    public CertRequest createCertRequest(CertRequest csr) throws ListenerConfigException {
        GenerateCertificateRequest genCsr = new GenerateCertificateRequest(csr);
        this.connection.executeCommand(genCsr);
        return genCsr.getCertRequest();
    }

    public Certificate getServerCertificate(String alias) throws ListenerConfigException {
        GetCertificate getCert = new GetCertificate("getServerCertificate", alias);
        this.connection.executeCommand(getCert);
        return new Certificate(getCert.getContent());
    }

    public Set<String> listServerCertificates() throws ListenerConfigException {
        ListCertAliases listAliases = new ListCertAliases("listServerCertificate");
        this.connection.executeCommand(listAliases);
        return listAliases.getAliases();
    }

    public void deleteServerCertificate(String alias) throws ListenerConfigException {
        DeleteCertificate delCert = new DeleteCertificate("deleteServerCertificate", alias);
        this.connection.executeCommand(delCert);
        this.applicationEventPublisher.publishEvent((ApplicationEvent)new ListenerCertificatesChanged(ListenerCertificate.Type.SERVER));
    }

    public byte[] exportServerCertificate(String id, String password) throws ListenerConfigException {
        if (id == null || id.length() == 0) {
            throw new ListenerConfigException(-1, "The certificate id need to be supplied.");
        }
        if (password == null || password.length() == 0) {
            throw new ListenerConfigException(47000, "The private key password need to be supplied.");
        }
        ExportServerCertificate export = new ExportServerCertificate(id, password);
        this.connection.executeCommand(export);
        return export.getPKCS12();
    }

    public String installServerCertificate(ServerCertificate cer) throws ListenerConfigException {
        InstallServerCertificate instCer = new InstallServerCertificate(cer);
        this.connection.executeCommand(instCer);
        this.applicationEventPublisher.publishEvent((ApplicationEvent)new ListenerCertificatesChanged(ListenerCertificate.Type.SERVER));
        return instCer.getCertificateId();
    }

    public List<String> getIpAddresses() throws ListenerConfigException {
        GetIpAdresses getIps = new GetIpAdresses();
        this.connection.executeCommand(getIps);
        ArrayList<String> list = getIps.getIpAddresses();
        list.sort(String::compareToIgnoreCase);
        return list;
    }

    public boolean isConnected() {
        return this.websocketClient.getConfigEndpoints().stream().anyMatch(AbstractEndpoint::isAuthenticated);
    }

    private void loadConfiguration() throws Exception {
        this.connection.executeCommand(new LoadConfiguration(this));
    }

    private void loadFtpUsersConfiguration() throws ListenerConfigException {
        this.connection.executeCommand(new LoadFtpExchangeUserConfiguration(this));
    }

    public boolean isSynchronizePartnerCertificatesEnabled() throws ListenerConfigException {
        boolean reload = this.propertiesTimestamp.compareTo(Instant.now().minusSeconds(300L)) <= 0;
        ListenerProperties listenerProperties = this.getProperties(reload);
        return listenerProperties.getSynchronizePartnerCertificates();
    }
}

