/*
 * Decompiled with CFR 0.152.
 */
package de.pontonconsulting.xmlpipe.config;

import de.pontonconsulting.xmlpipe.config.FoldersProvider;
import de.pontonconsulting.xmlpipe.config.IFolders;
import de.pontonconsulting.xmlpipe.config.IServerConfigBean;
import de.pontonconsulting.xmlpipe.config.MessengerConfig;
import de.pontonconsulting.xmlpipe.cpa.Agreements;
import de.pontonconsulting.xmlpipe.cpp.Profiles;
import de.pontonconsulting.xmlpipe.events.ReloadConfiguration;
import jakarta.annotation.PostConstruct;
import jakarta.xml.bind.JAXBException;
import java.io.File;
import java.io.IOException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationListener;

public class Folders
implements IFolders,
ApplicationListener {
    private static final Logger LOG = LogManager.getLogger((String)"Messenger.Folders");
    static final Pattern SEPARATOR_PATTERN = Pattern.compile("\\\\");
    private File _workFolder;
    private File _workInboundFolder;
    private File _workOutboundFolder;
    private File _archiveFolder;
    private File _archiveFailedFolder;
    private File _packedConfigFolder;
    private File _packedLogsFolder;
    private final IServerConfigBean _serverConfig;
    private final MessengerConfig _messengerConfig;

    public Folders(IServerConfigBean serverConfig, MessengerConfig messengerConfig) {
        this._serverConfig = serverConfig;
        this._messengerConfig = messengerConfig;
    }

    @PostConstruct
    public void init() throws Exception {
        this.initWorkFolders();
        this.initAgreementFolders();
        this.initProfileFolders();
        this.initArchiveFolder();
        this.initPackedConfigFolder();
        this.initPackedLogFolder();
        FoldersProvider.setFolders(this);
    }

    private void initPackedConfigFolder() {
        this._packedConfigFolder = new File(this.getWorkFolder(), "PackedConfigs");
        if (!this._packedConfigFolder.exists()) {
            this._packedConfigFolder.mkdirs();
        }
    }

    private void initPackedLogFolder() {
        this._packedLogsFolder = new File(this.getWorkFolder(), "PackedLogs");
        if (!this._packedLogsFolder.exists()) {
            this._packedLogsFolder.mkdirs();
        }
    }

    private void initArchiveFolder() throws IOException, JAXBException {
        this._archiveFolder = this._serverConfig.getRealFile(this._messengerConfig.getArchiveFolder());
        this._archiveFailedFolder = this._serverConfig.getRealFile(this._messengerConfig.getArchiveFailedFolder());
    }

    private void initWorkFolders() throws IOException, JAXBException {
        String workFolder = System.getProperty("ponton.messenger.cluster.workfolder", "none");
        this._workFolder = "none".equals(workFolder) ? this._serverConfig.getRealFile(this._messengerConfig.getWorkFolder()) : new File(workFolder);
        this._workInboundFolder = new File(this._workFolder, "Inbound");
        this._workInboundFolder.mkdirs();
        this._workOutboundFolder = new File(this._workFolder, "Outbound");
        this._workOutboundFolder.mkdirs();
    }

    private void initProfileFolders() throws Exception {
        File privateProfilesFolder;
        File profilesFolder = new File(this._serverConfig.getConfigFolder(), Profiles.CONFIG_PARTNERPROFILES);
        if (!profilesFolder.exists()) {
            profilesFolder.mkdirs();
        }
        if (!(privateProfilesFolder = new File(profilesFolder, Profiles.PRIVATE_PROFILE_SUBFOLDER)).exists()) {
            privateProfilesFolder.mkdirs();
        }
    }

    private void initAgreementFolders() throws Exception {
        File agreementsPrivateFolder;
        File agreementsFolder = new File(this._serverConfig.getConfigFolder(), Agreements.CONFIG_PARTNER_AGREEMENTS);
        if (!agreementsFolder.exists()) {
            agreementsFolder.mkdirs();
        }
        if (!(agreementsPrivateFolder = new File(agreementsFolder, Agreements.AGREEMENT_PRIVATE_FOLDER)).exists()) {
            agreementsPrivateFolder.mkdirs();
        }
    }

    @Override
    public String convertFolderToString(File folder) {
        if (folder == null) {
            return null;
        }
        Object folderStr = folder.getAbsolutePath();
        String archiveFolder = this.getArchiveFolder().getAbsolutePath();
        String archiveFailedFolder = this.getArchiveFailedFolder().getAbsolutePath();
        String workInboundFolder = this.getWorkInboundFolder().getAbsolutePath();
        String workOutboundFolder = this.getWorkOutboundFolder().getAbsolutePath();
        String workFolder = this.getWorkFolder().getAbsolutePath();
        if (((String)folderStr).length() == archiveFolder.length() && ((String)folderStr).equals(archiveFolder)) {
            folderStr = "$ARCHIVE";
        } else if (((String)folderStr).length() > archiveFolder.length() && ((String)folderStr).startsWith(archiveFolder + File.separator)) {
            folderStr = ((String)folderStr).substring(archiveFolder.length());
            folderStr = "$ARCHIVE" + (String)folderStr;
        } else if (((String)folderStr).length() == archiveFailedFolder.length() && ((String)folderStr).equals(archiveFailedFolder)) {
            folderStr = "$ARCHIVE_FAILED";
        } else if (((String)folderStr).length() > archiveFailedFolder.length() && ((String)folderStr).startsWith(archiveFailedFolder + File.separator)) {
            folderStr = ((String)folderStr).substring(archiveFailedFolder.length());
            folderStr = "$ARCHIVE_FAILED" + (String)folderStr;
        } else if (((String)folderStr).length() == workInboundFolder.length() && ((String)folderStr).equals(workInboundFolder)) {
            folderStr = "$WORK/Inbound";
        } else if (((String)folderStr).length() > workInboundFolder.length() && ((String)folderStr).startsWith(workInboundFolder + File.separator)) {
            folderStr = ((String)folderStr).substring(workInboundFolder.length());
            folderStr = "$WORK/Inbound" + (String)folderStr;
        } else if (((String)folderStr).length() == workOutboundFolder.length() && ((String)folderStr).equals(workOutboundFolder)) {
            folderStr = "$WORK/Outbound";
        } else if (((String)folderStr).length() > workOutboundFolder.length() && ((String)folderStr).startsWith(workOutboundFolder + File.separator)) {
            folderStr = ((String)folderStr).substring(workOutboundFolder.length());
            folderStr = "$WORK/Outbound" + (String)folderStr;
        } else if (((String)folderStr).length() == workFolder.length() && ((String)folderStr).equals(workFolder)) {
            folderStr = "$WORK";
        } else if (((String)folderStr).length() > workFolder.length() && ((String)folderStr).startsWith(workFolder + File.separator)) {
            folderStr = ((String)folderStr).substring(workFolder.length());
            folderStr = "$WORK" + (String)folderStr;
        }
        Matcher matcher = SEPARATOR_PATTERN.matcher((CharSequence)folderStr);
        return matcher.replaceAll("/");
    }

    @Override
    public File convertStringToFolder(String folderStr) {
        if (folderStr == null) {
            return null;
        }
        Object folder = folderStr;
        if (folderStr.startsWith("$ARCHIVE_FAILED")) {
            folder = folderStr.substring("$ARCHIVE_FAILED".length());
            folder = this.getArchiveFailedFolder().getAbsolutePath() + (String)folder;
        } else if (folderStr.startsWith("$ARCHIVE")) {
            folder = folderStr.substring("$ARCHIVE".length());
            folder = this.getArchiveFolder().getAbsolutePath() + (String)folder;
        } else if (folderStr.startsWith("$WORK/Inbound")) {
            folder = folderStr.substring("$WORK/Inbound".length());
            folder = this.getWorkInboundFolder().getAbsolutePath() + (String)folder;
        } else if (folderStr.startsWith("$WORK/Outbound")) {
            folder = folderStr.substring("$WORK/Outbound".length());
            folder = this.getWorkOutboundFolder().getAbsolutePath() + (String)folder;
        } else if (folderStr.startsWith("$WORK")) {
            folder = folderStr.substring("$WORK".length());
            folder = this.getWorkFolder().getAbsolutePath() + (String)folder;
        }
        return new File((String)folder);
    }

    @Override
    public File getArchiveFolder() {
        return this._archiveFolder;
    }

    @Override
    public File getArchiveFailedFolder() {
        return this._archiveFailedFolder;
    }

    @Override
    public File getWorkFolder() {
        return this._workFolder;
    }

    @Override
    public File getWorkInboundFolder() {
        return this._workInboundFolder;
    }

    @Override
    public File getWorkOutboundFolder() {
        return this._workOutboundFolder;
    }

    @Override
    public File getPackedConfigFolder() {
        return this._packedConfigFolder;
    }

    @Override
    public File getPackedLogsFolder() {
        return this._packedLogsFolder;
    }

    public void onApplicationEvent(ApplicationEvent event) {
        if (event instanceof ReloadConfiguration) {
            ReloadConfiguration reloadConfig = (ReloadConfiguration)event;
            try {
                if (reloadConfig.isMessengerConfigChanged()) {
                    this.init();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

