/*
 * Decompiled with CFR 0.152.
 */
package de.pontonconsulting.xmlpipe.config;

import de.pontonconsulting.common.file.DBConfigChangeWatcher;
import de.pontonconsulting.xmlpipe.config.IServerConfigBean;
import de.pontonconsulting.xmlpipe.messenger.database.hibernate.MessengerAddOnAdapter;
import de.pontonconsulting.xmlpipe.messenger.database.hibernate.MessengerAddOnConfig;
import de.pontonconsulting.xmlpipe.messenger.database.hibernate.PlugableAdapterConfig;
import de.pontonconsulting.xmlpipe.messenger.database.tables.MessengerAddOnDAO;
import de.pontonconsulting.xmlpipe.messenger.database.tables.MessengerConfigDAO;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.time.Instant;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.stream.Stream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.util.AntPathMatcher;
import org.springframework.util.PathMatcher;

public class ConfigResourceService {
    private static final Logger LOG = LogManager.getLogger((String)"Messenger.ConfigResourceService");
    private IServerConfigBean config;
    private URLClassLoader configClassLoader;
    private PathMatchingResourcePatternResolver configResolver;
    private ClassLoader applicationClassLoader;
    private PathMatchingResourcePatternResolver applicationResolver;
    private final MessengerConfigDAO messengerConfigDAO;
    private final Lock configChangeLock;

    public ConfigResourceService(IServerConfigBean config, MessengerConfigDAO messengerConfigDAO, MessengerAddOnDAO messengerAddOnDAO, DBConfigChangeWatcher schemataChangeWatcher, DBConfigChangeWatcher envelopesChangeWatcher, DBConfigChangeWatcher agreementTemplateConfigWatcher) throws IOException {
        File[] configs;
        File[] adapters;
        this.config = config;
        this.messengerConfigDAO = messengerConfigDAO;
        this.configChangeLock = new ReentrantLock(true);
        File schemataFolder = config.getSchemaSetFolder();
        File envelopeFolder = config.getEnvelopesFolder();
        File addOnsConfigFolder = config.getAddonsConfigsFolder();
        File addOnsAdaptersFolder = config.getAdaptersFolder();
        File agreementTemplateFolder = config.getAgreementTemplateFolder();
        File plugableAdapterConfigFolder = new File(config.getConfigFolder(), "plugableAdapterConfigs");
        if (Files.notExists(plugableAdapterConfigFolder.toPath(), new LinkOption[0])) {
            Files.createDirectory(plugableAdapterConfigFolder.toPath(), new FileAttribute[0]);
        }
        if ((adapters = addOnsAdaptersFolder.listFiles(e -> e.getName().endsWith(".jar"))) != null) {
            for (File addOnAdapter : adapters) {
                if (addOnAdapter.isDirectory()) continue;
                messengerAddOnDAO.storeMessengerAddOnAdapter(new MessengerAddOnAdapter().setFilename(addOnAdapter.getName()).setData(Files.readAllBytes(addOnAdapter.toPath())).setTimestamp(OffsetDateTime.ofInstant(Instant.ofEpochMilli(addOnAdapter.lastModified()), ZoneOffset.UTC)));
            }
        }
        if ((configs = addOnsConfigFolder.listFiles(e -> e.getName().endsWith(".jar"))) != null) {
            for (File addOnConfig : configs) {
                if (addOnConfig.isDirectory()) continue;
                messengerAddOnDAO.storeMessengerAddOnConfig(new MessengerAddOnConfig().setFilename(addOnConfig.getName()).setData(Files.readAllBytes(addOnConfig.toPath())).setTimestamp(OffsetDateTime.ofInstant(Instant.ofEpochMilli(addOnConfig.lastModified()), ZoneOffset.UTC)));
            }
        }
        if (!messengerConfigDAO.doesMessengerConfigExist("envelopes") && envelopeFolder.exists()) {
            messengerConfigDAO.storeMessengerConfig(this.compressFolderToByteStream(envelopeFolder), "envelopes", "SYSTEM");
        }
        if (!messengerConfigDAO.doesMessengerConfigExist("schemata") && schemataFolder.exists()) {
            messengerConfigDAO.storeMessengerConfig(this.compressFolderToByteStream(schemataFolder), "schemata", "SYSTEM");
        }
        if (agreementTemplateFolder.exists()) {
            try (Stream<Path> stream = Files.list(agreementTemplateFolder.toPath());){
                if (!messengerConfigDAO.doesMessengerConfigExist("agreement_templates") && stream.anyMatch(path -> path.toString().endsWith("public.vm") || path.toString().endsWith("private.vm"))) {
                    messengerConfigDAO.storeMessengerConfig(this.compressFolderToByteStream(agreementTemplateFolder), "agreement_templates", "SYSTEM");
                }
            }
        }
        for (File file : Objects.requireNonNull(plugableAdapterConfigFolder.listFiles(e -> !e.isDirectory()))) {
            if (!messengerAddOnDAO.loadPlugableAdapterConfig(file.getName()).isEmpty()) continue;
            Files.deleteIfExists(file.toPath());
        }
        this.loadConfig("envelopes", envelopeFolder);
        this.loadConfig("schemata", schemataFolder);
        this.loadConfig("agreement_templates", agreementTemplateFolder);
        for (MessengerAddOnConfig messengerAddOnConfig : messengerAddOnDAO.loadAllConfigs()) {
            File file = new File(addOnsConfigFolder, messengerAddOnConfig.getFilename());
            if (file.lastModified() >= messengerAddOnConfig.getTimestamp().toInstant().toEpochMilli()) continue;
            Files.write(file.toPath(), messengerAddOnConfig.getData(), StandardOpenOption.WRITE, StandardOpenOption.CREATE);
        }
        for (MessengerAddOnAdapter messengerAddOnAdapter : messengerAddOnDAO.loadAllAdapters()) {
            File file = new File(addOnsAdaptersFolder, messengerAddOnAdapter.getFilename());
            if (file.lastModified() >= messengerAddOnAdapter.getTimestamp().toInstant().toEpochMilli()) continue;
            Files.write(file.toPath(), messengerAddOnAdapter.getData(), StandardOpenOption.WRITE, StandardOpenOption.CREATE);
        }
        for (PlugableAdapterConfig plugableAdapterConfig : messengerAddOnDAO.loadAllPlugableAdapterConfigs()) {
            File file = new File(plugableAdapterConfigFolder, plugableAdapterConfig.getFilename());
            if (file.lastModified() >= plugableAdapterConfig.getTimestamp().toInstant().toEpochMilli()) continue;
            Files.write(file.toPath(), plugableAdapterConfig.getData(), StandardOpenOption.WRITE, StandardOpenOption.CREATE);
        }
        schemataChangeWatcher.addFileChangeListener(() -> {
            try {
                this.loadConfig("schemata", schemataFolder);
            }
            catch (IOException e) {
                LOG.error("Error while loading schemata", (Throwable)e);
            }
        });
        envelopesChangeWatcher.addFileChangeListener(() -> {
            try {
                this.loadConfig("envelopes", envelopeFolder);
            }
            catch (IOException e) {
                LOG.error("Error while loading envelopes", (Throwable)e);
            }
        });
        agreementTemplateConfigWatcher.addFileChangeListener(() -> {
            try {
                this.loadConfig("agreement_templates", agreementTemplateFolder);
            }
            catch (IOException e) {
                LOG.error("Error while loading agreementTemplates", (Throwable)e);
            }
        });
        this.init();
    }

    private void loadConfig(String type, File folder) throws IOException {
        if (this.messengerConfigDAO.doesMessengerConfigExist(type)) {
            this.configChangeLock.lock();
            try {
                LOG.debug("Loading config {} from database.", (Object)type);
                this.deleteFolder(folder);
                this.decompressFolder(this.messengerConfigDAO.loadMessengerConfig(type).getData(), folder);
            }
            finally {
                this.configChangeLock.unlock();
            }
        }
    }

    public void storeSchemataAndEnvelopes(String username) throws IOException {
        File schemataFolder = this.config.getSchemaSetFolder();
        File envelopeFolder = this.config.getEnvelopesFolder();
        this.messengerConfigDAO.storeMessengerConfig(this.compressFolderToByteStream(envelopeFolder), "envelopes", username);
        this.messengerConfigDAO.storeMessengerConfig(this.compressFolderToByteStream(schemataFolder), "schemata", username);
    }

    public void storeAgreementTemplates(String username) throws IOException {
        File agreementTemplateFolder = this.config.getAgreementTemplateFolder();
        this.messengerConfigDAO.storeMessengerConfig(this.compressFolderToByteStream(agreementTemplateFolder), "agreement_templates", username);
    }

    public Path getAgreementTemplateFolder() {
        Path folderPath = this.config.getAgreementTemplateFolder().toPath();
        if (Files.notExists(folderPath, new LinkOption[0])) {
            try {
                Files.createDirectories(folderPath, new FileAttribute[0]);
            }
            catch (IOException e) {
                LOG.error("Error creating agreement template folder: {}", (Object)folderPath.toAbsolutePath(), (Object)e);
            }
        }
        return folderPath;
    }

    public void init() {
        ArrayList<URL> urls = new ArrayList<URL>();
        this.addFileToList(urls, this.config.getConfigFolder());
        File addonFolder = this.config.getAddonsConfigsFolder();
        File[] addons = addonFolder.listFiles();
        if (addons != null) {
            Arrays.sort(addons, (a, b) -> a.getAbsolutePath().compareToIgnoreCase(b.getAbsolutePath()));
            for (File file : addons) {
                this.addFileToList(urls, file);
            }
        }
        this.configClassLoader = new URLClassLoader(urls.toArray(new URL[urls.size()]), null);
        this.configResolver = new PathMatchingResourcePatternResolver((ClassLoader)this.configClassLoader);
        AntPathMatcher matcher = new AntPathMatcher();
        matcher.setCaseSensitive(false);
        this.configResolver.setPathMatcher((PathMatcher)matcher);
        this.applicationClassLoader = this.getClass().getClassLoader();
        this.applicationResolver = new PathMatchingResourcePatternResolver(this.applicationClassLoader);
    }

    private void addFileToList(ArrayList<URL> urls, File file) {
        try {
            urls.add(file.toURI().toURL());
        }
        catch (MalformedURLException e) {
            LOG.warn("could not add File to ResourceLoader " + String.valueOf(file) + e.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map.Entry<URI, InputStream> getResource(String name) throws IOException {
        this.configChangeLock.lock();
        try {
            URI result;
            Resource resource;
            try {
                resource = this.configResolver.getResource(name);
                result = resource.getURI();
            }
            catch (IOException e) {
                resource = this.applicationResolver.getResource(name);
                result = resource.getURI();
            }
            LOG.debug("resolved {} to {}", (Object)name, (Object)result);
            AbstractMap.SimpleEntry<URI, InputStream> simpleEntry = new AbstractMap.SimpleEntry<URI, InputStream>(result, new ByteArrayInputStream(resource.getContentAsByteArray()));
            return simpleEntry;
        }
        finally {
            this.configChangeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<URI, InputStream> getResources(String pattern) {
        this.configChangeLock.lock();
        LinkedHashMap<URI, InputStream> map = new LinkedHashMap<URI, InputStream>();
        try {
            Resource[] resources;
            LOG.trace("looking for resources: " + pattern);
            try {
                for (Resource resource : resources = this.configResolver.getResources("classpath*:" + pattern)) {
                    LOG.trace("found config resource:" + String.valueOf(resource.getURL()));
                    map.put(resource.getURI(), new ByteArrayInputStream(resource.getContentAsByteArray()));
                }
            }
            catch (IOException ioe) {
                LOG.trace("No resources in config for pattern classpath*:" + pattern);
            }
            try {
                for (Resource resource : resources = this.applicationResolver.getResources("classpath*:" + pattern)) {
                    LOG.trace("found app resource:" + String.valueOf(resource.getURI()));
                    if (map.containsKey(resource.getURI())) continue;
                    map.put(resource.getURI(), new ByteArrayInputStream(resource.getContentAsByteArray()));
                }
            }
            catch (IOException ioe) {
                LOG.trace("No ressources in application for pattern classpath*:" + pattern);
            }
        }
        finally {
            this.configChangeLock.unlock();
        }
        return map;
    }

    private void deleteFolder(File folder) {
        File[] files = folder.listFiles();
        if (files != null) {
            for (File file : files) {
                if (file.isDirectory()) {
                    this.deleteFolder(file);
                    continue;
                }
                file.delete();
            }
        }
        folder.delete();
    }

    private byte[] compressFolderToByteStream(File folder) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try (ZipOutputStream zipOutputStream = new ZipOutputStream(byteArrayOutputStream);){
            this.compressFolder(folder, ".", zipOutputStream);
        }
        return byteArrayOutputStream.toByteArray();
    }

    private void compressFolder(File folder, String parentFolder, ZipOutputStream zipOutputStream) throws IOException {
        File[] files = folder.listFiles();
        if (files != null) {
            for (File file : files) {
                if (file.isDirectory()) {
                    this.compressFolder(file, parentFolder + "/" + file.getName(), zipOutputStream);
                    continue;
                }
                try (BufferedInputStream fileInputStream = new BufferedInputStream(Files.newInputStream(file.toPath(), new OpenOption[0]));){
                    int length;
                    ZipEntry zipEntry = new ZipEntry(parentFolder + "/" + file.getName());
                    zipOutputStream.putNextEntry(zipEntry);
                    byte[] buffer = new byte[1024];
                    while ((length = ((InputStream)fileInputStream).read(buffer)) > 0) {
                        zipOutputStream.write(buffer, 0, length);
                    }
                    zipOutputStream.closeEntry();
                }
            }
        }
    }

    public void decompressFolder(byte[] compressedData, File outputDir) throws IOException {
        if (!outputDir.exists()) {
            outputDir.mkdirs();
        }
        try (ZipInputStream zipInputStream = new ZipInputStream(new ByteArrayInputStream(compressedData));){
            ZipEntry entry;
            while ((entry = zipInputStream.getNextEntry()) != null) {
                File file = new File(outputDir, entry.getName());
                if (entry.isDirectory()) {
                    file.mkdirs();
                } else {
                    file.getParentFile().mkdirs();
                    try (BufferedOutputStream fileOutputStream = new BufferedOutputStream(Files.newOutputStream(file.toPath(), new OpenOption[0]));){
                        int length;
                        byte[] buffer = new byte[1024];
                        while ((length = zipInputStream.read(buffer)) > 0) {
                            ((OutputStream)fileOutputStream).write(buffer, 0, length);
                        }
                    }
                }
                zipInputStream.closeEntry();
            }
        }
    }

    public void clearCache() {
        this.configClassLoader = null;
        this.configResolver = null;
        this.applicationClassLoader = null;
        this.applicationResolver = null;
    }
}

