/*
 * Decompiled with CFR 0.152.
 */
package de.pontonconsulting.xmlpipe.as;

import de.pontonconsulting.common.activation.SimpleFileDataSource;
import de.pontonconsulting.common.activation.StreamDataSource;
import de.pontonconsulting.xmlpipe.as.ASException;
import de.pontonconsulting.xmlpipe.as.ASMessage;
import de.pontonconsulting.xmlpipe.as.ASObject;
import de.pontonconsulting.xmlpipe.as.ASReport;
import de.pontonconsulting.xmlpipe.as.MDNParameters;
import de.pontonconsulting.xmlpipe.cpp.Profiles;
import de.pontonconsulting.xmlpipe.mail.DispositionNotification;
import de.pontonconsulting.xmlpipe.message.XpMessage;
import de.pontonconsulting.xmlpipe.message.XpMessageAttachment;
import de.pontonconsulting.xmlpipe.messenger.IdGenerator;
import de.pontonconsulting.xmlpipe.messenger.ReferenceDateTask;
import de.pontonconsulting.xmlpipe.security.CertificateUtility;
import de.pontonconsulting.xmlpipe.security.smime.SMIMESigner;
import de.pontonconsulting.xmlpipe.util.MimeMultipartUtils;
import jakarta.activation.DataHandler;
import jakarta.activation.DataSource;
import jakarta.mail.BodyPart;
import jakarta.mail.Header;
import jakarta.mail.MessagingException;
import jakarta.mail.Multipart;
import jakarta.mail.Part;
import jakarta.mail.internet.ContentDisposition;
import jakarta.mail.internet.ContentType;
import jakarta.mail.internet.InternetHeaders;
import jakarta.mail.internet.MailDateFormat;
import jakarta.mail.internet.MimeBodyPart;
import jakarta.mail.internet.MimeMessage;
import jakarta.mail.internet.MimeMultipart;
import jakarta.mail.internet.MimeUtility;
import jakarta.mail.internet.SharedInputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.text.ParseException;
import java.util.Date;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.util.Assert;

public abstract class ASObjectFactory {
    private final IdGenerator _idGenerator;
    protected final ReferenceDateTask referenceDateTask;
    protected final CertificateUtility _certificateUtility;
    protected final SMIMESigner _smimeSigner;
    protected final Profiles _profiles;

    public ASObjectFactory(IdGenerator idGenerator, ReferenceDateTask referenceDateTask, CertificateUtility certificateUtility, SMIMESigner smimeSigner, Profiles profiles) {
        this._idGenerator = idGenerator;
        this.referenceDateTask = referenceDateTask;
        this._certificateUtility = certificateUtility;
        this._smimeSigner = smimeSigner;
        this._profiles = profiles;
    }

    public ASObject createASObject(MimeMessage mimeMessage) throws ASException, MessagingException, IOException {
        ContentType contentType = new ContentType(mimeMessage.getContentType());
        InternetHeaders headers = MimeMultipartUtils.createIntenetHeaders((Part)mimeMessage);
        MimeBodyPart mimePart = new MimeBodyPart();
        Object content = mimeMessage.getContent();
        if (content instanceof SharedInputStream) {
            mimePart.setDataHandler(new DataHandler((DataSource)new StreamDataSource(contentType.toString(), (SharedInputStream)content)));
        } else {
            mimePart.setContent(content, contentType.getBaseType());
        }
        if (contentType.getBaseType().toLowerCase().equals("multipart/report")) {
            return this.createASReport(headers, contentType, mimePart);
        }
        if (contentType.getBaseType().toLowerCase().equals("multipart/signed")) {
            MimeMultipart mp = (MimeMultipart)mimePart.getContent();
            boolean isReport = false;
            for (int i = 0; i < mp.getCount(); ++i) {
                ContentType bpContent;
                BodyPart bp = mp.getBodyPart(i);
                String bpContentType = bp.getContentType();
                if (bpContentType == null || !(bpContent = new ContentType(bpContentType)).getBaseType().toLowerCase().equals("multipart/report")) continue;
                isReport = true;
                break;
            }
            if (isReport) {
                return this.createASReport(headers, contentType, mimePart);
            }
        }
        return this.createASMessage(headers, contentType, mimePart);
    }

    public abstract ASReport createASReport(InternetHeaders var1, ContentType var2, MimeBodyPart var3) throws MessagingException, ASException;

    public abstract ASMessage createASMessage(InternetHeaders var1, ContentType var2, MimeBodyPart var3) throws MessagingException, ASException;

    private void initASObject(ASObject asObject, InternetHeaders headers, MimeBodyPart mimePart) throws MessagingException {
        asObject.setRecreateHeaders(false);
        asObject.setInternetHeaders(headers);
        asObject.setMimePart(mimePart);
        if (asObject.getInternetHeaders().getHeader("Message-Id") != null && asObject.getInternetHeaders().getHeader("Message-Id").length > 0) {
            String messageId = asObject.getInternetHeaders().getHeader("Message-Id")[0];
            asObject.setMessageId(messageId.replace('<', ' ').replace('>', ' ').trim());
        }
        Date date = null;
        if (asObject.getInternetHeaders().getHeader("Date") != null && asObject.getInternetHeaders().getHeader("Date").length > 0) {
            MailDateFormat dateFormatter = new MailDateFormat();
            try {
                String[] dateString = asObject.getInternetHeaders().getHeader("Date");
                if (dateString != null && dateString.length > 0) {
                    date = dateFormatter.parse(dateString[0]);
                }
            }
            catch (ParseException dateString) {
                // empty catch block
            }
        }
        if (date != null) {
            asObject.setDate(date);
        } else {
            asObject.setDate(this.referenceDateTask.getReferenceDate());
        }
        this.parseASObjectHeaders(asObject);
        Enumeration headerElements = headers.getAllHeaders();
        while (headerElements.hasMoreElements()) {
            Header header = (Header)headerElements.nextElement();
            asObject.getMimePart().addHeader(header.getName(), header.getValue());
        }
    }

    protected void initASReport(ASReport asReport, InternetHeaders headers, MimeBodyPart mimePart) throws MessagingException, ASException {
        this.initASObject(asReport, headers, mimePart);
        asReport.init();
    }

    protected void initASMessage(ASMessage asMessage, InternetHeaders headers, MimeBodyPart mimePart) throws ASException {
        try {
            this.initASObject(asMessage, headers, mimePart);
            String dispositionNotificationTo = null;
            String[] dispositionNotificaitonToFromHeader = asMessage.getInternetHeaders().getHeader("Disposition-Notification-To");
            if (dispositionNotificaitonToFromHeader != null && dispositionNotificaitonToFromHeader.length > 0) {
                dispositionNotificationTo = dispositionNotificaitonToFromHeader[0];
                asMessage.setMDNRequested(true);
            } else {
                asMessage.setMDNRequested(false);
            }
            String dispositionNotificationOptions = null;
            if (asMessage.getInternetHeaders().getHeader("Disposition-Notification-Options") != null && asMessage.getInternetHeaders().getHeader("Disposition-Notification-Options").length > 0) {
                dispositionNotificationOptions = asMessage.getInternetHeaders().getHeader("Disposition-Notification-Options")[0];
            }
            if (StringUtils.isNotBlank((CharSequence)dispositionNotificationTo)) {
                asMessage.setMDNParameters(new MDNParameters(dispositionNotificationTo, dispositionNotificationOptions));
            } else {
                asMessage.setMDNParameters(new MDNParameters(""));
            }
            this.parseASMessageHeaders(asMessage);
        }
        catch (MessagingException me) {
            throw new ASException(43002, "Unable to reconstruct the message. " + me.getMessage());
        }
    }

    protected abstract void parseASObjectHeaders(ASObject var1) throws MessagingException;

    protected abstract void parseASMessageHeaders(ASMessage var1) throws MessagingException;

    protected void initASMessage(ASMessage asMessage, XpMessage message) throws ASException {
        asMessage.setRecreateHeaders(true);
        asMessage.setMessageId(message.getMessageId());
        asMessage.setInternetHeaders(new InternetHeaders());
        asMessage.setMimePart(new MimeBodyPart());
        asMessage.setDate(message.getMessageTimestamp());
        try {
            if (message.getAttachments().size() > 0) {
                MimeMultipart mp = new MimeMultipart("related");
                MimeBodyPart bp = new MimeBodyPart();
                SimpleFileDataSource dataSource = new SimpleFileDataSource(message.getCurrentContentType(), message.getCurrentContentReference());
                asMessage.addAttahmentDataSource(dataSource);
                bp.setDataHandler(new DataHandler((DataSource)dataSource));
                if (message.getCurrentContentType().toLowerCase().startsWith("text/xml")) {
                    Object ct = message.getCurrentContentType();
                    ct = ((String)ct).substring("text/xml".length());
                    ct = "application/xml" + (String)ct;
                    bp.setHeader("Content-Type", (String)ct);
                } else {
                    bp.setHeader("Content-Type", message.getCurrentContentType());
                }
                bp.setHeader("Content-Transfer-Encoding", asMessage.getTransferEncoding());
                ContentDisposition disposition = new ContentDisposition();
                disposition.setDisposition("attachment");
                this.setFileName(disposition, message.getProcessingDirective("ProcessedOriginalFilename"));
                bp.setDisposition(disposition.toString());
                mp.addBodyPart((BodyPart)bp);
                Iterator<XpMessageAttachment> attachments = message.getAttachmentIterator();
                while (attachments.hasNext()) {
                    XpMessageAttachment attachment = attachments.next();
                    bp = new MimeBodyPart();
                    dataSource = new SimpleFileDataSource(attachment.getType(), attachment.getAttachment());
                    asMessage.addAttahmentDataSource(dataSource);
                    bp.setDataHandler(new DataHandler((DataSource)dataSource));
                    bp.addHeader("Content-Type", message.getCurrentContentType());
                    bp.addHeader("Content-Transfer-Encoding", asMessage.getTransferEncoding());
                    disposition = new ContentDisposition();
                    disposition.setDisposition("attachment");
                    this.setFileName(disposition, attachment.getAttachment().getName());
                    bp.setDisposition(disposition.toString());
                    mp.addBodyPart((BodyPart)bp);
                }
                asMessage.getMimePart().setContent((Multipart)mp);
                asMessage.getMimePart().setHeader("Content-Type", mp.getContentType());
            } else {
                SimpleFileDataSource dataSource = new SimpleFileDataSource(message.getCurrentContentType(), message.getCurrentContentReference());
                asMessage.addAttahmentDataSource(dataSource);
                asMessage.getMimePart().setDataHandler(new DataHandler((DataSource)dataSource));
                if (message.getCurrentContentType().toLowerCase().startsWith("text/xml")) {
                    Object ct = message.getCurrentContentType();
                    ct = ((String)ct).substring("text/xml".length());
                    ct = "application/xml" + (String)ct;
                    asMessage.getMimePart().setHeader("Content-Type", (String)ct);
                } else {
                    asMessage.getMimePart().setHeader("Content-Type", message.getCurrentContentType());
                }
                asMessage.getMimePart().setHeader("Content-Transfer-Encoding", asMessage.getTransferEncoding());
                ContentDisposition disposition = new ContentDisposition();
                disposition.setDisposition("attachment");
                this.setFileName(disposition, message.getProcessingDirective("ProcessedOriginalFilename"));
                asMessage.getMimePart().setDisposition(disposition.toString());
            }
        }
        catch (Exception e) {
            throw new ASException(43000, (Throwable)e);
        }
    }

    private void setFileName(ContentDisposition disposition, String fileName) {
        if (StringUtils.isNotBlank((CharSequence)fileName)) {
            String encoded = fileName;
            try {
                encoded = MimeUtility.encodeText((String)fileName);
            }
            catch (UnsupportedEncodingException ex) {
                encoded = fileName;
            }
            disposition.setParameter("filename", encoded);
        }
    }

    protected void initOKASReport(ASReport asReport, ASMessage asMessage, String statusDescription) {
        DispositionNotification mdn = new DispositionNotification();
        mdn.setReportingUA(this.getUserAgent());
        mdn.setOriginalRecipient("rfc822; " + asMessage.getTo());
        mdn.setFinalRecipient("rfc822; " + asMessage.getTo());
        mdn.setOriginalMessageID(asMessage.getMessageId());
        mdn.setDispositionType(ASReport.DispositionType.PROCESSED.getEnumValue());
        mdn.setReceivedContentMIC(asMessage.getMICDigest());
        mdn.setReceivedContentMICAlg(asMessage.getMICAlgorithm());
        asReport.setMessageId(this._idGenerator.generateMessageId());
        asReport.setMDN(mdn);
        asReport.setMDNParameters(asMessage.getMDNParameters());
        asReport.setFrom(asMessage.getTo());
        asReport.setTo(asMessage.getFrom());
        asReport.setStatusDescription(statusDescription);
    }

    protected abstract String getUserAgent();

    protected void initErrorASReport(ASReport asReport, ASMessage asMessage, ASReport.DispositionModifier dispositionModifier, ASReport.DispositionModifierExtension dispositionModifierExtension, String statusDescription, List<String> details) {
        DispositionNotification mdn = new DispositionNotification();
        mdn.setReportingUA(this.getUserAgent());
        mdn.setOriginalRecipient("rfc822; " + asMessage.getTo());
        mdn.setFinalRecipient("rfc822; " + asMessage.getTo());
        mdn.setOriginalMessageID(asMessage.getMessageId());
        mdn.setDispositionType(ASReport.DispositionType.FAILED.getEnumValue());
        mdn.setDispositionModifier(dispositionModifier.getEnumValue());
        mdn.setDispositionModifierText(dispositionModifierExtension.getEnumValue());
        if (details != null) {
            for (String detail : details) {
                mdn.addError(detail);
            }
        }
        asReport.setMessageId(this._idGenerator.generateMessageId());
        asReport.setMDN(mdn);
        asReport.setMDNParameters(asMessage.getMDNParameters());
        asReport.setFrom(asMessage.getTo());
        asReport.setTo(asMessage.getFrom());
        asReport.setStatusDescription(statusDescription);
    }

    public void afterPropertiesSet() {
        Assert.notNull((Object)this._idGenerator, (String)"IdGenerator reference not set");
        Assert.notNull((Object)this._certificateUtility, (String)"CertificateUtility reference not set");
        Assert.notNull((Object)this._smimeSigner, (String)"SMIMESigner reference not set");
    }
}

