/*
 * Decompiled with CFR 0.152.
 */
package de.pontonconsulting.xmlpipe.as;

import jakarta.mail.MessagingException;
import jakarta.mail.internet.InternetHeaders;
import jakarta.mail.internet.MailDateFormat;
import jakarta.mail.internet.MimeBodyPart;
import java.io.IOException;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.bouncycastle.mail.smime.util.FileBackedMimeBodyPart;

public abstract class ASObject {
    private static Logger LOG = LogManager.getLogger((String)"Messenger.ASObject");
    protected boolean _recreateHeaders;
    protected String _messageId;
    protected String _from;
    protected String _to;
    protected Date _date;
    protected boolean _wasSigned;
    protected InternetHeaders _headers;
    protected MimeBodyPart _mimePart;
    private final Set<FileBackedMimeBodyPart> _tempMimeFile = new HashSet<FileBackedMimeBodyPart>();

    protected ASObject() {
    }

    public String getMessageId() {
        return this._messageId;
    }

    public void setMessageId(String messageId) {
        this._messageId = messageId;
    }

    public Date getMessageDate() {
        return this._date;
    }

    protected void setDate(Date date) {
        this._date = date;
    }

    public String getFrom() {
        return this._from;
    }

    public void setFrom(String from) {
        this._from = from != null ? from.trim() : from;
    }

    public String getTo() {
        return this._to;
    }

    public void setTo(String to) {
        this._to = to != null ? to.trim() : to;
    }

    public InternetHeaders getInternetHeaders() throws MessagingException {
        if (this._recreateHeaders) {
            this.createHeaders();
        }
        return this._headers;
    }

    public MimeBodyPart getMimePart() {
        return this._mimePart;
    }

    public void setMimePart(MimeBodyPart mimePart) {
        this._mimePart = mimePart;
        if (mimePart instanceof FileBackedMimeBodyPart) {
            this._tempMimeFile.add((FileBackedMimeBodyPart)mimePart);
        }
    }

    protected void setRecreateHeaders(boolean recreateHeaders) {
        this._recreateHeaders = recreateHeaders;
    }

    protected void setInternetHeaders(InternetHeaders headers) {
        this._headers = headers;
    }

    protected void createHeaders() throws MessagingException {
        this._recreateHeaders = false;
        Object mid = this.getMessageId();
        if (!((String)mid).startsWith("<")) {
            mid = "<" + (String)mid;
        }
        if (!((String)mid).endsWith(">")) {
            mid = (String)mid + ">";
        }
        this._headers.setHeader("Message-Id", (String)mid);
        this._headers.setHeader("Content-Type", this.getMimePart().getContentType());
        MailDateFormat dateFormatter = new MailDateFormat();
        this._headers.setHeader("Date", dateFormatter.format(this._date));
    }

    public boolean wasSigned() {
        return this._wasSigned;
    }

    public void setWasSigned(boolean wasSigned) {
        this._wasSigned = wasSigned;
    }

    public abstract String getPackagingName();

    public abstract String getTransferEncoding();

    public void cleanupTempFiles() {
        for (FileBackedMimeBodyPart fileBackedMimeBodyPart : this._tempMimeFile) {
            try {
                fileBackedMimeBodyPart.dispose();
            }
            catch (IOException e) {
                LOG.warn("could not dispose temporary MimeBodyPart. {}", (Object)e.toString());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

