/*
 * Decompiled with CFR 0.152.
 */
package de.pontonconsulting.xmlpipe.adapter.test;

import de.pontonconsulting.xmlpipe.adapter.AdapterException;
import de.pontonconsulting.xmlpipe.adapter.AgreementPartners;
import de.pontonconsulting.xmlpipe.adapter.GenericAdapter;
import de.pontonconsulting.xmlpipe.adapter.IAgreementEventListener;
import de.pontonconsulting.xmlpipe.adapter.IPartnerEventListener;
import de.pontonconsulting.xmlpipe.adapter.ISpecificAdapter;
import de.pontonconsulting.xmlpipe.adapter.MessageResult;
import de.pontonconsulting.xmlpipe.adapter.test.config.TestAdapterConfiguration;
import de.pontonconsulting.xmlpipe.config.ConfigResourceService;
import de.pontonconsulting.xmlpipe.config.IServerConfigBean;
import de.pontonconsulting.xmlpipe.config.ServerSettings;
import de.pontonconsulting.xmlpipe.cpp.CppPartner;
import de.pontonconsulting.xmlpipe.cpp.Profiles;
import de.pontonconsulting.xmlpipe.message.BackEndMessage;
import de.pontonconsulting.xmlpipe.message.BackEndMessageException;
import de.pontonconsulting.xmlpipe.message.XpAcknowledgment;
import de.pontonconsulting.xmlpipe.util.IOUtil;
import jakarta.xml.bind.JAXBException;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.Document;
import org.dom4j.Node;
import org.dom4j.io.SAXReader;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;

public class TestAdapter
implements ISpecificAdapter,
IAgreementEventListener,
IPartnerEventListener {
    private static final String MESSENGER_ADDRESS = "localhost";
    private static final String MESSENGER_PATH = "/pontonxp/AdapterService";
    private static final String SERVICE_ADAPTER_SERVICE = "ADAPTER_SERVICE";
    public static final String ID = "TestAdapter";
    private static final String FEATURE_ALLOW_JAVA_ENCODINGS = "http://apache.org/xml/features/allow-java-encodings";
    private static final String FEATURE_CONTINUE_AFTER_FATAL = "http://apache.org/xml/features/continue-after-fatal-error";
    private static final String FEATURE_LOAD_EXTERNAL_DTD = "http://apache.org/xml/features/nonvalidating/load-external-dtd";
    private static final String FEATURE_LOAD_DTD = "http://apache.org/xml/features/nonvalidating/load-dtd-grammar";
    private static final String FEATURE_SCHEMA_FULL_CHECKING = "http://apache.org/xml/features/validation/schema-full-checking";
    private static final String FEATURE_SCHEMA_VALIDATION = "http://apache.org/xml/features/validation/schema";
    private static final String FEATURE_VALIDATION = "http://xml.org/sax/features/validation";
    private static final String FEATURE_DISALLOW_DOCTYPE_DECL = "http://apache.org/xml/features/disallow-doctype-decl";
    private final TestAdapterConfiguration _configuration;
    private final IServerConfigBean _serverConfig;
    private final ConfigResourceService _configResource;
    private final Profiles _profiles;
    private GenericAdapter _genericAdapter;
    private boolean _isRunning;
    private SimpleDateFormat _dateFormatter;
    private static Log _log;
    private int _received;
    private int _sent;
    private SAXParserFactory saxParserFactory;
    private static AtomicLong _tempId;

    public TestAdapter(TestAdapterConfiguration configuration, IServerConfigBean serverConfig, ConfigResourceService configResource, Profiles profiles) {
        this._configuration = configuration;
        this._serverConfig = serverConfig;
        this._configResource = configResource;
        this._profiles = profiles;
    }

    public synchronized void start() throws IOException, AdapterException, JAXBException {
        if (!this._isRunning) {
            this._dateFormatter = new SimpleDateFormat("yyyy-MM-dd' 'HH:mm:ss'&nbsp;'z");
            _log = LogFactory.getFactory().getInstance("TestAdapter.TestAdapter");
            this._genericAdapter = new GenericAdapter(ID);
            this._genericAdapter.setEndAdapter((ISpecificAdapter)this);
            this._genericAdapter.addMessengerConnection(MESSENGER_ADDRESS, this.getAdapterServicePort(), MESSENGER_PATH);
            this._isRunning = true;
        }
    }

    private int getAdapterServicePort() throws JAXBException {
        Map<String, ServerSettings> connectors = this._serverConfig.getConnectors();
        for (String key : connectors.keySet()) {
            ServerSettings serverSetting = connectors.get(key);
            for (String serviceName : serverSetting.getServices()) {
                if (!SERVICE_ADAPTER_SERVICE.equals(serviceName)) continue;
                return serverSetting.getPort();
            }
        }
        return this._configuration.getMessengerPort();
    }

    public boolean isRunning() {
        return this._isRunning;
    }

    public MessageResult sendMessage(URL fileURL, String originalFilename, String senderLocalID, String receiverLocalID, boolean test) throws AdapterException {
        BackEndMessage bem = null;
        try {
            bem = this.createBackEndMessage(fileURL);
        }
        catch (BackEndMessageException | IOException | URISyntaxException e) {
            Object msg = e.getMessage();
            msg = msg == null || ((String)msg).length() == 0 ? "." : ": " + (String)msg;
            msg = "Could not retrieve message from file '" + String.valueOf(fileURL) + "'" + (String)msg;
            AdapterException ae = new AdapterException((String)msg);
            ae.setStackTrace(e.getStackTrace());
            throw ae;
        }
        if (originalFilename != null && originalFilename.trim().length() > 0) {
            bem.addProcessingDirective("OriginalFilename", originalFilename);
        }
        bem.setTestFlag(test ? "Test" : "Production");
        if (senderLocalID != null && senderLocalID.length() != 0) {
            bem.setSenderOrganisation(senderLocalID);
        }
        if (receiverLocalID != null && receiverLocalID.length() != 0) {
            bem.setReceiverOrganisation(receiverLocalID);
        }
        bem.setTransferID("OverwriteMessageId");
        MessageResult result = this._genericAdapter.sendMessage(bem);
        String messageID = result.getMessageId();
        if (messageID != null && messageID.length() != 0) {
            bem.setTransferID(messageID);
        }
        File toFile = null;
        toFile = this.saveBackEndMessage(bem);
        Date transmissionTime = new Date(Long.parseLong(result.getMessageTime()));
        ++this._sent;
        return result;
    }

    private BackEndMessage createBackEndMessage(URL fileURL) throws URISyntaxException, BackEndMessageException, IOException {
        if (fileURL.getProtocol().equals("file")) {
            File source = Path.of(fileURL.toURI()).toFile();
            return new BackEndMessage(source);
        }
        try (InputStream in = fileURL.openStream();){
            BackEndMessage backEndMessage;
            try (ByteArrayOutputStream out = new ByteArrayOutputStream();){
                IOUtils.copy((InputStream)in, (OutputStream)out);
                backEndMessage = new BackEndMessage(out.toByteArray(), false);
            }
            return backEndMessage;
        }
    }

    public MessageResult sendPing(String senderInternalID, String receiverInternalID) throws AdapterException {
        _log.debug((Object)("Sending PING from '" + senderInternalID + "' to '" + receiverInternalID + "'"));
        MessageResult result = this._genericAdapter.sendPing(senderInternalID, receiverInternalID);
        _log.debug((Object)("Sent PING from '" + senderInternalID + "' to '" + receiverInternalID + "' : '" + result.getMessageId() + "'"));
        Date transmissionTime = new Date(Long.parseLong(result.getMessageTime()));
        long startTime = System.currentTimeMillis();
        return result;
    }

    public MessageResult sendStatusRequest(String senderInternalID, String receiverInternalID, String referenceID) throws AdapterException {
        _log.debug((Object)("Sending StatusRequest from '" + senderInternalID + "' to '" + receiverInternalID + "' referenceID: " + referenceID));
        MessageResult result = this._genericAdapter.sendStatusRequest(senderInternalID, receiverInternalID, referenceID);
        _log.debug((Object)("Sent StatusRequest from '" + senderInternalID + "' to '" + receiverInternalID + "' : '" + result.getMessageId() + "'"));
        Date transmissionTime = new Date(Long.parseLong(result.getMessageTime()));
        long startTime = System.currentTimeMillis();
        return result;
    }

    public MessageResult receiveMessage(BackEndMessage bem) {
        File inboxFolder = null;
        try {
            inboxFolder = this._serverConfig.getRealFile(this._configuration.getInbox());
            if (!inboxFolder.isDirectory()) {
                inboxFolder.mkdirs();
            }
        }
        catch (JAXBException e) {
            return new MessageResult(MessageResult.BACKENDMSG_COULD_NOT_BE_RECONSTRUCTED);
        }
        catch (IOException e) {
            return new MessageResult(MessageResult.BACKENDMSG_COULD_NOT_BE_RECONSTRUCTED);
        }
        File receiveFile = new File(inboxFolder, bem.getFilename());
        try {
            bem.writeMessageDocumentTo(receiveFile);
        }
        catch (BackEndMessageException bme) {
            return new MessageResult(MessageResult.BACKENDMSG_COULD_NOT_BE_RECONSTRUCTED);
        }
        MessageResult result = new MessageResult(MessageResult.MSG_SUCCESSFULLY_RECEIVED);
        ++this._received;
        return result;
    }

    private String mapToDisplayName(String internalId) {
        String result = internalId;
        CppPartner partner = null;
        try {
            partner = this._profiles.getProfileForInternalId(internalId, true);
            result = partner.getDisplayName();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }

    public MessageResult receiveTestMessage(BackEndMessage message) {
        return this.receiveMessage(message);
    }

    public MessageResult receiveAcknowledgement(BackEndMessage message) {
        String senderID = message.getSenderOrganisationText();
        try {
            XpAcknowledgment ack = this.readAckXml(message);
            String referenceId = ack.getMessageReferenceId();
            if (referenceId == null || referenceId.trim().length() == 0) {
                _log.warn((Object)"An Acknowledgement without a ReferenceId was received.");
                return new MessageResult(MessageResult.MSG_SUCCESSFULLY_RECEIVED);
            }
            _log.info((Object)("Receiving acknowledgment from: '" + senderID + "' for message: '" + referenceId + "'"));
            return new MessageResult(MessageResult.MSG_SUCCESSFULLY_RECEIVED);
        }
        catch (BackEndMessageException e) {
            _log.fatal((Object)"Could not reconstruct Acknowledgement.");
            return new MessageResult(MessageResult.BACKENDMSG_COULD_NOT_BE_RECONSTRUCTED);
        }
        catch (JAXBException e) {
            _log.fatal((Object)"Could not reconstruct Acknowledgement.");
            return new MessageResult(MessageResult.BACKENDMSG_COULD_NOT_BE_RECONSTRUCTED);
        }
    }

    public MessageResult receiveStatusResponse(BackEndMessage message) {
        String senderID = message.getSenderOrganisationText();
        Document statusResponse = this.readStatusResponseXml(message);
        if (statusResponse != null) {
            Node refNode = statusResponse.selectSingleNode("/XpStatusResponse/ReferenceId");
            if (refNode == null) {
                _log.warn((Object)"A Status Request without a ReferenceId was received.");
                return new MessageResult(MessageResult.MSG_SUCCESSFULLY_RECEIVED);
            }
            String referenceId = refNode.getText();
            _log.info((Object)("Receiving status request from: '" + senderID + "' for status request: '" + referenceId + "'"));
            return new MessageResult(MessageResult.MSG_SUCCESSFULLY_RECEIVED);
        }
        _log.fatal((Object)"Could not reconstruct Acknowledgement.");
        return new MessageResult(MessageResult.BACKENDMSG_COULD_NOT_BE_RECONSTRUCTED);
    }

    public boolean doSelfCheck() {
        return true;
    }

    public String getID() {
        return ID;
    }

    public String getStatus() {
        return "TestAdapter is ready to receive Messages.<br/>Sent " + this._sent + " Messages.<br/>Received " + this._received + " Messages.";
    }

    public String shutdown() {
        _log.debug((Object)"Testadapter will shut down");
        if (this._genericAdapter != null) {
            return this._genericAdapter.shutdown().getDescription();
        }
        return "Shutdown ok.";
    }

    public File getWorkFolder() {
        try {
            File work = this._serverConfig.getRealFile(this._configuration.getWork());
            if (!work.isDirectory()) {
                work.mkdirs();
            }
            return work;
        }
        catch (Exception e) {
            Object msg = e.getMessage();
            msg = msg == null || ((String)msg).length() == 0 ? "." : ": " + (String)msg;
            msg = "Could not retrieve workfolder from configuration" + (String)msg;
            _log.error(msg);
            return null;
        }
    }

    public boolean supportsAcknowledgements() {
        return true;
    }

    public boolean supportsAttachments() {
        return false;
    }

    public int getNumberOfParallelThreads() {
        return 3;
    }

    private File saveBackEndMessage(BackEndMessage bem) throws AdapterException {
        File outbox = null;
        try {
            outbox = this._serverConfig.getRealFile(this._configuration.getOutbox());
            if (!outbox.isDirectory()) {
                outbox.mkdirs();
            }
        }
        catch (Exception e) {
            Object msg = e.getMessage();
            msg = msg == null || ((String)msg).length() == 0 ? "." : ": " + (String)msg;
            msg = "Could not retrieve folder from configuration" + (String)msg;
            AdapterException ae = new AdapterException((String)msg);
            throw ae;
        }
        File destFile = new File(outbox, bem.getTransferIDText() + ".xml");
        try {
            bem.writeMessageDocumentTo(destFile);
        }
        catch (BackEndMessageException e) {
            Object msg = e.getMessage();
            msg = msg == null || ((String)msg).length() == 0 ? "." : ": " + (String)msg;
            msg = "Could not copy to outbox" + (String)msg;
            AdapterException ae = new AdapterException((String)msg);
            throw ae;
        }
        return destFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Document readStatusResponseXml(BackEndMessage beMessage) {
        if (_log.isDebugEnabled() && beMessage != null) {
            _log.debug((Object)("Reading StatusResponseXML for message: '" + beMessage.getReferenceId() + "'"));
        }
        File tempFile = new File(this.getWorkFolder(), "StatusResponse-temp-" + TestAdapter.getNextId() + ".xml");
        BufferedInputStream in = null;
        Document document = null;
        try {
            beMessage.writeMessageDocumentTo(tempFile);
            SAXParser saxParser2332 = this.getSAXParserFactory().newSAXParser();
            saxParser2332.setProperty("http://javax.xml.XMLConstants/property/accessExternalDTD", "");
            saxParser2332.setProperty("http://javax.xml.XMLConstants/property/accessExternalSchema", "");
            SAXReader reader = new SAXReader(saxParser2332.getXMLReader());
            reader.setFeature(FEATURE_DISALLOW_DOCTYPE_DECL, true);
            in = new BufferedInputStream(Files.newInputStream(tempFile.toPath(), new OpenOption[0]));
            document = reader.read((InputStream)in);
            IOUtil.closeStreamQuietly(in);
        }
        catch (Exception e) {
            if (!_log.isDebugEnabled()) return document;
            _log.debug((Object)("Could not read StatusResponseXML: " + e.toString()));
            return document;
        }
        try {
            tempFile.delete();
            return document;
        }
        catch (Exception saxParser2332) {
            return document;
        }
        finally {
            IOUtil.closeStreamQuietly(in);
            try {
                tempFile.delete();
            }
            catch (Exception exception) {}
        }
    }

    private XpAcknowledgment readAckXml(BackEndMessage beMessage) throws BackEndMessageException, JAXBException {
        if (_log.isDebugEnabled() && beMessage != null) {
            _log.debug((Object)("Reading AckXML for message: '" + beMessage.getReferenceId() + "'"));
        }
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        beMessage.writeMessageDocumentTo((OutputStream)out);
        return new XpAcknowledgment(out.toByteArray());
    }

    private static long getNextId() {
        return _tempId.incrementAndGet();
    }

    public void agreementAdded(String localPartnerId, String remotePartnerId) {
        _log.info((Object)("new agreement for local partner (internalId:" + localPartnerId + ") and remote partner (internalId:" + remotePartnerId + ")"));
    }

    public void agreementDeleted(String localPartnerId, String remotePartnerId) {
        _log.info((Object)("agreement deleted for local partner (internalId:" + localPartnerId + ") and remote partner (internalId:" + remotePartnerId + ")"));
    }

    public void agreementModified(String localPartnerId, String remotePartnerId) {
        _log.info((Object)("agreement modified for local partner (internalId:" + localPartnerId + ") and remote partner (internalId:" + remotePartnerId + ")"));
    }

    public void partnerAdded(String partnerId, String displayName, boolean isLocalPartner) {
        _log.info((Object)("partner added. internalId:" + partnerId + " displayname:" + displayName + " islocal:" + isLocalPartner));
    }

    public void partnerDeleted(String partnerId, String displayName, boolean isLocalPartner) {
        _log.info((Object)("partner deleted. internalId:" + partnerId + " displayname:" + displayName + " islocal:" + isLocalPartner));
    }

    public void partnerModified(String partnerId, String oldPartnerId, String displayName, boolean isLocalPartner) {
        _log.info((Object)("partner modified. new-internalId:" + partnerId + " old-internalId:" + oldPartnerId + " displayname:" + displayName + " islocal:" + isLocalPartner));
    }

    public AgreementPartners[] getAgreements() throws AdapterException {
        return this._genericAdapter.getAgreementPartnersList();
    }

    private SAXParserFactory getSAXParserFactory() throws SAXNotRecognizedException, SAXNotSupportedException, ParserConfigurationException {
        if (this.saxParserFactory == null) {
            this.saxParserFactory = SAXParserFactory.newInstance();
            this.saxParserFactory.setFeature(FEATURE_VALIDATION, false);
            this.saxParserFactory.setFeature(FEATURE_SCHEMA_VALIDATION, false);
            this.saxParserFactory.setFeature(FEATURE_SCHEMA_FULL_CHECKING, false);
            this.saxParserFactory.setFeature(FEATURE_LOAD_DTD, false);
            this.saxParserFactory.setFeature(FEATURE_LOAD_EXTERNAL_DTD, false);
            this.saxParserFactory.setFeature(FEATURE_CONTINUE_AFTER_FATAL, true);
            this.saxParserFactory.setFeature(FEATURE_ALLOW_JAVA_ENCODINGS, true);
        }
        return this.saxParserFactory;
    }

    static {
        _tempId = new AtomicLong(System.currentTimeMillis());
    }
}

